/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gift.packages;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.duowan.mobile.entlive.events.IPackageClient_onPackageGiftClick_EventArgs;
import com.duowan.mobile.entlive.events.IPackageClient_onPackageGiftSelect_EventArgs;
import com.duowan.mobile.entlive.events.IPackageClient_onPageSelected_EventArgs;
import com.unionyy.mobile.spdt.Spdt;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionlive.PluginBus;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.gift.utils.GiftViewCornerUtil;
import com.yy.mobile.ui.gift.widget.BagLayout;
import com.yy.mobile.ui.gift.widget.CircleProgressBar;
import com.yy.mobile.ui.gift.widget.ScrollLayout;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.AccountPref;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.gift.GiftConfigItemBase;
import com.yymobile.core.gift.GiftConfigParser;
import com.yymobile.core.gift.IGiftCore;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PackageAdapter
implements View.OnClickListener {
    private static final String TAG = "PackageAdapter";
    public static final String BAG_GIFT_ID_KEY = "BAG_GIFT_ID";
    public final int countPerRowPortrait = 4;
    public final int countPerRowLandscape = 7;
    public final int rowCountPortrait = 2;
    public final int rowCountLandscape = 1;
    Map<Integer, Boolean> selectedPages = new HashMap<Integer, Boolean>();
    private int rowCount = 2;
    private int countPerRow = 4;
    private int countPerPage = this.countPerRow * this.rowCount;
    private ScrollLayout mContainer;
    protected LayoutInflater mInflater;
    private Context mContext;
    private int pageNum = 0;
    private boolean mIsFullScreen = false;
    private GiftConfigItemBase mSelectedGiftItem;
    private View mSelectedGiftItemView;
    private Map<Integer, WeakReference<View>> mPages = new HashMap<Integer, WeakReference<View>>();
    private List<WeakReference<View>> mFreeItemViewList = new ArrayList<WeakReference<View>>();
    private List<GiftConfigParser.FreeGiftConfigItem> mFreeItemList = new ArrayList<GiftConfigParser.FreeGiftConfigItem>();

    public PackageAdapter(Context context, boolean isFullScreen) {
        this.mInflater = LayoutInflater.from((Context)context);
        this.mContext = context;
        this.initScreenMode(isFullScreen);
    }

    public void setContainer(ScrollLayout viewGroup) {
        this.mContainer = viewGroup;
    }

    public int getCount() {
        return this.pageNum;
    }

    private void initScreenMode(boolean isFullScreen) {
        if (isFullScreen) {
            this.rowCount = 1;
            this.countPerRow = 7;
        } else {
            this.rowCount = 2;
            this.countPerRow = 4;
        }
        this.countPerPage = this.countPerRow * this.rowCount;
        this.mIsFullScreen = isFullScreen;
    }

    public void setFullScreenMode(boolean isFullScreen) {
        this.initScreenMode(isFullScreen);
    }

    public List<GiftConfigParser.FreeGiftConfigItem> getFreeItemList() {
        return this.mFreeItemList;
    }

    public void setFreePropsItemList(List<GiftConfigParser.FreeGiftConfigItem> items) {
        if (items == null) {
            return;
        }
        this.clearAll();
        this.mFreeItemList = items;
        if (this.mFreeItemList.size() > 0) {
            this.pageNum = this.mFreeItemList.size() / this.countPerPage;
            if (this.countPerPage * this.pageNum < this.mFreeItemList.size()) {
                ++this.pageNum;
            }
        }
        this.instantiatePages(this.pageNum);
        this.updateFreePropsItemNum();
        this.checkLastSendGiftSelected();
    }

    private List<GiftConfigParser.FreeGiftConfigItem> rePackedGiftItem(List<GiftConfigParser.FreeGiftConfigItem> items) {
        if (items == null) {
            return null;
        }
        ArrayList<GiftConfigParser.FreeGiftConfigItem> itemList = new ArrayList<GiftConfigParser.FreeGiftConfigItem>();
        for (int i = 0; i < items.size(); ++i) {
            if (items.get((int)i).business == GiftConfigParser.FreeGiftConfigItem.Business.first_send) continue;
            itemList.add(items.get(i));
        }
        return itemList;
    }

    private void checkLastSendGiftSelected() {
        if (this.mFreeItemList == null || this.mFreeItemList.size() == 0) {
            return;
        }
        AccountPref accountPref = AccountPref.instance((long)LoginUtil.getUid());
        int giftId = accountPref.getInt(BAG_GIFT_ID_KEY);
        boolean find = false;
        for (GiftConfigParser.FreeGiftConfigItem fi : this.mFreeItemList) {
            if (fi.type != giftId) continue;
            find = true;
            break;
        }
        if (!find) {
            giftId = this.mFreeItemList.get((int)0).type;
        }
        for (int i = 0; i < this.mFreeItemViewList.size(); ++i) {
            GridItemViewHolder holder;
            View view;
            WeakReference<View> wr = this.mFreeItemViewList.get(i);
            if (wr == null || (view = (View)wr.get()) == null || (holder = (GridItemViewHolder)view.getTag()) == null || holder.giftItem == null || holder.giftItem.type != giftId) continue;
            this.setViewSelected(view);
            this.setSelectedGiftItem(holder.giftItem, false);
            this.mSelectedGiftItemView = view;
            break;
        }
    }

    private void clearAll() {
        this.mFreeItemList.clear();
        this.mFreeItemViewList.clear();
        this.mPages.clear();
        this.selectedPages.clear();
        if (this.mContainer != null) {
            this.mContainer.removeAllViews();
        }
        this.mSelectedGiftItem = null;
    }

    public void updateFreePropsItemNum(List<GiftConfigParser.FreeGiftConfigItem> items) {
        this.mFreeItemList = this.rePackedGiftItem(items);
        this.updateFreePropsItemNum();
    }

    public void updateFreePropsItemNum() {
        if (FP.empty(this.mFreeItemViewList) || FP.empty(this.mFreeItemList)) {
            return;
        }
        for (int i = 0; i < this.mFreeItemViewList.size(); ++i) {
            GiftConfigParser.FreeGiftConfigItem item2;
            GridItemViewHolder holder;
            View view = (View)this.mFreeItemViewList.get(i).get();
            if (view == null || (holder = (GridItemViewHolder)view.getTag()) == null || (item2 = GiftConfigParser.getInstance().getFreeGiftConfigByType(holder.giftItem.type.intValue())) == null) continue;
            if (!item2.isAvaliable) {
                holder.root.animate().alpha(0.2f);
            } else {
                holder.root.animate().alpha(1.0f);
            }
            if (item2.num > 0) {
                holder.freeGiftCountView.setText((CharSequence)String.valueOf(item2.num));
                if (item2.num < 10) {
                    holder.freeGiftCountView.setBackgroundResource(R.drawable.dian_normal);
                    continue;
                }
                holder.freeGiftCountView.setBackgroundResource(R.drawable.dian1);
                continue;
            }
            if (!MLog.isLogLevelAboveDebug()) continue;
            MLog.debug((Object)TAG, (String)("[updateFreePropsItemNum] error freeGiftCountView num = " + item2.num), (Object[])new Object[0]);
        }
    }

    public void updateFreePropsItemStatus(int availableInterval) {
        for (int i = 0; i < this.mFreeItemViewList.size(); ++i) {
            View view = (View)this.mFreeItemViewList.get(i).get();
            if (view == null) continue;
            this.setFreeGiftAvailable(view, availableInterval);
        }
    }

    public void onPageSelected(int position) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("onPageSelected pos=" + position), (Object[])new Object[0]);
        }
        PluginBus.INSTANCE.get().post((Object)new IPackageClient_onPageSelected_EventArgs(position));
        if (this.mPages != null && this.mPages.get(position) != null) {
            this.selectedPages.put(position, true);
        }
    }

    private void instantiatePages(int num) {
        for (int i = 0; i < num; ++i) {
            View pageView = this.mInflater.inflate(R.layout.gift_link_item_page, null);
            BagLayout bagLayout = (BagLayout)pageView;
            bagLayout.setRow(this.rowCount);
            bagLayout.setColumns(this.countPerRow);
            bagLayout.setDivider(0);
            this.mPages.put(i, new WeakReference<View>(pageView));
            this.mContainer.addView(pageView);
            this.fillPage((BagLayout)pageView, this.countPerPage * i, 1);
        }
        this.selectedPages.put(0, true);
    }

    private void fillPage(BagLayout row, int startIndex, int rowIndex) {
        int endIndex = startIndex + this.countPerPage;
        int i = startIndex;
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"fillPage startIndex=%d,endIndex=%d", (Object[])new Object[]{startIndex, endIndex});
        }
        row.removeAllViews();
        int freeItemCount = this.mFreeItemList.size();
        while (i < freeItemCount && i < endIndex) {
            View view = this.createGiftItemView(true);
            if (i == 0) {
                this.decorateView(view, (GiftConfigItemBase)this.mFreeItemList.get(i), true);
            } else {
                this.decorateView(view, (GiftConfigItemBase)this.mFreeItemList.get(i), false);
            }
            this.mFreeItemViewList.add(new WeakReference<View>(view));
            row.addView(view);
            ++i;
        }
    }

    public void performOnGiftSelect() {
        if (this.mSelectedGiftItem instanceof GiftConfigParser.FreeGiftConfigItem) {
            this.setSelectedGiftItem(this.mSelectedGiftItem, false);
        }
    }

    private void setSelectedGiftItem(GiftConfigItemBase giftItem, boolean isClick) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"select gift: %s", (Object[])new Object[]{giftItem.name});
        }
        AccountPref accountPref = AccountPref.instance((long)LoginUtil.getUid());
        accountPref.putInt(BAG_GIFT_ID_KEY, giftItem.type.intValue());
        if (!this.mIsFullScreen) {
            // empty if block
        }
        this.mSelectedGiftItem = giftItem;
        PluginBus.INSTANCE.get().post((Object)new IPackageClient_onPackageGiftSelect_EventArgs(giftItem));
        GiftConfigParser.FreeGiftConfigItem freeGiftConfigItem = (GiftConfigParser.FreeGiftConfigItem)giftItem;
        if (freeGiftConfigItem.business == GiftConfigParser.FreeGiftConfigItem.Business.first_charge) {
            if (freeGiftConfigItem.isAvaliable && isClick) {
                Toast.makeText((Context)this.mContext, (CharSequence)this.mContext.getString(R.string.free_gift_fc_tip), (int)1).show();
            }
        } else if (isClick && !freeGiftConfigItem.isAvaliable && !StringUtils.isNullOrEmpty((String)freeGiftConfigItem.freezeMsg)) {
            Toast.makeText((Context)this.mContext, (CharSequence)freeGiftConfigItem.freezeMsg, (int)1).show();
        }
    }

    private void setViewSelected(View view) {
        GridItemViewHolder viewHolder = (GridItemViewHolder)view.getTag();
        if (viewHolder == null) {
            return;
        }
        if (viewHolder.isSelected) {
            return;
        }
        if (this.mContext != null) {
            viewHolder.selectedTagImageView.setBackground(this.mContext.getResources().getDrawable(R.drawable.gift_selected_bg));
        }
        viewHolder.isSelected = true;
    }

    private void setViewUnSelected(View view) {
        GridItemViewHolder viewHolder = (GridItemViewHolder)view.getTag();
        if (viewHolder == null) {
            return;
        }
        if (!viewHolder.isSelected) {
            return;
        }
        if (this.mContext != null) {
            viewHolder.selectedTagImageView.setBackground(this.mContext.getResources().getDrawable(R.drawable.gift_unselected_bg));
        }
        viewHolder.isSelected = false;
    }

    public GiftConfigItemBase getSelectedItem() {
        return this.mSelectedGiftItem;
    }

    public void onClick(View v) {
        GridItemViewHolder viewHolder = (GridItemViewHolder)v.getTag();
        if (viewHolder == null || viewHolder.giftItem == null) {
            return;
        }
        PluginBus.INSTANCE.get().post((Object)new IPackageClient_onPackageGiftClick_EventArgs(viewHolder.giftItem));
        if (this.mSelectedGiftItemView == v) {
            return;
        }
        ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic("50020", "0013");
        this.setSelectedGiftItem(viewHolder.giftItem, true);
        this.setViewSelected(v);
        if (this.mSelectedGiftItemView != null) {
            this.setViewUnSelected(this.mSelectedGiftItemView);
        }
        this.mSelectedGiftItemView = v;
    }

    @SuppressLint(value={"NewApi"})
    private void decorateView(View view, GiftConfigItemBase giftItem, boolean isFirstGiftItem) {
        if (giftItem == null) {
            return;
        }
        GridItemViewHolder viewHolder = (GridItemViewHolder)view.getTag();
        if (viewHolder.giftItem != giftItem) {
            if (giftItem instanceof GiftConfigParser.FreeGiftConfigItem) {
                GiftConfigParser.FreeGiftConfigItem freeItem = (GiftConfigParser.FreeGiftConfigItem)giftItem;
                if (!(giftItem instanceof GiftConfigParser.FolwerFreeGiftConfigItem)) {
                    viewHolder.freeFlowerProgressBar.setVisibility(8);
                    viewHolder.jiaobiaoHuodong.setVisibility(8);
                    this.setFreeGiftAvailable(view, ((IGiftCore)CoreFactory.getCore(IGiftCore.class)).getGiftContainer().getFreeGiftAvailabelInterval());
                }
                GiftConfigItemBase item2 = GiftConfigParser.getInstance().getGiftConfigItemByType(freeItem.type.intValue());
                if (item2 != null) {
                    giftItem.name = item2.name;
                    giftItem.iconPath = item2.iconPath;
                    if (item2 instanceof GiftConfigParser.FreeGiftConfigItem) {
                        freeItem.price = ((GiftConfigParser.FreeGiftConfigItem)item2).price;
                    }
                }
                viewHolder.freeGiftCountView = (TextView)view.findViewById(R.id.tv_free_gift_count);
                viewHolder.freeGiftCountView.setVisibility(0);
                viewHolder.nameTextView.setText((CharSequence)giftItem.name);
                viewHolder.freeGiftCountView.setText((CharSequence)String.valueOf(freeItem.num));
                if (freeItem.num > 0) {
                    viewHolder.freeGiftCountView.setText((CharSequence)String.valueOf(freeItem.num));
                    if (freeItem.num < 10) {
                        viewHolder.freeGiftCountView.setBackgroundResource(R.drawable.dian_normal);
                    } else {
                        viewHolder.freeGiftCountView.setBackgroundResource(R.drawable.dian1);
                    }
                } else if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)TAG, (String)("[decorateView]error freeGiftCountView num = " + freeItem.num), (Object[])new Object[0]);
                }
                if (freeItem.business == GiftConfigParser.FreeGiftConfigItem.Business.first_charge) {
                    viewHolder.freeTagIv.setText((CharSequence)"");
                } else if (freeItem.price != 0) {
                    String price = Spdt.string((int)R.string.str_gift_price_format, (Object[])new Object[]{Float.valueOf((float)((GiftConfigParser.FreeGiftConfigItem)giftItem).price.intValue() / 100.0f)});
                    viewHolder.freeTagIv.setText((CharSequence)price);
                }
                viewHolder.freeTagIv.setVisibility(0);
                viewHolder.priceTextView.setVisibility(4);
            }
            if (giftItem instanceof GiftConfigParser.BowknotFreeGiftConfigItem) {
                ImageLoader.loadImageResource((int)StringUtils.safeParseInt((String)giftItem.iconPath), (RecycleImageView)viewHolder.iconImageView, (ImageConfig)ImageConfig.smallImageConfig());
            } else {
                final GridItemViewHolder fViewHolder = viewHolder;
                final String url = giftItem.iconPath;
                final ImageConfig config = ImageConfig.smallImageConfig();
                BitmapDrawable drawable2 = ImageLoader.getBitmapFromCache((String)url, (ImageConfig)config);
                if (drawable2 != null) {
                    viewHolder.iconImageView.setImageDrawable((Drawable)drawable2);
                } else {
                    ImageLoader.loadImageResource((int)R.drawable.lr_ic_default_gift, (RecycleImageView)viewHolder.iconImageView, (ImageConfig)ImageConfig.smallImageConfig());
                    ImageLoader.loadBitmap((Context)BasicConfig.getInstance().getAppContext(), (String)url, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                        public void onLoadFailed(Exception e) {
                        }

                        public void onResourceReady(Bitmap bitmap) {
                            if (bitmap != null) {
                                BitmapDrawable drawable2 = new BitmapDrawable(BasicConfig.getInstance().getAppContext().getResources(), bitmap);
                                fViewHolder.iconImageView.setImageDrawable((Drawable)drawable2);
                                ImageLoader.addBitmapToCache((String)url, (BitmapDrawable)drawable2, (ImageConfig)config);
                            }
                        }
                    });
                }
            }
            FrameLayout cornerContainer = (FrameLayout)view.findViewById(R.id.fl_corners);
            GiftViewCornerUtil.INSTANCE.initCorners(cornerContainer, giftItem);
            viewHolder.giftItem = giftItem;
        }
        if (this.mSelectedGiftItem != null && viewHolder.giftItem.getType() == this.mSelectedGiftItem.getType() && viewHolder.giftItem.type.equals(this.mSelectedGiftItem.type)) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"setViewSelected gift: %s", (Object[])new Object[]{viewHolder.giftItem.name});
            }
            this.setViewSelected(view);
            this.mSelectedGiftItemView = view;
        }
    }

    private void setFreeGiftAvailable(View view, int interval) {
        GridItemViewHolder viewHolder = (GridItemViewHolder)view.getTag();
        if (viewHolder.giftItem instanceof GiftConfigParser.FolwerFreeGiftConfigItem) {
            return;
        }
        if (viewHolder.giftItem instanceof GiftConfigParser.BowknotFreeGiftConfigItem) {
            return;
        }
        if (viewHolder.freeGiftUnavailableView == null) {
            viewHolder.freeGiftUnavailableView = view.findViewById(R.id.rl_free_gift_unavailable);
            viewHolder.freeProgressBar = (CircleProgressBar)view.findViewById(R.id.pb_time_left);
            viewHolder.freeTimeLeft = (TextView)view.findViewById(R.id.tv_time_left);
        }
        if (interval > 0) {
            if (viewHolder.giftItem instanceof GiftConfigParser.FreeGiftConfigItem) {
                GiftConfigParser.FreeGiftConfigItem item2 = (GiftConfigParser.FreeGiftConfigItem)viewHolder.giftItem;
                if (((IGiftCore)ICoreManagerBase.getCore(IGiftCore.class)).getGiftContainer() != null && ((IGiftCore)ICoreManagerBase.getCore(IGiftCore.class)).getGiftContainer().getFreeGiftMaxCountDown() - interval >= item2.countDown) {
                    item2.isCountDown = true;
                    item2.countDown = 0;
                    viewHolder.freeGiftUnavailableView.setVisibility(4);
                    viewHolder.freeProgressBar.setProgress(0);
                    viewHolder.freeTimeLeft.setText((CharSequence)"0s");
                } else {
                    item2.isCountDown = false;
                    int value = interval - (((IGiftCore)ICoreManagerBase.getCore(IGiftCore.class)).getGiftContainer().getFreeGiftMaxCountDown() - item2.countDown);
                    viewHolder.freeGiftUnavailableView.setVisibility(0);
                    if (item2.countDown > 0) {
                        viewHolder.freeProgressBar.setProgress(100 - 100 * (((IGiftCore)ICoreManagerBase.getCore(IGiftCore.class)).getGiftContainer().getFreeGiftMaxCountDown() - interval) / item2.countDown);
                    }
                    viewHolder.freeTimeLeft.setText((CharSequence)(value + "s"));
                }
            }
        } else {
            viewHolder.freeGiftUnavailableView.setVisibility(4);
        }
    }

    @SuppressLint(value={"SetTextI18n"})
    protected View createGiftItemView(boolean isFree) {
        View view = this.mInflater.inflate(R.layout.gift_link_grid_item, null);
        GridItemViewHolder viewHolder = new GridItemViewHolder();
        viewHolder.nameTextView = (TextView)view.findViewById(R.id.tv_gift_name);
        viewHolder.priceTextView = (TextView)view.findViewById(R.id.tv_gift_price);
        viewHolder.priceTextView.setText((CharSequence)("0.1" + Spdt.string((int)R.string.red_packet_price_unit_user, (Object[])new Object[0])));
        viewHolder.iconImageView = (RecycleImageView)view.findViewById(R.id.iv_gift_icon);
        viewHolder.selectedTagImageView = (ImageView)view.findViewById(R.id.iv_selected_tag);
        viewHolder.freeTagIv = (TextView)view.findViewById(R.id.iv_free_tag);
        viewHolder.freeFlowerProgressBar = (ProgressBar)view.findViewById(R.id.pb_flower_time_left);
        viewHolder.jiaobiaoHuodong = (ImageView)view.findViewById(R.id.jiaobiao_huodong);
        viewHolder.jiaobiaoBigGif = (ImageView)view.findViewById(R.id.jiaobiao_bigGif);
        viewHolder.root = view;
        view.setTag((Object)viewHolder);
        view.setOnClickListener((View.OnClickListener)this);
        return view;
    }

    public static class GridItemViewHolder {
        public TextView nameTextView;
        public TextView priceTextView;
        public RecycleImageView iconImageView;
        public TextView freeTagIv;
        public ImageView selectedTagImageView;
        public TextView freeGiftCountView;
        public View freeGiftUnavailableView;
        public TextView freeTimeLeft;
        public CircleProgressBar freeProgressBar;
        public GiftConfigItemBase giftItem;
        public boolean isSelected = false;
        public ProgressBar freeFlowerProgressBar;
        public ImageView jiaobiaoHuodong;
        public ImageView jiaobiaoBigGif;
        public View root;
    }
}

