/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gift.guid;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;

public class TrackView
extends View {
    Paint mPaint;
    Path mPath = new Path();
    RectF leftRect = new RectF();
    RectF rightRect = new RectF();
    int r;
    int mColor;
    boolean isLandscape;

    public TrackView(Context context) {
        this(context, null);
    }

    public TrackView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TrackView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(872406272);
        this.isLandscape = false;
    }

    public void setLandscape(boolean landscape) {
        this.isLandscape = landscape;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        this.mPath.reset();
        this.mPath.moveTo(0.0f, 0.0f);
        if (this.isLandscape) {
            this.r = this.getWidth() / 2;
            this.rightRect.left = 0.0f;
            this.rightRect.top = -this.r;
            this.rightRect.right = this.getWidth();
            this.rightRect.bottom = this.r;
            this.mPath.arcTo(this.rightRect, 180.0f, -180.0f);
            this.mPath.lineTo((float)this.getWidth(), (float)this.getHeight());
            this.leftRect.left = 0.0f;
            this.leftRect.right = this.getWidth();
            this.leftRect.top = this.getHeight() - this.r;
            this.leftRect.bottom = this.getHeight() + this.r;
            this.mPath.arcTo(this.leftRect, 0.0f, -180.0f);
            this.mPath.lineTo(0.0f, 0.0f);
        } else {
            this.mPath.lineTo((float)this.getWidth(), 0.0f);
            this.r = this.getHeight() / 2;
            this.rightRect.left = this.getWidth() - this.r;
            this.rightRect.top = 0.0f;
            this.rightRect.right = this.getWidth() + this.r;
            this.rightRect.bottom = this.getHeight();
            this.mPath.arcTo(this.rightRect, 270.0f, -180.0f);
            this.mPath.lineTo(0.0f, (float)this.getHeight());
            this.leftRect.left = -this.r;
            this.leftRect.right = this.r;
            this.leftRect.top = 0.0f;
            this.leftRect.bottom = this.getHeight();
            this.mPath.arcTo(this.leftRect, 90.0f, -180.0f);
        }
        canvas.drawPath(this.mPath, this.mPaint);
    }

    public int getColor() {
        return this.mColor;
    }

    public void setColor(int color2) {
        this.mColor = color2;
        this.mPaint.setColor(color2);
        this.invalidate();
    }
}

