/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gift.guid;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.Html;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.utils.AbstractViewController;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.ui.utils.ViewUtils;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Consumer;

public class ScenePacketTips
extends AbstractViewController {
    private static final String TAG = "ScenePacketTips";
    private static final long DEFAULT_DELAY_HIDDEN_TIME = 5000L;
    private View mAnchorIcon;
    protected TextView mTipTxt;
    private long mDuration = 5000L;
    private Runnable mDelayHidden = new Runnable(){

        @Override
        public void run() {
            ScenePacketTips.this.hide();
        }
    };
    private String mTipStr;
    private View.OnClickListener mOnClickListener;
    private CompositeDisposable mCompositeDisposable = new CompositeDisposable();

    protected View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mRootView = inflater.inflate(R.layout.scene_paket_tips, null, false);
        this.mAnchorIcon = container.findViewById(R.id.iv_scene_gift);
        return this.mRootView;
    }

    protected void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        this.mTipTxt = (TextView)view.findViewById(R.id.tip_txt);
        if (!TextUtils.isEmpty((CharSequence)this.mTipStr)) {
            this.mTipTxt.setText((CharSequence)Html.fromHtml((String)this.mTipStr));
        }
        this.mCompositeDisposable.add(ViewUtils.clicks((View)this.mRootView, (long)500L).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                if (null != ScenePacketTips.this.mOnClickListener) {
                    ScenePacketTips.this.mOnClickListener.onClick(ScenePacketTips.this.mRootView);
                }
            }
        }, RxUtils.errorConsumer((String)TAG, (String)"click exception")));
        this.onOrientationChanged(this.isLandScape());
    }

    protected void onCreatePrepare(Bundle savedInstanceState) {
        super.onCreatePrepare(savedInstanceState);
        this.isInitHidden = true;
    }

    public void setOnClickListener(View.OnClickListener listener2) {
        this.mOnClickListener = listener2;
    }

    public void setTipsMsg(String msg) {
        this.mTipStr = msg;
        if (null != this.mRootView && null != this.mTipTxt && !TextUtils.isEmpty((CharSequence)msg)) {
            this.mTipTxt.setText((CharSequence)Html.fromHtml((String)this.mTipStr));
        }
    }

    public void setDuration(long duration) {
        if (duration <= 0L) {
            this.mDuration = 5000L;
            return;
        }
        this.mDuration = duration;
    }

    protected void onOrientationChanged(boolean isLandscape) {
        int[] location;
        if (this.mRootView.getLayoutParams() instanceof RelativeLayout.LayoutParams && (location = this.getAnchorIconPosition()) != null) {
            RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.mRootView.getLayoutParams();
            lp.addRule(12);
            lp.addRule(11);
            int sw = ResolutionUtils.getScreenWidth((Context)this.getActivity());
            if (isLandscape) {
                lp.rightMargin = sw - location[0] - this.mAnchorIcon.getWidth();
                lp.bottomMargin = DensityUtil.dip2px((Context)this.getActivity(), (float)93.0f);
            } else {
                lp.rightMargin = sw - location[0] - this.mAnchorIcon.getWidth();
                lp.bottomMargin = DensityUtil.dip2px((Context)this.getActivity(), (float)47.0f);
            }
            this.mRootView.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
        if (isLandscape) {
            this.dismiss();
        }
    }

    private int[] getAnchorIconPosition() {
        if (this.mAnchorIcon != null) {
            int[] coordinate = new int[2];
            this.mAnchorIcon.getLocationOnScreen(coordinate);
            if (coordinate[0] == 0) {
                MLog.error((Object)TAG, (String)"mAnchorIcon coordinate is 0", (Object[])new Object[0]);
                return null;
            }
            return coordinate;
        }
        MLog.error((Object)TAG, (String)"mAnchorIcon is null", (Object[])new Object[0]);
        return null;
    }

    public void show() {
        super.show();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"cyy", (String)("show" + this.mDuration), (Object[])new Object[0]);
        }
        this.getHandler().removeCallbacks(this.mDelayHidden);
        this.getHandler().postDelayed(this.mDelayHidden, this.mDuration);
    }

    public void hide() {
        super.hide();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"cyy", (String)"hide", (Object[])new Object[0]);
        }
        this.getHandler().removeCallbacks(this.mDelayHidden);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"cyy", (String)"onDestroy", (Object[])new Object[0]);
        }
        this.getHandler().removeCallbacks(this.mDelayHidden);
        this.mCompositeDisposable.clear();
    }
}

