/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.common;

import android.graphics.Rect;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;

public class DividerGridItemDecoration
extends RecyclerView.ItemDecoration {
    private int horizontalSpacing = 0;
    private int verticalSpacing = 0;
    private boolean includeEdge = false;

    public DividerGridItemDecoration(int hSpacing, int vSpacing, boolean includeEdge) {
        this.horizontalSpacing = hSpacing;
        this.verticalSpacing = vSpacing;
        this.includeEdge = includeEdge;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        super.getItemOffsets(outRect, view, parent, state);
        int position = parent.getChildAdapterPosition(view);
        if (parent.getLayoutManager() instanceof GridLayoutManager) {
            GridLayoutManager layoutManager = (GridLayoutManager)parent.getLayoutManager();
            int spanCount = layoutManager.getSpanCount();
            int column = position % spanCount;
            this.getGridItemOffsets(outRect, position, column, spanCount);
        } else if (parent.getLayoutManager() instanceof StaggeredGridLayoutManager) {
            StaggeredGridLayoutManager layoutManager = (StaggeredGridLayoutManager)parent.getLayoutManager();
            int spanCount = layoutManager.getSpanCount();
            StaggeredGridLayoutManager.LayoutParams lp = (StaggeredGridLayoutManager.LayoutParams)view.getLayoutParams();
            int column = lp.getSpanIndex();
            this.getGridItemOffsets(outRect, position, column, spanCount);
        } else if (parent.getLayoutManager() instanceof LinearLayoutManager) {
            outRect.left = this.horizontalSpacing;
            outRect.right = this.horizontalSpacing;
            if (this.includeEdge) {
                if (position == 0) {
                    outRect.top = this.verticalSpacing;
                }
                outRect.bottom = this.verticalSpacing;
            } else if (position > 0) {
                outRect.top = this.verticalSpacing;
            }
        }
    }

    private void getGridItemOffsets(Rect outRect, int position, int column, int spanCount) {
        if (this.includeEdge) {
            outRect.left = this.horizontalSpacing * (spanCount - column) / spanCount;
            outRect.right = this.horizontalSpacing * (column + 1) / spanCount;
            if (position < spanCount) {
                outRect.top = this.verticalSpacing;
            }
            outRect.bottom = this.verticalSpacing;
        } else {
            outRect.left = this.horizontalSpacing * column / spanCount;
            outRect.right = this.horizontalSpacing * (spanCount - 1 - column) / spanCount;
            if (position >= spanCount) {
                outRect.top = this.verticalSpacing;
            }
        }
    }
}

