/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.chatemotion;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.TextView;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basefunction.followguide.LoginFollowGuideManager;
import com.yy.mobile.ui.basicchanneltemplate.component.BasePopupComponent;
import com.yy.mobile.ui.chatemotion.SendChatPresenter;
import com.yy.mobile.ui.chatemotion.ShowChatPresenter;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.util.HashMap;

public class LiteChatPopupComponent
extends BasePopupComponent {
    private static final String TAG = "LiteChatPopupComponent";
    public static final String CHAT_EMOTION_DEFAULT_TEXT = "CHAT_EMOTION_DEFAULT_TEXT";
    private CharSequence mDefaultText;
    private TextView mSendButton;
    private EditText mInputTextView;
    private ShowChatPresenter mShowChatPresenter;
    private SendChatPresenter mSendChatPresenter;
    private boolean mPortrait;

    public static LiteChatPopupComponent newInstance(CharSequence inputText) {
        LiteChatPopupComponent component = new LiteChatPopupComponent();
        Bundle arguments = new Bundle();
        arguments.putCharSequence(CHAT_EMOTION_DEFAULT_TEXT, inputText);
        component.setArguments(arguments);
        return component;
    }

    public static LiteChatPopupComponent newInstance(Bundle bundle) {
        LiteChatPopupComponent component = new LiteChatPopupComponent();
        component.setArguments(bundle);
        return component;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        this.setStyle(0, 16973833);
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.mDefaultText = this.getArguments().getCharSequence(CHAT_EMOTION_DEFAULT_TEXT);
        }
        this.mShowChatPresenter = new ShowChatPresenter();
        this.mSendChatPresenter = new SendChatPresenter(this.getContext());
        this.mPortrait = this.getResources().getConfiguration().orientation == 1;
        this.sendShowStatistic();
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.setCanceledOnTouchOutside(true);
        dialog.requestWindowFeature(1);
        dialog.getWindow().setWindowAnimations(R.style.DialogAnimation);
        dialog.getWindow().setBackgroundDrawableResource(R.color.transparent);
        dialog.getWindow().clearFlags(2);
        dialog.getWindow().setLayout(-1, (int)ResolutionUtils.convertDpToPixel((float)60.0f, (Context)this.getContext()));
        dialog.getWindow().setGravity(80);
        return dialog;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_lite_chat_component, container, false);
        this.mSendButton = (TextView)view.findViewById(R.id.btn_chat_emotion_send);
        this.mSendButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LiteChatPopupComponent.this.sendSendStatistic();
                LoginFollowGuideManager.instance().showFollowGuide(1);
                boolean success = LiteChatPopupComponent.this.mSendChatPresenter.onPreSendMessage(LiteChatPopupComponent.this.mInputTextView.getText().toString(), (TextView)LiteChatPopupComponent.this.mInputTextView, new boolean[]{true}, "1");
                if (success) {
                    try {
                        LiteChatPopupComponent.this.dismiss();
                    }
                    catch (Throwable throwable) {
                        MLog.error((Object)LiteChatPopupComponent.TAG, (Throwable)throwable);
                    }
                }
            }
        });
        this.mInputTextView = (EditText)view.findViewById(R.id.chat_emotion_input_box);
        if (!TextUtils.isEmpty((CharSequence)this.mDefaultText)) {
            this.mInputTextView.setText(this.mDefaultText);
            this.mInputTextView.setSelection(this.mDefaultText.length());
        }
        this.mInputTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LiteChatPopupComponent.this.sendEditStatistic();
                if (LiteChatPopupComponent.this.getResources().getConfiguration().orientation == 2) {
                    LiteChatPopupComponent.this.mShowChatPresenter.showLandScapeChatComponent((Fragment)LiteChatPopupComponent.this, (CharSequence)LiteChatPopupComponent.this.mDefaultText.toString());
                } else {
                    LiteChatPopupComponent.this.mShowChatPresenter.showPortraitChatComponent(LiteChatPopupComponent.this.mDefaultText.toString());
                }
                LiteChatPopupComponent.this.dismiss();
            }
        });
        return view;
    }

    private void sendShowStatistic() {
        HashMap<String, String> pro = new HashMap<String, String>();
        pro.put("key1", this.mPortrait ? "1" : "2");
        ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51001", "0062", pro);
    }

    private void sendSendStatistic() {
        HashMap<String, String> pro = new HashMap<String, String>();
        pro.put("key1", this.mPortrait ? "1" : "2");
        ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51001", "0063", pro);
    }

    private void sendEditStatistic() {
        HashMap<String, String> pro = new HashMap<String, String>();
        pro.put("key1", this.mPortrait ? "1" : "2");
        ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51001", "0064", pro);
    }
}

