/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.channelofficialInfo;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.main.events.IAuthClient_onKickOff_EventArgs;
import com.yy.mobile.plugin.main.events.IAuthClient_onLoginSucceed_EventArgs;
import com.yy.mobile.plugin.main.events.IAuthClient_onLogout_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelOfficialInfoClient_onRequestProgramPreList_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelOfficialInfoClient_onReserveProgramPreResult_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelOfficialInfoClient_onReserveProgramPreState_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.channelofficialInfo.ProgramPreComponent$$EventBinder;
import com.yy.mobile.ui.channelofficialInfo.ProgramPreItemInfo;
import com.yy.mobile.ui.utils.DateUtils;
import com.yy.mobile.ui.widget.ListViewForScrollView;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.CommonUtils;
import com.yy.mobile.util.DimenConverter;
import com.yy.mobile.util.FP;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.NavigationUtilApi;
import com.yy.mobile.yyprotocol.core.Uint32;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channelofficialInfo.IChannelOfficialInfoCore;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProgramPreComponent
extends Component {
    public static final String TAG = "ProgramPreComponent";
    private static float PRE_THUMB_ASPECT_RATIO = 0.56f;
    private int preThumbHeight;
    public static final String KEY_EXPAND_ID = "key_expand_id";
    public static String DEFAULT_PREVIEW_CONTENT_DESC = "\u8fd9\u4e2aYY\u76f4\u64ad\u6709\u70b9\u610f\u601d\uff01\u5343\u4e07\u522b\u70b9\u9519\uff01";
    private ListViewForScrollView mListView;
    private ProgramPreAdapter mAdapter;
    private List<Integer> mEventIds = new ArrayList<Integer>();
    private SimpleDateFormat mSimpleDateFormat = CommonUtils.getSimpleDateFormat((String)"MM\u6708dd\u65e5HH\u70b9");
    private Runnable checkRequestTimeoutTask = new Runnable(){

        @Override
        public void run() {
            if (ProgramPreComponent.this.mAdapter != null && ProgramPreComponent.this.mAdapter.getCount() > 0) {
                ProgramPreComponent.this.checkNetToast();
            } else {
                ProgramPreComponent.this.showNetworkErr();
            }
        }
    };
    View.OnClickListener mOnclick = new View.OnClickListener(){

        public void onClick(View v) {
            ProgramPreComponent.this.showLoading();
            ProgramPreComponent.this.loadData();
        }
    };
    private EventBinder mProgramPreComponentSniperEventBinder;

    public static ProgramPreComponent newInstance() {
        ProgramPreComponent fragment = new ProgramPreComponent();
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_program_pre_list_layout, container, false);
        this.mListView = (ListViewForScrollView)view.findViewById(R.id.program_pre_list_view);
        this.initThumbHeight();
        this.mAdapter = new ProgramPreAdapter((Context)this.getActivity());
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        this.showLoading(view);
        this.loadData();
        return view;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    private void loadData() {
        this.getHandler().postDelayed(this.checkRequestTimeoutTask, 10000L);
        ((IChannelOfficialInfoCore)ICoreManagerBase.getCore(IChannelOfficialInfoCore.class)).requestProgramPreList();
    }

    public void share(ProgramPreItemInfo item2) {
    }

    public View.OnClickListener getLoadListener() {
        return this.mOnclick;
    }

    public View.OnClickListener getNoMobileLiveDataListener() {
        return this.mOnclick;
    }

    @BusEvent
    public void onRequestProgramPreList(IChannelOfficialInfoClient_onRequestProgramPreList_EventArgs busEventArgs) {
        int code = busEventArgs.getCode();
        ArrayList data = busEventArgs.getData();
        this.getHandler().removeCallbacks(this.checkRequestTimeoutTask);
        this.hideStatus();
        if (data != null && code != -1) {
            if (data.size() != 0) {
                this.mAdapter.setData(data);
                ((IChannelOfficialInfoCore)ICoreManagerBase.getCore(IChannelOfficialInfoCore.class)).setPreviewExpandPos(0);
                this.mEventIds.clear();
                for (ProgramPreItemInfo itemInfo : data) {
                    this.mEventIds.add(itemInfo.eventId);
                }
                if (LoginUtil.isLogined() && !FP.empty(this.mEventIds)) {
                    ((IChannelOfficialInfoCore)ICoreManagerBase.getCore(IChannelOfficialInfoCore.class)).isReserveProgramPreState(this.mEventIds);
                }
            } else {
                this.mAdapter.clearData();
                this.showNoData(R.drawable.icon_none_content_data, "\u6682\u65e0\u9884\u544a\uff0c\u8bf7\u7a0d\u540e\u518d\u6765");
            }
        } else if (this.mAdapter != null && this.mAdapter.getCount() > 0) {
            this.checkNetToast();
        } else {
            this.showNetworkErr();
        }
    }

    @BusEvent(sync=true)
    public void onReserveProgramPreState(IChannelOfficialInfoClient_onReserveProgramPreState_EventArgs busEventArgs) {
        Map statusMap = busEventArgs.getStatusMap();
        this.mAdapter.setItemFollowState(statusMap);
    }

    @BusEvent(sync=true)
    public void onLoginSucceed(IAuthClient_onLoginSucceed_EventArgs busEventArgs) {
        long userId = busEventArgs.getUid();
        if (!FP.empty(this.mEventIds)) {
            ((IChannelOfficialInfoCore)ICoreManagerBase.getCore(IChannelOfficialInfoCore.class)).isReserveProgramPreState(this.mEventIds);
        }
    }

    @BusEvent(sync=true)
    public void onLogout(IAuthClient_onLogout_EventArgs busEventArgs) {
        this.mAdapter.removeAllFollowStates();
    }

    @BusEvent(sync=true)
    public void onKickOff(IAuthClient_onKickOff_EventArgs busEventArgs) {
        byte[] strReason = busEventArgs.getStrReason();
        int uReason = busEventArgs.getUReason();
        this.mAdapter.removeAllFollowStates();
    }

    @BusEvent(sync=true)
    public void onReserveProgramPreResult(IChannelOfficialInfoClient_onReserveProgramPreResult_EventArgs busEventArgs) {
        boolean success = busEventArgs.getSuccess();
        int eventId = busEventArgs.getEventId();
        Uint32 act = busEventArgs.getAct();
        if (success && !FP.empty(this.mEventIds) && this.mEventIds.contains(eventId)) {
            boolean isOrder = act.equals((Object)new Uint32(0));
            this.mAdapter.setItemFollowState(eventId, isOrder);
        }
    }

    private void initThumbHeight() {
        if (BasicConfig.getInstance().getAppContext() == null) {
            this.preThumbHeight = 405;
        } else {
            int preThumbWidth = BasicConfig.getInstance().getAppContext().getResources().getDisplayMetrics().widthPixels;
            this.preThumbHeight = (int)((float)preThumbWidth * PRE_THUMB_ASPECT_RATIO);
        }
    }

    private String getNavBizName(String biz) {
        return "\u5176\u4ed6";
    }

    protected void onViewCreated(View view, Bundle bundle) {
        if (this.mProgramPreComponentSniperEventBinder == null) {
            this.mProgramPreComponentSniperEventBinder = new ProgramPreComponent$$EventBinder();
        }
        this.mProgramPreComponentSniperEventBinder.bindEvent((Object)this);
        super.onViewCreated(view, bundle);
    }

    protected void onDestroyView() {
        super.onDestroyView();
        if (this.mProgramPreComponentSniperEventBinder != null) {
            this.mProgramPreComponentSniperEventBinder.unBindEvent();
        }
    }

    private static class ViewHolder {
        View container;
        RelativeLayout rlTop;
        TextView atteBtn;
        TextView preInfor;
        TextView preTitle;
        TextView preTag;
        RelativeLayout rlThumb;
        RecycleImageView thumb;
        RecycleImageView toPlay;
        TextView desc;
        TextView cycleTips;
        RelativeLayout rlShare;
        RecycleImageView share;

        private ViewHolder() {
        }
    }

    private class ProgramPreAdapter
    extends BaseAdapter {
        private static final int TYPE_COUNT = 3;
        private static final int DEFAULT_IS_THUMB = 0;
        private static final int HAS_VIDEO_URL = 1;
        private Context mContext;
        private List<ProgramPreItemInfo> mData = new ArrayList<ProgramPreItemInfo>();
        private TextView followBtn;

        ProgramPreAdapter(Context context) {
            this.mContext = context;
        }

        public int getCount() {
            return this.mData.size();
        }

        public ProgramPreItemInfo getItem(int position) {
            return this.mData.get(position);
        }

        public long getItemId(int position) {
            return 0L;
        }

        public int getItemViewType(int position) {
            return this.getItem((int)position).viewType;
        }

        public int getViewTypeCount() {
            return 3;
        }

        void showFollowState(ViewHolder holder, ProgramPreItemInfo item2) {
            if (item2.isFollow) {
                holder.atteBtn.setText((CharSequence)ProgramPreComponent.this.getResources().getString(R.string.previewed));
                holder.atteBtn.setTextColor(ProgramPreComponent.this.getResources().getColor(R.color.txt_color_four));
                holder.atteBtn.setBackgroundResource(R.drawable.transparent);
            } else {
                holder.atteBtn.setText((CharSequence)ProgramPreComponent.this.getResources().getString(R.string.preview));
                holder.atteBtn.setTextColor(ProgramPreComponent.this.getResources().getColor(R.color.txt_color_two));
                holder.atteBtn.setBackgroundResource(R.drawable.bg_preview_btn_selector);
            }
        }

        public View getView(final int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            boolean isChoosed;
            ProgramPreItemInfo preInfo = this.getItem(position);
            boolean bl = isChoosed = ((IChannelOfficialInfoCore)CoreFactory.getCore(IChannelOfficialInfoCore.class)).getPreviewExpandPos() == position;
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_mobile_live_preview_detail, parent, false);
                holder = this.initViewHolder(convertView);
                convertView.setTag((Object)holder);
            } else {
                holder = (ViewHolder)convertView.getTag();
            }
            this.bindViewHolder(holder, isChoosed, preInfo);
            holder.container.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (!isChoosed) {
                        ((IChannelOfficialInfoCore)CoreFactory.getCore(IChannelOfficialInfoCore.class)).setPreviewExpandPos(position);
                        ProgramPreAdapter.this.notifyDataSetChanged();
                    }
                }
            });
            return convertView;
        }

        public void setData(List<ProgramPreItemInfo> liveList) {
            if (liveList == null) {
                return;
            }
            this.mData.clear();
            this.mData.addAll(liveList);
            this.notifyDataSetChanged();
        }

        public void removeAllFollowStates() {
            if (!FP.empty(this.mData)) {
                for (ProgramPreItemInfo item2 : this.mData) {
                    item2.isFollow = false;
                }
                this.notifyDataSetChanged();
            }
        }

        public void clearData() {
            this.mData.clear();
            this.notifyDataSetChanged();
        }

        public void setItemFollowState(int eventId, boolean state) {
            if (!FP.empty(this.mData)) {
                for (ProgramPreItemInfo item2 : this.mData) {
                    if (item2.eventId != eventId) continue;
                    item2.isFollow = state;
                    if (state) {
                        ++item2.fans;
                        break;
                    }
                    if (item2.fans <= 0) break;
                    --item2.fans;
                    break;
                }
                if (this.followBtn != null) {
                    this.followBtn.setEnabled(true);
                }
                this.notifyDataSetChanged();
            }
        }

        public void setItemFollowState(Map<Integer, Boolean> stateMap) {
            if (!FP.empty(this.mData)) {
                if (!FP.empty(stateMap)) {
                    for (ProgramPreItemInfo item2 : this.mData) {
                        if (!stateMap.containsKey(item2.eventId)) continue;
                        item2.isFollow = stateMap.get(item2.eventId);
                    }
                }
                this.notifyDataSetChanged();
            }
        }

        ViewHolder initViewHolder(View convertView) {
            ViewHolder holder = new ViewHolder();
            holder.container = convertView.findViewById(R.id.pre_container_d);
            holder.rlTop = (RelativeLayout)convertView.findViewById(R.id.rl_pre_top);
            holder.atteBtn = (TextView)convertView.findViewById(R.id.pre_follow_btn_d);
            holder.preInfor = (TextView)convertView.findViewById(R.id.pre_info_d);
            holder.preTitle = (TextView)convertView.findViewById(R.id.pre_title_d);
            holder.preTag = (TextView)convertView.findViewById(R.id.pre_title_tag_d);
            holder.rlThumb = (RelativeLayout)convertView.findViewById(R.id.rl_pre_thumnb_d);
            holder.thumb = (RecycleImageView)convertView.findViewById(R.id.pre_thumb_d);
            holder.thumb.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, ProgramPreComponent.this.preThumbHeight));
            holder.toPlay = (RecycleImageView)convertView.findViewById(R.id.pre_play_d);
            holder.desc = (TextView)convertView.findViewById(R.id.pre_desc_d);
            holder.cycleTips = (TextView)convertView.findViewById(R.id.pre_cycle_tips_d);
            holder.rlShare = (RelativeLayout)convertView.findViewById(R.id.rl_pre_share_d);
            holder.share = (RecycleImageView)convertView.findViewById(R.id.pre_share_d);
            return holder;
        }

        void bindViewHolder(final ViewHolder holder, boolean isChoosed, final ProgramPreItemInfo preInfo) {
            holder.preInfor.setText((CharSequence)(DateUtils.convertTime((long)preInfo.timeStart) + "      " + String.valueOf(preInfo.fans) + "\u4eba\u9884\u8ba2"));
            holder.preTitle.setText((CharSequence)preInfo.title);
            String name = ProgramPreComponent.this.getNavBizName(preInfo.biz);
            holder.preTitle.setPadding(0, 0, this.paddingRightDis(name), 0);
            holder.preTag.setText((CharSequence)name);
            holder.atteBtn.setOnClickListener(new View.OnClickListener(){
                ProgramPreItemInfo item;
                {
                    this.item = preInfo;
                }

                public void onClick(View view) {
                    if (!LoginUtil.isLogined()) {
                        ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toLogin((Context)ProgramPreComponent.this.getActivity(), true, false);
                    } else if (LoginUtil.getUid() == this.item.uid) {
                        Toast.makeText((Context)ProgramPreComponent.this.getContext(), (CharSequence)ProgramPreAdapter.this.mContext.getResources().getString(R.string.xianchang_follow_tips), (int)0).show();
                    } else {
                        Uint32 act = this.item.isFollow ? new Uint32(1) : new Uint32(0);
                        holder.atteBtn.setEnabled(false);
                        ProgramPreAdapter.this.followBtn = holder.atteBtn;
                        ((IChannelOfficialInfoCore)ICoreManagerBase.getCore(IChannelOfficialInfoCore.class)).reserveProgramPreResult(this.item.eventId, act);
                    }
                }
            });
            this.showFollowState(holder, preInfo);
            if (isChoosed) {
                holder.rlTop.setBackgroundColor(ProgramPreComponent.this.getResources().getColor(R.color.bg_preview_expand));
                holder.rlThumb.setVisibility(0);
                holder.desc.setVisibility(0);
                holder.rlShare.setVisibility(0);
                if (FP.empty((CharSequence)preInfo.cycleTips)) {
                    holder.cycleTips.setVisibility(8);
                } else {
                    holder.cycleTips.setVisibility(0);
                    holder.cycleTips.setText((CharSequence)preInfo.cycleTips);
                }
                if (FP.empty((CharSequence)preInfo.desc)) {
                    holder.desc.setVisibility(8);
                } else {
                    holder.desc.setVisibility(0);
                    holder.desc.setText((CharSequence)preInfo.desc);
                }
                holder.share.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        ProgramPreItemInfo item2 = preInfo;
                        ProgramPreComponent.this.share(item2);
                    }
                });
                ImageLoader.loadImage((String)preInfo.thumb, (RecycleImageView)holder.thumb, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.mobile_live_default_background);
                if (preInfo.previewType == 1) {
                    holder.toPlay.setVisibility(0);
                    holder.toPlay.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toPlayPreviewVideo((Activity)ProgramPreAdapter.this.mContext, preInfo.video);
                        }
                    });
                } else {
                    holder.toPlay.setVisibility(8);
                }
            } else {
                holder.rlTop.setBackgroundColor(ProgramPreComponent.this.getResources().getColor(R.color.bg_preview_shrink));
                holder.rlThumb.setVisibility(8);
                holder.desc.setVisibility(8);
                holder.cycleTips.setVisibility(8);
                holder.rlShare.setVisibility(8);
            }
        }

        int paddingRightDis(String name) {
            if (!FP.empty((CharSequence)name)) {
                int size = name.length();
                return size * DimenConverter.dip2px((Context)this.mContext, (float)10.0f) + DimenConverter.dip2px((Context)this.mContext, (float)(12 - size));
            }
            return 0;
        }
    }
}

