/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.channelofficialInfo;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.channelofficialInfo.AnchorInfo;
import com.yy.mobile.ui.utils.DateUtils;
import com.yy.mobile.ui.utils.NoRepeatClickListener;
import com.yy.mobile.ui.widget.DrawableCenterTextView;
import com.yy.mobile.util.StringUtils;

public class AnchorListItem
extends LinearLayout {
    protected OnSubscribeListener mOnSubscribeListener;
    private ImageView mAnchorLiveImg;
    private DrawableCenterTextView mFocusTextView;
    private CircleImageView mCircleImageView;
    private TextView mTimeTitle;
    private TextView mNameTextView;
    private TextView mDecTextView;
    private AnchorInfo mAnchorInfo;
    private int mPosition;
    private int mTimeColor = -1;

    public AnchorListItem(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mAnchorLiveImg = (ImageView)this.findViewById(R.id.anchor_live_img);
        this.mCircleImageView = (CircleImageView)this.findViewById(R.id.anchor_img);
        this.mFocusTextView = (DrawableCenterTextView)this.findViewById(R.id.anchor_focus);
        this.mTimeTitle = (TextView)this.findViewById(R.id.time_title);
        this.mNameTextView = (TextView)this.findViewById(R.id.tv_anchor_name);
        this.mDecTextView = (TextView)this.findViewById(R.id.tv_anchor_dec);
        this.mFocusTextView.setOnClickListener((View.OnClickListener)new NoRepeatClickListener(){

            @Override
            public void onNoRepeatClick(View v) {
                if (AnchorListItem.this.mAnchorInfo == null || AnchorListItem.this.mOnSubscribeListener == null) {
                    return;
                }
                if (((AnchorListItem)AnchorListItem.this).mAnchorInfo.isSubscribe) {
                    AnchorListItem.this.mOnSubscribeListener.onUnSubscribeListener(AnchorListItem.this.mPosition, ((AnchorListItem)AnchorListItem.this).mAnchorInfo.uid);
                } else {
                    AnchorListItem.this.mOnSubscribeListener.onSubscribeListener(AnchorListItem.this.mPosition, ((AnchorListItem)AnchorListItem.this).mAnchorInfo.uid);
                }
            }
        });
    }

    public void bindData(int position, AnchorInfo anchorInfo) {
        if (anchorInfo != null) {
            this.mAnchorInfo = anchorInfo;
            this.mPosition = position;
            if (!TextUtils.isEmpty((CharSequence)anchorInfo.name)) {
                this.setVisibility((View)this.mNameTextView, 0);
                this.setText(this.mNameTextView, anchorInfo.name);
            } else {
                this.setVisibility((View)this.mNameTextView, 8);
                this.setText(this.mNameTextView, "");
            }
            if (!TextUtils.isEmpty((CharSequence)anchorInfo.desc)) {
                this.setVisibility((View)this.mDecTextView, 0);
                this.setText(this.mDecTextView, anchorInfo.desc);
            } else {
                this.setVisibility((View)this.mDecTextView, 8);
                this.setText(this.mDecTextView, "");
            }
            if (anchorInfo.isCurrent) {
                this.mTimeTitle.setText((CharSequence)this.getResources().getString(R.string.str_anchor_living));
                int timeColorToUpdate = this.getResources().getColor(R.color.bg_high_light);
                if (this.mTimeColor != timeColorToUpdate) {
                    this.mTimeColor = timeColorToUpdate;
                    this.mTimeTitle.setTextColor(timeColorToUpdate);
                }
                this.setVisibility((View)this.mFocusTextView, 8);
                this.setVisibility((View)this.mAnchorLiveImg, 0);
            } else {
                this.setText(this.mTimeTitle, DateUtils.convertTime((long)anchorInfo.startTime));
                int timeColorToUpdate = this.getResources().getColor(R.color.shenqu_black);
                if (this.mTimeColor != timeColorToUpdate) {
                    this.mTimeColor = timeColorToUpdate;
                    this.mTimeTitle.setTextColor(timeColorToUpdate);
                }
                this.setVisibility((View)this.mFocusTextView, 0);
                this.setVisibility((View)this.mAnchorLiveImg, 8);
            }
            ImageLoader.loadImage((String)anchorInfo.avatar, (RecycleImageView)this.mCircleImageView, (ImageConfig)ImageConfig.bigImageConfig(), (int)R.drawable.default_portrait);
            this.setFocusTextViewState(anchorInfo.isSubscribe);
        }
    }

    private void setVisibility(View view, int visibility) {
        if (view == null || view.getVisibility() == visibility) {
            return;
        }
        view.setVisibility(visibility);
    }

    private void setText(TextView textView, String text) {
        if (textView == null || textView.getText() != null && textView.getText() != null && StringUtils.equal((String)this.mFocusTextView.getText().toString(), (String)text)) {
            return;
        }
        textView.setText((CharSequence)text);
    }

    public void setFocusTextViewState(boolean isSubscribe) {
        if (this.mFocusTextView.getText() != null && StringUtils.equal((String)this.mFocusTextView.getText().toString(), (String)(isSubscribe ? this.getResources().getString(R.string.str_unsubscribe) : this.getResources().getString(R.string.str_subscribe)))) {
            return;
        }
        if (isSubscribe) {
            this.mFocusTextView.setText((CharSequence)this.getResources().getString(R.string.str_unsubscribe));
            this.mFocusTextView.setTextColor(this.getResources().getColor(R.color.txt_color_follow));
            this.mFocusTextView.setGravity(17);
            this.mFocusTextView.setBackgroundResource(R.drawable.bg_lian_mai_apply_diable);
            this.mFocusTextView.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null);
        } else {
            Drawable drawable2 = this.getResources().getDrawable(R.drawable.living_icon_follow_new);
            drawable2.setBounds(0, 0, drawable2.getMinimumWidth(), drawable2.getMinimumHeight());
            this.mFocusTextView.setCompoundDrawables(drawable2, null, null, null);
            this.mFocusTextView.setBackgroundResource(R.drawable.bg_lian_mai_apply_text);
            this.mFocusTextView.setTextColor(this.getResources().getColor(R.color.txt_color_unfollow));
            this.mFocusTextView.setText((CharSequence)this.getResources().getString(R.string.str_subscribe));
            this.mFocusTextView.setGravity(16);
        }
    }

    public void setSubscribeListener(OnSubscribeListener onSubscribeListener) {
        this.mOnSubscribeListener = onSubscribeListener;
    }

    public static interface OnSubscribeListener {
        public void onSubscribeListener(int var1, long var2);

        public void onUnSubscribeListener(int var1, long var2);
    }
}

