/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicvideomodel;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ListView;
import java.util.ArrayList;
import java.util.List;
import mobile.yy.com.toucheventbus.TouchEventHandlerUtil;

public class ComplexTouchListView
extends ListView {
    OnPreDispatchTouchEventListener mPreDispatchTouchEventListener;
    private float x;
    private float y;
    private long downtime;
    public View mView;
    private List<MotionEvent> set = new ArrayList<MotionEvent>();
    private boolean useTouch = false;

    public ComplexTouchListView(Context context) {
        super(context);
    }

    public ComplexTouchListView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ComplexTouchListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public ComplexTouchListView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public OnPreDispatchTouchEventListener getPreDispatchTouchEventListener() {
        return this.mPreDispatchTouchEventListener;
    }

    public void setPreDispatchTouchEventListener(OnPreDispatchTouchEventListener preDispatchTouchEventListener) {
        this.mPreDispatchTouchEventListener = preDispatchTouchEventListener;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        this.set.add(MotionEvent.obtain((MotionEvent)ev));
        switch (ev.getAction()) {
            case 0: {
                this.x = ev.getX();
                this.y = ev.getY();
                this.downtime = System.currentTimeMillis();
                break;
            }
            case 2: {
                if (!this.canScrollVertically(this.getMoveDirection(ev)) && this.mView != null) {
                    this.useTouch = true;
                    for (MotionEvent event : this.set) {
                        this.mView.dispatchTouchEvent(event);
                    }
                    this.set.clear();
                    return false;
                }
                this.set.clear();
                return this.mPreDispatchTouchEventListener != null && this.mPreDispatchTouchEventListener.onPreDispatchTouchEvent(ev) || super.dispatchTouchEvent(ev);
            }
            case 1: 
            case 3: {
                if (this.isPerformClick(ev)) {
                    this.set.clear();
                    this.useTouch = false;
                    return this.mPreDispatchTouchEventListener != null && this.mPreDispatchTouchEventListener.onPreDispatchTouchEvent(ev) || super.dispatchTouchEvent(ev);
                }
                if (this.useTouch && this.mView != null) {
                    for (MotionEvent event : this.set) {
                        this.mView.dispatchTouchEvent(event);
                    }
                    this.set.clear();
                    this.useTouch = false;
                    return false;
                }
                this.set.clear();
                return this.mPreDispatchTouchEventListener != null && this.mPreDispatchTouchEventListener.onPreDispatchTouchEvent(ev) || super.dispatchTouchEvent(ev);
            }
        }
        return this.mPreDispatchTouchEventListener != null && this.mPreDispatchTouchEventListener.onPreDispatchTouchEvent(ev) || super.dispatchTouchEvent(ev);
    }

    private boolean isPerformClick(MotionEvent event) {
        float cx = event.getX();
        float cy = event.getY();
        float dis = TouchEventHandlerUtil.distance((float)cx, (float)cy, (float)this.x, (float)this.y);
        long duration = System.currentTimeMillis() - this.downtime;
        return dis < 10.0f && duration < 500L;
    }

    private int getMoveDirection(MotionEvent event) {
        float cy = event.getY();
        float delta = this.y - cy;
        if (delta >= 0.0f) {
            return 1;
        }
        return -1;
    }

    public static interface OnPreDispatchTouchEventListener {
        public boolean onPreDispatchTouchEvent(MotionEvent var1);
    }
}

