/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicvideomodel;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentManager;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.RelativeLayout;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.RxBus;
import com.yy.mobile.android.arouter.facade.annotation.Autowired;
import com.yy.mobile.android.arouter.utils.TextUtils;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.liveapi.chatemotion.uicore.IChatEmotionCore;
import com.yy.mobile.liveapi.live.statistic.LiveStatistic;
import com.yy.mobile.liveapi.user.personalinfocard.PersonalInfoCardBuilder;
import com.yy.mobile.liveapi.user.personalinfocard.PersonalInfoCardParams;
import com.yy.mobile.plugin.main.events.IAnchorInfoCardClient_onShowPersonCardAnchor_EventArgs;
import com.yy.mobile.plugin.main.events.IAnchorInfoCardClient_onShowPersonCard_EventArgs;
import com.yy.mobile.plugin.main.events.IAuthClient_onLoginSucceed_EventArgs;
import com.yy.mobile.plugin.main.events.IPublicChatBroadcastClient_onTouchPublicChat_EventArgs;
import com.yy.mobile.plugin.main.events.IWebViewClient_webviewwidth_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basefunction.followguide.LoginFollowGuideManager;
import com.yy.mobile.ui.basefunction.followguide.LoginGuideFlowerPopupComponent;
import com.yy.mobile.ui.basicchanneltemplate.Temp;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.basicvideomodel.BasicChatPluginComponent$$EventBinder;
import com.yy.mobile.ui.basicvideomodel.BasicChatPresenter;
import com.yy.mobile.ui.basicvideomodel.ChatFragmentAdapter;
import com.yy.mobile.ui.basicvideomodel.ComplexTouchListView;
import com.yy.mobile.ui.basicvideomodel.IBasicChatView;
import com.yy.mobile.ui.chatemotion.ChatEmotionComponent;
import com.yy.mobile.ui.chatemotion.LiteChatPopupComponent;
import com.yy.mobile.ui.meidabasicvideoview.IMediaAuxiliaryVideoViewFrameCore;
import com.yy.mobile.ui.meidabasicvideoview.MediaVideoViewSite;
import com.yy.mobile.ui.meidabasicvideoview.uicore.IMediaVideoBasicCore;
import com.yy.mobile.ui.publicchat.model.PublicChatBaseModel;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.util.ActivityUtilKt;
import com.yy.mobile.util.DimenConverter;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.commomscreen.ICommonScreenCore;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import com.yymobile.core.mobilelive.MobileLiveType;
import com.yymobile.core.pluginsconfig.IPluginPropertyCore;
import com.yymobile.liveapi.plugincenter.PluginLivePropKey;
import mobile.yy.com.toucheventbus.TouchEventHandlerUtil;

public class BasicChatPluginComponent
extends Component
implements IBasicChatView {
    public static final int SCROLL_REFRESH_DELAY = 3000;
    public static final String MODEL_TYPE = "model_type";
    private static final String TAG = "BasicChatPluginComponent";
    protected ComplexTouchListView mChatList;
    protected RelativeLayout mChatListLayout;
    @NonNull
    protected PublicChatBaseModel.ModelType modelType = PublicChatBaseModel.ModelType.LIVE;
    protected ViewGroup revenueLayout;
    int layoutMultiHeight = 0;
    private RelativeLayout mRootView;
    protected boolean mCanAutoScroll = true;
    private boolean mIsLandscape;
    protected int screenWidth;
    protected int screenHeight;
    private int lampWidth;
    private int webWidth;
    private FragmentManager fragmentManager;
    private LiteChatPopupComponent component;
    protected boolean isonPause = false;
    protected BasicChatPresenter mPresenter;
    @Autowired(name="anchorCardContribution", desc="\u4e2a\u4eba\u4fe1\u606f\u5361\u662f\u5426\u9700\u8981\u663e\u793a\u8d21\u732e")
    boolean anchorCardShowContribution = true;
    @Autowired(name="anchorCardTrueLove", desc="\u7528\u6237\u8d44\u6599\u5361\u4e0a\u662f\u5426\u663e\u793a\u73cd\u7231\u56e2\u5165\u53e3")
    boolean anchorCardTrueLove = true;
    @Autowired(name="anchorCardNoble", desc="\u7528\u6237\u8d44\u6599\u5361\u4e0a\u662f\u5426\u663e\u793a\u8d35\u65cf\u5165\u53e3")
    boolean anchorCardNoble = false;
    protected Runnable mChatListScrollTask = new Runnable(){

        @Override
        public void run() {
            BasicChatPluginComponent.this.mCanAutoScroll = true;
            BasicChatPluginComponent.this.mPresenter.setDataFreeze(false);
            LiveStatistic.liveChannelBaseProperty((long)LoginUtil.getUid(), (String)"51001", (String)"0049");
        }
    };
    private Boolean lastChatInputSwitch = false;
    private Runnable updateChatListLayoutRunable = new Runnable(){

        @Override
        public void run() {
            BasicChatPluginComponent.this.startUpdateChatListLayoutParams(BasicChatPluginComponent.this.lastChatInputSwitch);
        }
    };
    private EventBinder mBasicChatPluginComponentSniperEventBinder;

    public static BasicChatPluginComponent newInstance(PublicChatBaseModel.ModelType type2, boolean anchorCardShowContribution, boolean anchorCardTrueLove, boolean anchorCardNoble) {
        BasicChatPluginComponent chatFragment = new BasicChatPluginComponent();
        chatFragment.modelType = type2;
        Bundle argument = new Bundle();
        argument.putBoolean("anchorCardContribution", anchorCardShowContribution);
        argument.putBoolean("anchorCardTrueLove", anchorCardTrueLove);
        argument.putBoolean("anchorCardNoble", anchorCardNoble);
        chatFragment.setArguments(argument);
        return chatFragment;
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(MODEL_TYPE, this.modelType.type);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        MLog.debug((Object)TAG, (String)"BasicChatPluginComponent onCreate", (Object[])new Object[0]);
        this.mIsLandscape = this.isLandScape();
        if (savedInstanceState != null) {
            this.modelType = PublicChatBaseModel.ModelType.of(savedInstanceState.getInt(MODEL_TYPE));
        } else if (this.getArguments() != null) {
            this.modelType = PublicChatBaseModel.ModelType.of(this.getArguments().getInt(MODEL_TYPE));
        }
        WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
        if (ActivityUtilKt.isLandScape((Activity)this.getActivity())) {
            this.screenWidth = wm.getDefaultDisplay().getHeight();
            this.screenHeight = wm.getDefaultDisplay().getWidth();
        } else {
            this.screenWidth = wm.getDefaultDisplay().getWidth();
            this.screenHeight = wm.getDefaultDisplay().getHeight();
        }
        MLog.debug((Object)TAG, (String)("onCreate getScreenWidth = " + this.screenWidth + " screenHeight = " + this.screenHeight), (Object[])new Object[0]);
        this.fragmentManager = this.getActivity().getSupportFragmentManager();
        this.lampWidth = (int)ResolutionUtils.convertDpToPixel((float)this.getLampWidth(), (Context)BasicConfig.getInstance().getAppContext());
        this.mPresenter = this.createChatPresenter(this.modelType);
        this.mPresenter.attachView(this);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        MLog.debug((Object)TAG, (String)"onCreateView", (Object[])new Object[0]);
        this.mRootView = (RelativeLayout)inflater.inflate(R.layout.fragment_live_chat, container, false);
        this.mChatList = (ComplexTouchListView)this.mRootView.findViewById(R.id.basic_live_plugin_chat_screen);
        this.mChatListLayout = (RelativeLayout)this.mRootView.findViewById(R.id.chatlist_layout);
        Display defaultDisplay = this.getActivity().getWindowManager().getDefaultDisplay();
        Rect frame = new Rect();
        this.getActivity().getWindow().getDecorView().getWindowVisibleDisplayFrame(frame);
        this.layoutMultiHeight = DensityUtil.px2dip((Context)this.getContext(), (float)(defaultDisplay.getHeight() - frame.top - defaultDisplay.getWidth())) - 80 - 50;
        this.initView();
        if (ICoreManagerBase.getMediaCore().getStreamListSize() >= 2) {
            this.measureUILocation(false);
        } else {
            this.setChatListLayoutParams(false);
        }
        if (ActivityUtilKt.isLandScape((Activity)this.getActivity())) {
            this.mRootView.setVisibility(8);
        } else {
            this.mRootView.setVisibility(0);
        }
        this.revenueLayout = (ViewGroup)this.mRootView.findViewById(R.id.public_chat_revenue);
        if (this.revenueLayout != null) {
            ViewGroup.LayoutParams params = this.revenueLayout.getLayoutParams();
            params.width = (Integer)((IPluginPropertyCore)ICoreManagerBase.getCore(IPluginPropertyCore.class)).getCustomerConfig(PluginLivePropKey.RevenueMarqueWidth.getKey(), (Object)-1);
            this.revenueLayout.setLayoutParams(params);
            if (this.modelType == PublicChatBaseModel.ModelType.LIVE) {
                this.setRevenueLayoutVisible(true);
                this.mPresenter.createChatRevenueController(savedInstanceState, this.revenueLayout);
                if (this.mChatListLayout != null) {
                    this.mPresenter.setMarqueWidth(this.mChatListLayout.getWidth());
                }
            } else {
                this.setRevenueLayoutVisible(false);
            }
        }
        LoginFollowGuideManager.instance().initFollowGuideCarrier(TAG);
        return this.mRootView;
    }

    public void onStart() {
        super.onStart();
        LoginFollowGuideManager.instance().checkShowLoginFlower();
    }

    @NonNull
    protected BasicChatPresenter createChatPresenter(@NonNull PublicChatBaseModel.ModelType type2) {
        return new BasicChatPresenter(type2);
    }

    private String getTemplateId() {
        return Temp.getCurrentBussinessId();
    }

    @Override
    @Nullable
    public FragmentManager getViewFragmentManager() {
        return this.fragmentManager;
    }

    protected int getLayoutHeightDefaultParams() {
        RelativeLayout.LayoutParams params;
        String templateId = this.getTemplateId();
        if (templateId != null && (params = ((ICommonScreenCore)ICoreManagerBase.getCore(ICommonScreenCore.class)).getVerticalParams(templateId)) != null) {
            MLog.info((Object)TAG, (String)("templateId = " + templateId + "  getLayoutHeightDefaultParams : height = " + params.height + " width = " + params.width), (Object[])new Object[0]);
            return params.height;
        }
        MLog.info((Object)TAG, (String)("templateId = " + templateId + "  getLayoutHeightDefaultParams : "), (Object[])new Object[0]);
        return (int)this.getResources().getDimension(R.dimen.new_chatlist_height);
    }

    protected boolean isUseLayoutWidthDefaultParams() {
        RelativeLayout.LayoutParams params;
        String templateId = this.getTemplateId();
        MLog.info((Object)TAG, (String)("getLayoutHeightDefaultParams getTemplate id = " + templateId), (Object[])new Object[0]);
        return templateId == null || (params = ((ICommonScreenCore)ICoreManagerBase.getCore(ICommonScreenCore.class)).getVerticalParams(templateId)) == null;
    }

    protected int getLayoutSpecifyWidthParams() {
        return ((ICommonScreenCore)ICoreManagerBase.getCore(ICommonScreenCore.class)).getVerticalParams((String)this.getTemplateId()).width;
    }

    protected int getLayoutHeightOpenInputParams() {
        RelativeLayout.LayoutParams params;
        String templateId = this.getTemplateId();
        if (templateId != null && (params = ((ICommonScreenCore)ICoreManagerBase.getCore(ICommonScreenCore.class)).getVerticalOpenInputParams(templateId)) != null) {
            MLog.info((Object)TAG, (String)("getLayoutHeightOpenInputParams getTemplate id = " + templateId + "height = " + params.height), (Object[])new Object[0]);
            return params.height;
        }
        return this.screenHeight - (DimenConverter.dip2px((Context)BasicConfig.getInstance().getAppContext(), (float)130.0f) + this.screenWidth * 3 / 4);
    }

    @Override
    public void setLayoutWidthAndHeight(int width, int height) {
        MLog.info((Object)TAG, (String)"update chatList height %d", (Object[])new Object[]{height});
        ViewGroup.LayoutParams param = this.mRootView.getLayoutParams();
        param.height = height;
        this.mRootView.setLayoutParams(param);
    }

    private void initView() {
        ChatFragmentAdapter adapter = this.mPresenter.getChatFragmentAdapter();
        this.mChatList.setAdapter((ListAdapter)adapter);
        this.setScrollFreezeChat();
        this.setPreTouchFreezeChat();
        this.setLongPressLiteChatPopup(adapter);
        if (!Build.MODEL.contains("Meitu")) {
            this.mChatList.setVerticalFadingEdgeEnabled(true);
        }
        this.scrollToBottom(false);
        this.mChatList.setOverScrollMode(2);
    }

    protected void setScrollFreezeChat() {
        this.mChatList.setOnScrollListener(new AbsListView.OnScrollListener(){
            private boolean scrolling = false;

            public void onScrollStateChanged(AbsListView absListView, int scrollState) {
                switch (scrollState) {
                    case 0: {
                        if (this.scrolling && absListView.getLastVisiblePosition() == ((ListAdapter)absListView.getAdapter()).getCount() - 1) {
                            BasicChatPluginComponent.this.mCanAutoScroll = true;
                            BasicChatPluginComponent.this.mPresenter.setDataFreeze(false);
                        }
                        this.scrolling = false;
                        break;
                    }
                    case 1: 
                    case 2: {
                        this.scrolling = true;
                        break;
                    }
                }
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            }
        });
    }

    protected void setPreTouchFreezeChat() {
        this.mChatList.setPreDispatchTouchEventListener(new ComplexTouchListView.OnPreDispatchTouchEventListener(){
            private float x;
            private float y;
            private long downTime;

            @Override
            public boolean onPreDispatchTouchEvent(MotionEvent ev) {
                switch (ev.getAction()) {
                    case 0: {
                        this.x = ev.getX();
                        this.y = ev.getY();
                        this.downTime = System.currentTimeMillis();
                        BasicChatPluginComponent.this.getHandler().removeCallbacks(BasicChatPluginComponent.this.mChatListScrollTask);
                        BasicChatPluginComponent.this.mCanAutoScroll = false;
                        BasicChatPluginComponent.this.mPresenter.setDataFreeze(true);
                        break;
                    }
                    case 1: 
                    case 3: {
                        if (this.isPerformClick(ev)) {
                            BasicChatPluginComponent.this.getHandler().post(BasicChatPluginComponent.this.mChatListScrollTask);
                            break;
                        }
                        BasicChatPluginComponent.this.getHandler().postDelayed(BasicChatPluginComponent.this.mChatListScrollTask, 3000L);
                        RxBus.getDefault().post((Object)new IPublicChatBroadcastClient_onTouchPublicChat_EventArgs());
                        break;
                    }
                }
                return false;
            }

            private boolean isPerformClick(MotionEvent event) {
                float cx = event.getX();
                float cy = event.getY();
                float dis = TouchEventHandlerUtil.distance((float)cx, (float)cy, (float)this.x, (float)this.y);
                long duration = System.currentTimeMillis() - this.downTime;
                return dis < 10.0f && duration < 500L;
            }
        });
    }

    protected void setLongPressLiteChatPopup(final ChatFragmentAdapter adapter) {
        if (this.modelType == PublicChatBaseModel.ModelType.LIVE) {
            this.mChatList.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener(){

                public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
                    ChannelMessage message = adapter.getItem(position);
                    if (message == null) {
                        return false;
                    }
                    MLog.info((Object)BasicChatPluginComponent.TAG, (String)("onLongClick position=" + position + " msg=" + message.pureText), (Object[])new Object[0]);
                    if (TextUtils.isEmpty((CharSequence)message.pureText)) {
                        return false;
                    }
                    if (BasicChatPluginComponent.this.getParentFragment() != null && BasicChatPluginComponent.this.getParentFragment() instanceof ChatEmotionComponent && ((ChatEmotionComponent)BasicChatPluginComponent.this.getParentFragment()).getHotWordsViewVisibility()) {
                        MLog.info((Object)BasicChatPluginComponent.TAG, (String)"current hotwords is showing", (Object[])new Object[0]);
                        return false;
                    }
                    if (LoginUtil.isLogined()) {
                        BasicChatPluginComponent.this.showLiteChatPopup(message.pureText);
                    }
                    return true;
                }
            });
        }
    }

    protected void showLiteChatPopup(String inputText) {
        if (!this.checkActivityValid()) {
            return;
        }
        try {
            if (this.component != null && this.component.isVisible()) {
                this.component.dismiss();
            }
            this.mPresenter.setDataFreeze(false);
            this.component = LiteChatPopupComponent.newInstance(inputText);
            this.component.show(this.getChildFragmentManager(), "\u7cbe\u7b80\u7248\u8f93\u5165\u6846");
        }
        catch (IllegalStateException ignore) {
            MLog.info((Object)TAG, (String)"show LiteChatPopupComponent fail", (Object[])new Object[0]);
        }
    }

    @Override
    public void setRevenueLayoutVisible(boolean isShow) {
        MLog.debug((Object)TAG, (String)("setRevenueLayoutVisible :" + isShow), (Object[])new Object[0]);
        if (this.revenueLayout == null) {
            return;
        }
        if (isShow && this.modelType == PublicChatBaseModel.ModelType.LIVE) {
            this.revenueLayout.setVisibility(0);
        } else {
            this.revenueLayout.setVisibility(8);
        }
    }

    @Override
    public void measureUILocation(boolean chatInputSwitch) {
        if (!this.checkActivityValid() || this.mChatListLayout == null) {
            return;
        }
        if (!((IMobileLiveCore)ICoreManagerBase.getCore(IMobileLiveCore.class)).isLoginUserMobileLive() && ((IMediaVideoBasicCore)ICoreManagerBase.getCore(IMediaVideoBasicCore.class)).getMediaVideoModeInfo().originalScreen == 0 && !((IMediaVideoBasicCore)ICoreManagerBase.getCore(IMediaVideoBasicCore.class)).getMediaVideoModeInfo().mNeedSpecialDeal) {
            MLog.debug((Object)TAG, (String)("originalScreen :" + ((IMediaVideoBasicCore)ICoreManagerBase.getCore(IMediaVideoBasicCore.class)).getMediaVideoModeInfo().originalScreen + " mNeedSpecialDeal :" + ((IMediaVideoBasicCore)ICoreManagerBase.getCore(IMediaVideoBasicCore.class)).getMediaVideoModeInfo().mNeedSpecialDeal), (Object[])new Object[0]);
            this.setSmallChatListLayoutParams(chatInputSwitch, 0);
            return;
        }
        int w = this.isUseLayoutWidthDefaultParams() ? this.screenWidth - DensityUtil.dip2px((Context)this.getActivity(), (float)140.0f) : this.getLayoutSpecifyWidthParams();
        int h = this.getLayoutHeightDefaultParams();
        RelativeLayout.LayoutParams landscapeLayoutParams = new RelativeLayout.LayoutParams(w, h);
        landscapeLayoutParams.addRule(12, -1);
        landscapeLayoutParams.addRule(9, -1);
        this.mChatListLayout.setLayoutParams((ViewGroup.LayoutParams)landscapeLayoutParams);
        MLog.debug((Object)TAG, (String)"measureUiLocation width = %d, height = %d", (Object[])new Object[]{w, h});
        this.mPresenter.setMarqueWidth(w);
    }

    @Override
    public void setChatListLayoutParams(boolean chatInputSwitch) {
        MLog.info((Object)TAG, (String)("setChatListLayoutParams : chatInputSwitch=" + chatInputSwitch), (Object[])new Object[0]);
        this.lastChatInputSwitch = chatInputSwitch;
        if (this.mChatListLayout != null) {
            this.mChatListLayout.removeCallbacks(this.updateChatListLayoutRunable);
            this.mChatListLayout.postDelayed(this.updateChatListLayoutRunable, 150L);
        }
    }

    protected int getLampWidth() {
        return 40;
    }

    private void startUpdateChatListLayoutParams(boolean chatInputSwitch) {
        MLog.info((Object)TAG, (String)("startUpdateChatListLayoutParams start : chatInputSwitch=" + chatInputSwitch), (Object[])new Object[0]);
        if (this.mChatListLayout != null) {
            int width = this.getLayoutWidth(chatInputSwitch);
            if (ICoreManagerBase.getCore(IMobileLiveCore.class) != null && ((IMobileLiveCore)ICoreManagerBase.getCore(IMobileLiveCore.class)).isLoginUserMobileLive()) {
                MLog.debug((Object)TAG, (String)"setChatListLayoutParams isLoginUserMobileLive", (Object[])new Object[0]);
                int w = this.isUseLayoutWidthDefaultParams() ? (width > 0 ? width : this.screenWidth - DensityUtil.dip2px((Context)this.getActivity(), (float)140.0f)) : this.getLayoutSpecifyWidthParams();
                int h = this.getLayoutHeightDefaultParams();
                RelativeLayout.LayoutParams landscapeLayoutParams = new RelativeLayout.LayoutParams(w, h);
                landscapeLayoutParams.addRule(12, -1);
                landscapeLayoutParams.addRule(9, -1);
                landscapeLayoutParams.setMargins(0, 0, 0, 0);
                this.mChatListLayout.setLayoutParams((ViewGroup.LayoutParams)landscapeLayoutParams);
                this.mPresenter.setMarqueWidth(w);
            } else {
                boolean showPosition = ICoreManagerBase.getChannelLinkCore().getPublicCommonShowPosition();
                MLog.debug((Object)TAG, (String)("originalScreen :" + ((IMediaVideoBasicCore)ICoreManagerBase.getCore(IMediaVideoBasicCore.class)).getMediaVideoModeInfo().originalScreen + " videoStyle :" + this.isVideoStyle() + " showPosition :" + showPosition), (Object[])new Object[0]);
                if (((IMediaVideoBasicCore)ICoreManagerBase.getCore(IMediaVideoBasicCore.class)).getMediaVideoModeInfo().originalScreen == 0 && this.isVideoStyle() || showPosition) {
                    if (MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)TAG, (String)"setChatListLayoutParams originalScreen == 0", (Object[])new Object[0]);
                    }
                    this.setSmallChatListLayoutParams(chatInputSwitch, width);
                } else {
                    if (MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)TAG, (String)"setChatListLayoutParams originalScreen != 0", (Object[])new Object[0]);
                    }
                    int w = this.isUseLayoutWidthDefaultParams() ? (width > 0 ? width : this.screenWidth * 3 / 4) : this.getLayoutSpecifyWidthParams();
                    int h = this.getLayoutHeightDefaultParams();
                    RelativeLayout.LayoutParams landscapeLayoutParams = new RelativeLayout.LayoutParams(w, h);
                    landscapeLayoutParams.addRule(12, -1);
                    landscapeLayoutParams.addRule(9, -1);
                    this.mChatListLayout.setLayoutParams((ViewGroup.LayoutParams)landscapeLayoutParams);
                    this.mPresenter.setMarqueWidth(w);
                }
            }
        }
        MLog.info((Object)TAG, (String)"setChatListLayoutParams end", (Object[])new Object[0]);
    }

    @Override
    public void setSmallChatListLayoutParams(boolean chatInputSwitch, int width) {
        MLog.info((Object)TAG, (String)("setSmallChatListLayoutParams : chatInputSwitch=" + chatInputSwitch + " ,width=" + width), (Object[])new Object[0]);
        if (this.mChatListLayout != null) {
            if (chatInputSwitch) {
                int w = width > 0 ? width : this.screenWidth * 3 / 4;
                int h = this.getLayoutHeightOpenInputParams();
                RelativeLayout.LayoutParams params = ((ICommonScreenCore)ICoreManagerBase.getCore(ICommonScreenCore.class)).getVerticalParams(this.getTemplateId());
                if (params != null && params.height > 0) {
                    h = params.height;
                    w = params.width;
                }
                RelativeLayout.LayoutParams landscapeLayoutParams = new RelativeLayout.LayoutParams(w, h);
                landscapeLayoutParams.addRule(12, -1);
                landscapeLayoutParams.addRule(9, -1);
                this.mChatListLayout.setLayoutParams((ViewGroup.LayoutParams)landscapeLayoutParams);
                MLog.debug((Object)TAG, (String)("setSmallChatListLayoutParams width :" + w + " height :" + h), (Object[])new Object[0]);
                this.mPresenter.setMarqueWidth(w);
            } else {
                RelativeLayout.LayoutParams params;
                int w = width > 0 ? width : this.screenWidth * 3 / 4;
                int h = -1;
                boolean match = (Boolean)((IPluginPropertyCore)ICoreManagerBase.getCore(IPluginPropertyCore.class)).getCustomerConfig(PluginLivePropKey.SmallChatListLayoutHeightMatch.getKey(), (Object)true);
                if (!match) {
                    h = this.getLayoutHeightDefaultParams();
                }
                if ((params = ((ICommonScreenCore)ICoreManagerBase.getCore(ICommonScreenCore.class)).getVerticalParams(this.getTemplateId())) != null && params.height > 0) {
                    h = params.height;
                    w = params.width;
                }
                RelativeLayout.LayoutParams landscapeLayoutParams = new RelativeLayout.LayoutParams(w, h);
                landscapeLayoutParams.setMargins(0, DimenConverter.dip2px((Context)BasicConfig.getInstance().getAppContext(), (float)80.0f) + this.screenWidth * 3 / 4, 0, 0);
                landscapeLayoutParams.addRule(9);
                this.mChatListLayout.setLayoutParams((ViewGroup.LayoutParams)landscapeLayoutParams);
                this.mPresenter.setMarqueWidth(w);
                MLog.debug((Object)TAG, (String)("setSmallChatListLayoutParams width :" + w + " height :" + h), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public int getScreenWidth() {
        return this.screenWidth;
    }

    @Override
    public int getLayoutWidth(boolean chatInputSwitch) {
        MLog.info((Object)TAG, (String)("getLayoutWidth : chatInputSwitch=" + chatInputSwitch), (Object[])new Object[0]);
        IMediaAuxiliaryVideoViewFrameCore iMediaAuxiliaryVideoViewFrameCore = (IMediaAuxiliaryVideoViewFrameCore)ICoreManagerBase.getCore(IMediaAuxiliaryVideoViewFrameCore.class);
        MediaVideoViewSite mediaVideoViewSite = null;
        if (iMediaAuxiliaryVideoViewFrameCore != null) {
            mediaVideoViewSite = iMediaAuxiliaryVideoViewFrameCore.getAuxiliaryVideoViewFrame();
        }
        if (this.mPresenter == null || ICoreManagerBase.getMediaCore() == null || ICoreManagerBase.getCore(IMobileLiveCore.class) == null) {
            MLog.error((Object)TAG, (String)"getLayoutWidth: -> some null happened", (Object[])new Object[0]);
            return 0;
        }
        if (this.mPresenter.isSmallMode() || (ICoreManagerBase.getMediaCore().getStreamListSize() >= 2 || Temp.getCurrentBussinessId() == null && ((IMobileLiveCore)ICoreManagerBase.getCore(IMobileLiveCore.class)).getMobileLiveType() != null && ((IMobileLiveCore)ICoreManagerBase.getCore(IMobileLiveCore.class)).getMobileLiveType() != MobileLiveType.NOT_LIVING && ICoreManagerBase.getMediaCore().getStreamListSize() >= 1) && null != mediaVideoViewSite && mediaVideoViewSite.getStyle() == 0) {
            return this.screenWidth - DensityUtil.dip2px((Context)this.getActivity(), (float)140.0f);
        }
        if (chatInputSwitch || this.webWidth == 0) {
            MLog.info((Object)TAG, (String)"getLayoutWidth : 0", (Object[])new Object[0]);
            return 0;
        }
        return this.screenWidth - this.webWidth - this.lampWidth;
    }

    @Override
    public void scrollToBottom(boolean needCheckAutoScroll) {
        if (needCheckAutoScroll && !this.mCanAutoScroll) {
            return;
        }
        ChatFragmentAdapter adapter = this.mPresenter.getChatFragmentAdapter();
        if (this.mChatList != null && adapter != null && adapter.getCount() > 0) {
            this.mChatList.setSelection(adapter.getCount() - 1);
        }
    }

    public void onOrientationChanged(boolean isLandscape) {
        this.mIsLandscape = isLandscape;
        if (!this.mIsLandscape) {
            this.mRootView.setVisibility(0);
            if (ICoreManagerBase.getMediaCore().getStreamListSize() >= 2) {
                this.measureUILocation(false);
            } else {
                this.setChatListLayoutParams(false);
            }
            this.mPresenter.onOrientationChange(isLandscape);
        } else {
            this.mRootView.setVisibility(8);
        }
    }

    public void onDestroyView() {
        if (this.mChatListLayout != null) {
            this.mChatListLayout.removeCallbacks(this.updateChatListLayoutRunable);
        }
        super.onDestroyView();
        Object var2_1 = null;
        if (this.mBasicChatPluginComponentSniperEventBinder != null) {
            this.mBasicChatPluginComponentSniperEventBinder.unBindEvent();
        }
    }

    public void onDestroy() {
        if (this.mPresenter != null) {
            this.mPresenter.detachView();
            this.mPresenter = null;
        }
        this.getHandler().removeCallbacks(this.mChatListScrollTask);
        this.mIsLandscape = false;
        this.fragmentManager = null;
        super.onDestroy();
    }

    @BusEvent(sync=true)
    public void onShowPersonCard(IAnchorInfoCardClient_onShowPersonCard_EventArgs busEventArgs) {
        long uid = busEventArgs.getUid();
        if (!this.isonPause) {
            boolean isReplay = this.modelType == PublicChatBaseModel.ModelType.REPLAY;
            new PersonalInfoCardBuilder(uid).setIsReplay(isReplay).addViewVisibility(PersonalInfoCardParams.OrignBtn.PrivateChat, !isReplay).setHasDimBehind(true).setShowContribution(this.anchorCardShowContribution).setShowTrasureLove(this.anchorCardTrueLove).setHasNoble(this.anchorCardNoble).withFragmentManager(this.fragmentManager).show();
        }
    }

    @BusEvent(sync=true)
    public void onShowPersonCardAnchor(IAnchorInfoCardClient_onShowPersonCardAnchor_EventArgs busEventArgs) {
        long uid = busEventArgs.getUid();
        String hdid = busEventArgs.getHdid();
        if (!this.isonPause) {
            boolean isReplay = this.modelType == PublicChatBaseModel.ModelType.REPLAY;
            new PersonalInfoCardBuilder(uid).addViewVisibility(PersonalInfoCardParams.OrignBtn.PrivateChat, !isReplay).setIsReplay(isReplay).setHasDimBehind(true).setUserHdid(hdid).setHasNoble(this.anchorCardNoble).setShowContribution(this.anchorCardShowContribution).setShowTrasureLove(this.anchorCardTrueLove).withFragmentManager(this.fragmentManager).show();
        }
    }

    @BusEvent(sync=true)
    public void webviewwidth(IWebViewClient_webviewwidth_EventArgs busEventArgs) {
        int width = busEventArgs.getWidth();
        MLog.debug((Object)TAG, (String)("webviewwidth=" + width), (Object[])new Object[0]);
        if (width > this.screenWidth / 2) {
            if (this.webWidth == this.screenWidth / 2) {
                MLog.info((Object)TAG, (String)"IWebViewClient_webviewwidth_EventArgs get too many times why?", (Object[])new Object[0]);
                return;
            }
            this.webWidth = this.screenWidth / 2;
        } else {
            if (this.webWidth == width) {
                MLog.info((Object)TAG, (String)"IWebViewClient_webviewwidth_EventArgs get too many times why why?", (Object[])new Object[0]);
                return;
            }
            this.webWidth = width;
        }
        this.setChatListLayoutParams(((IChatEmotionCore)ICoreManagerBase.getCore(IChatEmotionCore.class)).getChatInputState());
    }

    private boolean isVideoStyle() {
        return this.isLandScape() || ((IMediaVideoBasicCore)ICoreManagerBase.getCore(IMediaVideoBasicCore.class)).getMediaVideoModeInfo().verticalStyle != 1;
    }

    private boolean isLandScape() {
        if (this.checkActivityValid()) {
            return ActivityUtilKt.isLandScape((Activity)this.getActivity());
        }
        return false;
    }

    public void onResume() {
        super.onResume();
        this.isonPause = false;
    }

    public void onPause() {
        super.onPause();
        this.isonPause = true;
    }

    @Override
    public void updateRevenueMarginTop(int top) {
        if (this.revenueLayout == null) {
            return;
        }
        ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.revenueLayout.getLayoutParams();
        if (null != layoutParams) {
            layoutParams.topMargin = ScreenUtil.getInstance().dip2px(top);
            this.revenueLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            MLog.debug((Object)TAG, (String)("updateRevenueMarginTop :" + top + "dp"), (Object[])new Object[0]);
        }
    }

    @Override
    public Activity getChatActivity() {
        return this.getActivity();
    }

    @Override
    public boolean isReadyForChangData() {
        return this.checkActivityValid() && ActivityUtilKt.isPortrait((Activity)this.getActivity()) && this.getUserVisibleHint() && this.isResumed();
    }

    @Override
    public void addGuideViewToContainer(ViewGroup guideView, ViewGroup.LayoutParams layoutParams) {
        RelativeLayout rlGuideContainer = (RelativeLayout)this.mRootView.findViewById(R.id.rl_follow_guide_chat_container);
        if (rlGuideContainer != null) {
            rlGuideContainer.removeAllViews();
            rlGuideContainer.addView((View)guideView, layoutParams);
            MLog.debug((Object)TAG, (String)"addGuideViewToContainer", (Object[])new Object[0]);
        }
    }

    @Override
    public void clearGuideViewContainer() {
        RelativeLayout rlGuideContainer = (RelativeLayout)this.mRootView.findViewById(R.id.rl_follow_guide_chat_container);
        if (rlGuideContainer != null) {
            rlGuideContainer.removeAllViews();
        }
    }

    @Override
    public boolean isGuideContainerHasView(int resId) {
        RelativeLayout rlGuideContainer = (RelativeLayout)this.mRootView.findViewById(R.id.rl_follow_guide_chat_container);
        if (rlGuideContainer != null) {
            View childView = rlGuideContainer.findViewById(resId);
            return childView != null;
        }
        return false;
    }

    @Override
    public void showLoginGuideFlower() {
        MLog.info((Object)TAG, (String)"showLoginGuideFlower:", (Object[])new Object[0]);
        LoginGuideFlowerPopupComponent flowerPopupComponent = LoginGuideFlowerPopupComponent.newInstance();
        flowerPopupComponent.show(this.getChildFragmentManager(), "LoginGuideFlowerPopupComponent");
    }

    @BusEvent(sync=true)
    public void onLoginSucceed(IAuthClient_onLoginSucceed_EventArgs busEventArgs) {
        if (!this.isonPause) {
            LoginFollowGuideManager.instance().checkShowLoginFlower();
        }
    }

    protected void onViewCreated(View view, Bundle bundle) {
        if (this.mBasicChatPluginComponentSniperEventBinder == null) {
            this.mBasicChatPluginComponentSniperEventBinder = new BasicChatPluginComponent$$EventBinder();
        }
        this.mBasicChatPluginComponentSniperEventBinder.bindEvent((Object)this);
        super.onViewCreated(view, bundle);
    }
}

