/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicgunview.danmuopengl.gunpower;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.richtext.ChannelTicketFilter;
import com.yy.mobile.ui.basicgunview.newgunpower.GunNewPower;
import com.yy.mobile.util.DimenConverter;

public class GunPlaneTicketPowder
extends GunNewPower {
    private final Matrix mShaderMatrix = new Matrix();

    public GunPlaneTicketPowder(long gunId, String content, String nickName, int sid, int subid, long senderUid) {
        super(gunId, content, sid, subid, senderUid);
        this.nickName = nickName;
    }

    public void createPowertoShell(Context context) {
        Bitmap planeTicketIcon = BitmapFactory.decodeResource((Resources)context.getResources(), (int)R.drawable.icon_plane20);
        int giftWidth = 0;
        int offsetLeft = 0;
        int avatarWidth = 0;
        Paint mPainter = new Paint(1);
        mPainter.setTextSize((float)DimenConverter.sp2px((Context)BasicConfig.getInstance().getAppContext(), (float)this.mTextSize));
        mPainter.setColor(Color.parseColor((String)"#b5d000"));
        mPainter.setTextAlign(Paint.Align.LEFT);
        Paint myPainter = new Paint(1);
        myPainter.setTextSize((float)DimenConverter.sp2px((Context)BasicConfig.getInstance().getAppContext(), (float)this.mTextNicknameSize));
        myPainter.setColor(Color.parseColor((String)"#b5d000"));
        myPainter.setTextAlign(Paint.Align.LEFT);
        Paint mAvatarBorderPaint = new Paint(1);
        mAvatarBorderPaint.setAntiAlias(true);
        mAvatarBorderPaint.setColor(-1);
        mPainter.setShadowLayer(5.0f, 3.0f, 0.0f, -16777216);
        mAvatarBorderPaint.setShadowLayer(5.0f, 3.0f, 0.0f, -16777216);
        String str1 = ChannelTicketFilter.replaceChannelTicketWithGivenStr((String)this.content, (String)"");
        String content = str1 + "\u70b9\u51fb\u8fdb\u5165" + this.sid + "\u9891\u9053";
        if (str1.length() >= 15) {
            content = str1.substring(0, 15) + "...\u70b9\u51fb\u8fdb\u5165" + this.sid + "\u9891\u9053";
        }
        float baseline = (int)(-mPainter.ascent() + 0.5f);
        int width = (int)(mPainter.measureText(this.nickName + content + "  ") + 2.0f);
        giftWidth = DimenConverter.dip2px((Context)BasicConfig.getInstance().getAppContext(), (float)20.0f);
        offsetLeft = DimenConverter.dip2px((Context)BasicConfig.getInstance().getAppContext(), (float)8.0f);
        avatarWidth = DimenConverter.dip2px((Context)BasicConfig.getInstance().getAppContext(), (float)12.0f);
        int offsetRight = DimenConverter.dip2px((Context)BasicConfig.getInstance().getAppContext(), (float)20.0f);
        int avatarHeight = DimenConverter.dip2px((Context)BasicConfig.getInstance().getAppContext(), (float)28.0f);
        int actualWidth = width + offsetLeft + giftWidth + offsetRight;
        Bitmap bitmap = Bitmap.createBitmap((int)actualWidth, (int)avatarHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas();
        canvas.setBitmap(bitmap);
        int save = canvas.save();
        canvas.translate((float)offsetLeft, 0.0f);
        Paint strokePaint = new Paint(mPainter);
        strokePaint.setStyle(Paint.Style.FILL_AND_STROKE);
        strokePaint.setStrokeWidth(3.0f);
        strokePaint.setColor(-16777216);
        Paint strokeMyPaint = new Paint(myPainter);
        strokeMyPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        strokeMyPaint.setStrokeWidth(3.0f);
        strokeMyPaint.setColor(-16777216);
        int posX = 0;
        canvas.drawText(this.nickName + " : ", (float)posX, baseline, strokeMyPaint);
        canvas.drawText(this.nickName + " : ", (float)posX, baseline, myPainter);
        posX = (int)((float)posX + (myPainter.measureText(this.nickName) + (float)avatarWidth));
        canvas.drawBitmap(planeTicketIcon, (float)posX, 0.0f, strokePaint);
        canvas.drawBitmap(planeTicketIcon, (float)posX, 0.0f, mPainter);
        posX = (int)((double)posX + ((double)giftWidth + 3.0));
        canvas.drawText(content, (float)posX, baseline, strokePaint);
        canvas.drawText(content, (float)posX, baseline, mPainter);
        canvas.restoreToCount(save);
        this.bitmap = bitmap;
    }

    private Bitmap zoom(Bitmap oriBmp, int dstWidth, int dstHeight) {
        int width = oriBmp.getWidth();
        int height = oriBmp.getHeight();
        float scaleWidth = (float)dstWidth / (float)width;
        float scaleHeight = (float)dstHeight / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        return Bitmap.createBitmap((Bitmap)oriBmp, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
    }

    protected void updateShaderMatrix(BitmapShader bitmapShader, int bitmapWidth, int bitmapHeight, Rect drawableRect) {
        float scale;
        float dx = 0.0f;
        float dy = 0.0f;
        this.mShaderMatrix.set(null);
        if (bitmapWidth * drawableRect.height() > drawableRect.width() * bitmapHeight) {
            scale = (float)drawableRect.height() / (float)bitmapHeight;
            dx = ((float)drawableRect.width() - (float)bitmapWidth * scale) * 0.5f;
        } else {
            scale = (float)drawableRect.width() / (float)bitmapWidth;
            dy = ((float)drawableRect.height() - (float)bitmapHeight * scale) * 0.5f;
        }
        this.mShaderMatrix.setScale(scale, scale);
        this.mShaderMatrix.postTranslate((float)((int)(dx + 0.5f) + 2), (float)((int)(dy + 0.5f) + 2));
        bitmapShader.setLocalMatrix(this.mShaderMatrix);
    }

    public void setCount(String count) {
        this.mCount = count;
    }

    public String toString() {
        return "GunPowder{mPowder'" + this.content + '\'' + ", senderUid='" + this.senderUid + '\'' + '}';
    }
}

