/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicgunview.danmucanvas.utils;

import android.graphics.Bitmap;
import com.yy.mobile.ui.basicgunview.danmucanvas.Bean.PoolObject;
import com.yy.mobile.ui.basicgunview.danmucanvas.utils.ObjectPool;
import com.yy.mobile.util.ScreenUtil;
import java.util.ArrayList;

public class BitMapPool
extends ObjectPool {
    private static final int POOL_SIZE = 9;
    private static volatile BitMapPool mInstance;
    private int mHeight;
    private int mWidth;

    private BitMapPool() {
        this.mPoolList = new ArrayList(9);
        this.mHeight = ScreenUtil.getInstance().dip2px(27);
        this.mWidth = ScreenUtil.getInstance().getHeightPixels() / 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BitMapPool getInstance() {
        if (mInstance != null) return mInstance;
        Class<BitMapPool> clazz = BitMapPool.class;
        synchronized (BitMapPool.class) {
            if (mInstance != null) return mInstance;
            mInstance = new BitMapPool();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public Object getObj(int width) {
        ++this.query;
        if (this.mPoolList == null || width > this.mWidth) {
            return null;
        }
        if (this.mPoolList.size() < 9) {
            PoolObject po = this.createPoolObj(this.mWidth, true, this.mPoolList.size());
            this.mPoolList.add(po);
            ++this.hit;
            return po;
        }
        return this.findObj();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object findObj() {
        if (this.mPoolList == null) {
            return null;
        }
        for (int i = 0; i < this.mPoolList.size(); ++i) {
            PoolObject po = (PoolObject)this.mPoolList.get(i);
            BitMapPool bitMapPool = this;
            synchronized (bitMapPool) {
                if (!po.mUsed) {
                    ++this.hit;
                    po.mUsed = true;
                    return po;
                }
                continue;
            }
        }
        return null;
    }

    private PoolObject createPoolObj(int width, boolean used, int pos) {
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)this.mHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        return new PoolObject(bitmap, used, pos);
    }

    public void recycle() {
        if (this.mPoolList != null) {
            for (int i = 0; i < this.mPoolList.size(); ++i) {
                PoolObject po = (PoolObject)this.mPoolList.get(i);
                ((Bitmap)po.mObjection).recycle();
                po.mObjection = null;
            }
            this.mPoolList.clear();
        }
        this.mPoolList = null;
        mInstance = null;
    }
}

