/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicgunview.danmucanvas.renderer.android;

import com.yy.mobile.ui.basicgunview.danmucanvas.Bean.BaseDanmaku;
import com.yy.mobile.ui.basicgunview.danmucanvas.model.IDanmakus;
import com.yy.mobile.ui.basicgunview.danmucanvas.model.IDisplayer;
import com.yy.mobile.ui.basicgunview.danmucanvas.model.android.DanmakuContext;
import com.yy.mobile.ui.basicgunview.danmucanvas.renderer.IRenderer;
import com.yy.mobile.ui.basicgunview.danmucanvas.renderer.Renderer;
import com.yy.mobile.ui.basicgunview.danmucanvas.utils.BitMapPool;
import java.util.Iterator;

public class DanmakuRenderer
extends Renderer {
    private final IRenderer.RenderingState mRenderingState = new IRenderer.RenderingState();
    private final DanmakuContext mContext;
    private IRenderer.OnDanmakuShownListener mOnDanmakuShownListener;

    public DanmakuRenderer(DanmakuContext config) {
        this.mContext = config;
    }

    public void fix(BaseDanmaku drawItem, IDisplayer disp, float detalOffset, float lineHeigit) {
        drawItem.layout(disp, drawItem.getLeft(), drawItem.getYByPos(disp.getDensity()), detalOffset, lineHeigit);
    }

    @Override
    public IRenderer.RenderingState draw(IDisplayer disp, IDanmakus danmakus, long startRenderTime) {
        this.mRenderingState.reset();
        Iterator itr = danmakus.getItems().iterator();
        BaseDanmaku drawItem = null;
        while (itr.hasNext()) {
            drawItem = (BaseDanmaku)itr.next();
            this.fix(drawItem, disp, this.mContext.getDetalOffset(), this.mContext.getLineHeight());
            if (!drawItem.isOutside() && drawItem.isShown()) {
                drawItem.draw(disp);
                this.mRenderingState.addTotalCount(1);
                continue;
            }
            drawItem.setVisibility(false);
            itr.remove();
            if (drawItem.poolPos != -1) {
                BitMapPool.getInstance().setPosNoUse(drawItem.poolPos);
                continue;
            }
            if (drawItem.cache == null) continue;
            drawItem.cache.recycle();
            drawItem.cache = null;
        }
        this.mRenderingState.nothingRendered = this.mRenderingState.totalDanmakuCount == 0;
        return this.mRenderingState;
    }

    @Override
    public void setOnDanmakuShownListener(IRenderer.OnDanmakuShownListener onDanmakuShownListener) {
        this.mOnDanmakuShownListener = onDanmakuShownListener;
    }

    @Override
    public void removeOnDanmakuShownListener() {
        this.mOnDanmakuShownListener = null;
    }

    @Override
    public void alignBottom(boolean enable) {
    }
}

