/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicgunview.danmucanvas.model.android;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.os.Build;
import com.yy.mobile.ui.basicgunview.danmucanvas.Bean.BaseDanmaku;
import com.yy.mobile.ui.basicgunview.danmucanvas.model.AbsDisplayer;
import com.yy.mobile.util.log.MLog;

public class AndroidDisplayer
extends AbsDisplayer<Canvas, Typeface> {
    public Canvas canvas;
    private Paint alphaPaint = new Paint();
    private int width;
    private int height;
    private float density = 1.0f;
    private int densityDpi = 160;
    private boolean mIsHardwareAccelerated = true;
    private int mMaximumBitmapWidth = 2048;
    private int mMaximumBitmapHeight = 2048;

    @SuppressLint(value={"NewApi"})
    private static int getMaximumBitmapWidth(Canvas c) {
        if (Build.VERSION.SDK_INT >= 14) {
            return c.getMaximumBitmapWidth();
        }
        return c.getWidth();
    }

    @SuppressLint(value={"NewApi"})
    private static int getMaximumBitmapHeight(Canvas c) {
        if (Build.VERSION.SDK_INT >= 14) {
            return c.getMaximumBitmapHeight();
        }
        return c.getHeight();
    }

    private void update(Canvas c) {
        this.canvas = c;
        if (c != null) {
            this.width = c.getWidth();
            this.height = c.getHeight();
            if (this.mIsHardwareAccelerated) {
                this.mMaximumBitmapWidth = AndroidDisplayer.getMaximumBitmapWidth(c);
                this.mMaximumBitmapHeight = AndroidDisplayer.getMaximumBitmapHeight(c);
            }
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public float getDensity() {
        return this.density;
    }

    @Override
    public int getDensityDpi() {
        return this.densityDpi;
    }

    @Override
    public int draw(BaseDanmaku danmaku) {
        float top = danmaku.getTop();
        float left = danmaku.getLeft();
        if (this.canvas != null && danmaku.cache != null && !danmaku.cache.isRecycled()) {
            this.canvas.save();
            this.canvas.clipRect(left, top, danmaku.getRight(), danmaku.getBottom());
            try {
                this.canvas.drawBitmap(danmaku.cache, left, top, this.alphaPaint);
            }
            catch (Throwable e) {
                MLog.info((Object)"andriodDisplay", (String)("draw " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.canvas.restore();
            return 1;
        }
        return 0;
    }

    @Override
    public void measure(BaseDanmaku danmaku, boolean fromWorkerThread) {
        this.calcPaintWH(danmaku);
    }

    public void measure(BaseDanmaku danmaku) {
        if (danmaku.cache != null) {
            danmaku.paintHeight = danmaku.cache.getHeight();
        }
    }

    private void calcPaintWH(BaseDanmaku danmaku) {
        this.measure(danmaku);
        this.setDanmakuPaintWidthAndHeight(danmaku, danmaku.paintWidth, danmaku.paintHeight);
    }

    private void setDanmakuPaintWidthAndHeight(BaseDanmaku danmaku, float w, float h) {
        float pw = w + (float)(2 * danmaku.padding);
        float ph = h + (float)(2 * danmaku.padding);
        danmaku.paintWidth = pw;
        danmaku.paintHeight = ph;
    }

    @Override
    public void setDensities(float density, int densityDpi) {
        this.density = density;
        this.densityDpi = densityDpi;
    }

    @Override
    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public Canvas getExtraData() {
        return this.canvas;
    }

    @Override
    public void setExtraData(Canvas data) {
        this.update(data);
    }

    @Override
    public void setHardwareAccelerated(boolean enable) {
        this.mIsHardwareAccelerated = enable;
    }
}

