/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicgunview.danmucanvas.controller;

import com.yy.mobile.ui.basicgunview.danmucanvas.Bean.BaseDanmaku;
import com.yy.mobile.ui.basicgunview.danmucanvas.controller.IDrawTask;
import com.yy.mobile.ui.basicgunview.danmucanvas.model.AbsDisplayer;
import com.yy.mobile.ui.basicgunview.danmucanvas.model.IDanmakuIterator;
import com.yy.mobile.ui.basicgunview.danmucanvas.model.IDanmakus;
import com.yy.mobile.ui.basicgunview.danmucanvas.model.android.DanmakuContext;
import com.yy.mobile.ui.basicgunview.danmucanvas.model.android.Danmakus;
import com.yy.mobile.ui.basicgunview.danmucanvas.renderer.IRenderer;
import com.yy.mobile.ui.basicgunview.danmucanvas.renderer.android.DanmakuRenderer;
import com.yy.mobile.ui.basicgunview.danmucanvas.utils.DanmakuTimer;

public class DrawTask
implements IDrawTask {
    protected final DanmakuContext mContext;
    protected final AbsDisplayer mDisp;
    final IRenderer mRenderer;
    protected volatile IDanmakus danmakuList;
    protected int mPlayState;
    IDrawTask.TaskListener mTaskListener;
    DanmakuTimer mTimer;
    private long mStartRenderTime = 0L;
    private IRenderer.RenderingState mRenderingState = new IRenderer.RenderingState();
    private boolean mIsHidden;

    public DrawTask(DanmakuTimer timer, DanmakuContext context, IDrawTask.TaskListener taskListener) {
        if (context == null) {
            throw new IllegalArgumentException("context is null");
        }
        this.mContext = context;
        this.mDisp = context.getDisplayer();
        this.mTaskListener = taskListener;
        this.mRenderer = new DanmakuRenderer(context);
        this.mRenderer.setOnDanmakuShownListener(new IRenderer.OnDanmakuShownListener(){

            @Override
            public void onDanmakuShown(BaseDanmaku danmaku) {
                if (DrawTask.this.mTaskListener != null) {
                    DrawTask.this.mTaskListener.onDanmakuShown(danmaku);
                }
            }
        });
        this.initTimer(timer);
    }

    protected void initTimer(DanmakuTimer timer) {
        this.mTimer = timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addDanmaku(BaseDanmaku item2) {
        if (this.danmakuList == null) {
            return;
        }
        boolean added = false;
        item2.measure(this.mDisp, false);
        IDanmakus iDanmakus = this.danmakuList;
        synchronized (iDanmakus) {
            added = this.danmakuList.addItem(item2);
        }
        if (added && this.mTaskListener != null) {
            this.mTaskListener.onDanmakuAdd(item2);
        }
    }

    @Override
    public void invalidateDanmaku(BaseDanmaku item2, boolean remeasure) {
        if (remeasure) {
            item2.paintWidth = -1.0f;
            item2.paintHeight = -1.0f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeAllDanmakus(boolean isClearDanmakusOnScreen) {
        if (this.danmakuList == null || this.danmakuList.isEmpty()) {
            return;
        }
        IDanmakus iDanmakus = this.danmakuList;
        synchronized (iDanmakus) {
            this.danmakuList.clear();
        }
    }

    protected void onDanmakuRemoved(BaseDanmaku danmaku) {
    }

    @Override
    public synchronized void removeAllLiveDanmakus() {
    }

    @Override
    public IDanmakus getVisibleDanmakusOnTime(long time) {
        return this.danmakuList;
    }

    @Override
    public synchronized void draw(AbsDisplayer displayer) {
        this.drawDanmakus(displayer, this.mTimer);
    }

    @Override
    public void reset() {
    }

    @Override
    public void seek(long mills) {
        this.reset();
        this.mContext.mGlobalFlagValues.updateVisibleFlag();
        this.mContext.mGlobalFlagValues.updateFirstShownFlag();
        long l = this.mStartRenderTime = mills < 1000L ? 0L : mills;
        if (this.mRenderingState != null) {
            this.mRenderingState.reset();
            this.mRenderingState.endTime = this.mStartRenderTime;
        }
    }

    @Override
    public void clearDanmakusOnScreen(long currMillis) {
        this.reset();
        this.mContext.mGlobalFlagValues.updateVisibleFlag();
        this.mContext.mGlobalFlagValues.updateFirstShownFlag();
        this.mStartRenderTime = currMillis;
    }

    @Override
    public void prepare() {
        this.loadDanmakus();
        if (this.mTaskListener != null) {
            this.mTaskListener.ready();
        }
    }

    @Override
    public void onPlayStateChanged(int state) {
        this.mPlayState = state;
    }

    protected void loadDanmakus() {
        this.danmakuList = new Danmakus(4);
        if (this.danmakuList != null && !this.danmakuList.isEmpty() && this.danmakuList.first().flags == null) {
            IDanmakuIterator it = this.danmakuList.iterator();
            while (it.hasNext()) {
                BaseDanmaku item2 = it.next();
                if (item2 == null) continue;
                item2.flags = this.mContext.mGlobalFlagValues;
            }
        }
        this.mContext.mGlobalFlagValues.resetAll();
    }

    protected void drawDanmakus(AbsDisplayer disp, DanmakuTimer timer) {
        if (this.danmakuList != null) {
            if (this.mIsHidden) {
                return;
            }
            if (this.danmakuList != null && !this.danmakuList.isEmpty()) {
                IRenderer.RenderingState renderingState = this.mRenderingState = this.mRenderer.draw(this.mDisp, this.danmakuList, this.mStartRenderTime);
                if (this.mTaskListener != null) {
                    this.mTaskListener.checkAvaiableLine();
                }
                return;
            }
            if (this.mTaskListener != null) {
                this.mTaskListener.checkAvaiableLine();
            }
            return;
        }
    }

    @Override
    public void requestHide() {
        this.mIsHidden = true;
    }
}

