/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicgunview.danmucanvas.controller;

import android.os.Build;
import android.os.HandlerThread;
import android.util.SparseArray;
import com.yy.mobile.ui.basicgunview.danmucanvas.Bean.BaseDanmaku;
import com.yy.mobile.ui.basicgunview.danmucanvas.model.android.DanmakuContext;
import com.yy.mobile.ui.basicgunview.newgunpower.IDanmuOpenStatus;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.log.MLog;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class DanmuViewController {
    public static final String TAG = "DanmuViewController";
    public SparseArray<BaseDanmaku> mTracksStatus;
    private AtomicBoolean mIsDanmuStart = new AtomicBoolean(false);
    private volatile HashMap<Integer, Boolean> mTracksAvaliable = new HashMap();
    private volatile boolean scheduledTaskRunStatus = false;
    private int mDanmaRightPadding;
    private volatile IDanmuOpenStatus danmuOpenStatus;
    private int mTrackLines = 3;
    private HandlerThread mHandlerThread;
    private SafeDispatchHandler mSafeDispatchHandler;
    private DanmakuContext mContent;
    private Runnable scheduRunnable = new Runnable(){

        @Override
        public void run() {
            if (DanmuViewController.this.danmuOpenStatus != null) {
                DanmuViewController.this.danmuOpenStatus.getGunPower(DanmuViewController.this.mTracksAvaliable);
            }
            DanmuViewController.this.postTask(500);
        }
    };

    public DanmuViewController() {
        this.mTracksStatus = new SparseArray();
        this.resetLineMap();
        this.mHandlerThread = new HandlerThread("Danmaku-HandlerThread");
        this.mHandlerThread.start();
        this.mSafeDispatchHandler = new SafeDispatchHandler(this.mHandlerThread.getLooper());
    }

    public void setTrackLines(int lines) {
        this.mTrackLines = lines;
    }

    public void resetLineMap() {
        this.mTracksAvaliable.clear();
        for (int i = 0; i < this.mTrackLines; ++i) {
            this.mTracksAvaliable.put(i, true);
        }
        this.mTracksStatus.clear();
    }

    public void setDanmuContentAndRightPading(DanmakuContext context, int rightPading) {
        this.mContent = context;
        this.mDanmaRightPadding = rightPading;
    }

    public void setDanmuOpenStatus(IDanmuOpenStatus status) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"WYNOTSHOW DanmuViewController queryDanmuOpenStatus =", (Object[])new Object[0]);
        }
        this.danmuOpenStatus = status;
    }

    public void onBarrageSwitch(boolean on) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("WYNOTSHOW DanmuViewController onBarrageSwitch on = " + on + " scheduledTaskRunStatus " + this.scheduledTaskRunStatus), (Object[])new Object[0]);
        }
        if (on) {
            this.mIsDanmuStart.set(true);
            this.resetLineMap();
            if (!this.scheduledTaskRunStatus) {
                this.postTask(0);
                this.scheduledTaskRunStatus = true;
            }
        } else {
            this.mIsDanmuStart.set(false);
            this.removeTask();
            this.scheduledTaskRunStatus = false;
        }
    }

    public synchronized boolean checkTrackIsAvaliableLine(int position) {
        if (position > this.mTrackLines) {
            return false;
        }
        BaseDanmaku danmaku = (BaseDanmaku)this.mTracksStatus.get(position);
        if (danmaku == null) {
            this.setTrackAvaliableStatus(position, true);
            return true;
        }
        if (danmaku.paintHeight == -1.0f) {
            this.setTrackAvaliableStatus(position, false);
            return false;
        }
        if ((float)this.mContent.getDanmuWidth() - danmaku.getLeft() + (float)this.mDanmaRightPadding > danmaku.paintWidth) {
            this.setTrackAvaliableStatus(position, true);
            return true;
        }
        if (danmaku.isTimeOut() || danmaku.visibility == 0) {
            this.setTrackAvaliableStatus(position, true);
            return true;
        }
        this.setTrackAvaliableStatus(position, false);
        return false;
    }

    public synchronized void checkAllTrackIsAvaliableLine() {
        for (int i = 0; i < this.mTrackLines; ++i) {
            this.checkTrackIsAvaliableLine(i);
        }
    }

    public void setTrackAvaliableStatus(int position, boolean isOpen) {
        if (position < this.mTrackLines) {
            this.mTracksAvaliable.put(position, isOpen);
        } else {
            MLog.error((Object)TAG, (String)("getLineStatus is line > gapLine , gapLine " + this.mTrackLines), (Object[])new Object[0]);
        }
    }

    public void startRunDanmu() {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("WYNOTSHOW  DanmuViewController runDanmu scheduledTaskRunStatus = " + this.scheduledTaskRunStatus), (Object[])new Object[0]);
        }
        if (this.mTracksAvaliable.size() <= 0) {
            this.resetLineMap();
        }
        if (!this.scheduledTaskRunStatus) {
            this.postTask(0);
            this.scheduledTaskRunStatus = true;
        }
    }

    public void uninit() {
        this.removeTask();
        this.scheduledTaskRunStatus = false;
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("WYNOTSHOW DanmuViewController danmuOpenStatus = null scheduledTaskRunStatus= " + this.scheduledTaskRunStatus), (Object[])new Object[0]);
        }
        if (Build.VERSION.SDK_INT >= 18) {
            if (this.mHandlerThread != null) {
                this.mHandlerThread.quitSafely();
                this.mHandlerThread = null;
                MLog.debug((Object)TAG, (String)"[onDestory] quitSafely", (Object[])new Object[0]);
            }
        } else {
            try {
                if (this.mHandlerThread != null) {
                    this.mHandlerThread.quit();
                    this.mHandlerThread = null;
                    MLog.debug((Object)TAG, (String)"[onDestory] quit", (Object[])new Object[0]);
                }
            }
            catch (Throwable e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
    }

    public boolean isDanmuStart() {
        return this.mIsDanmuStart.get();
    }

    public void setTrackStatus(int pos, BaseDanmaku item2) {
        this.mTracksStatus.put(pos, (Object)item2);
    }

    private void postTask(int delay) {
        this.removeTask();
        MLog.info((Object)TAG, (String)("[postTask] delay=" + delay), (Object[])new Object[0]);
        if (this.mSafeDispatchHandler != null) {
            this.mSafeDispatchHandler.removeCallbacks(this.scheduRunnable);
            this.mSafeDispatchHandler.postDelayed(this.scheduRunnable, (long)delay);
        }
    }

    private void removeTask() {
        MLog.info((Object)TAG, (String)"[removeTask] ", (Object[])new Object[0]);
        if (this.mSafeDispatchHandler != null) {
            this.mSafeDispatchHandler.removeCallbacks(this.scheduRunnable);
        }
    }
}

