/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicgunview.danmucanvas.Bean;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatTextView;
import android.text.TextPaint;
import android.util.Log;
import android.widget.TextView;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicgunview.danmucanvas.Bean.PoolObject;
import com.yy.mobile.ui.basicgunview.danmucanvas.utils.BitMapPool;
import com.yy.mobile.ui.basicgunview.newgunpower.GunNewPower;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.log.MLog;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;

public class BitmapGunPowder
extends GunNewPower {
    private static int offsetLeft = ScreenUtil.getInstance().dip2px(8);
    private static int textHeight = ScreenUtil.getInstance().dip2px(19);
    private static int defaultHeight = ScreenUtil.getInstance().dip2px(27);
    private static int itemHeight = ScreenUtil.getInstance().dip2px(28);
    private static MyStrokeTextView textView;
    public boolean isGiftMessage = false;
    public Drawable bgDrawable;
    public boolean isAir;
    public int p;
    public boolean isme;
    WeakReference<Context> ct;
    private WeakReference<Drawable> mMessageBg = null;
    private TextView mTextView;

    public BitmapGunPowder(int p, int color2, String content, Context context, TextView tv) {
        super(123L, "123", -1L);
        this.content = content;
        this.ct = new WeakReference<Context>(context);
        this.backgroudColor = color2;
        this.p = p;
        this.mTextView = tv;
    }

    public void createPowertoShell(Context context) {
    }

    public void convert(boolean flag) {
        Context context = (Context)this.ct.get();
        if (context == null || this.span == null) {
            return;
        }
        try {
            if (this.mTextView == null) {
                this.mTextView = new MyStrokeTextView(context, -16777216, this.textColor);
            }
            this.mTextView.setText((CharSequence)this.span);
            this.mTextView.setGravity(80);
            this.mTextView.setSingleLine(true);
            this.mTextView.setGravity(16);
            if (this.bgDrawable != null) {
                this.setMessageBg(context, this.mTextView, this.bgDrawable);
            } else {
                this.setMessageBg(context, this.mTextView, false);
            }
            if (flag) {
                this.bitmap = this.viewToBitmapForSurfaceView(this.mTextView, this.backgroudColor);
            } else {
                PoolObject po = this.viewToBitmap(this.mTextView, this.backgroudColor);
                this.bitmap = (Bitmap)po.mObjection;
                this.poolPos = po.mPos;
                this.width = po.reserveTag;
            }
        }
        catch (Throwable e) {
            MLog.info((Object)"danmuutil", (String)e.getMessage(), (Object[])new Object[0]);
        }
    }

    private void setMessageBg(Context context, TextView tv, boolean isAddBg) {
        if (context == null || tv == null) {
            return;
        }
        tv.setPadding(0, 0, 0, 0);
        if (Build.VERSION.SDK_INT >= 16) {
            tv.setBackground(null);
        } else {
            tv.setBackgroundDrawable(null);
        }
        if (isAddBg) {
            Drawable bg = null;
            tv.setPadding((int)ResolutionUtils.convertDpToPixel((float)10.0f, (Context)context), (int)ResolutionUtils.convertDpToPixel((float)2.0f, (Context)context), (int)ResolutionUtils.convertDpToPixel((float)10.0f, (Context)context), (int)ResolutionUtils.convertDpToPixel((float)2.0f, (Context)context));
            if (this.mMessageBg == null || this.mMessageBg.get() == null) {
                bg = ContextCompat.getDrawable((Context)context, (int)R.drawable.public_chat_gift_message_bg);
                this.mMessageBg = new WeakReference<Drawable>(bg);
            } else {
                bg = (Drawable)this.mMessageBg.get();
            }
            if (Build.VERSION.SDK_INT >= 16) {
                tv.setBackground(bg);
            } else {
                tv.setBackgroundDrawable(bg);
            }
        }
    }

    private void setMessageBg(Context context, TextView tv, Drawable bgDrawable) {
        Drawable bg;
        if (context == null || tv == null) {
            return;
        }
        tv.setPadding(0, 0, 0, 0);
        if (Build.VERSION.SDK_INT >= 16) {
            tv.setBackground(null);
        } else {
            tv.setBackgroundDrawable(null);
        }
        itemHeight = ScreenUtil.getInstance().dip2px(32);
        tv.setPadding((int)ResolutionUtils.convertDpToPixel((float)10.0f, (Context)context), (int)ResolutionUtils.convertDpToPixel((float)2.0f, (Context)context), (int)ResolutionUtils.convertDpToPixel((float)10.0f, (Context)context), (int)ResolutionUtils.convertDpToPixel((float)2.0f, (Context)context));
        if (this.mMessageBg == null || this.mMessageBg.get() == null) {
            bg = bgDrawable;
            this.mMessageBg = new WeakReference<Drawable>(bg);
        } else {
            bg = (Drawable)this.mMessageBg.get();
        }
        if (Build.VERSION.SDK_INT >= 16) {
            tv.setBackground(bg);
        } else {
            tv.setBackgroundDrawable(bg);
        }
    }

    private PoolObject viewToBitmap(TextView view, int color2) {
        view.measure(0, 0x40000000 + (int)ResolutionUtils.convertDpToPixel((float)28.0f, (Context)view.getContext()));
        view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
        int actualWidth = view.getWidth() + 2 * offsetLeft;
        Bitmap bitmap = null;
        PoolObject pool = (PoolObject)BitMapPool.getInstance().getObj(actualWidth);
        if (pool != null) {
            bitmap = (Bitmap)pool.mObjection;
            bitmap.eraseColor(0);
        } else {
            bitmap = Bitmap.createBitmap((int)actualWidth, (int)itemHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            pool = new PoolObject(bitmap);
        }
        pool.reserveTag = actualWidth;
        Canvas canvas = new Canvas();
        canvas.setBitmap(bitmap);
        if (color2 != -1) {
            RectF powerAvatarRect = new RectF();
            Rect powerAvatarRect1 = new Rect();
            float t = defaultHeight - textHeight;
            canvas.translate(0.0f, t);
            float radius = (float)textHeight / 2.0f;
            powerAvatarRect.set(0.0f, 0.0f, (float)actualWidth, (float)textHeight);
            powerAvatarRect1.set(0, 0, actualWidth, textHeight);
            Paint mAvatarBorderPaint = new Paint(1);
            mAvatarBorderPaint.setAntiAlias(true);
            mAvatarBorderPaint.setColor(color2);
            BitmapShader shader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            this.updateShaderMatrix(shader, bitmap.getWidth(), bitmap.getHeight(), powerAvatarRect1);
            canvas.drawRoundRect(powerAvatarRect, radius, radius, mAvatarBorderPaint);
            mAvatarBorderPaint.setShader((Shader)shader);
            canvas.save();
            canvas.translate((float)offsetLeft, -t - 2.0f);
        }
        view.draw(canvas);
        return pool;
    }

    private Bitmap viewToBitmapForSurfaceView(TextView view, int color2) {
        view.measure(0, 0x40000000 + (int)ResolutionUtils.convertDpToPixel((float)28.0f, (Context)view.getContext()));
        view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
        int offsetLeft = (int)ResolutionUtils.convertDpToPixel((float)8.0f, (Context)view.getContext());
        int textHeight = (int)ResolutionUtils.convertDpToPixel((float)19.0f, (Context)view.getContext());
        int actualWidth = view.getMeasuredWidth() + 2 * offsetLeft;
        Bitmap bitmap = Bitmap.createBitmap((int)actualWidth, (int)itemHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas();
        canvas.setBitmap(bitmap);
        if (color2 != -1) {
            RectF powerAvatarRect = new RectF();
            Rect powerAvatarRect1 = new Rect();
            float t = ResolutionUtils.convertDpToPixel((float)27.0f, (Context)view.getContext()) - (float)textHeight;
            canvas.translate(0.0f, t);
            float radius = (float)textHeight / 2.0f;
            powerAvatarRect.set(0.0f, 0.0f, (float)actualWidth, (float)textHeight);
            powerAvatarRect1.set(0, 0, actualWidth, textHeight);
            Paint mAvatarBorderPaint = new Paint(1);
            mAvatarBorderPaint.setAntiAlias(true);
            mAvatarBorderPaint.setColor(color2);
            BitmapShader shader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            this.updateShaderMatrix(shader, bitmap.getWidth(), bitmap.getHeight(), powerAvatarRect1);
            canvas.drawRoundRect(powerAvatarRect, radius, radius, mAvatarBorderPaint);
            mAvatarBorderPaint.setShader((Shader)shader);
            canvas.save();
            canvas.translate((float)offsetLeft, -t - 2.0f);
        }
        view.draw(canvas);
        return bitmap;
    }

    private static class MyStrokeTextView
    extends AppCompatTextView {
        public int mInnerColor;
        public int mOuterColor;
        TextPaint mTextPaint = this.getPaint();
        private boolean mBDrawSideLine = true;

        private MyStrokeTextView(Context context, int outerColor, int innnerColor) {
            super(context);
            this.mInnerColor = innnerColor;
            this.mOuterColor = outerColor;
        }

        protected void onDraw(Canvas canvas) {
            if (this.mBDrawSideLine) {
                this.mTextPaint.setStrokeWidth(this.getContext().getResources().getDisplayMetrics().density);
                this.mTextPaint.setStyle(Paint.Style.FILL_AND_STROKE);
                this.mTextPaint.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
                super.onDraw(canvas);
                this.mTextPaint.setStrokeWidth(0.0f);
                this.mTextPaint.setStyle(Paint.Style.FILL_AND_STROKE);
                this.setShadowLayer(this.getContext().getResources().getDisplayMetrics().density + 1.0f, this.getContext().getResources().getDisplayMetrics().density, 1.0f, -16777216);
            }
            super.onDraw(canvas);
        }

        private void setTextColorUseReflection(int color2) {
            try {
                Field textColorField = TextView.class.getDeclaredField("mCurTextColor");
                textColorField.setAccessible(true);
                textColorField.set((Object)this, color2);
                textColorField.setAccessible(false);
            }
            catch (NoSuchFieldException e) {
                Log.e((String)"BitmapGunPowder", (String)"Empty Catch on setTextColorUseReflection", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                Log.e((String)"BitmapGunPowder", (String)"Empty Catch on setTextColorUseReflection", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                Log.e((String)"BitmapGunPowder", (String)"Empty Catch on setTextColorUseReflection", (Throwable)e);
            }
            this.mTextPaint.setColor(color2);
        }
    }
}

