/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicfunction.report;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.view.View;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.AudienceVideoManager;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.streamcompat.VideoStreamCompat;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.ui.ylink.LiveTemplateActivity;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;

public class ReportScreenShot {
    private static final String TAG = "ReportScreenShot";
    private static final int VIDEO_TOP_ENT = 80;
    private static final int VIDEO_TOP_GAME = 0;
    private static final int VIDEO_TOP_MULTI = 100;
    private static String templateId = "";

    private static boolean isMultipleVideo() {
        if (ICoreManagerBase.getMediaCore() != null) {
            return ICoreManagerBase.getMediaCore().getStreamListSize() >= 2;
        }
        return false;
    }

    public static boolean isMobileLiveMultiple() {
        return false;
    }

    private static Bitmap checkCreateBitmap(int width, int height, Bitmap.Config config) {
        if (width < 0 || height < 0) {
            return null;
        }
        Bitmap dstBitmap = null;
        try {
            dstBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        }
        catch (IllegalArgumentException e) {
            MLog.error((Object)TAG, (String)"IllegalArgumentException +", (Object[])new Object[]{e.toString()});
            dstBitmap = null;
        }
        return dstBitmap;
    }

    private static boolean isMediaVideoLandscape(Activity activity) {
        if (activity == null) {
            return false;
        }
        if (activity.getResources() == null) {
            return false;
        }
        return activity.getResources().getConfiguration().orientation == 2;
    }

    public static Bitmap checkCreateBitmap(Bitmap bitmap, int x, int y, int width, int height) {
        if (bitmap == null) {
            return null;
        }
        if (x + width > bitmap.getWidth()) {
            x = 0;
            width = bitmap.getWidth();
        }
        if (y + height > bitmap.getHeight()) {
            y = 0;
            height = bitmap.getHeight();
        }
        Bitmap dstBitmap = null;
        try {
            dstBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)x, (int)y, (int)width, (int)height);
        }
        catch (IllegalArgumentException e) {
            MLog.error((Object)TAG, (String)"IllegalArgumentException +", (Object[])new Object[]{e.toString()});
            dstBitmap = null;
        }
        return dstBitmap;
    }

    private static Bitmap getSnapShotFromActivity(Activity activity) {
        MLog.info((Object)TAG, (String)"getSnapShotFromActivity", (Object[])new Object[0]);
        if (activity == null) {
            return null;
        }
        View view = activity.getWindow().getDecorView();
        if (view == null) {
            return null;
        }
        view.buildDrawingCache();
        view.setDrawingCacheEnabled(true);
        view.getDrawingCache().setHasAlpha(true);
        Bitmap drawingBitmap = view.getDrawingCache();
        if (drawingBitmap == null) {
            view.destroyDrawingCache();
            return null;
        }
        DisplayMetrics dm = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(dm);
        int screenWidth = dm.widthPixels;
        int screenHeight = dm.heightPixels;
        Bitmap bitmap = ReportScreenShot.checkCreateBitmap(drawingBitmap, 0, 0, screenWidth, screenHeight);
        view.destroyDrawingCache();
        return bitmap;
    }

    private static Bitmap getSnapShotFromVideo(int videoIndex) {
        if (ICoreManagerBase.getMediaCore() != null) {
            return ICoreManagerBase.getMediaCore().getVideoScreenshot(videoIndex);
        }
        return null;
    }

    public static Bitmap getScreenSnapShot(Activity activity) {
        if (activity == null) {
            return null;
        }
        if (activity instanceof LiveTemplateActivity) {
            if (ICoreManagerBase.getChannelLinkCore() != null) {
                templateId = ICoreManagerBase.getChannelLinkCore().getTemplateId();
            }
            return ReportScreenShot.getScreenSnapShotAll(activity);
        }
        return null;
    }

    public static Bitmap getScreenSnapShotAll(Activity activity) {
        MLog.info((Object)TAG, (String)"getEntLandscapeSingleVideoBitmap", (Object[])new Object[0]);
        if (activity == null) {
            return null;
        }
        Bitmap surfaceViewBitmap = ReportScreenShot.getSnapShotFromVideo(0);
        Bitmap mainActivityBitmap = ReportScreenShot.getSnapShotFromActivity(activity);
        if (VideoStreamCompat.getInstance().getVideoStreamListSize() == 0 && mainActivityBitmap != null) {
            MLog.warn((Object)TAG, (String)("current live room has no stream, mainActivityBitmap = " + mainActivityBitmap), (Object[])new Object[0]);
            return mainActivityBitmap;
        }
        if (surfaceViewBitmap == null || mainActivityBitmap == null) {
            MLog.error((Object)TAG, (String)("surfaceViewBitmap = " + surfaceViewBitmap + ", mainActivityBitmap = " + mainActivityBitmap), (Object[])new Object[0]);
            return null;
        }
        DisplayMetrics dm = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(dm);
        mainActivityBitmap.setHasAlpha(true);
        Boolean isMixture = AudienceVideoManager.getInstance().isVideoMixture();
        if (isMixture == null) {
            MLog.error((Object)TAG, (String)"isMixture = null", (Object[])new Object[0]);
            return null;
        }
        if ("33554524".equals(templateId)) {
            return ReportScreenShot.getMultiLiveVideoBitmap(activity, isMixture);
        }
        Bitmap bitmap = ReportScreenShot.checkCreateBitmap(dm.widthPixels, dm.heightPixels, Bitmap.Config.ARGB_8888);
        if (bitmap == null) {
            MLog.error((Object)TAG, (String)"checkCreateBitmap bitmap = null", (Object[])new Object[0]);
            return null;
        }
        Canvas canvas = new Canvas(bitmap);
        Rect mDst = new Rect();
        mDst.right = dm.widthPixels;
        mDst.bottom = dm.heightPixels;
        ReportScreenShot.drawFirstRect(activity, dm, canvas, surfaceViewBitmap);
        if (ReportScreenShot.isMultipleVideo() && !isMixture.booleanValue()) {
            ReportScreenShot.drawSecondRect(dm, canvas);
        }
        canvas.drawBitmap(mainActivityBitmap, mDst, mDst, null);
        return bitmap;
    }

    private static void drawFirstRect(Activity activity, DisplayMetrics dm, Canvas canvas, Bitmap first) {
        if (activity == null) {
            return;
        }
        boolean isLianmai = ReportScreenShot.isMultipleVideo();
        Boolean isMixture = AudienceVideoManager.getInstance().isVideoMixture();
        if (isMixture == null) {
            MLog.error((Object)TAG, (String)"isMixture = null", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)("drawFirstRect, isMixture = " + isMixture), (Object[])new Object[0]);
        boolean isLand = ReportScreenShot.isMediaVideoLandscape(activity);
        Rect rect = new Rect();
        rect.top = DensityUtil.dip2px((Context)activity, (float)ReportScreenShot.calculateTop(activity));
        rect.bottom = isLand ? dm.heightPixels : rect.top + (int)((float)dm.widthPixels * 3.0f / 4.0f);
        rect.right = isLianmai && isMixture == false ? dm.widthPixels >> 1 : dm.widthPixels;
        canvas.drawBitmap(first, null, rect, null);
    }

    private static int calculateTop(Activity activity) {
        int top = 80;
        if (((LiveTemplateActivity)activity).getRoot() == null) {
            return top;
        }
        if (((LiveTemplateActivity)activity).getRoot().getContainerClz() == null) {
            return top;
        }
        switch (templateId) {
            case "33554521": {
                top = 0;
                break;
            }
            case "33554524": {
                top = 100;
                break;
            }
        }
        return top;
    }

    private static void drawSecondRect(DisplayMetrics dm, Canvas canvas) {
        Bitmap secondBitmap = ReportScreenShot.getSnapShotFromVideo(1);
        if (secondBitmap == null) {
            MLog.error((Object)TAG, (String)"secondBitmap = null", (Object[])new Object[0]);
            return;
        }
        Rect secondRect = new Rect();
        secondRect.left = dm.widthPixels >> 1;
        secondRect.right = dm.widthPixels;
        secondRect.bottom = dm.heightPixels;
        canvas.drawBitmap(secondBitmap, null, secondRect, null);
    }

    private static Bitmap getMultiLiveVideoBitmap(Activity activity, boolean isMixture) {
        MLog.info((Object)TAG, (String)"getMultiLiveVideoBitmap", (Object[])new Object[0]);
        if (activity == null) {
            return null;
        }
        Bitmap mainActivityBitmap = ReportScreenShot.getSnapShotFromActivity(activity);
        Bitmap surfaceViewBitmap = ReportScreenShot.getSnapShotFromVideo(0);
        if (mainActivityBitmap == null || surfaceViewBitmap == null) {
            MLog.error((Object)TAG, (String)("mainActivityBitmap = " + mainActivityBitmap + " ,surfaceViewBitmap = " + surfaceViewBitmap), (Object[])new Object[0]);
            return null;
        }
        DisplayMetrics dm = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(dm);
        mainActivityBitmap.setHasAlpha(true);
        Bitmap bitmap = ReportScreenShot.checkCreateBitmap(dm.widthPixels, dm.heightPixels, Bitmap.Config.ARGB_8888);
        if (bitmap == null) {
            MLog.error((Object)TAG, (String)"checkCreateBitmap bitmap = null", (Object[])new Object[0]);
            return null;
        }
        Canvas canvas = new Canvas(bitmap);
        if (isMixture) {
            Rect rect = new Rect();
            rect.left = 0;
            rect.right = dm.widthPixels;
            rect.top = DensityUtil.dip2px((Context)activity, (float)ReportScreenShot.calculateTop(activity));
            rect.bottom = rect.top + dm.widthPixels;
            canvas.drawBitmap(surfaceViewBitmap, null, rect, null);
        } else {
            for (int i = 0; i < 9; ++i) {
                int width;
                surfaceViewBitmap = ReportScreenShot.getSnapShotFromVideo(i);
                if (surfaceViewBitmap == null) {
                    MLog.error((Object)TAG, (String)("surfaceViewBitmap = " + surfaceViewBitmap), (Object[])new Object[0]);
                    return null;
                }
                Rect rect = new Rect();
                int height = width = dm.widthPixels / 3;
                rect.top = DensityUtil.dip2px((Context)activity, (float)ReportScreenShot.calculateTop(activity)) + i / 3 * height;
                rect.left = i % 3 * width;
                rect.right = rect.left + width;
                rect.bottom = rect.top + height;
                canvas.drawBitmap(surfaceViewBitmap, null, rect, null);
            }
        }
        Rect mDst = new Rect(0, 0, dm.widthPixels, dm.heightPixels);
        canvas.drawBitmap(mainActivityBitmap, mDst, mDst, null);
        return bitmap;
    }
}

