/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicfunction;

import android.app.Activity;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.widget.TextView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_leaveCurrentChannel_EventArgs;
import com.yy.mobile.plugin.main.events.IMediaVideoBasicClient_onMediaVideoBasicStopFlagSwitch_EventArgs;
import com.yy.mobile.plugin.main.events.IMediaVideoBasicClient_onMediaVideoBasicStopSwitch_EventArgs;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.videoenable.AudienceVideoEnableManager;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.videoquality.AudienceVideoQualityManager;
import com.yy.mobile.sdkwrapper.flowmanagement.api.line.StreamLineBrokenListener;
import com.yy.mobile.sdkwrapper.flowmanagement.api.line.StreamLineManager;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.videoquality.IAudienceVideoQualityChangeListener;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.AudienceVideoQuality;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoQuality;
import com.yy.mobile.sdkwrapper.flowmanagement.event.audience.NoVideoStreamEvent;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.nolive.NoLiveManager;
import com.yy.mobile.ui.basicfunction.StreamLineCodeRateModule$$EventBinder;
import com.yy.mobile.ui.basicfunction.StreamLineCodeRatePopupComponent;
import com.yy.mobile.ui.basicfunction.report.BaseModule;
import com.yy.mobile.ui.basicfunction.uicore.IBasicFunctionCore;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import java.util.List;
import java.util.Map;

public class StreamLineCodeRateModule
extends BaseModule
implements EventCompat,
IAudienceVideoQualityChangeListener,
StreamLineBrokenListener {
    private static final String TAG = "StreamLineCodeRateModul";
    private TextView mCurrentStreamAndRate;
    private int mCurrentLine = 0;
    private LineBrokenCallback mLineBrokenCallback;
    private boolean mIsVideoEnable = true;
    private View.OnClickListener onClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            MLog.info((Object)StreamLineCodeRateModule.TAG, (String)"StreamLineCodeRatePopupComponent create", (Object[])new Object[0]);
            ((IBasicFunctionCore)ICoreManagerBase.getCore(IBasicFunctionCore.class)).hideSlideFunctionsComponent();
            StreamLineCodeRatePopupComponent streamPopup = new StreamLineCodeRatePopupComponent();
            FragmentActivity activity = (FragmentActivity)StreamLineCodeRateModule.this.getActivity();
            FragmentManager supportFragmentManager = activity.getSupportFragmentManager();
            streamPopup.show(supportFragmentManager, "StreamLineCodeRatePopupComponent");
            MLog.info((Object)StreamLineCodeRateModule.TAG, (String)"StreamLineCodeRatePopupComponent after show()", (Object[])new Object[0]);
        }
    };
    private EventBinder mStreamLineCodeRateModuleSniperEventBinder;

    public void onEventBind() {
        if (this.mStreamLineCodeRateModuleSniperEventBinder == null) {
            this.mStreamLineCodeRateModuleSniperEventBinder = new StreamLineCodeRateModule$$EventBinder();
        }
        this.mStreamLineCodeRateModuleSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mStreamLineCodeRateModuleSniperEventBinder != null) {
            this.mStreamLineCodeRateModuleSniperEventBinder.unBindEvent();
        }
    }

    StreamLineCodeRateModule(FragmentActivity activity) {
        super((Activity)activity);
        this.mIsVideoEnable = AudienceVideoEnableManager.getInstance().isVideoEnable();
    }

    public void setComponentView(TextView tv) {
        this.mCurrentStreamAndRate = tv;
        AudienceVideoQualityManager.getInstance().addVideoQualityChangeListener((IAudienceVideoQualityChangeListener)this);
        StreamLineManager.getInstance().addLineBrokenListener((StreamLineBrokenListener)this);
    }

    public void setLineBrokenCallback(LineBrokenCallback callback2) {
        this.mLineBrokenCallback = callback2;
    }

    @BusEvent(sync=true)
    public void leaveCurrentChannel(IChannelLinkClient_leaveCurrentChannel_EventArgs busEventArgs) {
        MLog.info((Object)TAG, (String)"leaveCurrentChannel,channelInfo:%s", (Object[])new Object[]{busEventArgs.getInfo()});
        this.mCurrentLine = -1;
        this.mIsVideoEnable = true;
        this.setMultiCodeRateEnable(false);
    }

    public void initStreamAndRate() {
        if (this.mCurrentStreamAndRate == null) {
            MLog.info((Object)TAG, (String)"mCurrentStreamAndRate == null, mIsVideoEnable=%b", (Object[])new Object[]{this.mIsVideoEnable});
            return;
        }
        if (this.mIsVideoEnable && !NoLiveManager.getInstance().isCurrentNoLive()) {
            this.mCurrentStreamAndRate.setVisibility(0);
        } else {
            this.mCurrentStreamAndRate.setVisibility(4);
        }
        List qualityList = AudienceVideoQualityManager.getInstance().getAvailableVideoQualities();
        if (qualityList == null || qualityList.size() == 0) {
            MLog.info((Object)TAG, (String)"initStreamAndRate qualityList is empty", (Object[])new Object[0]);
            this.setMultiCodeRateEnable(false);
            return;
        }
        int curLine = AudienceVideoQualityManager.getInstance().getCurrentVideoLine();
        MLog.info((Object)TAG, (String)"AudienceVideoQualityManager return curLine=%d", (Object[])new Object[]{curLine});
        if (curLine < 0) {
            this.setMultiCodeRateEnable(false);
            return;
        }
        this.mCurrentLine = curLine;
        AudienceVideoQuality curQuality = AudienceVideoQualityManager.getInstance().getSelectedVideoQuality();
        String text = "\u7ebf\u8def" + this.mCurrentLine + ": " + curQuality.getName();
        MLog.info((Object)TAG, (String)"show line and quality:%s", (Object[])new Object[]{text});
        this.mCurrentStreamAndRate.setText((CharSequence)text);
        this.mCurrentStreamAndRate.setOnClickListener(this.onClickListener);
    }

    private String getDesc(VideoQuality curQuality) {
        if (curQuality == VideoQuality.HD) {
            return "\u9ad8\u6e05";
        }
        if (curQuality == VideoQuality.Standard) {
            return "\u6d41\u7545";
        }
        if (curQuality == VideoQuality.Super) {
            return "\u8d85\u6e05";
        }
        if (curQuality == VideoQuality.BlueRay) {
            return "\u84dd\u5149";
        }
        return "\u672a\u77e5";
    }

    @BusEvent(sync=true)
    public void onNoVideoStreamEvent(NoVideoStreamEvent event) {
        MLog.info((Object)TAG, (String)"onNoVideoStreamEvent: hide quality lines ui", (Object[])new Object[0]);
        if (this.mCurrentStreamAndRate != null) {
            this.mCurrentStreamAndRate.setVisibility(4);
        }
    }

    @BusEvent
    public void onVideoAudioModeSwitch(IMediaVideoBasicClient_onMediaVideoBasicStopSwitch_EventArgs event) {
        MLog.info((Object)TAG, (String)("onVideoAudioModeSwitch called with: event = [" + event + "]"), (Object[])new Object[0]);
        this.mIsVideoEnable = event.isVideoEnable;
        this.setMultiCodeRateEnable(this.mIsVideoEnable);
    }

    public void onUpdateAvaliableVideoQualities(List<AudienceVideoQuality> videoQualities) {
        MLog.info((Object)TAG, (String)("[onUpdateAvaliableVideoQualities] videoQualities=" + videoQualities), (Object[])new Object[0]);
        this.initStreamAndRate();
    }

    public void onUpdateStreamLineInfo(Map<Integer, List<AudienceVideoQuality>> lineQuality) {
        MLog.info((Object)TAG, (String)("[onUpdateStreamLineInfo] curLineQuality=" + lineQuality), (Object[])new Object[0]);
        this.initStreamAndRate();
    }

    public void onUpdateCurStreamLine(Integer curLine, AudienceVideoQuality curVideoQuality) {
        MLog.info((Object)TAG, (String)"[onUpdateCurStreamLine],curLine=%d, curVideoQuality=%s", (Object[])new Object[]{curLine, curVideoQuality});
        this.mCurrentLine = curLine;
        this.initStreamAndRate();
    }

    public void onCurrentLineBroken(int brokenLine) {
        this.notifyLineBroken();
    }

    private void notifyLineBroken() {
        if (this.mLineBrokenCallback != null) {
            this.mLineBrokenCallback.onCurrentLineBroken();
        }
    }

    @BusEvent
    public void onMediaVideoBasicStopFlagSwitch(IMediaVideoBasicClient_onMediaVideoBasicStopFlagSwitch_EventArgs busEventArgs) {
        this.mIsVideoEnable = !busEventArgs.getStopFlag();
        MLog.info((Object)TAG, (String)("[onMediaVideoBasicStopFlagSwitch] mIsVidoEnable = " + this.mIsVideoEnable), (Object[])new Object[0]);
        this.setMultiCodeRateEnable(this.mIsVideoEnable);
    }

    private void setMultiCodeRateEnable(boolean enable) {
        MLog.info((Object)TAG, (String)("setMultiCodeRateEnable : " + enable), (Object[])new Object[0]);
        if (this.mCurrentStreamAndRate != null) {
            if (!enable) {
                this.mCurrentStreamAndRate.setVisibility(4);
            } else {
                this.mCurrentStreamAndRate.setVisibility(0);
                this.initStreamAndRate();
            }
        }
    }

    public void destroy() {
        MLog.info((Object)TAG, (String)"StreamLineCodeRateModul destroy()", (Object[])new Object[0]);
        super.destroy();
        AudienceVideoQualityManager.getInstance().removeVideoQualityChangeListener((IAudienceVideoQualityChangeListener)this);
        StreamLineManager.getInstance().removeLineBrokenListener((StreamLineBrokenListener)this);
    }

    public static interface LineBrokenCallback {
        public void onCurrentLineBroken();
    }
}

