/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import com.yy.mobile.baseapi.NavigationUtils;
import com.yy.mobile.sdkwrapper.flowmanagement.api.channel.LiveKitChannelManager;
import com.yy.mobile.ui.mobilelive.MobileLiveReplayActivity;
import com.yy.mobile.ui.mobilelive.MobileLiveReplayLeaveActivity;
import com.yy.mobile.ui.mobilelive.replay.ReplayLeaveInfo;
import com.yy.mobile.ui.swivelChair.SwivelChairActivity;
import com.yy.mobile.ui.turntable.TurnTableAttachedActivity;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.ChannelState;
import com.yymobile.core.live.LiveCore.ILiveCore;

public class LiveNavigationUtils {
    private static final String TAG = "LiveNavigationUtils";

    public static void slideStartActivity(Context context, Intent intent) {
        NavigationUtils.slideStartActivity((Context)context, (Intent)intent);
    }

    public static void slideStartLiveTemplateActivity(Context context, Intent intent) {
        NavigationUtils.slideStartLiveTemplateActivity((Context)context, (Intent)intent);
    }

    public static void toMobileLiveReplayWithTitle(Context context, String replayId, long uid, String playUrl, String imgUrl, String title, int toMobileLiveReplayPath) {
        ((ILiveCore)CoreFactory.getCore(ILiveCore.class)).sendPlayRecord(uid, replayId);
        Intent intent = new Intent(context, MobileLiveReplayActivity.class);
        intent.putExtra("data_replay_id", replayId);
        intent.putExtra("data_replay_uid", uid);
        intent.putExtra("data_replay_url", playUrl);
        intent.putExtra("data_replay_imgurl", imgUrl);
        intent.putExtra("data_replay_title", title);
        intent.addFlags(0x4000000);
        intent.putExtra("to_mobile_live_replay_path", toMobileLiveReplayPath);
        context.startActivity(intent);
    }

    public static void toMobileLiveReplayWithType(Context context, String replayId, long uid, String playUrl, String imgUrl, String title, int toMobileLiveReplayPath, int replayType) {
        ((ILiveCore)CoreFactory.getCore(ILiveCore.class)).sendPlayRecord(uid, replayId);
        Intent intent = new Intent(context, MobileLiveReplayActivity.class);
        intent.putExtra("data_replay_id", replayId);
        intent.putExtra("data_replay_uid", uid);
        intent.putExtra("data_replay_url", playUrl);
        intent.putExtra("data_replay_imgurl", imgUrl);
        intent.putExtra("data_replay_title", title);
        intent.putExtra("data_replay_type", replayType);
        intent.addFlags(0x4000000);
        intent.putExtra("to_mobile_live_replay_path", toMobileLiveReplayPath);
        context.startActivity(intent);
    }

    public static void toTurnChairAttachActivity(Context context) {
        Intent turnChairIntent = new Intent(context, SwivelChairActivity.class);
        LiveNavigationUtils.slideStartActivity(context, turnChairIntent);
    }

    public static void toTurnTableAttachedActivity(Context context) {
        Intent intent = new Intent(context, TurnTableAttachedActivity.class);
        LiveNavigationUtils.slideStartActivity(context, intent);
    }

    private static void ensureLeaveChannel() {
        if (ICoreManagerBase.getChannelLinkCore().getChannelState() != ChannelState.No_Channel) {
            MLog.info((Object)TAG, (String)"leave channel link core", (Object[])new Object[0]);
            ICoreManagerBase.getChannelLinkCore().leaveChannel();
        } else {
            MLog.info((Object)TAG, (String)"not in channel link core, leave live kit channel", (Object[])new Object[0]);
            LiveKitChannelManager.getInstance().leave();
        }
    }

    public static void toSwivelChairActivity(Context context) {
        try {
            if (!SwivelChairActivity.isCreateTurnChairAttachedActivity) {
                Intent intent = new Intent(context, SwivelChairActivity.class);
                LiveNavigationUtils.slideStartActivity(context, intent);
            }
        }
        catch (Throwable e) {
            MLog.error((Object)context, (String)"[kaede][start activity exception] parcel data too large!", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public static void toMobileLiveReplayLeaveActivity(Context context, ReplayLeaveInfo replayLeaveInfo) {
        Intent intent = new Intent(context, MobileLiveReplayLeaveActivity.class);
        intent.putExtra(MobileLiveReplayLeaveActivity.MOBILE_LIVE_LEAVE_INFO_KEY, (Parcelable)replayLeaveInfo);
        LiveNavigationUtils.slideStartActivity(context, intent);
    }
}

