/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.module.vote.ui;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.TranslateAnimation;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.duowan.mobile.entlive.events.IVoteClient_closeVote_EventArgs;
import com.duowan.mobile.entlive.events.IVoteClient_switchVote_EventArgs;
import com.duowan.mobile.entlive.events.IVoteClient_updateRemainTickets_EventArgs;
import com.duowan.mobile.entlive.events.IVoteClient_updateVoteInfo_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.datacenter.LiveRoomDataCenter;
import com.yy.datacenter.action.LiveRoomDataState_InteractiveExpandVisibleAction;
import com.yy.live.module.vote.core.Vote;
import com.yy.live.module.vote.ui.ClickInterfaceListener;
import com.yy.live.module.vote.ui.VoteAnimListen;
import com.yy.live.module.vote.ui.VoteBaseView$$EventBinder;
import com.yy.mobile.model.Action;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;

public abstract class VoteBaseView
extends View
implements EventCompat,
VoteAnimListen {
    private static final String TAG = "VoteBaseView";
    public static boolean isFirstHide = false;
    public ClickInterfaceListener clickInterfaceListener = null;
    protected Activity mActivity;
    protected View view;
    ImageView animView;
    TextView titleView;
    TextView clockText;
    TextView remainTicketsText;
    TextView itemMaxTicketsText;
    Handler clockHandler;
    Runnable clockRun;
    int clockNum = 0;
    Vote.VoteInfo vif;
    int leftTeamTotalTickets = 0;
    int rightTeamTotalTickets = 0;
    boolean isCancelAnim = false;
    View mLayoutShade;
    int voteStatus = -1;
    private EventBinder mVoteBaseViewSniperEventBinder;

    public void onEventBind() {
        if (this.mVoteBaseViewSniperEventBinder == null) {
            this.mVoteBaseViewSniperEventBinder = new VoteBaseView$$EventBinder();
        }
        this.mVoteBaseViewSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mVoteBaseViewSniperEventBinder != null) {
            this.mVoteBaseViewSniperEventBinder.unBindEvent();
        }
    }

    public VoteBaseView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public VoteBaseView(Context context) {
        super(context);
    }

    abstract View initView(LayoutInflater var1, ViewGroup var2);

    abstract void initAdapter();

    public abstract void disableAllBtn();

    public abstract void enableAllBtn();

    abstract void endVoteHandle();

    abstract void setStatus(int var1, int var2);

    public void init(Activity activity) {
        this.mActivity = activity;
        ICoreManagerBase.addClient((Object)this);
        this.initView();
        this.initData();
        this.initAdapter();
    }

    private void initView() {
        if (this.mActivity == null) {
            return;
        }
        this.view = this.initView(LayoutInflater.from((Context)this.mActivity), null);
        this.clockText = (TextView)this.view.findViewById(R.id.vote_clock);
        this.titleView = (TextView)this.view.findViewById(R.id.vote_text_title);
        this.remainTicketsText = (TextView)this.view.findViewById(R.id.vote_remain_tickets);
        this.itemMaxTicketsText = (TextView)this.view.findViewById(R.id.vote_item_tickets);
        this.animView = new ImageView(this.view.getContext());
        this.animView.setImageResource(R.drawable.vote_plus);
        this.animView.setVisibility(8);
        RelativeLayout.LayoutParams fParams = new RelativeLayout.LayoutParams(-2, -2);
        ((RelativeLayout)this.view).addView((View)this.animView, (ViewGroup.LayoutParams)fParams);
    }

    public View getView() {
        return this.view;
    }

    public int getVisibility() {
        if (this.view == null) {
            return 0;
        }
        return this.view.getVisibility();
    }

    public void setVisibility(int visibility) {
        if (this.view != null) {
            this.view.setVisibility(visibility);
            boolean interactiveVisible = visibility != 0;
            LiveRoomDataCenter.INSTANCE.dispatch((Action)new LiveRoomDataState_InteractiveExpandVisibleAction(interactiveVisible));
        }
    }

    public void updateData(Vote.VoteInfo vif) {
        this.leftTeamTotalTickets = vif.mTotalVotesTeam1;
        this.rightTeamTotalTickets = vif.mTotalVotesTeam2;
        if (this.remainTicketsText != null) {
            this.remainTicketsText.setText((CharSequence)(vif.mVoteTickets + ""));
        }
        if (this.voteStatus != vif.status) {
            this.voteStatus = vif.status;
            if (vif.status == 1) {
                this.stopVote();
            } else {
                this.clockNum = vif.timeLeft;
                this.enableAllBtn();
                this.startVote();
            }
        }
        this.setStatus(vif.mVoteTickets, vif.status);
    }

    @Override
    public void startAddOneAnim(int animDuration, View v) {
        if (this.animView == null) {
            return;
        }
        int[] location = new int[2];
        int[] locationImg = new int[2];
        v.getLocationOnScreen(location);
        this.animView.getLocationOnScreen(locationImg);
        TranslateAnimation translateAnimation = new TranslateAnimation((float)location[0], (float)location[0], (float)(location[1] - locationImg[1] + 20), (float)(location[1] - locationImg[1] - 40));
        AlphaAnimation alphaAnimation = new AlphaAnimation(0.1f, 1.0f);
        AnimationSet animSet = new AnimationSet(true);
        animSet.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                if (VoteBaseView.this.animView != null) {
                    VoteBaseView.this.animView.setVisibility(0);
                }
            }

            public void onAnimationEnd(Animation animation) {
                if (VoteBaseView.this.animView != null) {
                    VoteBaseView.this.animView.setVisibility(4);
                }
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        animSet.addAnimation((Animation)translateAnimation);
        animSet.addAnimation((Animation)alphaAnimation);
        animSet.setDuration((long)animDuration);
        this.animView.startAnimation((Animation)animSet);
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive")
    public void updateVoteInfo(IVoteClient_updateVoteInfo_EventArgs busEventArgs) {
        Vote.VoteInfo vif = busEventArgs.getVif();
        this.updateVoteInfo(vif);
    }

    public void updateVoteInfo(Vote.VoteInfo vif) {
        if (this.vif != null && vif != null) {
            this.updateData(vif);
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive")
    public void closeVote(IVoteClient_closeVote_EventArgs busEventArgs) {
        this.closeVote();
    }

    public void closeVote() {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"[wwd \u6295\u7968\u5173\u95ed!]", (Object[])new Object[0]);
        }
        if (this != null) {
            isFirstHide = false;
            this.setVisibility(8);
            if (this.clickInterfaceListener != null) {
                this.clickInterfaceListener.removeTopViewClicked();
            }
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive")
    public void updateRemainTickets(IVoteClient_updateRemainTickets_EventArgs busEventArgs) {
        int remainTickets = busEventArgs.mRemainTickets;
        if (remainTickets == 0) {
            this.disableAllBtn();
        }
        this.remainTicketsText.setText((CharSequence)(remainTickets + ""));
        this.setStatus(remainTickets, -1);
    }

    private void closeClock() {
        this.clockHandler.removeCallbacks(this.clockRun);
        this.clockText.setText((CharSequence)"\u6295\u7968\u5df2\u7ecf\u7ed3\u675f");
        this.endVoteHandle();
    }

    public void stopVote() {
        this.disableAllBtn();
        this.clockNum = 0;
        this.closeClock();
    }

    private void startVote() {
        this.clockHandler.removeCallbacks(this.clockRun);
        this.clockHandler.postDelayed(this.clockRun, 1000L);
    }

    public void initData() {
        this.vif = new Vote.VoteInfo();
        this.vif.title = "";
        this.clockNum = this.vif.timeLeft;
        this.titleView.setText((CharSequence)this.vif.title);
        this.remainTicketsText.setText((CharSequence)(this.vif.mVoteTickets + ""));
        this.itemMaxTicketsText.setText((CharSequence)(this.vif.mOptionTickets + ""));
        this.clockHandler = new Handler();
        this.clockRun = new Runnable(){

            @Override
            public void run() {
                String tmpStr;
                --VoteBaseView.this.clockNum;
                if (VoteBaseView.this.clockNum <= 0) {
                    tmpStr = "\u6295\u7968\u5df2\u7ecf\u7ed3\u675f";
                } else {
                    int minutes = VoteBaseView.this.clockNum / 60;
                    int seconds = VoteBaseView.this.clockNum % 60;
                    tmpStr = (minutes < 10 ? "0" + minutes : "" + minutes) + ":" + (seconds < 10 ? "0" + seconds : "" + seconds) + "\u540e\u505c\u6b62";
                }
                VoteBaseView.this.clockText.setText((CharSequence)tmpStr);
                if (VoteBaseView.this.clockNum <= 0) {
                    VoteBaseView.this.clockHandler.removeCallbacks(VoteBaseView.this.clockRun);
                    VoteBaseView.this.disableAllBtn();
                    VoteBaseView.this.endVoteHandle();
                    return;
                }
                VoteBaseView.this.clockHandler.postDelayed(VoteBaseView.this.clockRun, 1000L);
            }
        };
        --this.clockNum;
        this.clockHandler.postDelayed(this.clockRun, 1000L);
    }

    public void setData(Vote.VoteInfo voteInfo) {
        if (voteInfo == null) {
            return;
        }
        this.vif = voteInfo;
        this.clockNum = this.vif.timeLeft;
        this.titleView.setText((CharSequence)this.vif.title);
        this.remainTicketsText.setText((CharSequence)(this.vif.mVoteTickets + ""));
        this.itemMaxTicketsText.setText((CharSequence)(this.vif.mOptionTickets + ""));
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive")
    public void switchVote(IVoteClient_switchVote_EventArgs busEventArgs) {
        int state = busEventArgs.mState;
        this.switchVote(state);
    }

    public void switchVote(int state) {
        this.setVisibility(8);
        isFirstHide = true;
        if (this.clickInterfaceListener != null) {
            this.clickInterfaceListener.removeTopViewClicked();
        }
    }

    public void deInit() {
        this.animView = null;
        if (this.clockHandler != null) {
            this.clockHandler.removeCallbacks(this.clockRun);
        }
        ICoreManagerBase.removeClient((Object)this);
    }

    public ClickInterfaceListener getClickInterfaceListener() {
        return this.clickInterfaceListener;
    }

    public void setClickInterfaceListener(ClickInterfaceListener clickInterfaceListener) {
        this.clickInterfaceListener = clickInterfaceListener;
    }
}

