/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.module.treasure;

import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.live.module.treasure.TreasureGuideFragment$$EventBinder;
import com.yy.live.module.treasure.TreasureIntroduceFragment;
import com.yy.live.module.treasure.TreasureProfileFragment;
import com.yy.live.module.treasure.TrueLoveAnchorUtil;
import com.yy.mobile.plugin.main.events.ITrueLoveClient_onQueryTreasureGroupInfo_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.yyprotocol.core.Uint32;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.basechannel.IChannelLinkCore;
import com.yymobile.core.truelove.TrueLoveInfo;

public class TreasureGuideFragment
extends Component {
    private static final String TAG = "TreasureGuideFragment";
    static final String TAG_INTRODUCE = "tag_introduce";
    static final String TAG_PROFILE = "tag_profile";
    private static ViewGroup parent;
    View mRootView;
    String mTag;
    private IChannelLinkCore channelLinkCore;
    private EventBinder mTreasureGuideFragmentSniperEventBinder;

    public static TreasureGuideFragment instance(ViewGroup viewGroup) {
        TreasureGuideFragment treasureGuideFragment = new TreasureGuideFragment();
        parent = viewGroup;
        return treasureGuideFragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.channelLinkCore = ICoreManagerBase.getChannelLinkCore();
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.init();
    }

    private void init() {
        if (TrueLoveAnchorUtil.isMyselfTopMicAndAnchor()) {
            this.showContent(TAG_PROFILE);
        } else if (!TrueLoveInfo.MyTrueLoveInfo.isTrueLoveUserLv((Uint32)new Uint32(this.channelLinkCore.getCurrentTopMicId()))) {
            this.showContent(TAG_INTRODUCE);
        } else {
            this.showContent(TAG_PROFILE);
        }
    }

    private void showContent(String tag) {
        this.mTag = tag;
        FragmentManager fm = this.getChildFragmentManager();
        FragmentTransaction ft = fm.beginTransaction();
        Object f = fm.findFragmentByTag(tag);
        if (null != f) {
            ft.show(f);
        } else if (TAG_INTRODUCE.equals(tag)) {
            f = TreasureIntroduceFragment.instance();
        } else if (TAG_PROFILE.equals(tag)) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)("[showContent],parent---" + parent), (Object[])new Object[0]);
            }
            f = TreasureProfileFragment.instance(parent);
        }
        if (null == f) {
            return;
        }
        if (f.isDetached()) {
            ft.attach(f);
        } else if (!f.isAdded()) {
            ft.add(this.getView().findViewById(R.id.treasure_container).getId(), f, tag);
        }
        int result = ft.commitAllowingStateLoss();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mRootView = inflater.inflate(R.layout.treasure_fragment_guide, container, false);
        this.mRootView.findViewById(R.id.screen_all_truelove).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)TreasureGuideFragment.TAG, (String)"all screen click @@@", (Object[])new Object[0]);
                }
                TreasureGuideFragment.this.hideSelf();
            }
        });
        return this.mRootView;
    }

    @BusEvent
    public void onQueryTreasureGroupInfo(ITrueLoveClient_onQueryTreasureGroupInfo_EventArgs busEventArgs) {
        TrueLoveInfo.TreasureGroupData treasureGroupData = busEventArgs.getTreasureGroupData();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"onQueryTreasureGroupInfo", (Object[])new Object[0]);
        }
        this.updateContent();
    }

    public void hideSelf() {
        super.hideSelf();
    }

    private void updateContent() {
        if (this.getView() != null) {
            boolean isTrueLove = TrueLoveInfo.MyTrueLoveInfo.isTrueLoveUserLv((Uint32)new Uint32(this.channelLinkCore.getCurrentTopMicId()));
            boolean isMyselfAncorAndTopMic = TrueLoveAnchorUtil.isMyselfTopMicAndAnchor();
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"updateContent tag=%s,topMicId=%d,isTrueLove=%b,isMyselfTopMicAndAnchor=%b", (Object[])new Object[]{this.mTag, this.channelLinkCore.getCurrentTopMicId(), isTrueLove, isMyselfAncorAndTopMic});
            }
            if (isMyselfAncorAndTopMic) {
                if (TAG_INTRODUCE.equals(this.mTag)) {
                    this.getChildFragmentManager().beginTransaction().replace(this.getView().findViewById(R.id.treasure_container).getId(), (Fragment)TreasureProfileFragment.instance(parent), TAG_PROFILE).commitAllowingStateLoss();
                }
            } else if (TAG_INTRODUCE.equals(this.mTag)) {
                if (isTrueLove) {
                    this.getChildFragmentManager().beginTransaction().replace(this.getView().findViewById(R.id.treasure_container).getId(), (Fragment)TreasureProfileFragment.instance(parent), TAG_PROFILE).commitAllowingStateLoss();
                }
            } else if (TAG_PROFILE.equals(this.mTag) && !isTrueLove) {
                this.getChildFragmentManager().beginTransaction().replace(this.getView().findViewById(R.id.treasure_container).getId(), (Fragment)TreasureIntroduceFragment.instance(), TAG_INTRODUCE).commitAllowingStateLoss();
            }
        }
    }

    public void onHiddenChanged(boolean hidden) {
        super.onHiddenChanged(hidden);
        if (hidden) {
            return;
        }
        this.updateContent();
    }

    public void onDestroy() {
        super.onDestroy();
    }

    protected void onViewCreated(View view, Bundle bundle) {
        if (this.mTreasureGuideFragmentSniperEventBinder == null) {
            this.mTreasureGuideFragmentSniperEventBinder = new TreasureGuideFragment$$EventBinder();
        }
        this.mTreasureGuideFragmentSniperEventBinder.bindEvent((Object)this);
        super.onViewCreated(view, bundle);
    }

    protected void onDestroyView() {
        super.onDestroyView();
        if (this.mTreasureGuideFragmentSniperEventBinder != null) {
            this.mTreasureGuideFragmentSniperEventBinder.unBindEvent();
        }
    }
}

