/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.module.giftmodule.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.os.Looper;
import android.os.Message;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.yy.live.publicapi.PublicApiManager;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.liveapi.gift.IGiftServiceApi;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.gift.core.IGiftUICore;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yymobile.core.ICoreManagerBase;

public class GiftIconScaleAnimatorView {
    Context mContext;
    int defSize = (int)ResolutionUtils.convertDpToPixel((float)36.0f, (Context)BasicConfig.getInstance().getAppContext());
    int pkDefSizeW = (int)ResolutionUtils.convertDpToPixel((float)71.0f, (Context)BasicConfig.getInstance().getAppContext());
    int pkDefSizeH = (int)ResolutionUtils.convertDpToPixel((float)30.0f, (Context)BasicConfig.getInstance().getAppContext());
    int bottomMargin = (int)ResolutionUtils.convertDpToPixel((float)8.0f, (Context)BasicConfig.getInstance().getAppContext());
    int pkTypeBottomMargin = (int)ResolutionUtils.convertDpToPixel((float)13.0f, (Context)BasicConfig.getInstance().getAppContext());
    int rightMargin = (int)ResolutionUtils.convertDpToPixel((float)10.0f, (Context)BasicConfig.getInstance().getAppContext());
    int pkTypeRightMarginLandscape = (int)ResolutionUtils.convertDpToPixel((float)10.0f, (Context)BasicConfig.getInstance().getAppContext());
    int rightMarginLandscape = this.bottomMargin;
    RecycleImageView vulgarEffect;
    RelativeLayout.LayoutParams layoutParams;
    final int actionType = 240;
    ObjectAnimator mEffectVlScaleX;
    ObjectAnimator mEffectVlScaleY;
    ObjectAnimator mEffectVlAlpha;
    AnimatorSet mEffectSet;
    boolean playEnd = true;
    boolean isChange = false;
    boolean playing = false;
    float startScale = 1.0f;
    SafeDispatchHandler handler = new SafeDispatchHandler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (msg.what == 240) {
                if (((IGiftUICore)ICoreManagerBase.getCore(IGiftUICore.class)).isGiftComponentShow()) {
                    GiftIconScaleAnimatorView.this.endAnimation();
                    return;
                }
                GiftIconScaleAnimatorView.this.checkIconPos();
                if (GiftIconScaleAnimatorView.this.isChange) {
                    GiftIconScaleAnimatorView.this.startScale = 1.25f;
                    GiftIconScaleAnimatorView.this.playVulgarIconEffect(1.35f, 0.4f, 0.0f);
                } else {
                    GiftIconScaleAnimatorView.this.startScale = 1.0f;
                    GiftIconScaleAnimatorView.this.playVulgarIconEffect(1.25f, 0.3f, 0.4f);
                }
            }
        }
    };

    public GiftIconScaleAnimatorView(Context mContext, ViewGroup parent) {
        this.mContext = mContext;
        this.vulgarEffect = new RecycleImageView(mContext);
        parent.addView((View)this.vulgarEffect, (ViewGroup.LayoutParams)this.getVulgarEffect(false));
    }

    public RecycleImageView getView() {
        return this.vulgarEffect;
    }

    public boolean isPlayEnd() {
        return this.playEnd;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void startAnimation() {
        this.playing = true;
        this.playEnd = false;
        this.setIconParams(false);
        this.vulgarEffect.setVisibility(0);
        this.handler.sendEmptyMessage(240);
    }

    public void endAnimation() {
        if (this.mEffectSet != null) {
            this.playEnd = true;
            this.mEffectSet.removeAllListeners();
            this.mEffectSet.end();
            this.isChange = false;
        }
        this.playing = false;
        if (this.vulgarEffect != null) {
            this.vulgarEffect.setVisibility(8);
        }
    }

    public void setIconParams(boolean isLandscape) {
        if (PublicApiManager.giftIconState == IGiftServiceApi.GiftIconState.pkgift) {
            this.vulgarEffect.setImageDrawable(this.mContext.getResources().getDrawable(R.drawable.icon_support_sel));
        } else if (PublicApiManager.giftIconState == IGiftServiceApi.GiftIconState.pkfirstcharge) {
            this.vulgarEffect.setImageDrawable(this.mContext.getResources().getDrawable(R.drawable.ico_firstcharge_pk));
        } else if (PublicApiManager.giftIconState == IGiftServiceApi.GiftIconState.arenagiftred) {
            this.vulgarEffect.setImageDrawable(this.mContext.getResources().getDrawable(R.drawable.bg_arena_gift_icon_red));
        } else if (PublicApiManager.giftIconState == IGiftServiceApi.GiftIconState.arenagiftbule) {
            this.vulgarEffect.setImageDrawable(this.mContext.getResources().getDrawable(R.drawable.bg_arena_gift_icon_blue));
        } else {
            this.vulgarEffect.setImageDrawable(this.mContext.getResources().getDrawable(R.drawable.btn_yellow_normal_corner));
        }
        this.vulgarEffect.setLayoutParams((ViewGroup.LayoutParams)this.getVulgarEffect(isLandscape));
    }

    public void onOrientationChange(boolean isLandscape) {
        this.vulgarEffect.setLayoutParams((ViewGroup.LayoutParams)this.getVulgarEffect(isLandscape));
    }

    private void checkIconPos() {
        boolean needCheck = false;
        if (this.layoutParams != null) {
            if (this.isLandScape()) {
                needCheck = PublicApiManager.giftIconState == IGiftServiceApi.GiftIconState.pkgift || PublicApiManager.giftIconState == IGiftServiceApi.GiftIconState.arenagiftred || PublicApiManager.giftIconState == IGiftServiceApi.GiftIconState.arenagiftbule ? this.layoutParams.rightMargin != this.pkTypeRightMarginLandscape : this.layoutParams.rightMargin != this.rightMarginLandscape;
            } else {
                boolean bl = needCheck = this.layoutParams.rightMargin != this.rightMargin;
            }
        }
        if (needCheck) {
            this.vulgarEffect.setLayoutParams((ViewGroup.LayoutParams)this.getVulgarEffect(true));
        }
    }

    private RelativeLayout.LayoutParams getVulgarEffect(boolean isLandscape) {
        this.layoutParams = PublicApiManager.giftIconState == IGiftServiceApi.GiftIconState.pkgift || PublicApiManager.giftIconState == IGiftServiceApi.GiftIconState.arenagiftred || PublicApiManager.giftIconState == IGiftServiceApi.GiftIconState.arenagiftbule ? new RelativeLayout.LayoutParams(this.pkDefSizeW, this.pkDefSizeH) : new RelativeLayout.LayoutParams(this.defSize, this.defSize);
        this.layoutParams.addRule(12);
        this.layoutParams.addRule(11);
        this.layoutParams.bottomMargin = PublicApiManager.giftIconState == IGiftServiceApi.GiftIconState.pkgift || PublicApiManager.giftIconState == IGiftServiceApi.GiftIconState.arenagiftred || PublicApiManager.giftIconState == IGiftServiceApi.GiftIconState.arenagiftbule ? this.pkTypeBottomMargin : this.bottomMargin;
        this.layoutParams.rightMargin = isLandscape ? (PublicApiManager.giftIconState == IGiftServiceApi.GiftIconState.pkgift || PublicApiManager.giftIconState == IGiftServiceApi.GiftIconState.arenagiftred || PublicApiManager.giftIconState == IGiftServiceApi.GiftIconState.arenagiftbule ? this.pkTypeRightMarginLandscape : this.rightMarginLandscape) : this.rightMargin;
        return this.layoutParams;
    }

    private void playVulgarIconEffect(float toScale, float fromAlpha, float toAlpha) {
        if (this.mEffectVlScaleX != null) {
            this.mEffectVlScaleX.end();
        }
        if (this.mEffectVlScaleY != null) {
            this.mEffectVlScaleY.end();
        }
        if (this.mEffectVlAlpha != null) {
            this.mEffectVlAlpha.end();
        }
        if (this.mEffectSet != null) {
            this.mEffectSet.removeAllListeners();
            this.mEffectSet.end();
        }
        this.mEffectSet = new AnimatorSet();
        this.mEffectVlScaleX = ObjectAnimator.ofFloat((Object)this.vulgarEffect, (String)"scaleX", (float[])new float[]{this.startScale, toScale});
        this.mEffectVlScaleY = ObjectAnimator.ofFloat((Object)this.vulgarEffect, (String)"scaleY", (float[])new float[]{this.startScale, toScale});
        this.mEffectVlAlpha = ObjectAnimator.ofFloat((Object)this.vulgarEffect, (String)"alpha", (float[])new float[]{fromAlpha, toAlpha});
        this.mEffectSet.setDuration(500L);
        this.mEffectSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (!GiftIconScaleAnimatorView.this.playEnd) {
                    GiftIconScaleAnimatorView.this.isChange = !GiftIconScaleAnimatorView.this.isChange;
                    GiftIconScaleAnimatorView.this.handler.sendEmptyMessage(240);
                } else {
                    GiftIconScaleAnimatorView.this.isChange = false;
                }
            }
        });
        this.mEffectSet.playTogether(new Animator[]{this.mEffectVlScaleX, this.mEffectVlScaleY, this.mEffectVlAlpha});
        this.mEffectSet.start();
    }

    private boolean isLandScape() {
        return this.mContext != null && this.mContext.getResources().getConfiguration().orientation == 2;
    }
}

