/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.module.giftmodule;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.yy.live.publicapi.PublicApiManager;
import com.yy.mobile.RxBus;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.liveapi.gift.IGiftServiceApi;
import com.yy.mobile.plugin.main.events.IGiftUIListener_onGiftIconVisibleChanged_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.gift.core.IGiftUICore;
import com.yy.mobile.ui.utils.IView;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;

public class GiftIconView
implements IView {
    private static final String TAG = "GiftIconView";
    Activity mActivity;
    View mRootView;
    ImageView mIcon;
    Button mIconSupport;
    RecycleImageView commonRedDot;
    RelativeLayout.LayoutParams normalParams;
    RelativeLayout.LayoutParams pkParamas;

    public GiftIconView(Activity context) {
        this.mActivity = context;
    }

    public void setOnClickListener(View.OnClickListener onClickListener2) {
        if (this.mRootView != null && onClickListener2 != null) {
            if (this.mIconSupport != null) {
                this.mIconSupport.setOnClickListener(onClickListener2);
            }
            if (this.mIcon != null) {
                this.mIcon.setOnClickListener(onClickListener2);
            }
        }
    }

    public View getView() {
        if (this.mRootView == null) {
            this.mRootView = LayoutInflater.from((Context)this.mActivity).inflate(R.layout.lr_layout_gift_module, null);
            this.mIcon = (ImageView)this.mRootView.findViewById(R.id.icon_gift);
            this.mIconSupport = (Button)this.mRootView.findViewById(R.id.icon_support);
            this.mIconSupport.setVisibility(8);
            this.mIcon.setImageDrawable((Drawable)this.getDrawable());
            this.commonRedDot = (RecycleImageView)this.mRootView.findViewById(R.id.common_red_dot);
            this.commonRedDot.setVisibility(8);
        }
        MLog.info((Object)TAG, (String)"gift icon view is created ok!", (Object[])new Object[0]);
        return this.mRootView;
    }

    private StateListDrawable getDrawable() {
        StateListDrawable sd = new StateListDrawable();
        BitmapDrawable press = ImageLoader.getBitmapDrawableFromResource((int)R.drawable.gift_icon_press, (ImageConfig)ImageConfig.fullImageConfig());
        BitmapDrawable normal = ImageLoader.getBitmapDrawableFromResource((int)R.drawable.gift_icon_normal, (ImageConfig)ImageConfig.fullImageConfig());
        sd.addState(new int[]{16842919}, (Drawable)press);
        sd.addState(new int[]{16842908}, (Drawable)press);
        sd.addState(new int[0], (Drawable)normal);
        return sd;
    }

    public void show() {
        if (this.mRootView != null) {
            MLog.info((Object)TAG, (String)"gift icon view show", (Object[])new Object[0]);
            boolean lastVisible = this.mRootView.getVisibility() == 0;
            this.mRootView.setVisibility(0);
            this.setGiftIconBg(PublicApiManager.giftIconState);
            ((IGiftUICore)ICoreManagerBase.getCore(IGiftUICore.class)).setGiftIconVisible(true);
            if (!lastVisible) {
                RxBus.getDefault().post((Object)new IGiftUIListener_onGiftIconVisibleChanged_EventArgs(true));
            }
        }
    }

    public void hide() {
        if (this.mRootView != null) {
            MLog.info((Object)TAG, (String)"gift icon view hide", (Object[])new Object[0]);
            boolean lastVisible = this.mRootView.getVisibility() == 0;
            this.mRootView.setVisibility(8);
            ((IGiftUICore)ICoreManagerBase.getCore(IGiftUICore.class)).setGiftIconVisible(false);
            if (lastVisible) {
                RxBus.getDefault().post((Object)new IGiftUIListener_onGiftIconVisibleChanged_EventArgs(false));
            }
        }
    }

    public boolean isShown() {
        return null != this.mRootView && this.mRootView.getVisibility() == 0;
    }

    public void animteGiftIcon(Animator.AnimatorListener listener2) {
        if (this.mRootView == null) {
            return;
        }
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)this.mRootView, (String)"scaleX", (float[])new float[]{1.0f, 1.2f, 1.0f}), ObjectAnimator.ofFloat((Object)this.mRootView, (String)"scaleY", (float[])new float[]{1.0f, 1.2f, 1.0f})});
        if (listener2 != null) {
            set.addListener(listener2);
        }
        set.setDuration(300L).start();
    }

    public void changeState(IGiftServiceApi.GiftIconState state) {
        if (this.mRootView == null) {
            return;
        }
        if (this.mRootView.getVisibility() != 0) {
            this.show();
            if (this.commonRedDot != null && this.commonRedDot.getVisibility() == 0) {
                this.showGiftIconRedDot(true);
            }
        }
        this.setGiftIconBg(state);
    }

    private void setGiftIconBg(IGiftServiceApi.GiftIconState state) {
        if (state == IGiftServiceApi.GiftIconState.gift) {
            this.mIcon.setVisibility(0);
            this.mIcon.setImageDrawable((Drawable)this.getDrawable());
            this.mIconSupport.setVisibility(8);
        } else if (state == IGiftServiceApi.GiftIconState.pkgift) {
            this.mIcon.setVisibility(8);
            this.mIconSupport.setVisibility(0);
            this.mIconSupport.setTextColor(Color.parseColor((String)"#14262f"));
            this.mIconSupport.setBackgroundResource(R.drawable.icon_support_sel);
        } else if (state == IGiftServiceApi.GiftIconState.pkfirstcharge) {
            this.mIcon.setVisibility(0);
            this.mIcon.setImageResource(R.drawable.ico_firstcharge_pk);
            this.mIconSupport.setVisibility(8);
        } else if (state == IGiftServiceApi.GiftIconState.arenagiftred) {
            this.mIcon.setVisibility(8);
            this.mIconSupport.setVisibility(0);
            this.mIconSupport.setTextColor(Color.parseColor((String)"#ffffff"));
            this.mIconSupport.setBackgroundResource(R.drawable.bg_arena_gift_icon_red);
        } else if (state == IGiftServiceApi.GiftIconState.arenagiftbule) {
            this.mIcon.setVisibility(8);
            this.mIconSupport.setVisibility(0);
            this.mIconSupport.setTextColor(Color.parseColor((String)"#ffffff"));
            this.mIconSupport.setBackgroundResource(R.drawable.bg_arena_gift_icon_blue);
        }
    }

    public void showGiftIconRedDot(boolean changeState) {
        if (this.commonRedDot == null) {
            return;
        }
        if (PublicApiManager.giftIconState != IGiftServiceApi.GiftIconState.pkgift || PublicApiManager.giftIconState != IGiftServiceApi.GiftIconState.arenagiftbule || PublicApiManager.giftIconState != IGiftServiceApi.GiftIconState.arenagiftred) {
            if (this.normalParams == null) {
                this.normalParams = new RelativeLayout.LayoutParams(-2, -2);
                this.normalParams.leftMargin = (int)ResolutionUtils.convertDpToPixel((float)30.0f, (Context)BasicConfig.getInstance().getAppContext());
                this.normalParams.topMargin = (int)ResolutionUtils.convertDpToPixel((float)2.0f, (Context)BasicConfig.getInstance().getAppContext());
                this.commonRedDot.setLayoutParams((ViewGroup.LayoutParams)this.normalParams);
            } else if (changeState) {
                this.commonRedDot.setLayoutParams((ViewGroup.LayoutParams)this.normalParams);
            }
        } else if (this.pkParamas == null) {
            this.pkParamas = new RelativeLayout.LayoutParams(-2, -2);
            this.pkParamas.topMargin = (int)ResolutionUtils.convertDpToPixel((float)2.0f, (Context)BasicConfig.getInstance().getAppContext());
            this.pkParamas.leftMargin = (int)ResolutionUtils.convertDpToPixel((float)64.0f, (Context)BasicConfig.getInstance().getAppContext());
            this.commonRedDot.setLayoutParams((ViewGroup.LayoutParams)this.pkParamas);
        } else if (changeState) {
            this.commonRedDot.setLayoutParams((ViewGroup.LayoutParams)this.pkParamas);
        }
        if (this.commonRedDot.getVisibility() != 0) {
            this.commonRedDot.setVisibility(0);
        }
    }

    public void hideGiftIconRedDot() {
        if (this.commonRedDot == null) {
            return;
        }
        if (this.commonRedDot.getVisibility() != 8) {
            this.commonRedDot.setVisibility(8);
        }
    }
}

