/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.module.giftdanmu;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.Spannable;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.richtext.BaseRichTextFilter;
import com.yy.mobile.ui.widget.CustomImageSpan;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.noble.emotion.ChatEmotion;
import com.yymobile.core.noble.emotion.NobleEmotionParser;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NewNobleFilter
extends BaseRichTextFilter {
    GIFInterruptListener mGifListener;
    private Pattern mPattern = Pattern.compile("#\\d{2}");

    public void strToEmotion(Spannable spannable, Context context) {
        Matcher matcher = this.mPattern.matcher((CharSequence)spannable);
        List chatEmotions = NobleEmotionParser.getInstance().getChatEmotions();
        while (matcher.find()) {
            Bitmap bitmap;
            BitmapDrawable bitmapDrawable;
            final String uri = this.getGifByNobleEmotion(chatEmotions, matcher.group());
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"NobleEmotionFilter", (String)("uri = " + uri + " matcher.group() = " + matcher.group()), (Object[])new Object[0]);
            }
            BitmapDrawable bitmapDrawable2 = bitmapDrawable = (bitmap = NobleEmotionParser.getInstance().getNobleBitmapFromCache(uri)) == null ? null : new BitmapDrawable(bitmap);
            if (bitmapDrawable != null) {
                bitmapDrawable.setBounds(5, 0, bitmapDrawable.getIntrinsicWidth() * 3, bitmapDrawable.getIntrinsicHeight() * 3);
                CustomImageSpan imageSpan = new CustomImageSpan((Drawable)bitmapDrawable, 2.0f);
                spannable.setSpan((Object)imageSpan, matcher.start(), matcher.end(), 33);
                continue;
            }
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"NobleEmotionFilter", (String)(" download  uri = " + uri + " matcher.group() = " + matcher.group()), (Object[])new Object[0]);
            }
            ImageLoader.loadBitmap((Context)BasicConfig.getInstance().getAppContext(), (String)uri, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                public void onLoadFailed(Exception e) {
                    MLog.info((Object)"NobleEmotionFilter", (String)"NOBLE EMOTION DOWNLOAD ERROR!", (Object[])new Object[0]);
                }

                public void onResourceReady(Bitmap bitmap) {
                    NobleEmotionParser.getInstance().saveNobleEmotionBitmapToCache(uri, bitmap);
                }
            });
        }
    }

    private void inits(Bitmap bitmap) {
    }

    private String getFilePath(String url) {
        String fileName = url;
        int index = url.lastIndexOf(File.separatorChar);
        if (index != -1) {
            fileName = url.substring(index + 1);
        }
        String filePath = BasicConfig.getInstance().getConfigDir().getAbsolutePath() + File.separator + fileName;
        return filePath;
    }

    public void setGifListener(GIFInterruptListener mGifListener) {
        this.mGifListener = mGifListener;
    }

    private String getGifByNobleEmotion(List<ChatEmotion> chatEmotions, String shortCut) {
        String uri = "";
        if (chatEmotions != null && chatEmotions.size() > 0 && shortCut != null) {
            for (ChatEmotion chatEmotion : chatEmotions) {
                if (!shortCut.equalsIgnoreCase(chatEmotion.getShortcut())) continue;
                uri = chatEmotion.getUrlPngMob();
            }
        }
        return uri;
    }

    public void parseSpannable(Context context, Spannable spannable, int maxWidth) {
        this.parseSpannable(context, spannable, maxWidth, null);
    }

    public void parseSpannable(Context context, Spannable spannable, int maxWidth, Object tag) {
        this.strToEmotion(spannable, context);
    }

    public static interface GIFInterruptListener {
        public void interrupt(String var1, Spannable var2, int var3, int var4);
    }
}

