/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.module.giftdanmu;

import android.text.TextUtils;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.duowan.mobile.entlive.events.IGiftClient_addNormalMessage_EventArgs;
import com.duowan.mobile.entlive.events.IGiftClient_appendGiftDanMu_EventArgs;
import com.duowan.mobile.entlive.events.IGiftClient_onAddChannelChatMessage_EventArgs;
import com.duowan.mobile.entlive.events.IGiftClient_onComboGiftSendBroadcast_EventArgs;
import com.duowan.mobile.entlive.events.IGiftClient_onFreeGiftSendBroadcast_EventArgs;
import com.duowan.mobile.entlive.events.IGiftClient_onPaidGiftSendBroadcast_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.live.basic.ELBasicModule;
import com.yy.live.module.DiamondBroadcastModule.ui.BaseViewController;
import com.yy.live.module.giftdanmu.GiftDanMu$$EventBinder;
import com.yy.live.module.giftdanmu.LiveDanMuUtil;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_leaveCurrentChannel_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_updateCurrentChannelMessage_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.richtext.VipEmoticonFilter;
import com.yy.mobile.richtext.XmlChannelMessage;
import com.yy.mobile.richtext.XmlFilter;
import com.yy.mobile.ui.actmedal.core.IActMedalCore;
import com.yy.mobile.ui.publicchat.util.RichTextUtil;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.basechannel.ChannelChatFilter;
import com.yymobile.core.basechannel.SessOnText;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.channel.ChannelMsgRecvFilter;
import com.yymobile.core.channel.ChannelState;
import com.yymobile.core.channel.PublicChatMessage;
import com.yymobile.core.gift.GiftChannelMessage;
import com.yymobile.core.gift.GiftConfigItemBase;
import com.yymobile.core.gift.GiftConfigParser;
import com.yymobile.core.gift.GiftProtocol;
import com.yymobile.core.medal.MedalCenter;
import com.yymobile.core.medal.PenetrateInfoEntry;
import com.yymobile.core.noble.emotion.NobleEmotionParser;

public class GiftDanMu
extends BaseViewController
implements EventCompat {
    private static final String TAG = "GiftDanMu";
    private ChannelMsgRecvFilter f = new ChannelMsgRecvFilter();
    private boolean isEnableComboGift = true;
    private EventBinder mGiftDanMuSniperEventBinder;

    @Override
    public void init() {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"wangke", (String)"GiftDanMu init", (Object[])new Object[0]);
        }
        this.mRoot = new RelativeLayout(this.getContext());
        GiftDanMuModuleParameter parameter = (GiftDanMuModuleParameter)this.getInitialParameter();
        if (parameter != null) {
            this.isEnableComboGift = parameter.isEnableComboGift();
        }
    }

    @Override
    protected ViewGroup.LayoutParams getPortraitLayout() {
        if (this.pp == null) {
            this.pp = new RelativeLayout.LayoutParams(-2, -2);
        }
        return this.pp;
    }

    @Override
    protected ViewGroup.LayoutParams getLandscapeLayout() {
        if (this.ll == null) {
            this.ll = new RelativeLayout.LayoutParams(-2, -2);
        }
        return this.ll;
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void onPaidGiftSendBroadcast(IGiftClient_onPaidGiftSendBroadcast_EventArgs busEventArgs) {
        GiftProtocol.PPaidGiftBroadcastSingle gift = busEventArgs.mGift;
        if (ICoreManagerBase.getChannelLinkCore().getChannelState() == ChannelState.In_Channel) {
            String giftName = "";
            String isPrePaid = (String)gift.detailInfo.get("isprepaid");
            String actId = (String)gift.detailInfo.get("actId");
            String headUrl = (String)gift.detailInfo.get("headUrl");
            String medalUrl = (String)gift.detailInfo.get("medalUrl");
            String medalId = (String)gift.detailInfo.get("medalId");
            String shortCutGift = "{\"fast\":\"1\"}";
            if (shortCutGift.equals(gift.detailInfo.get("PBUY_KEY_PRODUCTINFO")) && gift.fromId.longValue() != LoginUtil.getUid() && Math.random() > 0.4) {
                return;
            }
            if (gift.num.intValue() == 0) {
                return;
            }
            PenetrateInfoEntry entry = MedalCenter.getInstance().parserPenetrateInfo(gift.detailInfo);
            if (entry.actMedalInfo != null) {
                ((IActMedalCore)ICoreManagerBase.getCore(IActMedalCore.class)).setActMedalInfoByUid(gift.fromId.longValue(), entry.actMedalInfo);
            }
            this.sendPaidGiftText(medalUrl, gift.fromName, gift.fromId.longValue(), gift.type.intValue(), gift.num.intValue(), entry);
        }
    }

    public void sendPaidGiftText(String medalUrl, String fromName, long fromId, int giftType, int num, PenetrateInfoEntry entry) {
        String giftText = BasicConfig.getInstance().getAppContext().getResources().getString(R.string.str_send_gift_text_format, new Object[]{fromName, giftType, num});
        if (!StringUtils.isNullOrEmpty((String)medalUrl)) {
            giftText = "s" + giftText;
        }
        GiftChannelMessage msg = new GiftChannelMessage(GiftChannelMessage.GiftType.PaidGift, medalUrl);
        msg.giftTypeId = giftType;
        msg.nickname = fromName;
        msg.uid = fromId;
        msg.text = giftText;
        MedalCenter.getInstance().createMedalEntry((ChannelMessage)msg, entry);
        LiveDanMuUtil.getInstance().appendDanmu((ChannelMessage)msg, this.getContext());
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void onComboGiftSendBroadcast(IGiftClient_onComboGiftSendBroadcast_EventArgs busEventArgs) {
        if (!this.isEnableComboGift) {
            return;
        }
        String fromName = busEventArgs.mFromName;
        long fromId = busEventArgs.mFromId;
        int giftType = busEventArgs.mGiftType;
        int num = busEventArgs.mNum;
        int comboNum = busEventArgs.mComboNum;
        PenetrateInfoEntry entry = busEventArgs.entry;
        this.sendComboGiftText(fromName, fromId, giftType, num, comboNum, entry);
    }

    public void sendComboGiftText(String fromName, long fromId, int giftType, int num, int comboNum, PenetrateInfoEntry entry) {
        String giftText = BasicConfig.getInstance().getAppContext().getResources().getString(R.string.str_text_combo_gift, new Object[]{fromName, giftType, num, comboNum});
        GiftChannelMessage msg = new GiftChannelMessage(GiftChannelMessage.GiftType.ComboGift);
        msg.giftTypeId = giftType;
        msg.nickname = fromName;
        msg.uid = fromId;
        msg.text = giftText;
        MedalCenter.getInstance().createMedalEntry((ChannelMessage)msg, entry);
        LiveDanMuUtil.getInstance().appendDanmu((ChannelMessage)msg, this.getContext());
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void addNormalMessage(IGiftClient_addNormalMessage_EventArgs busEventArgs) {
        ChannelMessage message = busEventArgs.mMessage;
        message.nickname = null;
        LiveDanMuUtil.getInstance().appendDanmu(message, this.getContext());
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void onAddChannelChatMessage(IGiftClient_onAddChannelChatMessage_EventArgs busEventArgs) {
        ChannelMessage channelMessage = busEventArgs.mChannelMessage;
        this.appendChannelMessage(channelMessage);
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void onFreeGiftSendBroadcast(IGiftClient_onFreeGiftSendBroadcast_EventArgs busEventArgs) {
        GiftProtocol.MobFreePropsBroadcastSingle gift = busEventArgs.mGift;
        String giftName = "";
        String actId = (String)gift.detailInfo.get("actId");
        String headUrl = (String)gift.detailInfo.get("headUrl");
        String medalUrl = (String)gift.detailInfo.get("medalUrl");
        String medalId = (String)gift.detailInfo.get("medalId");
        PenetrateInfoEntry entry = MedalCenter.getInstance().parserPenetrateInfo(gift.detailInfo);
        if (entry.actMedalInfo != null) {
            ((IActMedalCore)ICoreManagerBase.getCore(IActMedalCore.class)).setActMedalInfoByUid(gift.fromId.longValue(), entry.actMedalInfo);
        }
        if (ICoreManagerBase.getChannelLinkCore().getChannelState() == ChannelState.In_Channel) {
            this.sendFreeGiftText(medalUrl, gift.fromName, gift.fromId.longValue(), gift.type.intValue(), gift.num.intValue(), entry);
        }
    }

    public void sendFreeGiftText(String medalUrl, String fromName, long fromId, int giftType, int num, PenetrateInfoEntry entry) {
        String giftText = BasicConfig.getInstance().getAppContext().getResources().getString(R.string.str_send_gift_text_format, new Object[]{fromName, giftType, num});
        GiftConfigItemBase item2 = GiftConfigParser.getInstance().getGiftConfigItemByType(giftType);
        if (item2 != null && item2 instanceof GiftConfigParser.FreeGiftConfigItem && ((GiftConfigParser.FreeGiftConfigItem)item2).business == GiftConfigParser.FreeGiftConfigItem.Business.reward_task) {
            giftText = BasicConfig.getInstance().getAppContext().getResources().getString(R.string.str_send_weekstar_gift_text_format, new Object[]{fromName, item2.name, giftType, num});
        }
        if (!StringUtils.isNullOrEmpty((String)medalUrl)) {
            giftText = "s" + giftText;
        }
        GiftChannelMessage msg = new GiftChannelMessage(GiftChannelMessage.GiftType.FreeGift, medalUrl);
        msg.giftTypeId = giftType;
        msg.nickname = fromName;
        msg.uid = fromId;
        msg.text = giftText;
        MedalCenter.getInstance().createMedalEntry((ChannelMessage)msg, entry);
        LiveDanMuUtil.getInstance().appendDanmu((ChannelMessage)msg, this.getContext());
    }

    @BusEvent
    public void updateCurrentChannelMessage(IChannelLinkClient_updateCurrentChannelMessage_EventArgs busEventArgs) {
        SessOnText etSessOnText = busEventArgs.getEtSessOnText();
        if (etSessOnText == null) {
            MLog.info((Object)"wangke", (String)"onChanText ", (Object[])new Object[0]);
            return;
        }
        if (LoginUtil.isLogined() && etSessOnText.uid == LoginUtil.getUid()) {
            return;
        }
        long chatSubSid = etSessOnText.subSid;
        PublicChatMessage message = new PublicChatMessage();
        message.uid = etSessOnText.uid;
        message.sid = chatSubSid;
        message.nickname = etSessOnText.nickname;
        message.text = etSessOnText.text;
        this.appendChannelMessage((ChannelMessage)message);
    }

    public void appendChannelMessage(final ChannelMessage message) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    String chatEmotionUri;
                    message.text = message.text.trim();
                    if (XmlFilter.checkValid((String)message.text)) {
                        String tempXmlStr = message.text;
                        XmlChannelMessage xmlChannelMessage = XmlFilter.parseNobleChannelMessage((String)message.text);
                        message.text = xmlChannelMessage.text;
                        String filterText = RichTextUtil.filterEmotion(message.text);
                        if (!TextUtils.isEmpty((CharSequence)filterText)) {
                            message.text = filterText;
                        }
                        PenetrateInfoEntry entry = MedalCenter.getInstance().parserPenetrateInfoV4(xmlChannelMessage, tempXmlStr);
                        MedalCenter.getInstance().createMedalEntry(message, entry);
                    }
                    if (!FP.empty((CharSequence)(chatEmotionUri = NobleEmotionParser.getInstance().getChatEmotionUri(message.text)))) {
                        message.gifUri = chatEmotionUri;
                        message.channelMessageType = ChannelMessage.ChannelMsgType.NOBLEEMOTION_MESSAGE_TYPE;
                        MLog.info((Object)"ChannelCore", (String)("[appendChannelMessage] :[NobleEmotionMessage]: " + message), (Object[])new Object[0]);
                    }
                    message.text = VipEmoticonFilter.replaceVipEmoticonWithGivenStr((String)message.text, (String)"[\u4f1a\u5458\u8868\u60c5]");
                    if (ChannelChatFilter.filter((ChannelMessage)message, (ChannelMsgRecvFilter)GiftDanMu.this.f)) {
                        return;
                    }
                }
                catch (Throwable throwable) {
                    MLog.error((Object)GiftDanMu.TAG, (Throwable)throwable);
                }
                LiveDanMuUtil.getInstance().appendDanmu(message, GiftDanMu.this.getContext());
            }
        });
    }

    @BusEvent(sync=true)
    public void leaveCurrentChannel(IChannelLinkClient_leaveCurrentChannel_EventArgs busEventArgs) {
        ChannelInfo channelInfo = busEventArgs.getInfo();
        LiveDanMuUtil.getInstance().stopDanmu();
        this.f.clear();
    }

    @Override
    public void onDispose() {
        super.onDispose();
        LiveDanMuUtil.getInstance().clear();
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void appendGiftDanMu(IGiftClient_appendGiftDanMu_EventArgs busEventArgs) {
        ChannelMessage message = busEventArgs.mMessage;
        LiveDanMuUtil.getInstance().appendDanmu(message, this.getContext());
    }

    @Override
    public void onEventBind() {
        super.onEventBind();
        if (this.mGiftDanMuSniperEventBinder == null) {
            this.mGiftDanMuSniperEventBinder = new GiftDanMu$$EventBinder();
        }
        this.mGiftDanMuSniperEventBinder.bindEvent((Object)this);
    }

    @Override
    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mGiftDanMuSniperEventBinder != null) {
            this.mGiftDanMuSniperEventBinder.unBindEvent();
        }
    }

    public static class GiftDanMuModuleParameter
    extends ELBasicModule.ModuleInitialParameter {
        private boolean isEnableComboGift = true;

        public GiftDanMuModuleParameter(boolean isEnableComboGift) {
            this.isEnableComboGift = isEnableComboGift;
        }

        public boolean isEnableComboGift() {
            return this.isEnableComboGift;
        }
    }
}

