/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.basic.module.management;

import com.yy.live.basic.module.management.ModuleManagerOperator;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AliveManagerReference {
    private static final Set<WeakReference<ModuleManagerOperator>> M_REFERENCE_SET = new HashSet<WeakReference<ModuleManagerOperator>>();

    static void callWhenOnCreated(ModuleManagerOperator moduleManagerOperator) {
        M_REFERENCE_SET.add(new WeakReference<ModuleManagerOperator>(moduleManagerOperator));
    }

    static void callWhenOnDestoried(ModuleManagerOperator moduleManagerOperator) {
        Iterator<WeakReference<ModuleManagerOperator>> iterator = M_REFERENCE_SET.iterator();
        while (iterator.hasNext()) {
            WeakReference<ModuleManagerOperator> reference = iterator.next();
            if (reference != null && reference != moduleManagerOperator) continue;
            iterator.remove();
        }
    }

    public static int applySupplement(@NotNull String componentName, @NotNull String diffName) {
        for (WeakReference<ModuleManagerOperator> reference : M_REFERENCE_SET) {
            int featureId;
            ModuleManagerOperator managerOperator = (ModuleManagerOperator)reference.get();
            if (managerOperator == null || !componentName.equals(managerOperator.getAttachedComponentName()) || (featureId = managerOperator.applySupplement(diffName)) == -1) continue;
            return featureId;
        }
        return -1;
    }

    public static boolean cancelSupplement(@NotNull String componentName, int cancelId) {
        for (WeakReference<ModuleManagerOperator> reference : M_REFERENCE_SET) {
            boolean isDone;
            ModuleManagerOperator managerOperator = (ModuleManagerOperator)reference.get();
            if (managerOperator == null || !componentName.equals(managerOperator.getAttachedComponentName()) || !(isDone = managerOperator.cancelSupplement(cancelId))) continue;
            return true;
        }
        return false;
    }
}

