/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.ui.videobusiness;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicfunction.uicore.IBasicFunctionCore;
import com.yy.mobile.ui.touch.BrightnessAndVolumnSetter;
import com.yymobile.core.ICoreManagerBase;

public class VolumeBrightnessView
extends RelativeLayout {
    private View mTipContainer;
    private TextView mTipTextView;
    private BrightnessAndVolumnSetter.VolumeSetter mVolumeSetter;
    private BrightnessAndVolumnSetter.BrightnessSetter mBrightnessSetter;
    private float mMaxDistance = 0.0f;
    private float mYpre = 0.0f;
    private float mYdown = 0.0f;
    private float mXdown = 0.0f;
    private boolean mEnable = true;
    public static final String TAG = "VolumeBrightnessView1";

    public VolumeBrightnessView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setTipContainer(View view) {
        this.mTipContainer = view;
        this.mTipTextView = (TextView)view.findViewById(R.id.swipe_text_control_tip);
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        Boolean intercept = false;
        if (!this.mEnable) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                this.mYdown = event.getY(0);
                this.mYpre = event.getY(0);
                this.mXdown = event.getX(0);
                intercept = false;
                break;
            }
            case 2: {
                if (Math.abs(this.mYdown - event.getY()) >= (float)ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop() && Math.abs(this.mYdown - event.getY()) > Math.abs(this.mXdown - event.getX())) {
                    intercept = true;
                    break;
                }
                intercept = false;
                break;
            }
            case 1: {
                intercept = false;
                break;
            }
        }
        return intercept;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mEnable) {
            return false;
        }
        if (event.getPointerCount() > 1) {
            return true;
        }
        switch (event.getAction()) {
            case 0: {
                break;
            }
            case 2: {
                this.volumeAndBrightnessChange(event.getY() - this.mYpre);
                this.mYpre = event.getY(0);
                break;
            }
            default: {
                this.mYdown = 0.0f;
                this.mYpre = 0.0f;
                this.mXdown = 0.0f;
                if (this.mTipContainer == null) break;
                this.mTipContainer.setVisibility(8);
            }
        }
        return true;
    }

    public boolean isEnable() {
        return this.mEnable;
    }

    public void setEnable(boolean enable) {
        this.mEnable = enable;
    }

    private void volumeAndBrightnessChange(float offset) {
        int value;
        float distance = this.mYpre + offset - this.mYdown;
        if (this.mXdown > (float)(this.getWidth() / 2)) {
            if (this.mVolumeSetter == null) {
                this.mVolumeSetter = new BrightnessAndVolumnSetter.VolumeSetter(this.getContext());
            }
            value = Math.round(this.mVolumeSetter.changeVolume(this.mYdown, this.convertPix2Value(distance)) * 100.0f);
        } else {
            if (this.mBrightnessSetter == null) {
                this.mBrightnessSetter = new BrightnessAndVolumnSetter.BrightnessSetter((Activity)this.getContext());
            }
            value = Math.round(this.mBrightnessSetter.changeBrightness(this.mYdown, this.convertPix2Value(distance)) * 100.0f);
            IBasicFunctionCore basicFunctionCore = (IBasicFunctionCore)ICoreManagerBase.getCore(IBasicFunctionCore.class);
            double cacheLight = (float)value * 2.55f;
            basicFunctionCore.setLiveRoomBrightnessCache((int)cacheLight);
        }
        if (this.mTipContainer != null) {
            this.mTipContainer.setVisibility(0);
            this.mTipTextView.setCompoundDrawablesWithIntrinsicBounds(this.mXdown > (float)(this.getWidth() / 2) ? R.drawable.icon_voice : R.drawable.icon_brigh, 0, 0, 0);
            this.mTipTextView.setText((CharSequence)String.format("%s%%", value));
        }
    }

    private float convertPix2Value(float f) {
        float rv;
        if (this.mMaxDistance == 0.0f) {
            this.mMaxDistance = (float)this.getHeight() * 1.5f;
        }
        return (rv = -f / this.mMaxDistance) > 1.0f ? 1.0f : (rv < -1.0f ? -1.0f : rv);
    }
}

