/*
 * Decompiled with CFR 0.152.
 */
package com.yy.entlivedata;

import android.os.SystemClock;
import android.support.annotation.NonNull;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EntLiveDataRecorder {
    private static final String TAG = "EntLiveDataMgr";
    public static final String KEY_NOBLE = "key_noble";
    public static final String KEY_AIRPLANE_TASK = "key_ariplane_task";
    public static final String KEY_TRUE_LOVE = "key_true_love";
    public static final String KEY_GIFT_BROADCAST = "key_gift_broadcast";
    public static final String KEY_PLATFORM_AIRPLANE_TASK = "key_platform_ariplane_task";
    public static final String KEY_PLATFORM_GIFT_BROADCAST = "key_platform_gift_broadcast";
    public static final String KEY_HOT_BALL_BROADCAST = "key_hot_ball_broadcast";
    private static final EntLiveDataRecorder INSTANCE = new EntLiveDataRecorder();
    private boolean mIsStarted;
    private Map<String, List<Object>> mRecords = new HashMap<String, List<Object>>();
    private long mStarteTime;

    public static EntLiveDataRecorder getInstance() {
        return INSTANCE;
    }

    public void startRecord() {
        this.mIsStarted = true;
        this.mStarteTime = SystemClock.uptimeMillis();
    }

    public void stopRecord() {
        this.mIsStarted = false;
    }

    public long getRecordDuration() {
        return SystemClock.uptimeMillis() - this.mStarteTime;
    }

    public void stopAndClearRecord() {
        this.stopRecord();
        this.mRecords.clear();
        this.mStarteTime = 0L;
    }

    public void record(@NonNull String key) {
        this.record(key, new Object());
    }

    public void record(@NonNull String key, @NonNull Object data) {
        if (this.mIsStarted) {
            if (this.mRecords.containsKey(key)) {
                List<Object> list2 = this.mRecords.get(key);
                list2.add(data);
            } else {
                ArrayList<Object> list3 = new ArrayList<Object>();
                list3.add(data);
                this.mRecords.put(key, list3);
            }
            MLog.debug((Object)TAG, (String)("entlivedata record :" + data.toString()), (Object[])new Object[0]);
        } else if (!this.mRecords.isEmpty()) {
            this.mRecords.clear();
        }
    }

    public int getRecorder(@NonNull String key) {
        if (this.mRecords.containsKey(key)) {
            return this.mRecords.get(key).size();
        }
        return 0;
    }
}

