/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.plugin.pluginunionlive.R;

public class RoundCornersImageView
extends RecycleImageView {
    private float topLeftRadius;
    private float topRightRadius;
    private float bottomLeftRadius;
    private float bottomRightRadius;

    public RoundCornersImageView(Context context) {
        super(context);
        this.init();
    }

    public RoundCornersImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public RoundCornersImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.topLeftRadius = this.getResources().getDimensionPixelSize(R.dimen.topLeftRadius);
        this.topRightRadius = this.getResources().getDimensionPixelSize(R.dimen.topRightRadius);
        this.bottomRightRadius = this.getResources().getDimensionPixelSize(R.dimen.bottomRightRadius);
        this.bottomLeftRadius = this.getResources().getDimensionPixelSize(R.dimen.bottomLeftRadius);
    }

    public void setTopLeftRadius(float topLeftRadius) {
        this.topLeftRadius = topLeftRadius;
    }

    public void setTopRightRadius(float topRightRadius) {
        this.topRightRadius = topRightRadius;
    }

    public void setBottomLeftRadius(float bottomLeftRadius) {
        this.bottomLeftRadius = bottomLeftRadius;
    }

    public void setBottomRightRadius(float bottomRightRadius) {
        this.bottomRightRadius = bottomRightRadius;
    }

    protected void onDraw(Canvas canvas) {
        Path path = new Path();
        Rect rect = new Rect(0, 0, this.getWidth(), this.getHeight());
        RectF rectF = new RectF(rect);
        float[] radii = new float[]{this.topLeftRadius, this.topLeftRadius, this.topRightRadius, this.topRightRadius, this.bottomRightRadius, this.bottomRightRadius, this.bottomLeftRadius, this.bottomLeftRadius};
        path.addRoundRect(rectF, radii, Path.Direction.CCW);
        canvas.clipPath(path);
        super.onDraw(canvas);
    }
}

