/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.webview;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.plugin.main.events.IWebViewClient_closeActWindow_EventArgs;
import com.yy.mobile.plugin.main.events.IWebViewClient_openActWindow_EventArgs;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yy.mobile.ui.webview.WebViewPopupComponent;
import com.yy.mobile.ui.webview.WebViewPopupController$$EventBinder;
import com.yy.mobile.ui.ylink.LiveTemplateActivity;
import com.yy.mobile.util.javascript.ResultData;
import com.yy.mobile.util.javascript.apiModule.IApiModule;
import com.yy.mobile.util.json.JsonParser;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.coreapi.IWebViewFragmentInterface;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.media.IMediaCore;
import com.yymobile.event.keyboard.KayBoardStateChangeEventArgs;
import com.yyproto.utils.FP;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class WebViewPopupController
implements EventCompat {
    private static final String TAG = "WebViewPopupController";
    private FragmentManager fm;
    private Context mContext;
    private final List<WebViewStruct> mPopupWindowStack = new LinkedList<WebViewStruct>();
    private OperationReporter mOperationReporter = new OperationReporter(){

        @Override
        public void dismissedSelf(@NonNull WebViewPopupComponent component) {
            for (WebViewStruct struct : WebViewPopupController.this.mPopupWindowStack) {
                if (struct.getPopup() != component) continue;
                WebViewPopupController.this.mPopupWindowStack.remove(struct);
                break;
            }
        }
    };
    private EventBinder mWebViewPopupControllerSniperEventBinder;

    public void onEventBind() {
        if (this.mWebViewPopupControllerSniperEventBinder == null) {
            this.mWebViewPopupControllerSniperEventBinder = new WebViewPopupController$$EventBinder();
        }
        this.mWebViewPopupControllerSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mWebViewPopupControllerSniperEventBinder != null) {
            this.mWebViewPopupControllerSniperEventBinder.unBindEvent();
        }
    }

    public void init(Context context) {
        this.mContext = context;
        this.fm = ((FragmentActivity)context).getSupportFragmentManager();
        ICoreManagerBase.addClient((Object)this);
    }

    public void onDestroy() {
        ICoreManagerBase.removeClient((Object)this);
        this.fm = null;
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public void onOrientationChange(boolean isLanscape) {
    }

    @BusEvent
    public void openActWindow(IWebViewClient_openActWindow_EventArgs busEventArgs) {
        JSONObject jsonObject;
        String json = busEventArgs.getJson();
        try {
            jsonObject = new JSONObject(json);
        }
        catch (Exception e) {
            return;
        }
        String popupWindowKey = jsonObject.optString("actKey");
        boolean isKeyExist = false;
        if (busEventArgs.getCallback() != null) {
            for (WebViewStruct struct : this.mPopupWindowStack) {
                if (!struct.getId().equals(popupWindowKey)) continue;
                isKeyExist = true;
                break;
            }
            ResultData resultData = new ResultData();
            resultData.code = isKeyExist ? 1 : 0;
            busEventArgs.getCallback().invokeCallback("'" + JsonParser.toJson((Object)resultData) + "'");
        }
        WebViewPopupComponent component = WebViewPopupComponent.newInstance(jsonObject);
        component.setComponent(this.mOperationReporter);
        component.show(this.fm, "WebViewPopupComponent");
        this.mPopupWindowStack.add(new WebViewStruct(jsonObject.optString("actKey"), component));
    }

    @BusEvent
    public void closeActWindow(IWebViewClient_closeActWindow_EventArgs busEventArgs) {
        this.closeActWindow(busEventArgs.getCallback(), busEventArgs.getParams());
    }

    public void closeActWindow(IApiModule.IJSCallback callback2, String param) {
        LiveTemplateActivity aty;
        MLog.info((Object)TAG, (String)(" closeActWindow -> " + param), (Object[])new Object[0]);
        String popupWindowKey = "";
        if (!FP.empty((CharSequence)param)) {
            JSONObject jsonObject;
            try {
                jsonObject = new JSONObject(param);
            }
            catch (JSONException e) {
                MLog.error((Object)TAG, (String)("->closeActWindow error" + (Object)((Object)e)), (Object[])new Object[0]);
                return;
            }
            if (jsonObject.has("from")) {
                return;
            }
            popupWindowKey = jsonObject.optString("actKey");
        }
        if (!this.mPopupWindowStack.isEmpty()) {
            if (TextUtils.isEmpty((CharSequence)popupWindowKey)) {
                this.mPopupWindowStack.remove(this.mPopupWindowStack.size() - 1).getPopup().dismissAllowingStateLoss();
            } else {
                boolean isPopupWindowExist = false;
                for (WebViewStruct struct : this.mPopupWindowStack) {
                    if (!struct.getId().equals(popupWindowKey)) continue;
                    this.mPopupWindowStack.remove(struct);
                    struct.getPopup().dismissAllowingStateLoss();
                    isPopupWindowExist = true;
                    break;
                }
                if (callback2 != null) {
                    ResultData resultData = new ResultData();
                    resultData.code = isPopupWindowExist ? 0 : 1;
                    callback2.invokeCallback("'" + JsonParser.toJson((Object)resultData) + "'");
                }
            }
        }
        if (this.mContext != null && this.mContext instanceof LiveTemplateActivity && (aty = (LiveTemplateActivity)this.mContext).isResume() && ICoreManagerBase.getCore(IMediaCore.class) != null) {
            ((IMediaCore)ICoreManagerBase.getCore(IMediaCore.class)).switchVoice(true);
        }
    }

    @BusEvent
    public void onChatInputSwitch(KayBoardStateChangeEventArgs busEventArgs) {
        BaseLinkFragment mWVFragment;
        boolean chatInputSwitch = busEventArgs.getOpenSwitch();
        if (!this.mPopupWindowStack.isEmpty() && (mWVFragment = this.mPopupWindowStack.get(this.mPopupWindowStack.size() - 1).getPopup().getRootFragment()) != null && mWVFragment instanceof IWebViewFragmentInterface) {
            ((IWebViewFragmentInterface)mWVFragment).loadJavaScript("javascript:dealKeyboardEvent(" + chatInputSwitch + ")");
        }
    }

    public static interface OperationReporter {
        public void dismissedSelf(@NonNull WebViewPopupComponent var1);
    }

    private static class WebViewStruct {
        @NonNull
        private String id;
        @NonNull
        private WebViewPopupComponent popup;

        WebViewStruct(@Nullable String id2, @NonNull WebViewPopupComponent popup) {
            this.id = id2 == null ? "" : id2;
            this.popup = popup;
        }

        @NonNull
        public String getId() {
            return this.id;
        }

        @NonNull
        public WebViewPopupComponent getPopup() {
            return this.popup;
        }
    }
}

