/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gift.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import com.yy.mobile.ui.utils.DensityUtil;

public class CircleProgressBar
extends View {
    RectF oval = new RectF();
    Paint paint = new Paint();
    int mProgressColor = Color.rgb((int)255, (int)86, (int)0);
    int mColor = 0x2A000000;
    int circleWidth;
    private int maxProgress = 100;
    private int progress = 0;

    public CircleProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.circleWidth = DensityUtil.dip2px((Context)context, (float)2.0f);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int width = this.getWidth();
        int height = this.getHeight();
        if (width != height) {
            int min;
            width = min = Math.min(width, height);
            height = min;
        }
        this.paint.setAntiAlias(true);
        this.paint.setColor(this.mColor);
        canvas.drawColor(0);
        int progressStrokeWidth = this.circleWidth;
        this.paint.setStrokeWidth((float)progressStrokeWidth);
        this.paint.setStyle(Paint.Style.STROKE);
        this.oval.left = progressStrokeWidth / 2;
        this.oval.top = progressStrokeWidth / 2;
        this.oval.right = width - progressStrokeWidth / 2;
        this.oval.bottom = height - progressStrokeWidth / 2;
        canvas.drawArc(this.oval, 0.0f, 360.0f, false, this.paint);
        this.paint.setColor(this.mProgressColor);
        canvas.drawArc(this.oval, -90.0f, -((float)this.progress / (float)this.maxProgress) * 360.0f, false, this.paint);
        this.paint.setStyle(Paint.Style.FILL);
    }

    public void setCircleWidth(int circleWidth) {
        this.circleWidth = circleWidth;
        this.invalidate();
    }

    public void setProgressColor(int color2) {
        this.mProgressColor = color2;
        this.invalidate();
    }

    public void setBgColor(int color2) {
        this.mColor = color2;
        this.invalidate();
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public void setMaxProgress(int maxProgress) {
        this.maxProgress = maxProgress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
        this.invalidate();
    }

    public void setProgressNotInUiThread(int progress) {
        this.progress = progress;
        this.postInvalidate();
    }
}

