/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gift;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.unionyy.mobile.spdt.Spdt;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.RxBus;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.liveapi.multifightpk.IMultiFightPKCore;
import com.yy.mobile.liveapi.multifightpk.MultiFightPK_OnShowContRankNotify_EventArgs;
import com.yy.mobile.plugin.main.events.IAttentionFriendClient_onQueryBookAnchorBatchResult_EventArgs;
import com.yy.mobile.plugin.main.events.IProfileClient_onRequestProfile_EventArgs;
import com.yy.mobile.plugin.main.events.ISubscribeClient_onSubscribeResult_EventArgs;
import com.yy.mobile.plugin.main.events.ISubscribeClient_onUnSubscribeResult_EventArgs;
import com.yy.mobile.plugin.main.events.IUserClient_onRequestDetailUserInfo_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.gift.MultiFightPKGiftTopController$$EventBinder;
import com.yy.mobile.ui.subscribebroadcast.ISubscribeBroadcastCore;
import com.yy.mobile.ui.utils.AbstractViewController;
import com.yy.mobile.ui.utils.dialog.BaseDialog;
import com.yy.mobile.ui.utils.dialog.DialogLinkManager;
import com.yy.mobile.ui.utils.dialog.OkCancelDialog;
import com.yy.mobile.ui.utils.dialog.OkCancelDialogListener;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.BaseFragmentApi;
import com.yy.mobile.ylink.bridge.coreapi.ProgramInfoApi;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import com.yymobile.core.profile.EntUserInfo;
import com.yymobile.core.profile.IProfileCore;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import com.yymobile.core.subscribe.ISubscribeCore;
import com.yymobile.core.user.IUserCore;
import com.yymobile.core.user.UserInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;

public class MultiFightPKGiftTopController
extends AbstractViewController {
    private static final String TAG = "MultiFightPKGiftTopController";
    private long mSendToUid;
    private TextView mSendTipsTxv;
    private TextView mFollowTxv;
    private View mInfoBtn;
    private View mContRankBtn;
    private boolean mIsFollowed;
    private boolean isFollowClicked;
    private boolean mIsMe;
    private boolean mIsCreated;
    private UserInfo mUserInfo;
    private EntUserInfo mEntUserInfo;
    private DialogLinkManager mDialogLinkManager;
    private EventBinder mMultiFightPKGiftTopControllerSniperEventBinder;

    protected View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.layout_multi_fightpk_gift_top, container, false);
    }

    protected void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mIsCreated = true;
        this.mDialogLinkManager = new DialogLinkManager((Context)this.getActivity());
        this.mSendTipsTxv = (TextView)view.findViewById(R.id.send_tips);
        this.mFollowTxv = (TextView)view.findViewById(R.id.follow_btn);
        this.mInfoBtn = view.findViewById(R.id.info_btn);
        this.mContRankBtn = view.findViewById(R.id.cont_rank_btn);
        this.mContRankBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RxBus.getDefault().post((Object)new MultiFightPK_OnShowContRankNotify_EventArgs(1, MultiFightPKGiftTopController.this.mSendToUid));
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51331", "0007");
            }
        });
        this.initInfoBtn();
        this.initFollowTxv();
        this.requestData();
        this.updateView();
    }

    private void initInfoBtn() {
        this.mInfoBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MultiFightPKGiftTopController.this.mSendToUid > 0L) {
                    if (!((IMobileLiveCore)ICoreManagerBase.getCore(IMobileLiveCore.class)).isLoginUserMobileLive()) {
                        MultiFightPKGiftTopController.this.toProfile(false);
                    } else {
                        MultiFightPKGiftTopController.this.toProfile(true);
                    }
                }
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51331", "0006");
            }
        });
    }

    public void toProfile(boolean showInMobileLive) {
        if (CoreApiManager.getInstance() != null && CoreApiManager.getInstance().getApi(ProgramInfoApi.class) != null) {
            ((ProgramInfoApi)CoreApiManager.getInstance().getApi(ProgramInfoApi.class)).showProfileActivity((Context)this.getActivity(), this.mSendToUid, this.mEntUserInfo == null || this.mEntUserInfo.userType == 0 ? 0 : this.mEntUserInfo.userType, showInMobileLive);
        }
    }

    private void initFollowTxv() {
        this.mFollowTxv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!MultiFightPKGiftTopController.this.checkNetToast()) {
                    return;
                }
                if (MultiFightPKGiftTopController.this.isLogined()) {
                    if (MultiFightPKGiftTopController.this.mIsFollowed) {
                        int labelColor = Spdt.color((int)R.color.confirm_btn_color);
                        MultiFightPKGiftTopController.this.mDialogLinkManager.showDialog((BaseDialog)new OkCancelDialog((CharSequence)"\u786e\u5b9a\u4e0d\u518d\u5173\u6ce8\u5417\uff1f", (CharSequence)"\u4e0d\u518d\u5173\u6ce8", labelColor, (CharSequence)"\u53d6\u6d88", 0, true, true, new OkCancelDialogListener(){

                            public void onCancel() {
                            }

                            public void onOk() {
                                MultiFightPKGiftTopController.this.mIsMe = true;
                                ((ISubscribeCore)CoreFactory.getCore(ISubscribeCore.class)).unSubscribe(MultiFightPKGiftTopController.this.mSendToUid);
                            }
                        }));
                    } else {
                        MultiFightPKGiftTopController.this.isFollowClicked = true;
                        MultiFightPKGiftTopController.this.mIsMe = true;
                        ((ISubscribeCore)ICoreManagerBase.getCore(ISubscribeCore.class)).subscribe(MultiFightPKGiftTopController.this.mSendToUid);
                    }
                } else if (CoreApiManager.getInstance() != null && CoreApiManager.getInstance().getApi(BaseFragmentApi.class) != null) {
                    ((BaseFragmentApi)CoreApiManager.getInstance().getApi(BaseFragmentApi.class)).showLoginDialog(MultiFightPKGiftTopController.this.getActivity());
                }
                Property pro = new Property();
                pro.putString("key1", String.valueOf(MultiFightPKGiftTopController.this.isLianMaiUser(LoginUtil.getUid()) ? 2 : 3));
                ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51331", "0005", (Serializable)pro);
            }
        });
    }

    @Deprecated
    private boolean isLianMaiUser(long uid) {
        return false;
    }

    @BusEvent
    public void onSubscribeResult(ISubscribeClient_onSubscribeResult_EventArgs busEventArgs) {
        long anchorUid = busEventArgs.getAnchorUid();
        boolean success = busEventArgs.getSuccess();
        String errorMsg = busEventArgs.getErrorMsg();
        MLog.info((Object)TAG, (String)("onSubscribeResult anchorUid=" + anchorUid + ",success=" + success), (Object[])new Object[0]);
        if (!this.isFollowClicked) {
            return;
        }
        ((ISubscribeCore)ICoreManagerBase.getCore(ISubscribeCore.class)).updateSubscribeResultHashMap(anchorUid, true);
        this.isFollowClicked = false;
        if (anchorUid == this.mSendToUid && this.mSendToUid != 0L) {
            if (success) {
                this.mIsFollowed = true;
                this.updateFollowState();
                ((ISubscribeBroadcastCore)ICoreManagerBase.getCore(ISubscribeBroadcastCore.class)).subscribeSuccessFeedBack(String.valueOf(anchorUid));
                if (this.mIsMe) {
                    this.toast(R.string.str_subscribe_succed);
                }
            } else {
                this.updateFollowState();
                if (this.mIsMe) {
                    if (!StringUtils.isEmpty((String)errorMsg).booleanValue()) {
                        this.toast(errorMsg);
                    } else {
                        this.toast(R.string.str_subscribe_failed);
                    }
                }
            }
            this.mIsMe = false;
        }
    }

    @BusEvent
    public void onUnSubscribeResult(ISubscribeClient_onUnSubscribeResult_EventArgs busEventArgs) {
        long anchorUid = busEventArgs.getAnchorUid();
        boolean success = busEventArgs.getSuccess();
        ((ISubscribeCore)ICoreManagerBase.getCore(ISubscribeCore.class)).updateSubscribeResultHashMap(anchorUid, false);
        if (anchorUid == this.mSendToUid) {
            if (success) {
                if (this.mIsMe) {
                    this.toast(R.string.str_unsubscribe_succ);
                }
                if (this.mEntUserInfo != null && LoginUtil.isLogined()) {
                    this.requestFollowInfo(this.mEntUserInfo.userType == 1);
                }
            } else if (this.mIsMe) {
                this.toast(R.string.str_unsubscribe_fail);
            }
            this.mIsMe = false;
        }
    }

    protected void requestFollowInfo(boolean isAnchor) {
        MLog.info((Object)TAG, (String)("requestFollowInfo isAnchor:" + isAnchor + ", mUid:" + this.mSendToUid), (Object[])new Object[0]);
        if (LoginUtil.isLogined()) {
            if (isAnchor) {
                ((ISubscribeCore)ICoreManagerBase.getCore(ISubscribeCore.class)).querySubscribe(this.mSendToUid);
            } else {
                ArrayList<Long> uids = new ArrayList<Long>();
                uids.add(this.mSendToUid);
                ((ISubscribeCore)ICoreManagerBase.getCore(ISubscribeCore.class)).queryBookAnchorBatchReq(LoginUtil.getUid(), uids);
            }
        }
    }

    @BusEvent(sync=true)
    public void onQueryBookAnchorBatchResult(IAttentionFriendClient_onQueryBookAnchorBatchResult_EventArgs busEventArgs) {
        long uid = busEventArgs.getAnchorUid();
        Map friendList = busEventArgs.getFriendList();
        MLog.info((Object)TAG, (String)("onQueryBookAnchorBatchResult uid:" + uid + ",friendList=" + friendList), (Object[])new Object[0]);
        if (uid != 0L && uid == LoginUtil.getUid() && friendList != null) {
            for (Map.Entry entry : friendList.entrySet()) {
                if ((Long)entry.getKey() != this.mSendToUid) continue;
                this.mIsFollowed = (Boolean)entry.getValue();
                this.updateFollowState();
                return;
            }
        }
    }

    @BusEvent(sync=true)
    public void onRequestProfile(IProfileClient_onRequestProfile_EventArgs busEventArgs) {
        EntUserInfo info = busEventArgs.getInfo();
        this.onRequestProfile(info);
    }

    private void onRequestProfile(EntUserInfo info) {
        MLog.info((Object)TAG, (String)("onRequestProfile info=" + info), (Object[])new Object[0]);
        if (info != null && info.uid == this.mSendToUid && this.mSendToUid != 0L) {
            this.mEntUserInfo = info;
            this.requestFollowInfo(info.userType == 1);
        }
    }

    @BusEvent(sync=true)
    public void onRequestDetailUserInfo(IUserClient_onRequestDetailUserInfo_EventArgs busEventArgs) {
        long userId = busEventArgs.getUserId();
        UserInfo info = busEventArgs.getInfo();
        if (this.mSendToUid != userId || info == null) {
            return;
        }
        this.mUserInfo = info;
        this.updateSendTxtTips();
    }

    private void updateFollowState() {
        if (this.mSendToUid != 0L && this.mSendToUid == LoginUtil.getUid() || !LoginUtil.isLogined()) {
            this.mFollowTxv.setVisibility(4);
            return;
        }
        if (this.mIsFollowed) {
            this.mFollowTxv.setVisibility(0);
            this.mFollowTxv.setSelected(true);
            this.mFollowTxv.setText((CharSequence)"\u5df2\u5173\u6ce8");
        } else {
            this.mFollowTxv.setVisibility(0);
            this.mFollowTxv.setSelected(false);
            this.mFollowTxv.setText((CharSequence)"\u5173\u6ce8");
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mSendToUid = 0L;
        this.mIsCreated = false;
    }

    public void setSendToUid(long sendToUid) {
        this.mEntUserInfo = null;
        this.mUserInfo = null;
        this.mSendToUid = sendToUid;
        if (this.mIsCreated) {
            this.requestData();
            this.updateView();
        }
    }

    private void updateSendTxtTips() {
        if (null != this.mUserInfo) {
            String teamName = ((IMultiFightPKCore)ICoreManagerBase.getCore(IMultiFightPKCore.class)).findTeamNameByUid(this.mUserInfo.userId);
            this.mSendTipsTxv.setText((CharSequence)String.format("\u9001\u7ed9%s: %s", teamName, this.mUserInfo.nickName));
        } else {
            this.mSendTipsTxv.setText((CharSequence)"");
        }
    }

    private void requestData() {
        if (this.mSendToUid > 0L) {
            this.mUserInfo = ((IUserCore)ICoreManagerBase.getCore(IUserCore.class)).getCacheUserInfoByUid(this.mSendToUid);
            this.mEntUserInfo = ((IProfileCore)ICoreManagerBase.getCore(IProfileCore.class)).getCachedProfileInfo(this.mSendToUid);
            if (null == this.mUserInfo) {
                ((IUserCore)ICoreManagerBase.getCore(IUserCore.class)).requestDetailUserInfo(this.mSendToUid, true);
            }
            if (null == this.mEntUserInfo) {
                ((IProfileCore)ICoreManagerBase.getCore(IProfileCore.class)).requestProfile(this.mSendToUid);
            } else {
                this.requestFollowInfo(this.mEntUserInfo.userType == 1);
            }
        }
    }

    private void updateView() {
        this.updateFollowState();
        this.updateSendTxtTips();
    }

    private void toast(@StringRes int resId) {
        if (null != this.getActivity()) {
            Toast.makeText((Context)this.getActivity(), (int)resId, (int)1).show();
        }
    }

    private void toast(@NonNull String str) {
        if (null != this.getActivity()) {
            Toast.makeText((Context)this.getActivity(), (CharSequence)str, (int)1).show();
        }
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mMultiFightPKGiftTopControllerSniperEventBinder == null) {
            this.mMultiFightPKGiftTopControllerSniperEventBinder = new MultiFightPKGiftTopController$$EventBinder();
        }
        this.mMultiFightPKGiftTopControllerSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mMultiFightPKGiftTopControllerSniperEventBinder != null) {
            this.mMultiFightPKGiftTopControllerSniperEventBinder.unBindEvent();
        }
    }
}

