/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.module.webdialog;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.webkit.WebView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.live.module.webdialog.CommonWebDialogController$$EventBinder;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_leaveCurrentChannel_EventArgs;
import com.yy.mobile.plugin.main.events.IChatEmotionClient_onChatEmotionComponentDismiss_EventArgs;
import com.yy.mobile.plugin.main.events.IChatEmotionClient_onShowChatInputBroadcast_EventArgs;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yy.mobile.ui.utils.AbstractViewController;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.javascript.ResultData;
import com.yy.mobile.util.javascript.apiModule.IApiModule;
import com.yy.mobile.util.json.JsonParser;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.IWebViewEventExtListener;
import com.yy.mobile.ylink.bridge.coreapi.IWebViewEventListener;
import com.yy.mobile.ylink.bridge.coreapi.IWebViewFragmentInterface;
import com.yy.mobile.ylink.bridge.coreapi.WebViewFragmentApi;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.webdialog.CloseWebDialogEventArgs;
import com.yymobile.core.webdialog.CreateWebDialogEventArgs;
import com.yymobile.core.webdialog.ICommonWebDialogCore;
import com.yymobile.core.webdialog.UpdateWebDialogEventArgs;
import com.yymobile.core.webdialog.WebDialogDataInfo;
import org.json.JSONObject;

public class CommonWebDialogController
extends AbstractViewController {
    private FragmentManager mChildFragmentManager;
    private int mContainerId;
    private LinearLayout mWebContainer;
    public static String TAG = "CommonWebDialogController";
    private int mUiLevel;
    private RelativeLayout rootContentView;
    private BaseLinkFragment mWVFragment = null;
    private WebDialogDataInfo mSelfWebInfo = null;
    private WebStyleInfo mWebStyleInfo;
    private View mWebViewFragmentViewCreatedView;
    int detaY = ScreenUtil.getInstance().dip2px(-100);
    private EventBinder mCommonWebDialogControllerSniperEventBinder;

    public CommonWebDialogController(FragmentManager childFragmentManager, int containterId, int uiLevel, WebDialogDataInfo info) {
        this.mChildFragmentManager = childFragmentManager;
        this.mContainerId = containterId;
        this.mSelfWebInfo = info;
        this.mUiLevel = uiLevel;
        MLog.info((Object)TAG, (String)("CommonWebDialogController  " + (Object)((Object)this) + ", mu=" + this.mUiLevel), (Object[])new Object[0]);
    }

    private BaseLinkFragment getOrCreatWebViewFragment(String url, IWebViewEventExtListener iWebViewEventListener) {
        BaseLinkFragment wvFragment = ((WebViewFragmentApi)CoreApiManager.getInstance().getApi(WebViewFragmentApi.class)).createWebViewFragment(url, false, true);
        if (wvFragment instanceof IWebViewFragmentInterface) {
            ((IWebViewFragmentInterface)wvFragment).setEnablePullRefresh(false);
            ((IWebViewFragmentInterface)wvFragment).setWebViewEventLister((IWebViewEventListener)iWebViewEventListener);
        }
        return wvFragment;
    }

    private void setWebViewStyle(JSONObject jsonObject) {
        if (this.mWebStyleInfo == null) {
            this.mWebStyleInfo = new WebStyleInfo(jsonObject);
        } else {
            this.mWebStyleInfo.setWebStyleInfo(jsonObject);
        }
        this.rootContentView.setBackgroundColor(Color.parseColor((String)this.mWebStyleInfo.backgroupcolor));
        if (this.mWebStyleInfo.clickState == 1) {
            this.rootContentView.setClickable(true);
            this.rootContentView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    CommonWebDialogController.this.dismissSelfWebView();
                }
            });
        } else if (this.mWebStyleInfo.clickState == 0) {
            this.rootContentView.setOnClickListener(null);
            this.rootContentView.setClickable(false);
        } else if (this.mWebStyleInfo.clickState == 2) {
            this.rootContentView.setClickable(true);
            this.rootContentView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                }
            });
        }
        this.updateWebContentStyle();
        if (this.mWebViewFragmentViewCreatedView != null) {
            this.mWebViewFragmentViewCreatedView.setVisibility(0);
        }
    }

    private void updateWebContentStyle() {
        if (!this.checkIsOpenWebDialog()) {
            return;
        }
        if (this.mWebContainer != null && this.mWebStyleInfo != null) {
            RelativeLayout.LayoutParams layoutParams;
            if (this.isLandScape()) {
                layoutParams = new RelativeLayout.LayoutParams(this.mWebStyleInfo.hwidth, this.mWebStyleInfo.hheight);
                layoutParams.setMargins(this.mWebStyleInfo.hx, this.mWebStyleInfo.hy, 0, 0);
            } else {
                layoutParams = new RelativeLayout.LayoutParams(this.mWebStyleInfo.width, this.mWebStyleInfo.height);
                layoutParams.setMargins(this.mWebStyleInfo.x, this.mWebStyleInfo.y, 0, 0);
            }
            this.mWebContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mWebContainer.invalidate();
        }
    }

    private void dismissSelfWebView() {
        ((ICommonWebDialogCore)ICoreManagerBase.getCore(ICommonWebDialogCore.class)).removeCommonWebDialog(this.mSelfWebInfo);
        this.closeCommonWebDialog(this.mSelfWebInfo);
    }

    private IWebViewEventExtListener createWebEventListener() {
        return new IWebViewEventExtListener(){

            public String invokeFromWebPage(String moduleName, String methodName, String param, final IApiModule.IJSCallback ijsCallback, Context context) {
                MLog.info((Object)TAG, (String)(moduleName + "," + methodName + "," + param), (Object[])new Object[0]);
                if (moduleName.equals("ui")) {
                    try {
                        final JSONObject jsonObject = new JSONObject(param);
                        if (methodName.equals("showCommonWebDialogStyle")) {
                            final ResultData resultData = new ResultData();
                            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    CommonWebDialogController.this.setWebViewStyle(jsonObject);
                                    if (ijsCallback != null) {
                                        ijsCallback.invokeCallback("'" + JsonParser.toJson((Object)resultData) + "'");
                                    }
                                }
                            });
                            return JsonParser.toJson((Object)resultData);
                        }
                        if (methodName.equals("dismissCommonWebDialog")) {
                            final ResultData resultData = new ResultData();
                            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    CommonWebDialogController.this.dismissSelfWebView();
                                    if (ijsCallback != null) {
                                        ijsCallback.invokeCallback("'" + JsonParser.toJson((Object)resultData) + "'");
                                    }
                                }
                            });
                            return JsonParser.toJson((Object)resultData);
                        }
                    }
                    catch (Throwable e) {
                        MLog.error((Object)TAG, (String)("invokeFromWebPage " + e + ",m=" + methodName), (Object[])new Object[0]);
                    }
                }
                return "";
            }

            public void shouldOverrideUrlLoading(WebView view, String url) {
            }

            public void onPageFinished(WebView view, String url) {
                MLog.info((Object)TAG, (String)("onPageFinished " + url), (Object[])new Object[0]);
                if (CommonWebDialogController.this.mSelfWebInfo != null && ((CommonWebDialogController)CommonWebDialogController.this).mSelfWebInfo.data != null) {
                    CommonWebDialogController.this.updateCommonWebDialog(CommonWebDialogController.this.mSelfWebInfo);
                    ((CommonWebDialogController)CommonWebDialogController.this).mSelfWebInfo.data = null;
                }
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                MLog.error((Object)TAG, (String)("onReceivedError " + errorCode + ",d=" + description + ",fu=" + failingUrl), (Object[])new Object[0]);
            }

            public void onPageStarted(WebView view, String url, Bitmap favIcon) {
            }

            public void onViewCreated(View view) {
                CommonWebDialogController.this.mWebViewFragmentViewCreatedView = view;
            }

            public void onActWebData(String param) {
            }

            public void handleBackAction() {
            }

            public void onReceivedTitle(WebView view, String title) {
            }

            public Animation createAnim(int transit, boolean enter, int nextAnim) {
                return null;
            }

            public void changeHeight(int height) {
            }
        };
    }

    public void createOrUpdateCommonWebDialog(WebDialogDataInfo info) {
        if (!this.createCommonWebDialog(info)) {
            this.updateCommonWebDialog(info);
        }
    }

    public void updateCommonWebDialog(WebDialogDataInfo info) {
        if (this.mWVFragment != null && info != null && this.mWVFragment instanceof IWebViewFragmentInterface) {
            String jsonArgs = info.data;
            if (FP.empty((CharSequence)jsonArgs)) {
                jsonArgs = "";
            }
            if (!info.url.equals(this.mSelfWebInfo.url)) {
                MLog.info((Object)TAG, (String)("updateCommonWebDialog " + (Object)((Object)this) + ",old=" + this.mSelfWebInfo.url + ",new=" + info.url), (Object[])new Object[0]);
                ((IWebViewFragmentInterface)this.mWVFragment).setUrl(info.url, true);
                this.mSelfWebInfo.url = info.url;
                this.mSelfWebInfo.data = jsonArgs;
            } else {
                ((IWebViewFragmentInterface)this.mWVFragment).loadJavaScript("javascript:refreshJsWithData('" + jsonArgs.trim() + "')");
            }
        }
    }

    public boolean createCommonWebDialog(WebDialogDataInfo info) {
        if (this.mSelfWebInfo == null && this.mWVFragment == null) {
            this.mSelfWebInfo = new WebDialogDataInfo(info.tagName, info.url, info.priority, info.uiLevel, info.state, info.data);
            if (this.rootContentView.findViewById(this.mContainerId) == null) {
                this.mWebContainer = new LinearLayout((Context)this.getActivity());
                this.mWebContainer.setId(this.mContainerId);
                this.rootContentView.addView((View)this.mWebContainer);
            }
            this.mWVFragment = this.getOrCreatWebViewFragment(info.url, this.createWebEventListener());
            if (this.mChildFragmentManager != null) {
                this.mChildFragmentManager.beginTransaction().replace(this.mContainerId, (Fragment)this.mWVFragment, info.tagName).commitAllowingStateLoss();
            }
            return true;
        }
        return false;
    }

    public void closeCommonWebDialog(WebDialogDataInfo info) {
        if (info != null && !FP.empty((CharSequence)info.tagName) && this.mSelfWebInfo != null && info.tagName.equals(this.mSelfWebInfo.tagName)) {
            this.mWebStyleInfo = null;
            this.rootContentView.setBackgroundResource(17170445);
            this.rootContentView.setOnClickListener(null);
            this.rootContentView.setClickable(false);
            if (this.mWVFragment != null && this.mChildFragmentManager != null && this.mWVFragment.isAdded()) {
                this.mWebViewFragmentViewCreatedView = null;
                this.mChildFragmentManager.beginTransaction().remove((Fragment)this.mWVFragment).commitAllowingStateLoss();
                this.mWVFragment = null;
            }
            this.mSelfWebInfo = null;
        }
    }

    public void onOrientationChanges(boolean isLandscape) {
        this.updateWebContentStyle();
    }

    public void destroyAll() {
        this.destroy();
        if (this.mWVFragment != null && this.mChildFragmentManager != null) {
            this.mChildFragmentManager.beginTransaction().remove((Fragment)this.mWVFragment).commitAllowingStateLoss();
        }
        this.mSelfWebInfo = null;
        this.mWVFragment = null;
    }

    protected View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.rootContentView = new RelativeLayout((Context)this.getActivity());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        this.rootContentView.setLayoutParams((ViewGroup.LayoutParams)params);
        return this.rootContentView;
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void createCommonWebDialog(CreateWebDialogEventArgs eventArgs) {
        if (eventArgs == null || eventArgs.webDialogDataInfo == null || eventArgs.webDialogDataInfo.uiLevel != this.mUiLevel) {
            return;
        }
        MLog.info((Object)TAG, (String)("createCommonWebDialog " + (Object)((Object)this) + ", t=" + eventArgs.webDialogDataInfo.tagName + ",u=" + eventArgs.webDialogDataInfo.url + ",s=" + this.mSelfWebInfo + ",mv" + this.mWVFragment), (Object[])new Object[0]);
        this.createOrUpdateCommonWebDialog(eventArgs.webDialogDataInfo);
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void updateCommonWebDialog(UpdateWebDialogEventArgs eventArgs) {
        if (eventArgs == null || eventArgs.webDialogDataInfo == null || !this.checkIsMyEventArgs(eventArgs.webDialogDataInfo)) {
            return;
        }
        this.updateCommonWebDialog(eventArgs.webDialogDataInfo);
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void closeCommonWebDialog(CloseWebDialogEventArgs eventArgs) {
        if (eventArgs == null || eventArgs.webDialogDataInfo == null || !this.checkIsMyEventArgs(eventArgs.webDialogDataInfo)) {
            return;
        }
        MLog.info((Object)TAG, (String)("createCommonWebDialog " + (Object)((Object)this) + ", t=" + eventArgs.webDialogDataInfo.tagName + ",u=" + eventArgs.webDialogDataInfo.url + ",mv=" + this.mWVFragment + ",sf=" + this.mSelfWebInfo), (Object[])new Object[0]);
        this.closeCommonWebDialog(eventArgs.webDialogDataInfo);
    }

    public boolean checkIsMyEventArgs(WebDialogDataInfo info) {
        return info.uiLevel == this.mUiLevel && this.mSelfWebInfo != null && info.tagName.equals(this.mSelfWebInfo.tagName);
    }

    public boolean checkIsOpenWebDialog() {
        return this.mSelfWebInfo != null && this.mWVFragment != null;
    }

    @BusEvent(sync=true)
    public void leaveCurrentChannel(IChannelLinkClient_leaveCurrentChannel_EventArgs busEventArgs) {
        if (this.checkIsOpenWebDialog()) {
            this.closeCommonWebDialog(this.mSelfWebInfo);
        }
    }

    @BusEvent
    public void onShowChatInputBroadcast(IChatEmotionClient_onShowChatInputBroadcast_EventArgs eventArgs) {
        boolean showChatInput = eventArgs.getShowChatInput();
        if (!this.isLandScape() && this.mWebContainer != null && this.checkIsOpenWebDialog() && showChatInput && this.mWebContainer.getTranslationY() == 0.0f) {
            this.mWebContainer.animate().translationY((float)this.detaY);
        }
    }

    @BusEvent
    public void onChatEmotionComponentDismiss(IChatEmotionClient_onChatEmotionComponentDismiss_EventArgs eventArgs) {
        if (!this.isLandScape() && this.mWebContainer != null && this.checkIsOpenWebDialog()) {
            this.mWebContainer.animate().translationY(0.0f);
        }
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mCommonWebDialogControllerSniperEventBinder == null) {
            this.mCommonWebDialogControllerSniperEventBinder = new CommonWebDialogController$$EventBinder();
        }
        this.mCommonWebDialogControllerSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mCommonWebDialogControllerSniperEventBinder != null) {
            this.mCommonWebDialogControllerSniperEventBinder.unBindEvent();
        }
    }

    private static class WebStyleInfo {
        public int x;
        public int y;
        public int width;
        public int height;
        public int hx;
        public int hy;
        public int hwidth;
        public int hheight;
        public int clickState;
        public String backgroupcolor;

        WebStyleInfo(JSONObject jsonObject) {
            this.x = jsonObject.optInt("x");
            this.y = jsonObject.optInt("y");
            this.width = jsonObject.optInt("width");
            this.height = jsonObject.optInt("height");
            this.hx = jsonObject.optInt("hx");
            this.hy = jsonObject.optInt("hy");
            this.hwidth = jsonObject.optInt("hwidth");
            this.hheight = jsonObject.optInt("hheight");
            this.clickState = jsonObject.optInt("bgclickstate");
            this.backgroupcolor = jsonObject.optString("bgcolor");
        }

        public void setWebStyleInfo(JSONObject jsonObject) {
            this.x = jsonObject.optInt("x");
            this.y = jsonObject.optInt("y");
            this.width = jsonObject.optInt("width");
            this.height = jsonObject.optInt("height");
            this.hx = jsonObject.optInt("hx");
            this.hy = jsonObject.optInt("hy");
            this.hwidth = jsonObject.optInt("hwidth");
            this.hheight = jsonObject.optInt("hheight");
            this.clickState = jsonObject.optInt("bgclickstate");
            this.backgroupcolor = jsonObject.optString("bgcolor");
        }
    }
}

