/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils.rest;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.ui.utils.rest.base.INavParam;
import com.yy.mobile.ui.utils.rest.base.IRestApiEx;
import com.yy.mobile.ui.utils.rest.base.IRestApiList;
import com.yy.mobile.ui.utils.rest.base.NavRestApi;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.NavigationUtilApi;
import com.yy.mobile.ylink.bridge.coreapi.PersonInfoHandlerApi;
import com.yymobile.core.live.LiveCore.JoinChannelIntent;
import com.yymobile.core.profile.EntUserInfo;
import java.util.ArrayList;
import java.util.List;

public class MobileLiveApiList
implements IRestApiList {
    private static final String TAG = "MobileLiveApiList";
    private static final String AUTHORITY = "MobileLive";

    public List<IRestApiEx> getList() {
        ArrayList<IRestApiEx> list2 = new ArrayList<IRestApiEx>();
        list2.add(this.gotoMobileLive());
        list2.add(this.gotoMobileLivePreViewPage());
        list2.add(this.gotoMobileLiveDescant());
        list2.add(this.gotoPureReplay());
        return list2;
    }

    public IRestApiEx gotoMobileLive() {
        return new NavRestApi(){

            public String getAuthority() {
                return MobileLiveApiList.AUTHORITY;
            }

            public String getPath() {
                return "Uid/*";
            }

            public void run() {
                final INavParam param = (INavParam)this.getParam();
                final Uri uri = param.uri;
                List segments = uri.getPathSegments();
                final long uid = StringUtils.safeParseLong((String)((String)segments.get(1)));
                param.context.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String tpl = uri.getQueryParameter("tpl");
                            long sid = StringUtils.safeParseLong((String)uri.getQueryParameter("sid"));
                            long ssid = StringUtils.safeParseLong((String)uri.getQueryParameter("ssid"));
                            String token = uri.getQueryParameter("token");
                            if (sid <= 0L && uid > 0L) {
                                ((PersonInfoHandlerApi)CoreApiManager.getInstance().getApi(PersonInfoHandlerApi.class)).requestEntUserInfo(uid, new PersonInfoHandlerApi.EntInfoListener(){

                                    public void onRetrieve(EntUserInfo info) {
                                        if (info != null) {
                                            long topSid = 0L;
                                            long subSid = 0L;
                                            if (uid != info.uid) {
                                                return;
                                            }
                                            if (info.isLiving == 1 && info.topId > 0L) {
                                                topSid = info.topId;
                                                subSid = info.subId;
                                            } else if (info.roomIdLong > 0L) {
                                                topSid = info.roomIdLong;
                                                subSid = info.roomIdLong;
                                            } else if (StringUtils.safeParseLong((String)info.signChLong) > 0L) {
                                                topSid = StringUtils.safeParseLong((String)info.signChLong);
                                                subSid = StringUtils.safeParseLong((String)info.signChLong);
                                            }
                                            if (topSid <= 0L) {
                                                if (BasicConfig.getInstance().isDebuggable()) {
                                                    throw new IllegalArgumentException("\u8fdb\u5165\u76f4\u64ad\u95f4\u7f3a\u5c11\u4e86sid");
                                                }
                                                MLog.error((Object)MobileLiveApiList.TAG, (String)"\u8fdb\u5165\u76f4\u64ad\u95f4\u7f3a\u5c11\u4e86sid", (Object[])new Object[0]);
                                            } else {
                                                JoinChannelIntent.instance((long)topSid, (long)subSid).anchorUid(uid).src("90001").build().joinChannel((Context)param.context);
                                            }
                                        }
                                    }
                                });
                            } else {
                                JoinChannelIntent.instance((long)sid, (long)ssid).anchorUid(uid).src("90001").templateId(tpl).token(token).build().joinChannel((Context)param.context);
                            }
                        }
                        catch (Throwable e) {
                            MLog.error((Object)MobileLiveApiList.TAG, (String)"gotoMobileLive error !", (Throwable)e, (Object[])new Object[0]);
                        }
                    }
                });
            }
        };
    }

    public IRestApiEx gotoMobileLiveDescant() {
        return new NavRestApi(){

            public String getAuthority() {
                return MobileLiveApiList.AUTHORITY;
            }

            public String getPath() {
                return "Descant/*/*";
            }

            public void run() {
            }
        };
    }

    public IRestApiEx gotoPureReplay() {
        return new NavRestApi(){

            public String getAuthority() {
                return MobileLiveApiList.AUTHORITY;
            }

            public String getPath() {
                return "Pure";
            }

            public void run() {
                final INavParam param = (INavParam)this.getParam();
                if (null == param.context) {
                    return;
                }
                Uri uri = param.uri;
                final String videoUrl = uri.getQueryParameter("mediaUri");
                MLog.info((Object)MobileLiveApiList.TAG, (String)("gotoPureReplay->url:" + videoUrl), (Object[])new Object[0]);
                param.context.runOnUiThread(new Runnable(){

                    @Override
                    @SuppressLint(value={"BadNavigation"})
                    public void run() {
                        if (NetworkUtils.isNetworkAvailable((Context)param.context)) {
                            ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toPurePlayVideo(param.context, videoUrl);
                        } else {
                            Toast.makeText((Context)param.context, (CharSequence)"\u7f51\u7edc\u4e0d\u7ed9\u529b", (int)0).show();
                        }
                    }
                });
            }
        };
    }

    public IRestApiEx gotoMobileLivePreViewPage() {
        return new NavRestApi(){

            public String getAuthority() {
                return MobileLiveApiList.AUTHORITY;
            }

            public String getPath() {
                return "PreViewPage";
            }

            public void run() {
                final INavParam param = (INavParam)this.getParam();
                param.context.runOnUiThread(new Runnable(){

                    @Override
                    @SuppressLint(value={"BadNavigation"})
                    public void run() {
                        MLog.info((Object)MobileLiveApiList.TAG, (String)"startMobileLive from MobileLiveApiList", (Object[])new Object[0]);
                        ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toCameraPerviewActivity((Context)param.context);
                    }
                });
            }
        };
    }
}

