/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.turntable.v2.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.yy.mobile.RxBus;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.turntable.v2.bean.LuckyLotteryBean;
import com.yy.mobile.ui.turntable.v2.event.TurnTableCommonEvent;
import com.yy.mobile.util.DontProguardClass;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.gift.GiftConfigParser;
import java.util.ArrayList;
import java.util.List;

@DontProguardClass
public class YYCricleProgressView
extends View {
    public static final String TAG = "YYCricleProgressView";
    private Context mContext;
    private int arraySize = 4;
    private int centerX;
    private int centerY;
    private static final int ARC_FULL_DEGREE = -135;
    private int strokeWidth;
    private int width;
    private int height;
    private float max;
    private float progress;
    private RectF circleRectF;
    private Paint progressPaint;
    private Paint thumbPaint;
    private int circleRadius;
    private String defaultProgressColor = "#ff4883";
    private String defaultProgressBgColor = "#696074";
    private String defaultProgressValueTvColor = "#1d1d1d";
    private String defaultTipsBgColor = "#65000000";
    private String defaultTipsTextColor = "#ffffff";
    private int tipsTextFontSize = (int)ResolutionUtils.convertDpToPixel((float)9.0f, (Context)BasicConfig.getInstance().getAppContext());
    private int progressPI = 180;
    private int startAngle = 90;
    private float angleNodeTag = 33.5f;
    private int nodeTag = 25;
    private int tipsRadius = (int)ResolutionUtils.convertDpToPixel((float)3.0f, (Context)BasicConfig.getInstance().getAppContext());
    private int giftCircleRadiud = (int)ResolutionUtils.convertDpToPixel((float)10.0f, (Context)BasicConfig.getInstance().getAppContext());
    private int textFontSize = (int)ResolutionUtils.convertDpToPixel((float)9.0f, (Context)BasicConfig.getInstance().getAppContext());
    private int mBubbleHeight = (int)ResolutionUtils.convertDpToPixel((float)13.0f, (Context)BasicConfig.getInstance().getAppContext());
    private int mBubbleWidth = (int)ResolutionUtils.convertDpToPixel((float)14.0f, (Context)BasicConfig.getInstance().getAppContext());
    private int giftIconRectSize = (int)ResolutionUtils.convertDpToPixel((float)12.0f, (Context)BasicConfig.getInstance().getAppContext());
    private boolean isClickNodeContainer = true;
    private RectF[] giftContainerNodes = new RectF[this.arraySize];
    private RectF[] tipContainerArea = new RectF[this.arraySize];
    private final int notFindContainerNode = -1;
    private OnGiftNodeContainerClickListener nodeClickListener;
    private long nanoTime = 0L;
    private long clickDelayTime = 300L;
    private float nodeCenterX;
    private float nodeCenterY;
    private int currentClickNodeIndex = -1;
    private boolean nodeTipsIsShow = false;
    private String tipInfo = "";
    private List<LuckyLotteryBean> luckyLotteryBeans = new ArrayList<LuckyLotteryBean>();
    private Bitmap[] giftDefaultIcon = new Bitmap[this.arraySize];

    public YYCricleProgressView(Context context) {
        super(context, null);
        this.mContext = context;
        this.init();
    }

    public YYCricleProgressView(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
        this.mContext = context;
        this.init();
    }

    public YYCricleProgressView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.init();
    }

    public void setMax(float max) {
        this.max = max <= 0.0f ? 100.0f : max;
    }

    public void setProgress(float progress) {
        if (progress < 0.0f) {
            return;
        }
        this.progress = progress;
        if (progress > this.max) {
            this.progress = this.max;
        }
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public void setContainerSize(int width, int height) {
        this.setContainerSize(width, height, 0, 0);
    }

    public void setContainerSize(int width, int height, int centerX, int centerY) {
        MLog.info((Object)TAG, (String)("setContainerSize" + width + " " + height), (Object[])new Object[0]);
        this.width = width;
        this.height = height;
        this.circleRadius = Math.min(width, height) / 2;
        this.strokeWidth = (int)ResolutionUtils.convertDpToPixel((float)7.5f, (Context)BasicConfig.getInstance().getAppContext());
        this.circleRadius -= this.strokeWidth;
        this.centerX = centerX <= 0 ? width / 2 : centerX;
        this.centerY = centerY <= 0 ? height / 2 : centerY;
        this.circleRectF = new RectF();
        this.circleRectF.left = this.centerX - this.circleRadius;
        this.circleRectF.top = this.centerY - this.circleRadius;
        this.circleRectF.right = this.centerX + this.circleRadius;
        this.circleRectF.bottom = this.centerY + this.circleRadius;
        for (int idx = 0; idx < this.arraySize; ++idx) {
            this.giftDefaultIcon[idx] = BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)R.drawable.lr_ic_default_gift);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isClickNodeContainer) {
            return super.onTouchEvent(event);
        }
        float currentX = event.getX();
        float currentY = event.getY();
        int action = event.getAction();
        boolean touchEvent = super.onTouchEvent(event);
        switch (action) {
            case 0: {
                int tempIndex = this.isclickInNode(currentX, currentY);
                if (tempIndex > -1 && tempIndex < this.arraySize) {
                    this.currentClickNodeIndex = tempIndex;
                    long currentNanoTime = System.currentTimeMillis();
                    if (currentNanoTime - this.nanoTime > this.clickDelayTime) {
                        this.nodeTipsIsShow = true;
                        this.nanoTime = currentNanoTime;
                        if (this.nodeClickListener != null) {
                            this.nodeClickListener.onClick(this.currentClickNodeIndex);
                        }
                        this.invalidate();
                    }
                    touchEvent = true;
                    break;
                }
                if (this.nodeTipsIsShow) {
                    boolean isClickInTipContainer = this.isClickInTipContainer(this.currentClickNodeIndex, currentX, currentY);
                    if (!isClickInTipContainer) {
                        this.nodeTipsIsShow = false;
                        if (this.nodeClickListener != null) {
                            this.nodeClickListener.showFinishEnd(true);
                        }
                        this.invalidate();
                        this.currentClickNodeIndex = -1;
                    } else {
                        touchEvent = true;
                    }
                }
                TurnTableCommonEvent rxEvent = new TurnTableCommonEvent(1, true);
                RxBus.getDefault().post((Object)rxEvent);
                break;
            }
        }
        return touchEvent;
    }

    public void setNodeTipInfo(String info) {
        this.tipInfo = info;
    }

    public boolean isNodeTipsIsShow() {
        return this.nodeTipsIsShow;
    }

    public void hideNodeTips() {
        this.nodeTipsIsShow = false;
        this.currentClickNodeIndex = -1;
        this.invalidate();
    }

    public void setGiftNodeClickListener(OnGiftNodeContainerClickListener listener2) {
        this.nodeClickListener = listener2;
    }

    public void setLuckyLotteryBeans(List<LuckyLotteryBean> luckyLotteryBeans) {
        this.luckyLotteryBeans = luckyLotteryBeans;
    }

    protected void onDraw(Canvas canvas) {
        float ratio = this.progress / this.max * 100.0f / 100.0f;
        float tempRatio = this.conversionRatio(ratio);
        float sweep = -135.0f * (tempRatio > 1.0f ? 1.0f : tempRatio);
        this.progressPaint.setColor(Color.parseColor((String)this.defaultProgressColor));
        this.progressPaint.setStyle(Paint.Style.FILL);
        canvas.drawCircle((float)this.centerX, (float)(this.centerY + this.circleRadius), (float)(this.strokeWidth / 2), this.progressPaint);
        this.drawProgress(canvas, this.startAngle, -135.0f, false, this.defaultProgressBgColor, this.progressPaint);
        this.drawProgress(canvas, this.startAngle, sweep, false, this.defaultProgressColor, this.progressPaint);
        int ratioToInt = (int)(ratio * 100.0f);
        int progressIndex = -1;
        boolean userNodeCenterXy = false;
        if (ratioToInt % this.nodeTag == 0) {
            progressIndex = ratioToInt / this.nodeTag;
        }
        for (int idx = 1; idx < 5; ++idx) {
            if (this.canfillCircle(ratioToInt, idx)) {
                this.progressPaint.setColor(Color.parseColor((String)this.defaultProgressColor));
            } else {
                this.progressPaint.setColor(Color.parseColor((String)this.defaultProgressBgColor));
            }
            this.progressPaint.setStyle(Paint.Style.FILL);
            double deg = Math.PI * (double)this.angleNodeTag * (double)idx / (double)this.progressPI;
            float endX = (float)this.centerX + (float)this.circleRadius * (float)Math.sin(deg);
            float endY = (float)this.centerY + (float)this.circleRadius * (float)Math.cos(deg);
            canvas.drawCircle(endX, endY, (float)this.giftCircleRadiud, this.progressPaint);
            this.createGiftIconContainerSize(idx, endX, endY);
            if (progressIndex != idx) continue;
            userNodeCenterXy = true;
            this.nodeCenterX = endX;
            this.nodeCenterY = endY;
        }
        float progressRadians = (float)((double)(sweep / (float)this.progressPI) * Math.PI);
        this.progressPaint.setColor(Color.parseColor((String)this.defaultProgressColor));
        this.progressPaint.setStrokeWidth(0.0f);
        this.progressPaint.setStyle(Paint.Style.FILL);
        float startX = (float)this.centerX - (float)this.circleRadius * (float)Math.sin(progressRadians);
        float startY = (float)this.centerY + (float)this.circleRadius * (float)Math.cos(progressRadians);
        canvas.drawCircle(startX, startY, (float)(this.strokeWidth / 2), this.progressPaint);
        this.drawGiftBitmap(canvas);
        this.drawProgressDetail(canvas, userNodeCenterXy ? this.nodeCenterX : startX, userNodeCenterXy ? this.nodeCenterY : startY, userNodeCenterXy);
        if (this.nodeTipsIsShow) {
            this.drawGiftNodeTips(canvas);
        }
    }

    private void init() {
        this.progressPaint = new Paint();
        this.progressPaint.setAntiAlias(true);
        this.thumbPaint = new Paint();
        this.thumbPaint.setAntiAlias(true);
        this.max = 100.0f;
        this.progress = 0.01f;
    }

    private float conversionRatio(float ratio) {
        int temp = (int)(ratio * 100.0f);
        if (temp <= 24) {
            return 21.0f * ((float)temp / 24.0f) / 100.0f;
        }
        if (temp == 25) {
            return 0.26f;
        }
        if (temp > 25 && temp <= 49) {
            return (27.0f + 19.0f * ((float)(temp - 26) / 23.0f)) / 100.0f;
        }
        if (temp == 50) {
            return 0.51f;
        }
        if (temp > 50 && temp <= 74) {
            return (52.0f + 19.0f * ((float)(temp - 51) / 23.0f)) / 100.0f;
        }
        if (temp == 75) {
            return 0.76f;
        }
        if (temp > 75 && temp <= 99) {
            return (77.0f + 19.0f * ((float)(temp - 76) / 23.0f)) / 100.0f;
        }
        if (temp >= 100) {
            return 1.0f;
        }
        return ratio;
    }

    private void drawGiftBitmap(Canvas canvas) {
        for (int idx = 0; idx < this.luckyLotteryBeans.size(); ++idx) {
            LuckyLotteryBean bean = this.luckyLotteryBeans.get(idx);
            if (bean == null) continue;
            final String url = GiftConfigParser.getInstance().getGiftIconPath(bean.giftId);
            BitmapDrawable drawable2 = ImageLoader.getBitmapFromCache((String)url);
            if (drawable2 == null) {
                ImageLoader.loadBitmap((Context)this.mContext, (String)url, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                    public void onLoadFailed(Exception e) {
                    }

                    public void onResourceReady(Bitmap bitmap) {
                        try {
                            BitmapDrawable cacheDrawable = new BitmapDrawable(bitmap);
                            ImageLoader.addBitmapToCache((String)url, (BitmapDrawable)cacheDrawable);
                            YYCricleProgressView.this.invalidate();
                        }
                        catch (Exception e) {
                            MLog.info((Object)YYCricleProgressView.TAG, (String)"load image onResourceReady", (Object[])new Object[0]);
                        }
                    }
                });
                continue;
            }
            if (idx <= -1 || idx >= this.arraySize || this.giftDefaultIcon[idx] == null) continue;
            this.giftDefaultIcon[idx] = drawable2.getBitmap();
            float centerX = this.giftContainerNodes[idx].left + (this.giftContainerNodes[idx].right - this.giftContainerNodes[idx].left) / 2.0f;
            float centerY = this.giftContainerNodes[idx].top + (this.giftContainerNodes[idx].bottom - this.giftContainerNodes[idx].top) / 2.0f;
            Rect rect = new Rect();
            rect.left = (int)(centerX - (float)(this.giftIconRectSize / 2));
            rect.top = (int)(centerY - (float)(this.giftIconRectSize / 2));
            rect.right = (int)(centerX + (float)(this.giftIconRectSize / 2));
            rect.bottom = (int)(centerY + (float)(this.giftIconRectSize / 2));
            canvas.drawBitmap(this.giftDefaultIcon[idx], null, rect, null);
        }
    }

    private void drawProgress(Canvas canvas, float startAngle, float sweep, boolean userCenter, String colorString, Paint paint) {
        paint.setStrokeWidth((float)this.strokeWidth);
        paint.setColor(Color.parseColor((String)colorString));
        paint.setStyle(Paint.Style.STROKE);
        canvas.drawArc(this.circleRectF, startAngle, sweep, userCenter, paint);
    }

    private void drawProgressDetail(Canvas canvas, float startx, float starty, boolean userNodeCenterXy) {
        this.progressPaint.setTextSize((float)this.textFontSize);
        String txtStr = String.format("%d", (int)this.progress);
        int txtWidth = (int)this.progressPaint.measureText(txtStr);
        int rectFW = this.mBubbleWidth / 2 + txtWidth;
        this.progressPaint.setColor(-1);
        this.progressPaint.setStrokeWidth(0.0f);
        this.progressPaint.setStyle(Paint.Style.FILL);
        Path trigonPath = new Path();
        if (userNodeCenterXy) {
            starty += (float)(this.strokeWidth / 2);
        }
        int trigonOriginW = txtWidth > this.mBubbleWidth / 2 ? this.mBubbleWidth / 2 : txtWidth;
        trigonPath.moveTo(startx, starty);
        trigonPath.lineTo(startx - (float)(trigonOriginW / 2), starty + (float)(this.mBubbleHeight / 2 * 7 / 8));
        trigonPath.lineTo(startx + (float)(trigonOriginW / 2), starty + (float)(this.mBubbleHeight / 2 * 7 / 8));
        trigonPath.close();
        canvas.drawPath(trigonPath, this.progressPaint);
        RectF rectF = new RectF(startx - (float)(rectFW / 2), starty += (float)(this.mBubbleHeight / 3), startx + (float)(rectFW / 2), starty + (float)this.mBubbleHeight);
        canvas.drawRoundRect(rectF, (float)this.giftCircleRadiud, (float)this.giftCircleRadiud, this.progressPaint);
        this.progressPaint.setTextSize((float)this.textFontSize);
        this.progressPaint.setColor(Color.parseColor((String)this.defaultProgressValueTvColor));
        this.progressPaint.setTypeface(Typeface.DEFAULT_BOLD);
        float startTemp = startx - (float)(txtWidth / 2);
        canvas.drawText(txtStr, startTemp, starty + (float)this.textFontSize + (float)((this.mBubbleHeight - this.textFontSize) / 4), this.progressPaint);
    }

    private void drawGiftNodeTips(Canvas canvas) {
        if (this.currentClickNodeIndex > -1 && this.currentClickNodeIndex < this.giftContainerNodes.length && this.giftContainerNodes[this.currentClickNodeIndex] != null) {
            this.progressPaint.setTextSize((float)this.tipsTextFontSize);
            int txtWidth = (int)this.progressPaint.measureText(this.tipInfo);
            int rectFW = this.mBubbleWidth + txtWidth;
            this.progressPaint.setColor(Color.parseColor((String)this.defaultTipsBgColor));
            this.progressPaint.setStrokeWidth(0.0f);
            this.progressPaint.setStyle(Paint.Style.FILL);
            RectF tipsRectF = new RectF(this.giftContainerNodes[this.currentClickNodeIndex].left - (float)rectFW, this.giftContainerNodes[this.currentClickNodeIndex].top, this.giftContainerNodes[this.currentClickNodeIndex].left, this.giftContainerNodes[this.currentClickNodeIndex].bottom);
            if (this.tipContainerArea[this.currentClickNodeIndex] == null) {
                this.tipContainerArea[this.currentClickNodeIndex] = tipsRectF;
            }
            canvas.drawRoundRect(tipsRectF, (float)this.tipsRadius, (float)this.tipsRadius, this.progressPaint);
            this.progressPaint.setColor(Color.parseColor((String)this.defaultTipsTextColor));
            float startTemp = tipsRectF.left + (float)(this.mBubbleWidth / 2);
            canvas.drawText(this.tipInfo, startTemp, tipsRectF.bottom - (float)((this.giftCircleRadiud * 2 - this.tipsTextFontSize) * 3 / 5), this.progressPaint);
        }
    }

    private boolean canfillCircle(int ratioAsInt, int index) {
        return ratioAsInt >= index * this.nodeTag;
    }

    private boolean isClickInTipContainer(int currentClickNodeIndex, float x, float y) {
        boolean result = false;
        if (currentClickNodeIndex > -1 && currentClickNodeIndex < this.arraySize && this.tipContainerArea[currentClickNodeIndex] != null && this.tipContainerArea[currentClickNodeIndex].contains(x, y)) {
            result = true;
        }
        return result;
    }

    private int isclickInNode(float x, float y) {
        int nodeId;
        int result = nodeId = -1;
        for (RectF rectF : this.giftContainerNodes) {
            ++nodeId;
            if (rectF == null || !rectF.contains(x, y)) continue;
            result = nodeId;
            return result;
        }
        return result;
    }

    private void createGiftIconContainerSize(int idx, float radiosX, float radiusY) {
        int index = idx - 1;
        if (this.giftContainerNodes[index] == null && index > -1 && index < this.giftContainerNodes.length) {
            this.giftContainerNodes[index] = this.creatRectFByXy(radiosX, radiusY);
        }
    }

    private RectF creatRectFByXy(float radiusX, float radiusY) {
        RectF rectF = new RectF();
        rectF.left = radiusX - (float)this.giftCircleRadiud;
        rectF.top = radiusY - (float)this.giftCircleRadiud;
        rectF.right = radiusX + (float)this.giftCircleRadiud;
        rectF.bottom = radiusY + (float)this.giftCircleRadiud;
        return rectF;
    }

    public static interface OnGiftNodeContainerClickListener {
        public void onClick(int var1);

        public void showFinishEnd(boolean var1);
    }
}

