/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.screencapture.ui;

import android.content.Context;
import android.graphics.Point;
import android.graphics.PointF;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.yy.mobile.ui.screencapture.CaptureConstant;

public abstract class AbsFloatingView {
    protected final Context baseContext;
    protected final WindowManager mWindowManager;
    protected View mContentView;
    protected WindowManager.LayoutParams mLayoutParams;
    private Point mWHPoint = new Point(-2, -2);

    public AbsFloatingView(Context context) {
        if (null == context) {
            throw new IllegalArgumentException("context must NOT be NULL!");
        }
        this.baseContext = context;
        this.mWindowManager = (WindowManager)context.getSystemService("window");
    }

    public WindowManager getWindowManager() {
        return this.mWindowManager;
    }

    public Context getContext() {
        return this.baseContext;
    }

    public void attach() {
        if (this.isAttached()) {
            return;
        }
        if (null == this.mContentView) {
            this.mContentView = this.inflate(this.baseContext);
        }
        if (null == this.mLayoutParams) {
            this.mLayoutParams = this.configParams();
        }
        if (this.mContentView.getParent() != null) {
            this.mWindowManager.removeViewImmediate(this.mContentView);
        }
        this.mWindowManager.addView(this.mContentView, (ViewGroup.LayoutParams)this.mLayoutParams);
    }

    public void detach() {
        if (!this.isAttached()) {
            return;
        }
        if (null == this.mContentView) {
            return;
        }
        if (this.mContentView.getParent() != null) {
            this.mWindowManager.removeViewImmediate(this.mContentView);
        }
    }

    public boolean isAttached() {
        if (null == this.mContentView) {
            return false;
        }
        return this.mContentView.getParent() != null;
    }

    private void setVisible(boolean visible) {
        if (null == this.mContentView) {
            return;
        }
        if (visible) {
            this.mContentView.setVisibility(0);
        } else {
            this.mContentView.setVisibility(8);
        }
    }

    public void show() {
        if (!this.isAttached()) {
            this.attach();
        } else if (!this.isShown()) {
            this.setVisible(true);
        }
    }

    public void hide() {
        if (!this.isAttached()) {
            return;
        }
        if (this.isShown()) {
            this.setVisible(false);
        }
    }

    public boolean isShown() {
        if (!this.isAttached()) {
            return false;
        }
        return this.mContentView.isShown();
    }

    protected void setDragTriggerView(View view) {
        if (null == view) {
            return;
        }
        view.setOnTouchListener((View.OnTouchListener)new DragViewOnTouchListener());
    }

    public void updateViewPosition(float x, float y, PointF point) {
        this.mLayoutParams.x = (int)(x - point.x);
        this.mLayoutParams.y = (int)(y - point.y);
        this.requestUpdate();
    }

    public void setXY(int x, int y) {
        if (null == this.mLayoutParams) {
            this.mLayoutParams = this.configParams();
        }
        this.mLayoutParams.x = x;
        this.mLayoutParams.y = y;
        this.requestUpdate();
    }

    public void setWH(int w, int h) {
        if (null == this.mLayoutParams) {
            this.mLayoutParams = this.configParams();
        }
        this.mWHPoint.set(w, h);
        this.mLayoutParams.width = w;
        this.mLayoutParams.height = h;
        this.requestUpdate();
    }

    public void setFocusable(boolean focusable) {
        if (null == this.mLayoutParams) {
            this.mLayoutParams = this.configParams();
        }
        this.mLayoutParams.flags = !focusable ? (this.mLayoutParams.flags |= 8) : (this.mLayoutParams.flags &= 0xFFFFFFF7);
        this.requestUpdate();
    }

    public void setGravity(int gravity) {
        if (null == this.mLayoutParams) {
            this.mLayoutParams = this.configParams();
        }
        this.mLayoutParams.gravity = gravity;
        this.requestUpdate();
    }

    protected void requestUpdate() {
        if (!this.isAttached()) {
            return;
        }
        this.mWindowManager.updateViewLayout(this.mContentView, (ViewGroup.LayoutParams)this.mLayoutParams);
    }

    public WindowManager.LayoutParams configParams() {
        WindowManager.LayoutParams params = new WindowManager.LayoutParams();
        params.type = Build.VERSION.SDK_INT > 24 ? 2002 : 2005;
        params.format = 1;
        params.flags = 8;
        params.gravity = 19;
        params.y = 0;
        params.x = 0;
        params.height = -2;
        params.width = -2;
        return params;
    }

    public abstract View inflate(Context var1);

    private class DragViewOnTouchListener
    implements View.OnTouchListener {
        private PointF mStartPosition = new PointF();
        private PointF mStartRawPosition = new PointF();
        private boolean isMoveEvent = false;

        private DragViewOnTouchListener() {
        }

        public boolean onTouch(View view, MotionEvent event) {
            int action = event.getAction();
            boolean ret = false;
            float x = event.getRawX();
            float y = event.getRawY() - (float)CaptureConstant.STATUS_BAR_HEIGHT;
            switch (action) {
                case 0: {
                    this.mStartPosition.set(event.getX(), event.getY());
                    this.mStartRawPosition.set(x, y);
                    this.isMoveEvent = false;
                    ret = true;
                    break;
                }
                case 2: {
                    if (!this.isMoveEvent && (Math.abs(this.mStartRawPosition.x - x) >= (float)CaptureConstant.MIN_SCROLL_DISTANCE || Math.abs(this.mStartRawPosition.y - y) >= (float)CaptureConstant.MIN_SCROLL_DISTANCE)) {
                        this.isMoveEvent = true;
                    }
                    if (!this.isMoveEvent) break;
                    AbsFloatingView.this.updateViewPosition(x, y, this.mStartPosition);
                    break;
                }
                case 1: {
                    if (this.isMoveEvent) break;
                    view.performClick();
                    break;
                }
            }
            return ret;
        }
    }
}

