/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.mic;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.main.events.IUserClient_onRequestBasicUserInfo_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.home.BasicFaceHelper;
import com.yy.mobile.ui.home.FaceHelperFactory;
import com.yy.mobile.ui.mic.MicFreedomSpeakerAdapter$$EventBinder;
import com.yy.mobile.ui.widget.MarqueeTextView;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreError;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.media.IMediaMicFreeCore;
import com.yymobile.core.media.MicSpeaker;
import com.yymobile.core.user.IUserCore;
import com.yymobile.core.user.UserInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MicFreedomSpeakerAdapter
extends BaseAdapter
implements EventCompat {
    private boolean isNewSpeakShow = false;
    private static final String TAG = "MicFreedomSpeakerAdapter";
    protected HashMap<Long, UserInfo> mUserInfos = new HashMap();
    private List<MicSpeaker> mSpeakerList = new ArrayList<MicSpeaker>();
    private Activity mContext;
    private LayoutInflater mInflater;
    private EventBinder mMicFreedomSpeakerAdapterSniperEventBinder;

    public void onEventBind() {
        if (this.mMicFreedomSpeakerAdapterSniperEventBinder == null) {
            this.mMicFreedomSpeakerAdapterSniperEventBinder = new MicFreedomSpeakerAdapter$$EventBinder();
        }
        this.mMicFreedomSpeakerAdapterSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mMicFreedomSpeakerAdapterSniperEventBinder != null) {
            this.mMicFreedomSpeakerAdapterSniperEventBinder.unBindEvent();
        }
    }

    public MicFreedomSpeakerAdapter(Activity ctx) {
        ICoreManagerBase.addClient((Object)((Object)this));
        this.mContext = ctx;
        this.mInflater = LayoutInflater.from((Context)ctx);
    }

    public void setNewSpeakShow(boolean newSpeakShow) {
        this.isNewSpeakShow = newSpeakShow;
        ((IMediaMicFreeCore)ICoreManagerBase.getCore(IMediaMicFreeCore.class)).setMicInSpeakerListMaxSize(this.isNewSpeakShow ? 3 : 6);
    }

    public void setData(List<MicSpeaker> list2) {
        this.mSpeakerList.clear();
        if (list2 != null && list2.size() > 0) {
            if (this.isNewSpeakShow) {
                if (list2.size() > 3) {
                    for (int j = 0; j < 3; ++j) {
                        this.mSpeakerList.add(list2.get(j));
                    }
                } else {
                    this.mSpeakerList.addAll(list2);
                }
            } else {
                this.mSpeakerList.addAll(list2);
            }
            ArrayList<Long> idList = new ArrayList<Long>();
            for (int i = 0; i < this.mSpeakerList.size(); ++i) {
                idList.add(this.mSpeakerList.get(i).uid());
            }
            ((IUserCore)ICoreManagerBase.getCore(IUserCore.class)).requestBasicUserInfo(idList, false);
        }
        this.notifyDataSetChanged();
    }

    @BusEvent
    public void onRequestBasicUserInfo(IUserClient_onRequestBasicUserInfo_EventArgs busEventArgs) {
        List userIdList = busEventArgs.getUserIdList();
        List userInfoList = busEventArgs.getUserInfoList();
        boolean isLocalData = busEventArgs.getIsLocalData();
        CoreError error = busEventArgs.getError();
        String ctx = busEventArgs.getCtx();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)(userIdList.size() + "    " + userInfoList.size() + "  ctx =  " + ctx), (Object[])new Object[0]);
        }
        for (int i = 0; i < userIdList.size(); ++i) {
            this.mUserInfos.put((Long)userIdList.get(i), (UserInfo)userInfoList.get(i));
        }
        this.notifyDataSetChanged();
    }

    public int getCount() {
        if (this.mSpeakerList != null && this.mSpeakerList.size() > 0) {
            return this.mSpeakerList.size();
        }
        return 0;
    }

    public Object getItem(int position) {
        if (this.mSpeakerList != null && position >= 0 && position < this.mSpeakerList.size()) {
            return this.mSpeakerList.get(position);
        }
        return null;
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        FreeModeSpeakViewHolder holder = null;
        if (convertView == null) {
            convertView = this.mInflater.inflate(R.layout.layout_channel_video_free_speaker_item, null);
            holder = new FreeModeSpeakViewHolder();
            holder.icon = (CircleImageView)convertView.findViewById(R.id.iv_icon);
            holder.iconParent = (ImageView)convertView.findViewById(R.id.rl_icon_parent);
            holder.mNameText = (MarqueeTextView)convertView.findViewById(R.id.tv_text);
            convertView.setTag((Object)holder);
        } else {
            holder = (FreeModeSpeakViewHolder)convertView.getTag();
        }
        MicSpeaker speaker = (MicSpeaker)this.getItem(position);
        if (speaker != null) {
            if (this.mUserInfos.containsKey(speaker.uid())) {
                UserInfo userInfo = this.mUserInfos.get(speaker.uid());
                if (userInfo != null) {
                    BasicFaceHelper.loadFace((String)userInfo.iconUrl_100_100, (int)userInfo.iconIndex, (FaceHelperFactory.FaceType)FaceHelperFactory.FaceType.FriendFace, (RecycleImageView)holder.icon, (ImageConfig)ImageConfig.smallImageConfig(), (int)R.drawable.default_portrait);
                } else {
                    ImageLoader.loadImage((String)speaker.headUrl(), (RecycleImageView)holder.icon, (ImageConfig)ImageConfig.smallImageConfig(), (int)R.drawable.default_portrait, (int)R.drawable.default_portrait);
                }
            } else {
                ImageLoader.loadImage((String)speaker.headUrl(), (RecycleImageView)holder.icon, (ImageConfig)ImageConfig.smallImageConfig(), (int)R.drawable.default_portrait, (int)R.drawable.default_portrait);
            }
            if (!TextUtils.isEmpty((CharSequence)speaker.nickname())) {
                holder.mNameText.setText((CharSequence)speaker.nickname());
                holder.mNameText.setTextColor(-1);
            }
            if (speaker.isSpeaking()) {
                holder.iconParent.setVisibility(0);
                holder.mNameText.setTextColor(this.mContext.getResources().getColor(R.color.common_color_11));
            } else {
                holder.iconParent.setVisibility(8);
                holder.mNameText.setTextColor(this.mContext.getResources().getColor(R.color.common_color_11));
            }
        }
        return convertView;
    }

    public void onDestroy() {
        ICoreManagerBase.removeClient((Object)((Object)this));
        if (this.mSpeakerList != null) {
            this.mSpeakerList.clear();
        }
        if (this.mUserInfos != null) {
            this.mUserInfos.clear();
        }
        this.mContext = null;
    }

    static class FreeModeSpeakViewHolder {
        CircleImageView icon;
        ImageView iconParent;
        MarqueeTextView mNameText;

        FreeModeSpeakViewHolder() {
        }
    }
}

