/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.guess.result;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import com.yy.mobile.RxBus;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.BasePopupComponent;
import com.yy.mobile.ui.guess.result.GuessResult;
import com.yy.mobile.ui.guess.result.GuessResultAdapter;
import com.yy.mobile.ui.guess.result.GuessResultPopupDismissEvent;
import com.yy.mobile.ui.utils.ViewUtils;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;

public class GuessResultPopupComponent
extends BasePopupComponent
implements View.OnClickListener {
    private static final String TAG = "GameQuizResultPopupComp";
    private static final String ARG_RESULTS = "ARG_RESULTS";
    private static final String ARG_UNITICON_RESID = "ARG_UNITICON";
    private RecyclerView mRvResult;
    private GuessResultAdapter mAdapter;
    private ArrayList<GuessResult> mResults;
    private int mUnitIconResId;

    public static GuessResultPopupComponent showResultPopup(FragmentActivity activity, ArrayList<GuessResult> results, int unitIcon) {
        Bundle args = new Bundle();
        if (results == null) {
            results = new ArrayList();
        }
        args.putSerializable(ARG_RESULTS, results);
        args.putInt(ARG_UNITICON_RESID, unitIcon);
        return (GuessResultPopupComponent)ViewUtils.showPopupComponent((Activity)activity, (FragmentManager)activity.getSupportFragmentManager(), (Bundle)args, GuessResultPopupComponent.class, (String)TAG);
    }

    public static GuessResultPopupComponent showResultPopup(FragmentActivity activity, ArrayList<GuessResult> results) {
        return GuessResultPopupComponent.showResultPopup(activity, results, -1);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mResults = (ArrayList)this.getArguments().getSerializable(ARG_RESULTS);
        this.mUnitIconResId = this.getArguments().getInt(ARG_UNITICON_RESID);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.fragment_game_quiz_result, container, false);
        this.mRvResult = (RecyclerView)rootView.findViewById(R.id.rv_game_result);
        rootView.findViewById(R.id.btn_ok).setOnClickListener((View.OnClickListener)this);
        rootView.findViewById(R.id.iv_close_result).setOnClickListener((View.OnClickListener)this);
        this.initRv();
        return rootView;
    }

    private void initRv() {
        LinearLayoutManager manager = new LinearLayoutManager((Context)this.getActivity(), 1, false);
        this.mRvResult.setLayoutManager((RecyclerView.LayoutManager)manager);
        this.mAdapter = new GuessResultAdapter(this.mUnitIconResId);
        this.mRvResult.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mAdapter.setData(this.mResults);
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        MLog.info((Object)TAG, (String)"onCreateDialog", (Object[])new Object[0]);
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.setCanceledOnTouchOutside(false);
        dialog.setCancelable(false);
        dialog.requestWindowFeature(1);
        return dialog;
    }

    public void onStart() {
        super.onStart();
        MLog.info((Object)TAG, (String)"onStart", (Object[])new Object[0]);
        Context context = this.getContext();
        Dialog dialog = this.getDialog();
        Window window = dialog.getWindow();
        if (window != null) {
            int width = (int)ResolutionUtils.convertDpToPixel((float)261.0f, (Context)context);
            window.setBackgroundDrawableResource(R.color.transparent);
            window.clearFlags(2);
            window.setWindowAnimations(R.style.DialogAnimation);
            window.setLayout(width, -2);
        }
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        RxBus.getDefault().post((Object)new GuessResultPopupDismissEvent());
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.btn_ok || i == R.id.iv_close_result) {
            this.dismissAllowingStateLoss();
        }
    }
}

