/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.commontip;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.duowan.mobile.entlive.events.ICommonTipClient_onCommonTipBroadcast_EventArgs;
import com.duowan.mobile.entlive.events.ICommonTipClient_onJsCallCloseWeb_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.commontip.CommonTipController$$EventBinder;
import com.yy.mobile.ui.commontip.core.CommonTipInfo;
import com.yy.mobile.ui.utils.AbstractViewController;
import com.yy.mobile.ui.utils.CommonWebPopupComponent;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.util.StringUtils;

public class CommonTipController
extends AbstractViewController
implements EventCompat {
    private static final String COMMON_TIP_WEB_POPUP_TAG = "COMMON_TIP_WEB_POPUP_TAG";
    int cnt;
    private TextView tvTipInfo;
    private RecycleImageView ivClose;
    private String url;
    private boolean isFullScreenWeb;
    private FragmentActivity mContext;
    private Runnable delayHide = new Runnable(){

        @Override
        public void run() {
            CommonTipController.this.hide();
        }
    };
    private EventBinder mCommonTipControllerSniperEventBinder;

    public void onEventBind() {
        super.onEventBind();
        if (this.mCommonTipControllerSniperEventBinder == null) {
            this.mCommonTipControllerSniperEventBinder = new CommonTipController$$EventBinder();
        }
        this.mCommonTipControllerSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mCommonTipControllerSniperEventBinder != null) {
            this.mCommonTipControllerSniperEventBinder.unBindEvent();
        }
    }

    public CommonTipController(FragmentActivity mContext) {
        this.mContext = mContext;
    }

    protected void onCreatePrepare(Bundle savedInstanceState) {
        super.onCreatePrepare(savedInstanceState);
        this.isInitHidden = true;
    }

    protected View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.layout_common_tip, container, false);
    }

    protected void onViewCreated(View view, Bundle savedInstanceState) {
        this.tvTipInfo = (TextView)this.findViewById(R.id.tv_tip_info);
        this.tvTipInfo.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!StringUtils.isEmpty((String)CommonTipController.this.url).booleanValue()) {
                    CommonTipController.this.hide();
                    WebSpec webSpec = CommonTipController.this.bulidWebSpec(CommonTipController.this.isFullScreenWeb);
                    CommonWebPopupComponent webPopupComponent = new CommonWebPopupComponent();
                    webPopupComponent.setUrl(CommonTipController.this.url).setWidth(webSpec.w).setHeight(webSpec.h).show(CommonTipController.this.mContext.getSupportFragmentManager(), CommonTipController.COMMON_TIP_WEB_POPUP_TAG);
                }
            }
        });
        this.ivClose = (RecycleImageView)this.findViewById(R.id.iv_close);
        this.ivClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CommonTipController.this.hide();
            }
        });
        this.onOrientationChanged(this.isLandScape());
    }

    protected void onOrientationChanged(boolean isLandscape) {
        super.onOrientationChanged(isLandscape);
        if (this.mRootView != null && this.mRootView.getParent() != null) {
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mRootView.getLayoutParams();
            params.addRule(12);
            params.addRule(14);
            params.bottomMargin = isLandscape ? DensityUtil.dip2px((Context)this.mContext, (float)75.0f) : DensityUtil.dip2px((Context)this.mContext, (float)44.0f);
            this.mRootView.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    public void show() {
        super.show();
        this.getHandler().removeCallbacks(this.delayHide);
        this.getHandler().postDelayed(this.delayHide, 8000L);
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void onCommonTipBroadcast(ICommonTipClient_onCommonTipBroadcast_EventArgs busEventArgs) {
        CommonTipInfo info = busEventArgs.mInfo;
        this.onCommonTipBroadcast(info);
    }

    public void onCommonTipBroadcast(CommonTipInfo info) {
        this.url = info.url;
        this.isFullScreenWeb = info.isFullScreenWeb;
        if (!StringUtils.isEmpty((String)info.url).booleanValue()) {
            this.tvTipInfo.setText((CharSequence)(info.txt + ">"));
            this.tvTipInfo.setTextColor(Color.parseColor((String)"#fac200"));
        } else {
            this.tvTipInfo.setText((CharSequence)info.txt);
            this.tvTipInfo.setTextColor(this.mContext.getResources().getColor(R.color.white));
        }
        this.show();
    }

    private boolean isScreenPortrait(Context context) {
        return context.getResources().getConfiguration().orientation == 1;
    }

    private WebSpec bulidWebSpec(boolean isFullScreenWeb) {
        WebSpec webSpec = new WebSpec();
        if (isFullScreenWeb) {
            webSpec.w = -1;
            webSpec.h = -1;
        } else if (this.isScreenPortrait((Context)this.mContext)) {
            webSpec.w = -1;
            webSpec.h = DensityUtil.dip2px((Context)this.mContext, (float)301.0f);
        } else {
            webSpec.w = DensityUtil.dip2px((Context)this.mContext, (float)375.0f);
            webSpec.h = DensityUtil.dip2px((Context)this.mContext, (float)302.0f);
        }
        return webSpec;
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void onJsCallCloseWeb(ICommonTipClient_onJsCallCloseWeb_EventArgs busEventArgs) {
        CommonWebPopupComponent webPopupComponent = (CommonWebPopupComponent)this.mContext.getSupportFragmentManager().findFragmentByTag(COMMON_TIP_WEB_POPUP_TAG);
        if (webPopupComponent != null) {
            webPopupComponent.dismissAllowingStateLoss();
        }
    }

    static class WebSpec {
        int w;
        int h;

        WebSpec() {
        }
    }
}

