/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.comfessionwall;

import android.content.Context;
import android.graphics.Color;
import android.text.TextPaint;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.comfessionwall.WallDetailBean;
import com.yy.mobile.ui.utils.TextLengthUtils;
import com.yy.mobile.util.ResolutionUtils;

public class ConfessionWallDetailView
extends RelativeLayout {
    private int viewHeight;
    private TextView anchorNickTv;
    private TextView sendTagTv;
    private TextView userNickTv;
    private TextView giftInfoTv;
    private RecycleImageView helpRiv;
    private RecycleImageView giftIconRiv;
    private TextView gotoComfessionChannelBtn;
    private LinearLayout giftContaier;
    private Context mContext;
    private OnConfessionWallDetailViewClickListener listener;
    public static int viewWidth = (int)ResolutionUtils.convertDpToPixel((float)104.0f, (Context)BasicConfig.getInstance().getAppContext());
    private int giftIconSize = (int)ResolutionUtils.convertDpToPixel((float)16.0f, (Context)BasicConfig.getInstance().getAppContext());
    private int helpIconSize = (int)ResolutionUtils.convertDpToPixel((float)12.0f, (Context)BasicConfig.getInstance().getAppContext());
    private int gotoBtnWidth = (int)ResolutionUtils.convertDpToPixel((float)44.0f, (Context)BasicConfig.getInstance().getAppContext());
    private int gotoBtnHeight = (int)ResolutionUtils.convertDpToPixel((float)15.0f, (Context)BasicConfig.getInstance().getAppContext());
    public static int InAnchorChannelViewHeight = (int)ResolutionUtils.convertDpToPixel((float)83.0f, (Context)BasicConfig.getInstance().getAppContext());
    public static int OutAnchorChannelViewHeight = (int)ResolutionUtils.convertDpToPixel((float)98.0f, (Context)BasicConfig.getInstance().getAppContext());
    private int helpBottomMargin;
    private boolean isViewCreated = false;

    public void setListener(OnConfessionWallDetailViewClickListener listener2) {
        this.listener = listener2;
    }

    public ConfessionWallDetailView(Context context) {
        super(context);
        this.mContext = context;
    }

    public void init(ViewType viewType, boolean isCurrentInChannel) {
        if (viewType == ViewType.InAnchorChannel) {
            this.viewHeight = isCurrentInChannel ? InAnchorChannelViewHeight - (int)ResolutionUtils.convertDpToPixel((float)20.0f, (Context)BasicConfig.getInstance().getAppContext()) : InAnchorChannelViewHeight;
            this.viewHeight = InAnchorChannelViewHeight;
            this.helpBottomMargin = 6;
        } else if (viewType == ViewType.OutAnchorChannel) {
            this.viewHeight = isCurrentInChannel ? OutAnchorChannelViewHeight - (int)ResolutionUtils.convertDpToPixel((float)20.0f, (Context)BasicConfig.getInstance().getAppContext()) : OutAnchorChannelViewHeight;
            this.helpBottomMargin = 8;
        }
        if (!this.isViewCreated) {
            this.gotoComfessionChannelBtn = new TextView(this.mContext);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(this.gotoBtnWidth, this.gotoBtnHeight);
            layoutParams.addRule(12);
            layoutParams.addRule(14);
            layoutParams.bottomMargin = (int)ResolutionUtils.convertDpToPixel((float)7.0f, (Context)BasicConfig.getInstance().getAppContext());
            this.gotoComfessionChannelBtn.setBackgroundDrawable(this.mContext.getResources().getDrawable(R.drawable.bg_comfessionwall_goto));
            this.gotoComfessionChannelBtn.setText((CharSequence)"\u53bb\u56f4\u89c2");
            this.gotoComfessionChannelBtn.setGravity(17);
            this.gotoComfessionChannelBtn.setTextColor(-16777216);
            this.gotoComfessionChannelBtn.setTextSize(9.0f);
            TextPaint textPaint = this.gotoComfessionChannelBtn.getPaint();
            textPaint.setFakeBoldText(true);
            this.gotoComfessionChannelBtn.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.gotoComfessionChannelBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (ConfessionWallDetailView.this.listener != null) {
                        ConfessionWallDetailView.this.listener.onClickCircusee(view);
                    }
                }
            });
            if (this.gotoComfessionChannelBtn != null) {
                this.addView((View)this.gotoComfessionChannelBtn);
            }
            this.setBackgroundResource(R.drawable.bg_comfessionwall_detail);
            this.userNickTv = this.createdUserNickTextView(R.id.comfessionwall_detail_usernick);
            RelativeLayout.LayoutParams userNickTvLp = new RelativeLayout.LayoutParams(-2, -2);
            userNickTvLp.addRule(14);
            userNickTvLp.topMargin = (int)ResolutionUtils.convertDpToPixel((float)16.0f, (Context)BasicConfig.getInstance().getAppContext());
            this.addView((View)this.userNickTv, (ViewGroup.LayoutParams)userNickTvLp);
            this.sendTagTv = this.createSendTagTextView();
            RelativeLayout.LayoutParams sendTagTvLp = new RelativeLayout.LayoutParams(-2, -2);
            sendTagTvLp.addRule(14);
            sendTagTvLp.addRule(3, R.id.comfessionwall_detail_usernick);
            this.addView((View)this.sendTagTv, (ViewGroup.LayoutParams)sendTagTvLp);
            this.anchorNickTv = this.createdUserNickTextView(R.id.comfessionwall_detail_anchornick);
            RelativeLayout.LayoutParams anchorNickTvLp = new RelativeLayout.LayoutParams(-2, -2);
            anchorNickTvLp.addRule(14);
            anchorNickTvLp.addRule(3, R.id.comfessionwall_detail_tag);
            this.addView((View)this.anchorNickTv, (ViewGroup.LayoutParams)anchorNickTvLp);
            this.createdGiftInfoContaier();
            RelativeLayout.LayoutParams giftContaierLp = new RelativeLayout.LayoutParams(-2, -2);
            giftContaierLp.addRule(14);
            giftContaierLp.addRule(3, R.id.comfessionwall_detail_anchornick);
            giftContaierLp.topMargin = (int)ResolutionUtils.convertDpToPixel((float)3.0f, (Context)BasicConfig.getInstance().getAppContext());
            this.addView((View)this.giftContaier, (ViewGroup.LayoutParams)giftContaierLp);
            this.helpRiv = new RecycleImageView(this.mContext);
            RelativeLayout.LayoutParams helpRivLp = new RelativeLayout.LayoutParams(this.helpIconSize, this.helpIconSize);
            helpRivLp.addRule(12);
            helpRivLp.addRule(11);
            helpRivLp.rightMargin = (int)ResolutionUtils.convertDpToPixel((float)6.0f, (Context)BasicConfig.getInstance().getAppContext());
            helpRivLp.bottomMargin = (int)ResolutionUtils.convertDpToPixel((float)this.helpBottomMargin, (Context)BasicConfig.getInstance().getAppContext());
            this.helpRiv.setImageDrawable(this.mContext.getResources().getDrawable(R.drawable.icon_liveroom_confession_help));
            this.helpRiv.setLayoutParams((ViewGroup.LayoutParams)helpRivLp);
            this.helpRiv.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (ConfessionWallDetailView.this.listener != null) {
                        ConfessionWallDetailView.this.listener.onClickProblem(view);
                    }
                }
            });
            this.addView((View)this.helpRiv);
            this.isViewCreated = true;
        }
    }

    private void createdGiftInfoContaier() {
        this.giftContaier = new LinearLayout(this.mContext);
        this.giftContaier.setId(R.id.comfessionwall_detail_giftcontainer);
        this.giftContaier.setOrientation(0);
        this.giftIconRiv = new RecycleImageView(this.mContext);
        RelativeLayout.LayoutParams giftIconRivLayoutParams = new RelativeLayout.LayoutParams(this.giftIconSize, this.giftIconSize);
        this.giftIconRiv.setImageDrawable(this.mContext.getResources().getDrawable(R.drawable.default_portrait));
        this.giftIconRiv.setLayoutParams((ViewGroup.LayoutParams)giftIconRivLayoutParams);
        this.giftContaier.addView((View)this.giftIconRiv);
        this.giftInfoTv = new TextView(this.mContext);
        this.giftInfoTv.setTextSize(10.0f);
        TextPaint textPaint = this.giftInfoTv.getPaint();
        textPaint.setFakeBoldText(true);
        this.giftInfoTv.setTextColor(-1);
        this.giftInfoTv.setText((CharSequence)"1314x1");
        LinearLayout.LayoutParams giftInfoTvLayoutParams = new LinearLayout.LayoutParams(-2, -2);
        giftInfoTvLayoutParams.gravity = 16;
        giftInfoTvLayoutParams.leftMargin = (int)ResolutionUtils.convertDpToPixel((float)4.0f, (Context)BasicConfig.getInstance().getAppContext());
        this.giftContaier.addView((View)this.giftInfoTv, (ViewGroup.LayoutParams)giftInfoTvLayoutParams);
    }

    private TextView createdUserNickTextView(int id2) {
        TextView view = new TextView(this.mContext);
        view.setTextSize(9.0f);
        view.setPadding(4, 2, 4, 0);
        view.setTextColor(Color.parseColor((String)"#ffdd00"));
        view.setId(id2);
        view.setText((CharSequence)"\u6e38\u5ba2");
        view.setSingleLine();
        return view;
    }

    private TextView createSendTagTextView() {
        TextView view = new TextView(this.mContext);
        view.setTextSize(8.0f);
        view.setTextColor(-1);
        view.setId(R.id.comfessionwall_detail_tag);
        view.setSingleLine();
        view.setText((CharSequence)"\u9001\u7ed9");
        return view;
    }

    public int getViewHeight() {
        return this.viewHeight;
    }

    public void setData(WallDetailBean bean) {
        if (bean == null) {
            return;
        }
        if (this.userNickTv != null) {
            this.userNickTv.setText((CharSequence)TextLengthUtils.handleMaxText(bean.userNick, 16));
        }
        if (this.anchorNickTv != null) {
            this.anchorNickTv.setText((CharSequence)TextLengthUtils.handleMaxText(bean.anchorNick, 16));
        }
        if (this.giftIconRiv != null) {
            ImageLoader.loadImage((RecycleImageView)this.giftIconRiv, (String)bean.getGiftUrl(), (int)R.drawable.default_portrait);
        }
        if (this.giftInfoTv != null) {
            this.giftInfoTv.setText((CharSequence)bean.giftInfo);
        }
        if (bean.isCurrentInChannel) {
            this.gotoComfessionChannelBtn.setVisibility(8);
        } else {
            this.gotoComfessionChannelBtn.setVisibility(0);
        }
    }

    static interface OnConfessionWallDetailViewClickListener {
        public void onClickCircusee(View var1);

        public void onClickProblem(View var1);
    }

    public static enum ViewType {
        InAnchorChannel,
        OutAnchorChannel;

    }
}

