/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicfunction.danmu.filter;

import android.content.Context;
import android.graphics.Color;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import com.yy.live.module.giftdanmu.DanmuTextManager;
import com.yy.mobile.richtext.RichTextManager;
import com.yy.mobile.ui.publicchat.util.RichTextUtil;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.channel.PublicChatMessage;
import com.yymobile.core.gift.GiftChannelMessage;
import com.yymobile.core.medal.MedalNobleEntry;
import java.util.HashMap;
import java.util.List;

public enum DanMuCommentFilter {
    INSTANCE;

    private static final String TAG = "DanMuCommentFilter";
    private boolean filterUserInfo = false;
    private int nickLength = 7;

    public boolean intercept(ChannelMessage message) {
        boolean isFreeGiftMsg = message instanceof GiftChannelMessage && ((GiftChannelMessage)message).type == GiftChannelMessage.GiftType.FreeGift;
        return !isFreeGiftMsg;
    }

    public Spannable getSpannable(Context context, ChannelMessage message, List<RichTextManager.Feature> features) {
        boolean isCommentMsg;
        boolean bl = isCommentMsg = message.channelMessageType == ChannelMessage.ChannelMsgType.COMMON_MESSAGE_TYPE && message instanceof PublicChatMessage;
        if (isCommentMsg) {
            MLog.info((Object)TAG, (String)"[getSpannable] message: %s", (Object[])new Object[]{message});
            StringBuilder reorderContent = new StringBuilder();
            HashMap entryMap = (HashMap)message.medalEntryList.get(1);
            if (entryMap != null) {
                MedalNobleEntry entry = (MedalNobleEntry)entryMap.get(1);
                message.nobleLevel = entry.getNobleLevel();
                message.vulgarLevel = entry.getVulgarLevel();
            }
            boolean isNormalPeople = true;
            if (message.nobleLevel > 0 || message.vulgarLevel > 0) {
                reorderContent.append("[noblelv]");
                isNormalPeople = false;
            }
            if (ICoreManagerBase.getChannelLinkCore().getChannelAdminRoles(message.uid) != null) {
                reorderContent.append("[role]");
                isNormalPeople = false;
            }
            if (!isNormalPeople) {
                if (message.nickname != null && message.nickname.length() > this.nickLength) {
                    message.nickname = message.nickname.substring(0, this.nickLength);
                }
                reorderContent.append(message.nickname);
            }
            reorderContent.append(" " + message.pureText);
            SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)DanmuTextManager.getSpannableString(context, reorderContent, features));
            RichTextUtil.parseNobleLevel(message, spannable, true);
            RichTextUtil.parseRoleLevel(message, spannable, true);
            RichTextUtil.parseNickname(message, spannable, Color.parseColor((String)"#6DEAFF"), Color.parseColor((String)"#ffffff"));
            MLog.info((Object)TAG, (String)("[getSpannable] span=" + spannable), (Object[])new Object[0]);
            return spannable;
        }
        MLog.info((Object)TAG, (String)"[getSpannable] skip msg: %s", (Object[])new Object[]{message});
        return null;
    }

    public boolean isNormalPeople(ChannelMessage message) {
        boolean isNormalPeople = true;
        if (message.nobleLevel > 0 || message.vulgarLevel > 0) {
            isNormalPeople = false;
        }
        if (ICoreManagerBase.getChannelLinkCore().getChannelAdminRoles(message.uid) != null) {
            isNormalPeople = false;
        }
        return isNormalPeople;
    }

    public void setCanFilterUserInfo(boolean filter) {
        this.filterUserInfo = filter;
    }

    public boolean interceptAnchorLiveFilter(ChannelMessage message) {
        return this.filterUserInfo && this.intercept(message);
    }
}

