/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basefunction.followguide;

import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.main.events.IAttentionFriendClient_onQueryBookAnchorBatchResult_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_leaveCurrentChannel_EventArgs;
import com.yy.mobile.plugin.main.events.IChatEmotionClient_onChatInputSwitch_EventArgs;
import com.yy.mobile.ui.basefunction.followguide.AbsFollowGuideHandler$$EventBinder;
import com.yy.mobile.ui.basefunction.followguide.KeyBehaviorGuideStatistic;
import com.yy.mobile.ui.basefunction.followguide.LoginFollowGuideManager;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.subscribe.ISubscribeCore;
import com.yyproto.utils.FP;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class AbsFollowGuideHandler
implements EventCompat {
    private static final String TAG = "AbsFollowGuideHandler";
    private int mFollowGuideShowState = 0;
    private static final int SHOW_TIME_COUNT_DOWN = 20;
    private Disposable mHiddenTimer;
    private int mHiddenCountDown;
    private EventBinder mAbsFollowGuideHandlerSniperEventBinder;

    public void onEventBind() {
        if (this.mAbsFollowGuideHandlerSniperEventBinder == null) {
            this.mAbsFollowGuideHandlerSniperEventBinder = new AbsFollowGuideHandler$$EventBinder();
        }
        this.mAbsFollowGuideHandlerSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mAbsFollowGuideHandlerSniperEventBinder != null) {
            this.mAbsFollowGuideHandlerSniperEventBinder.unBindEvent();
        }
    }

    public void init() {
        this.onEventBind();
    }

    public void release() {
        this.onEventUnBind();
        if (this.mHiddenTimer != null && !this.mHiddenTimer.isDisposed()) {
            this.mHiddenTimer.dispose();
        }
        this.mHiddenTimer = null;
    }

    public abstract String getTAG();

    protected boolean isAnchorLiving() {
        long uid = ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId();
        return uid > 0L;
    }

    protected boolean isDisplayableState() {
        return this.mFollowGuideShowState == 0;
    }

    protected void checkCurrentFollowState() {
        if (LoginUtil.isLogined()) {
            long uid = ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId();
            ArrayList<Long> uids = new ArrayList<Long>();
            uids.add(uid);
            ((ISubscribeCore)ICoreManagerBase.getCore(ISubscribeCore.class)).queryBookAnchorBatchReq(LoginUtil.getUid(), uids);
            this.mFollowGuideShowState = 1;
        } else {
            this.mHiddenCountDown = 20;
            this.startFollowGuideShowTimmer();
            this.finalNotifyShowFollowGuide();
        }
    }

    public void showFollowGuide() {
        if (!this.isAnchorLiving()) {
            MLog.info((Object)this.getTAG(), (String)"Maybe BUG, top mic uid not valid", (Object[])new Object[0]);
            return;
        }
        if (!this.isDisplayableState()) {
            MLog.info((Object)this.getTAG(), (String)("follow guide is in process, mFollowGuideShowState=" + this.mFollowGuideShowState), (Object[])new Object[0]);
            return;
        }
        if (!LoginFollowGuideManager.instance().isAbleToShowFollowGuide()) {
            MLog.info((Object)this.getTAG(), (String)"not isAbleToShowFollowGuide", (Object[])new Object[0]);
            return;
        }
        this.checkCurrentFollowState();
    }

    @BusEvent
    public void onQueryBookAnchorBatchResult(IAttentionFriendClient_onQueryBookAnchorBatchResult_EventArgs busEventArgs) {
        long uid = busEventArgs.getAnchorUid();
        Map friendList = busEventArgs.getFriendList();
        long anchorUid = ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId();
        MLog.debug((Object)this.getTAG(), (String)"onQueryBookAnchorBatchResult: uid=%s, anchorUid=%s", (Object[])new Object[]{uid, anchorUid});
        if (uid != 0L && uid == LoginUtil.getUid() && !FP.empty((Map)friendList) && uid != anchorUid) {
            for (Map.Entry entry : friendList.entrySet()) {
                if ((Long)entry.getKey() != anchorUid) continue;
                if (((Boolean)entry.getValue()).booleanValue()) {
                    this.mFollowGuideShowState = 3;
                    this.resetTimmer();
                    this.finalNotifyHideFollowGuide();
                    break;
                }
                if (this.mFollowGuideShowState != 1) break;
                this.mHiddenCountDown = 20;
                this.startFollowGuideShowTimmer();
                this.finalNotifyShowFollowGuide();
                break;
            }
        }
    }

    private void startFollowGuideShowTimmer() {
        if (this.mHiddenTimer == null || this.mHiddenTimer.isDisposed()) {
            KeyBehaviorGuideStatistic.reportFollowGuideBarButtonExposureEvent(this.getType());
            this.mHiddenTimer = Observable.interval((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS).subscribeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

                public void accept(Long aLong) throws Exception {
                    MLog.debug((Object)AbsFollowGuideHandler.this.getTAG(), (String)"FollowGuideShowTimmer: mFollowGuideShowState=%s, mHiddenCountDown=%s", (Object[])new Object[]{AbsFollowGuideHandler.this.mFollowGuideShowState, AbsFollowGuideHandler.this.mHiddenCountDown});
                    if (AbsFollowGuideHandler.this.mHiddenCountDown > 0) {
                        AbsFollowGuideHandler.this.mHiddenCountDown--;
                    } else {
                        AbsFollowGuideHandler.this.mFollowGuideShowState = 3;
                        AbsFollowGuideHandler.this.resetTimmer();
                        AbsFollowGuideHandler.this.finalNotifyHideFollowGuide();
                    }
                }
            }, RxUtils.errorConsumer((String)TAG, (String)"FollowGuideShowTimmer:  count down timmer error !"));
        }
    }

    protected abstract void finalNotifyShowFollowGuide();

    protected abstract void finalNotifyHideFollowGuide();

    protected abstract void onResetComponentCountDownTimmer();

    protected void followAnchorSuccess() {
        MLog.debug((Object)this.getTAG(), (String)"followAnchorSuccess: ", (Object[])new Object[0]);
        this.mFollowGuideShowState = 3;
        this.resetTimmer();
    }

    public boolean shoudResumeShow() {
        return this.mHiddenCountDown > 0;
    }

    public void updateFollowGuideShownState(boolean isShown) {
        MLog.debug((Object)this.getTAG(), (String)"updateFollowGuideShownState: isShown=%s, mFollowGuideShowState=%s", (Object[])new Object[]{isShown, this.mFollowGuideShowState});
        if (this.mHiddenCountDown > 0 && isShown) {
            this.mFollowGuideShowState = 2;
        }
    }

    @BusEvent(sync=true)
    public void leaveCurrentChannel(IChannelLinkClient_leaveCurrentChannel_EventArgs busEventArgs) {
        this.mFollowGuideShowState = 0;
        this.resetTimmer();
    }

    private void resetTimmer() {
        if (this.mHiddenTimer != null && !this.mHiddenTimer.isDisposed()) {
            this.mHiddenTimer.dispose();
        }
        this.mHiddenTimer = null;
        this.mHiddenCountDown = 0;
        this.onResetComponentCountDownTimmer();
    }

    @BusEvent
    public void onChatInputSwitch(IChatEmotionClient_onChatInputSwitch_EventArgs busEventArgs) {
        boolean chatInputSwitch = busEventArgs.getChatInputSwitch();
        MLog.debug((Object)this.getTAG(), (String)"onChatInputSwitch: chatInputSwitch = %s", (Object[])new Object[]{chatInputSwitch});
        if (this.shoudResumeShow()) {
            this.finalNotifyShowFollowGuide();
        }
    }

    public void enterLiveRoom() {
        if (this.shoudResumeShow()) {
            this.finalNotifyShowFollowGuide();
        }
    }

    public int getFollowGuideShowState() {
        if (this.mHiddenCountDown <= 0) {
            return 0;
        }
        return this.mFollowGuideShowState;
    }

    public abstract int getType();
}

