/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.duowan.mobile.entlive.events.IChannelModeClient_notifyCurrentChannelMode_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onChannelRolesChange_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelSuccess_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_updateCurrentChannelInfo_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelVoiceClient_disableVoice_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.chatemotion.uicore.IChatEmotionCoreImpl;
import com.yy.mobile.ui.utils.MobilePhoneAccessUtils;
import com.yy.mobile.ui.widget.MicSpeakView$$EventBinder;
import com.yy.mobile.ui.widget.SuccessAndFailToast;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.DimenConverter;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.BaseFragmentApi;
import com.yymobile.baseapi.R;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.basechannel.IChannelLinkCore;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.channel.ChannelState;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.util.ArrayList;

public class MicSpeakView
extends FrameLayout
implements EventCompat,
View.OnClickListener {
    private static final String TAG = "MicSpeakView";
    ImageView portraitMicPicIv;
    ImageView horizontalMicPicIv;
    private IChannelLinkCore mChannelCore;
    protected boolean isLandscape;
    private boolean isOnDestory = false;
    private EventBinder mMicSpeakViewSniperEventBinder;

    public MicSpeakView(@NonNull Context context) {
        this(context, null);
    }

    public MicSpeakView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MicSpeakView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.onEventBind();
        this.init(context);
    }

    private void init(Context context) {
        this.initCore();
        this.initView(context);
    }

    private void initCore() {
        this.mChannelCore = ICoreManagerBase.getChannelLinkCore();
    }

    private void initView(Context context) {
        View mRootView = LayoutInflater.from((Context)context).inflate(R.layout.layout_mic_speak_view, null);
        this.portraitMicPicIv = (ImageView)mRootView.findViewById(R.id.iv_portrait_mic_pic);
        this.horizontalMicPicIv = (ImageView)mRootView.findViewById(R.id.iv_horizontal_mic_pic);
        this.addView(mRootView);
        this.isLandscape = this.getResources().getConfiguration().orientation == 2;
        this.portraitMicPicIv.setVisibility(this.isLandscape ? 8 : 0);
        this.horizontalMicPicIv.setVisibility(this.isLandscape ? 0 : 8);
        this.portraitMicPicIv.setOnClickListener((View.OnClickListener)this);
        this.horizontalMicPicIv.setOnClickListener((View.OnClickListener)this);
        this.isViewShow();
    }

    public void onEventBind() {
        if (this.mMicSpeakViewSniperEventBinder == null) {
            this.mMicSpeakViewSniperEventBinder = new MicSpeakView$$EventBinder();
        }
        this.mMicSpeakViewSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mMicSpeakViewSniperEventBinder != null) {
            this.mMicSpeakViewSniperEventBinder.unBindEvent();
        }
    }

    private ChannelInfo.ChannelMode getChannelMode() {
        ChannelInfo mChannelInfo = this.mChannelCore.getCurrentChannelInfo();
        if (mChannelInfo != null) {
            MLog.info((Object)TAG, (String)"#getChannelMode channelMode = %s", (Object[])new Object[]{mChannelInfo.channelMode});
        }
        if (mChannelInfo != null && mChannelInfo.channelMode != null) {
            return mChannelInfo.channelMode;
        }
        return ChannelInfo.ChannelMode.MicQueue_Mode;
    }

    private void channelMicStatusClick() {
        if (!this.mChannelCore.isOpenMic()) {
            this.channelMicOpen();
        } else {
            this.channelMicClose();
        }
    }

    private void channelMicOpen() {
        if (!this.mChannelCore.isOpenMic()) {
            if (this.mChannelCore.getCurrentChannelInfo().isGuestLimited && this.mChannelCore.getCurrentChannelInfo().forbidGuestVoice && this.isChannelGuest()) {
                Toast.makeText((Context)this.getContext(), (CharSequence)this.getContext().getString(R.string.str_channel_cannot_speak), (int)0).show();
            } else if (this.mChannelCore.getCurrentChannelLoginUserPowerInfo().disableVoice) {
                Toast.makeText((Context)this.getContext(), (CharSequence)this.getContext().getString(R.string.str_channel_andmin_cannot_speak), (int)0).show();
            } else {
                AnimationDrawable horizontalDrawable;
                if (!MobilePhoneAccessUtils.isRecord_Audio((Activity)((Activity)this.getContext()))) {
                    SuccessAndFailToast.show((Context)this.getContext(), (String)this.getResources().getString(R.string.str_perssion_tip), (int)80, (int)0, (int)DimenConverter.dip2px((Context)this.getContext(), (float)50.0f), (boolean)true);
                    return;
                }
                if (this.mChannelCore.isChannelPOLICE()) {
                    SuccessAndFailToast.show((Context)this.getContext(), (String)this.getResources().getString(R.string.str_forbid_send_with_userInfo_channelPolice), (int)80, (int)0, (int)DimenConverter.dip2px((Context)this.getContext(), (float)50.0f), (boolean)true);
                    return;
                }
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "FreeSchemaSpeakerSize");
                AnimationDrawable portraitDrawable = (AnimationDrawable)this.getResources().getDrawable(R.drawable.mic_freedom_speak_portrait_anim);
                if (portraitDrawable != null) {
                    this.portraitMicPicIv.setImageDrawable((Drawable)portraitDrawable);
                    portraitDrawable.start();
                }
                if ((horizontalDrawable = (AnimationDrawable)this.getResources().getDrawable(R.drawable.mic_speak_anim)) != null) {
                    this.horizontalMicPicIv.setImageDrawable((Drawable)horizontalDrawable);
                    horizontalDrawable.start();
                }
                Toast.makeText((Context)this.getContext(), (CharSequence)this.getContext().getString(R.string.str_channel_open_mic), (int)0).show();
            }
        }
    }

    private void channelMicClose() {
        if (this.mChannelCore.isOpenMic()) {
            if (this.mChannelCore.getCurrentChannelInfo().isGuestLimited && this.mChannelCore.getCurrentChannelInfo().forbidGuestVoice && this.isChannelGuest()) {
                Toast.makeText((Context)this.getContext(), (CharSequence)this.getContext().getString(R.string.str_channel_cannot_speak), (int)0).show();
            } else if (this.mChannelCore.getCurrentChannelLoginUserPowerInfo().disableVoice) {
                Toast.makeText((Context)this.getContext(), (CharSequence)this.getContext().getString(R.string.str_channel_andmin_cannot_speak), (int)0).show();
            } else {
                Toast.makeText((Context)this.getContext(), (CharSequence)this.getContext().getString(R.string.str_channel_close_mic), (int)0).show();
            }
        }
        this.portraitMicPicIv.setImageResource(R.drawable.mic_speak_icon_freedom_portrait);
        this.horizontalMicPicIv.setImageResource(R.drawable.mic_freedom_and_admin_selector);
    }

    private boolean isChannelGuest() {
        return this.mChannelCore.getCurrentChannelLoginUserPowerInfo().isChannelGuest(this.mChannelCore.getCurrentChannelInfo().topSid, this.mChannelCore.getCurrentChannelInfo().subSid);
    }

    public void onClick(View view) {
        int i = view.getId();
        if (i == R.id.iv_portrait_mic_pic || i == R.id.iv_horizontal_mic_pic) {
            if (!this.checkNetToast()) {
                return;
            }
            if (!LoginUtil.isLogined()) {
                ((BaseFragmentApi)CoreApiManager.getInstance().getApi(BaseFragmentApi.class)).showLoginDialog((Activity)this.getContext());
            } else {
                this.channelMicStatusClick();
            }
        }
    }

    public boolean isNetworkAvailable() {
        return NetworkUtils.isNetworkStrictlyAvailable((Context)this.getContext());
    }

    public boolean checkNetToast() {
        boolean falg = this.isNetworkAvailable();
        if (!this.isOnDestory && !falg && this.getContext() != null) {
            Toast.makeText((Context)this.getContext(), (int)R.string.str_network_not_capable, (int)0).show();
        }
        return falg;
    }

    @BusEvent(sync=true)
    public void disableVoice(IChannelVoiceClient_disableVoice_EventArgs busEventArgs) {
        long topSid = busEventArgs.getTopSid();
        long subSid = busEventArgs.getSubSid();
        long uid = busEventArgs.getUid();
        MLog.info((Object)TAG, (String)"#disableVoice topSid = %d, subSid = %d, uid = %d", (Object[])new Object[]{topSid, subSid, uid});
        boolean disableVoice = busEventArgs.getDisableVoice();
        if (this.getChannelMode() == ChannelInfo.ChannelMode.Free_Mode && this.mChannelCore.isOpenMic() && uid == LoginUtil.getUid() && !disableVoice) {
            this.channelMicClose();
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.isLandscape = newConfig.orientation == 2;
        this.horizontalMicPicIv.setVisibility(this.isLandscape ? 0 : 8);
        this.portraitMicPicIv.setVisibility(this.isLandscape ? 8 : 0);
        if (this.isLandscape && this.mChannelCore.isOpenMic()) {
            AnimationDrawable horizontalDrawable = (AnimationDrawable)this.getResources().getDrawable(R.drawable.mic_speak_anim);
            if (horizontalDrawable != null && !horizontalDrawable.isRunning()) {
                this.horizontalMicPicIv.setImageDrawable((Drawable)horizontalDrawable);
                horizontalDrawable.start();
            }
        } else if (!this.isLandscape && this.mChannelCore.isOpenMic()) {
            AnimationDrawable portraitDrawable = (AnimationDrawable)this.getResources().getDrawable(R.drawable.mic_freedom_speak_portrait_anim);
            if (portraitDrawable != null && !portraitDrawable.isRunning()) {
                this.portraitMicPicIv.setImageDrawable((Drawable)portraitDrawable);
                portraitDrawable.start();
            }
        } else {
            this.portraitMicPicIv.setImageResource(R.drawable.mic_speak_icon_freedom_portrait);
            this.horizontalMicPicIv.setImageResource(R.drawable.mic_freedom_and_admin_selector);
        }
    }

    @BusEvent
    public void updateCurrentChannelInfo(IChannelLinkClient_updateCurrentChannelInfo_EventArgs busEventArgs) {
        MLog.info((Object)TAG, (String)"#updateCurrentChannelInfo", (Object[])new Object[0]);
        ChannelInfo info = busEventArgs.getChannelInfo();
        if (this.mChannelCore.getChannelState() == ChannelState.In_Channel && this.getChannelMode() == ChannelInfo.ChannelMode.Free_Mode) {
            if (this.getChannelMode() == ChannelInfo.ChannelMode.Free_Mode && info != null && info.isGuestLimited && info.forbidGuestVoice && this.isChannelGuest()) {
                this.channelMicClose();
            } else if (this.getChannelMode() == ChannelInfo.ChannelMode.Free_Mode) {
                this.channelMicStatusShow();
            }
        }
        this.isViewShow();
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive")
    public void notifyCurrentChannelMode(IChannelModeClient_notifyCurrentChannelMode_EventArgs busEventArgs) {
        MLog.info((Object)TAG, (String)"#notifyCurrentChannelMode", (Object[])new Object[0]);
        ArrayList channelModeList = busEventArgs.mChannelModeList;
        if (channelModeList != null && channelModeList.size() > 0) {
            for (int i = 0; i < channelModeList.size(); ++i) {
                if (!((ChannelInfo.ChannelMode)channelModeList.get(i)).equals((Object)ChannelInfo.ChannelMode.Free_Mode) && (!((ChannelInfo.ChannelMode)channelModeList.get(i)).equals((Object)ChannelInfo.ChannelMode.ADMIN_Mode) || !IChatEmotionCoreImpl.isMobileChannelManager())) continue;
                MLog.info((Object)TAG, (String)"#notifyCurrentChannelMode cur channel is free mode or channel manager in admin mode", (Object[])new Object[0]);
                this.setVisibility(0);
                return;
            }
            this.setVisibility(8);
        }
    }

    @BusEvent(sync=true)
    public void onJoinChannelSuccess(IChannelLinkClient_onJoinChannelSuccess_EventArgs busEventArgs) {
        MLog.info((Object)TAG, (String)"#onJoinChannelSuccess", (Object[])new Object[0]);
        this.isViewShow();
    }

    @BusEvent(sync=true)
    public void onChannelRolesChange(IChannelLinkClient_onChannelRolesChange_EventArgs busEventArgs) {
        boolean isChannelManager;
        if (busEventArgs == null) {
            return;
        }
        int role = 0;
        long mUid = 0L;
        if (busEventArgs != null && busEventArgs.getRole() != null) {
            role = busEventArgs.getRole().role;
            mUid = busEventArgs.getUid();
        }
        boolean isCurrentUid = mUid == LoginUtil.getUid();
        MLog.info((Object)TAG, (String)"#onChannelRolesChange role = %d, isCurrentUid = %s", (Object[])new Object[]{role, isCurrentUid});
        boolean bl = isChannelManager = role >= 150;
        if (isCurrentUid) {
            this.isViewShowByRolesChange(isChannelManager);
        }
    }

    public void isViewShow() {
        if (this.mChannelCore == null) {
            return;
        }
        if (this.mChannelCore.getChannelState() == ChannelState.In_Channel) {
            if (this.getChannelMode() == ChannelInfo.ChannelMode.Free_Mode) {
                MLog.info((Object)TAG, (String)"#initView cur channel is free mode", (Object[])new Object[0]);
                this.setVisibility(0);
            } else if (this.getChannelMode() == ChannelInfo.ChannelMode.ADMIN_Mode) {
                boolean isChannelManager = IChatEmotionCoreImpl.isMobileChannelAdmin();
                MLog.info((Object)TAG, (String)"#initView cur channel is admin mode isChannelManager = %s", (Object[])new Object[]{isChannelManager});
                this.setVisibility(isChannelManager ? 0 : 8);
            } else {
                MLog.info((Object)TAG, (String)"#initView cur channel is micqueue mode", (Object[])new Object[0]);
                this.setVisibility(8);
            }
        } else {
            MLog.info((Object)TAG, (String)"#initView not in channel", (Object[])new Object[0]);
            this.setVisibility(8);
        }
    }

    public void isViewShowByRolesChange(boolean isChannelManager) {
        if (this.mChannelCore == null) {
            return;
        }
        if (this.mChannelCore.getChannelState() == ChannelState.In_Channel) {
            if (this.getChannelMode() == ChannelInfo.ChannelMode.Free_Mode) {
                MLog.info((Object)TAG, (String)"#initView cur channel is free mode", (Object[])new Object[0]);
                this.setVisibility(0);
            } else if (this.getChannelMode() == ChannelInfo.ChannelMode.ADMIN_Mode) {
                MLog.info((Object)TAG, (String)"#initView cur channel is admin mode isChannelManager = %s", (Object[])new Object[]{isChannelManager});
                this.setVisibility(isChannelManager ? 0 : 8);
            } else {
                MLog.info((Object)TAG, (String)"#initView cur channel is micqueue mode", (Object[])new Object[0]);
                this.setVisibility(8);
            }
        } else {
            MLog.info((Object)TAG, (String)"#initView not in channel", (Object[])new Object[0]);
            this.setVisibility(8);
        }
    }

    private void channelMicStatusShow() {
        if (this.mChannelCore.isOpenMic()) {
            AnimationDrawable horizontalDrawable;
            AnimationDrawable portraitDrawable = (AnimationDrawable)this.getResources().getDrawable(R.drawable.mic_freedom_speak_portrait_anim);
            if (portraitDrawable != null) {
                this.portraitMicPicIv.setImageDrawable((Drawable)portraitDrawable);
                portraitDrawable.start();
            }
            if ((horizontalDrawable = (AnimationDrawable)this.getResources().getDrawable(R.drawable.mic_speak_anim)) != null) {
                this.horizontalMicPicIv.setImageDrawable((Drawable)horizontalDrawable);
                horizontalDrawable.start();
            }
        } else {
            this.portraitMicPicIv.setImageResource(R.drawable.mic_speak_icon_freedom_portrait);
            this.horizontalMicPicIv.setImageResource(R.drawable.mic_freedom_and_admin_selector);
        }
    }

    public void onUnBind() {
        this.isOnDestory = true;
        this.mChannelCore = null;
        this.onEventUnBind();
    }
}

