/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.publicchat.model.medal;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.SpannableStringBuilder;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.liveapi.ChannelLinkApi;
import com.yy.mobile.ui.publicchat.model.medal.LiveRoomLoadDrawableWrapper;
import com.yy.mobile.ui.publicchat.model.medal.utils.MedalMarginUtils;
import com.yy.mobile.ui.utils.CheckIndexUtils;
import com.yy.mobile.ui.widget.CustomImageSpan;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.channel.ChatMedalInfo;

public class CommonMedalModel {
    public static SpannableStringBuilder getSpannable(Context context, SpannableStringBuilder spannable, ChannelMessage message) {
        String text = spannable.toString();
        for (ChatMedalInfo medal : message.commonMedals) {
            if (medal == null) continue;
            String imgKey = medal.imgKey;
            int imgId = ((ChannelLinkApi)CoreApiManager.getInstance().getApi(ChannelLinkApi.class)).getChatMedalImgId(imgKey);
            imgKey = "[" + imgKey + "]";
            Drawable drawable2 = LiveRoomLoadDrawableWrapper.INSTANCE.getDrawableWithCache(BasicConfig.getInstance().getAppContext(), imgId);
            int startIdx = text.indexOf(imgKey);
            int endIdx = startIdx + imgKey.length();
            if (startIdx < 0) continue;
            if (drawable2 != null && CheckIndexUtils.isSafeRange(startIdx, endIdx, spannable.length())) {
                drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
                int marginLeft = MedalMarginUtils.getMedalMarginLeft(text, startIdx);
                int marginRight = MedalMarginUtils.getMedalMarginRight(text, startIdx + imgKey.length());
                spannable.setSpan((Object)new CustomImageSpan(drawable2, 2, ResolutionUtils.convertDpToPixel((float)marginLeft, (Context)context), ResolutionUtils.convertDpToPixel((float)marginRight, (Context)context)), startIdx, endIdx, 33);
                continue;
            }
            spannable.replace(startIdx, endIdx, (CharSequence)"");
            if (message.medals.length() >= endIdx) {
                message.medals.replace(startIdx, endIdx, "");
            }
            message.text = message.text.replace(imgKey, "");
        }
        return spannable;
    }
}

