/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.plugins;

import android.os.Bundle;
import android.view.View;
import android.widget.RelativeLayout;
import com.yy.live.module.giftdanmu.LiveDanMuUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.ui.basicfunction.danmu.filter.DanMuCommentFilter;
import com.yy.mobile.ui.basicgunview.BaseDanMuComponent;
import com.yy.mobile.ui.basicgunview.danmucanvas.view.DanmuViewCanvas;
import com.yy.mobile.ui.publicchat.EnterChannelMessage;
import com.yy.mobile.ui.publicchat.MergeChannelMessage;
import com.yy.mobile.ui.publicchat.PublicChatController;
import com.yy.mobile.ui.publicchat.model.IPublicChatViewListener;
import com.yy.mobile.ui.publicchat.model.PublicChatBaseModel;
import com.yy.mobile.ui.publicchat.model.PublicChatLiveModel;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.channel.NoticeMessage;
import com.yymobile.core.gift.GiftChannelMessage;
import java.util.List;

public class PluginsDanMuComponent
extends BaseDanMuComponent {
    private static final String TAG = "PluginsDanMuComponent";
    private static final String KEY_BACKRES = "key_backlres";
    private static final String KEY_HEIGHT = "key_height";
    private static final String KEY_WIDTH = "key_width";
    private PublicChatBaseModel publicChatModel;
    private PublicChatController mController;
    private ChannelMessage lastChannelMessage = null;
    private IPublicChatViewListener publicChatViewListener = new IPublicChatViewListener(){

        @Override
        public void onMeasureUILocation(boolean chatInputSwitch) {
        }

        @Override
        public void onSetChatListLayoutParams(boolean chatInputSwitch) {
        }

        @Override
        public void onSetSmallChatListLayoutParams(boolean chatInputSwitch, int width) {
        }

        @Override
        public int onGetLayoutWidth(boolean chatInputSwitch) {
            return 0;
        }

        @Override
        public void onSetChatData(List<ChannelMessage> data) {
            boolean found = false;
            for (ChannelMessage tempMsg : data) {
                if (found) {
                    PluginsDanMuComponent.this.appendDamMu(tempMsg);
                    continue;
                }
                if (PluginsDanMuComponent.this.lastChannelMessage != tempMsg) continue;
                found = true;
            }
            if (!found) {
                for (ChannelMessage message : data) {
                    PluginsDanMuComponent.this.appendDamMu(message);
                }
            }
        }

        @Override
        public void onUpdateGiftDrawable(GiftChannelMessage msg) {
        }

        @Override
        public void onUpdateMergeMessage(MergeChannelMessage msg) {
        }

        @Override
        public void onUpdateLayoutParams(RelativeLayout.LayoutParams params) {
        }
    };

    public static PluginsDanMuComponent newInstance(int bacRes) {
        return PluginsDanMuComponent.newInstance(bacRes, -1);
    }

    public static PluginsDanMuComponent newInstance(int bacRes, int height) {
        return PluginsDanMuComponent.newInstance(bacRes, height, -1);
    }

    public static PluginsDanMuComponent newInstance(int backRes, int height, int width) {
        Bundle args = new Bundle();
        args.putInt(KEY_BACKRES, backRes);
        args.putInt(KEY_HEIGHT, height);
        args.putInt(KEY_WIDTH, width);
        PluginsDanMuComponent fragment = new PluginsDanMuComponent();
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    protected void doBgShow(boolean show) {
    }

    @Override
    protected void onLandscape() {
        LiveDanMuUtil.getInstance().open(false);
    }

    @Override
    protected boolean doSuperJoinChannelSuccess() {
        return true;
    }

    @Override
    protected void initJoinChannelSuccess() {
        if (this.shouldDanmuShow()) {
            LiveDanMuUtil.getInstance().open(true);
        }
        LiveDanMuUtil.getInstance().setSurfaceView(this.isSurfaceView);
        LiveDanMuUtil.getInstance().setDanmuView(this.tanmuView);
        this.tanmuView.queryDanmuOpenStatus(LiveDanMuUtil.getInstance().getDanmuOpenStatus(1));
    }

    @Override
    protected boolean isReplayDanmuConfig() {
        return false;
    }

    @Override
    protected void initDanmuParameter() {
        if (this.tanmuView != null) {
            this.tanmuView.setScreenWidth(this.totalWidth);
            this.tanmuView.setLineSpace(0);
            this.tanmuView.setSpeed(60.0f);
            this.tanmuView.setDrawTime(4000);
            this.tanmuView.setOnClickListener(null);
            this.tanmuView.setLines(2);
            this.setDanmuViewLayoutForShowView();
        }
    }

    @Override
    public void initView() {
        LiveDanMuUtil.getInstance().setSurfaceView(this.isSurfaceView);
        LiveDanMuUtil.getInstance().setDanmuView(this.tanmuView);
        if (this.shouldDanmuShow()) {
            LiveDanMuUtil.getInstance().open(true);
            LiveDanMuUtil.getInstance().setDanmuEnabled(true);
            DanMuCommentFilter.INSTANCE.setCanFilterUserInfo(false);
        } else {
            LiveDanMuUtil.getInstance().open(false);
            LiveDanMuUtil.getInstance().setDanmuEnabled(false);
            LiveDanMuUtil.getInstance().setDanmuEnabled(false);
        }
        LiveDanMuUtil.getInstance().setIgnoreOrientation(true);
        LiveDanMuUtil.getInstance().setDanmuTextSize(14);
        this.tanmuView.queryDanmuOpenStatus(LiveDanMuUtil.getInstance().getDanmuOpenStatus(1));
        if (this.tanmuView instanceof View) {
            View view = (View)this.tanmuView;
            view.setBackgroundResource(17170445);
        }
    }

    @Override
    protected void setDanmuViewLayoutForShowView() {
        if (this.tanmuView != null) {
            this.tanmuView.showView(this.rootView, this.getDanMuViewLayoutParams());
        }
    }

    @Override
    protected boolean shouldDanmuShow() {
        return true;
    }

    @Override
    protected void onPortrait() {
        LiveDanMuUtil.getInstance().open(true);
        LiveDanMuUtil.getInstance().setDanmuEnabled(true);
        LiveDanMuUtil.getInstance().setDanmuEnabled(true);
    }

    @Override
    protected RelativeLayout.LayoutParams getDanMuViewLayoutParams() {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        return params;
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        LiveDanMuUtil.getInstance().setSurfaceView(false);
        LiveDanMuUtil.getInstance().open(false);
        LiveDanMuUtil.getInstance().stopDanmu();
        LiveDanMuUtil.getInstance().setDanmuView(null);
        LiveDanMuUtil.getInstance().clear();
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.publicChatModel == null) {
            this.publicChatModel = new PublicChatLiveModel();
        }
        if (this.mController == null) {
            this.mController = new PublicChatController(this.publicChatModel);
        }
        this.mController.init(this.getContext());
        this.mController.setPublicChatViewListener(this.publicChatViewListener);
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (this.mController != null) {
            this.mController.resetMessage();
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (this.mController != null) {
            this.mController.onDispose();
        }
    }

    private void appendDamMu(ChannelMessage message) {
        if (!(message instanceof NoticeMessage || message instanceof EnterChannelMessage || message instanceof MergeChannelMessage)) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"aa", (String)("appendDamMu: " + message.getClass().getName() + ", " + message), (Object[])new Object[0]);
            }
            LiveDanMuUtil.getInstance().appendSpannableDanMu(message, BasicConfig.getInstance().getAppContext());
        }
        this.lastChannelMessage = message;
    }

    @Override
    protected void initDanmuView() {
        this.tanmuView = new DanmuViewCanvas(this.getContext());
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.shouldDanmuShow()) {
            LiveDanMuUtil.getInstance().open(true);
            LiveDanMuUtil.getInstance().setDanmuEnabled(true);
            DanMuCommentFilter.INSTANCE.setCanFilterUserInfo(false);
        } else {
            LiveDanMuUtil.getInstance().open(false);
            LiveDanMuUtil.getInstance().setDanmuEnabled(false);
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        LiveDanMuUtil.getInstance().open(false);
        LiveDanMuUtil.getInstance().stopDanmu();
    }
}

