/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.mobilelive;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.yy.mobile.util.activity.YYActivityManager;
import com.yy.mobile.util.log.MLog;

public enum MobileLiveLeaveManager {
    INSTANCE;

    private static final String TAG = "MobileLiveLeaveManager";
    private Intent lastLeaveIntent;
    private Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            MLog.info((Object)MobileLiveLeaveManager.TAG, (String)("onActivityCreated() called with: activity = [" + activity + "], savedInstanceState = [" + savedInstanceState + "]"), (Object[])new Object[0]);
            if (MobileLiveLeaveManager.this.lastLeaveIntent != null && activity.getClass().getName().equals(MobileLiveLeaveManager.this.lastLeaveIntent.getComponent().getClassName())) {
                MobileLiveLeaveManager.this.setLeaveIntent(null);
            }
        }

        public void onActivityStarted(Activity activity) {
            MLog.info((Object)MobileLiveLeaveManager.TAG, (String)("onActivityStarted() called with: activity = [" + activity + "]"), (Object[])new Object[0]);
            if (MobileLiveLeaveManager.this.lastLeaveIntent != null && !activity.getClass().getName().equals(MobileLiveLeaveManager.this.lastLeaveIntent.getComponent().getClassName())) {
                activity.startActivity(MobileLiveLeaveManager.this.lastLeaveIntent.setComponent(new ComponentName((Context)activity, MobileLiveLeaveManager.this.lastLeaveIntent.getComponent().getClassName())));
                MobileLiveLeaveManager.this.setLeaveIntent(null);
            }
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
        }
    };

    public void setLeaveIntent(Intent leaveIntent) {
        MLog.info((Object)TAG, (String)("setLeaveIntent() called with: leaveIntent = [" + leaveIntent + "]"), (Object[])new Object[0]);
        this.lastLeaveIntent = leaveIntent;
        YYActivityManager.INSTANCE.unregisterActivityLifecycleCallbacks(this.activityLifecycleCallbacks);
        if (this.lastLeaveIntent != null) {
            YYActivityManager.INSTANCE.registerActivityLifecycleCallbacks(this.activityLifecycleCallbacks);
        }
    }
}

