/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.mobilelive;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentTransaction;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.duowan.mobile.basemedia.watchlive.template.ComponentRoot;
import com.duowan.mobile.basemedia.watchlive.template.generate.ComponentsFactory;
import com.duowan.mobile.basemedia.watchlive.template.generate.ComponentsMaker;
import com.duowan.mobile.entlive.ComponentsFactoryIpml_pluginunionlive;
import com.unionyy.mobile.spdt.annotation.SpdtSkin;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.imageloader.transform.YYBitmapTransformation;
import com.yy.mobile.imageloader.transform.YYBlurBitmapTransformation;
import com.yy.mobile.plugin.main.events.IBasicFunctionClient_onShowScreenElementsView_EventArgs;
import com.yy.mobile.plugin.main.events.IMobileLiveClient_onGetLiveSetRecord_EventArgs;
import com.yy.mobile.plugin.main.events.IPublicChatBroadcastClient_onTouchPublicChat_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.IComponentContainer;
import com.yy.mobile.ui.basicchanneltemplate.component.IComponentRoot;
import com.yy.mobile.ui.basicfunction.uicore.IBasicFunctionCore;
import com.yy.mobile.ui.mobilelive.BaseReplayActivity;
import com.yy.mobile.ui.mobilelive.MobileLiveReplayActivity$$EventBinder;
import com.yy.mobile.ui.mobilelive.ReplayControlFragment;
import com.yy.mobile.ui.mobilelive.ReplayVideoFragment;
import com.yy.mobile.ui.mobilelive.replay.ReplayControlComponentBehavior;
import com.yy.mobile.ui.mobilelive.replay.bean.event.HideLoadingViewEvent;
import com.yy.mobile.ui.mobilelive.replay.bean.event.ReplayControlFragment_onClickClose_EventArgs;
import com.yy.mobile.ui.mobilelive.replay.bean.event.ReplayVideoFragment_UpdateEventArgs;
import com.yy.mobile.ui.mobilelive.replay.bean.event.ReplayVideoFragment_VideoAreaClick_EventArgs;
import com.yy.mobile.ui.mobilelive.replay.uicore.ReplayContainer;
import com.yy.mobile.ui.plugincenter.PluginPropertyFactory;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.ui.widget.TouchInterceptRelativeLayout;
import com.yy.mobile.ui.widget.swipeloadingview.OnSwipeListener;
import com.yy.mobile.ui.widget.swipeloadingview.SwipeDetectorView;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.ent.DefaultEntRetryPolicy;
import com.yymobile.core.ent.EntRetryPolicy;
import com.yymobile.core.ent.protos.IEntProtocol;
import com.yymobile.core.mobilelive.IMobileLiveReplayCore;
import com.yymobile.core.mobilelive.MobileLiveProtocol;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import com.yymobile.core.uicore.ITouchCore;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

@SpdtSkin
public class MobileLiveReplayActivity
extends BaseReplayActivity
implements OnSwipeListener,
View.OnClickListener,
ReplayControlFragment.ReplayControlFragmentEvents {
    private static final String TAG = "MobileLiveReplayActivity";
    public static final String DATA_REPLAY_TYPE = "data_replay_type";
    private IComponentRoot mCurrentTemplate;
    private boolean mHasClearCurrentTemplate;
    protected String mReplayId;
    private String mImgUrl;
    private String mPlayUrl;
    private int mReplayType = 0;
    protected long mUid;
    private RecycleImageView ivBackground;
    private long mIhiidoWatchReplayStartTime = 0L;
    private RelativeLayout mRlLoadLiveStreamLayout;
    private SwipeDetectorView mSwipeDetectorView;
    private ImageView imgShowScreenElements;
    private int mOrientation;
    private boolean mHideSwipe = false;
    private boolean ismHideSwipe = false;
    private ComponentsMaker mComponentsMaker;
    private ObjectAnimator animator;
    private Disposable disposable;
    ReplayVideoFragment mVideoFragment;
    private EventBinder mMobileLiveReplayActivitySniperEventBinder;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        this.getWindow().addFlags(128);
        super.onCreate(savedInstanceState);
        if (!this.sdkInitStatus.get()) {
            return;
        }
        this.mIhiidoWatchReplayStartTime = System.currentTimeMillis();
        this.getWindow().setBackgroundDrawable(null);
        this.mComponentsMaker = new ComponentsMaker((ComponentsFactory)new ComponentsFactoryIpml_pluginunionlive());
        this.mSwipeDetectorView = (SwipeDetectorView)this.findViewById(R.id.swipe_loading);
        this.initData();
        this.imgShowScreenElements = (ImageView)this.findViewById(R.id.img_show_screen_elements);
        this.imgShowScreenElements.setOnClickListener((View.OnClickListener)this);
        this.mRlLoadLiveStreamLayout = (RelativeLayout)this.findViewById(R.id.rl_load_live_stream);
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("mRlLoadLiveStreamLayout = " + this.mRlLoadLiveStreamLayout.toString()), (Object[])new Object[0]);
        }
        this.setupGradientBackground();
        this.initSwipeDetectorView();
    }

    private void initPluginProperty() {
        PluginPropertyFactory.getInstance().initDefault();
    }

    private void initTemplate() {
        this.initPluginProperty();
        ComponentRoot template = new ComponentRoot((FragmentActivity)this, this.mComponentsMaker);
        template.applyContainer(R.id.channel_template, (IComponentContainer)new ReplayContainer());
        this.mCurrentTemplate = template;
    }

    private void setupGradientBackground() {
        int[] colors = new int[]{-11184811, -15066598};
        GradientDrawable drawable2 = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, colors);
        drawable2.setGradientType(1);
        float px = ImageConfig.fullImageConfig().getImagePrecision().getWidth();
        drawable2.setGradientRadius(px);
        if (Build.VERSION.SDK_INT >= 16) {
            this.mRlLoadLiveStreamLayout.setBackground((Drawable)drawable2);
        } else {
            this.mRlLoadLiveStreamLayout.setBackgroundDrawable((Drawable)drawable2);
        }
    }

    public void initData() {
        this.mHasClearCurrentTemplate = false;
        Intent intent = this.getIntent();
        if (intent != null) {
            this.mReplayId = this.getIntent().getStringExtra("data_replay_id");
            this.mPlayUrl = this.getIntent().getStringExtra("data_replay_url");
            this.mImgUrl = this.getIntent().getStringExtra("data_replay_imgurl");
            this.mUid = this.getIntent().getLongExtra("data_replay_uid", 0L);
            this.mReplayType = this.getIntent().getIntExtra(DATA_REPLAY_TYPE, 0);
            ((IMobileLiveReplayCore)ICoreManagerBase.getCore(IMobileLiveReplayCore.class)).setReplayType(this.mReplayType);
            MLog.info((Object)TAG, (String)("MobileLiveReplayActivity mReplayId=" + this.mReplayId + " uid=" + this.mUid + " mPlayUrl=" + this.mPlayUrl + " mImgUrl=" + this.mImgUrl + " , mReplayType = " + this.mReplayType), (Object[])new Object[0]);
            if (this.mReplayId == null || this.mReplayId.length() <= 0 || this.mUid <= 0L) {
                this.finish();
                return;
            }
        } else {
            this.finish();
            return;
        }
        this.initTemplate();
        this.findViewById(R.id.btn_leave_mobile_live_loading).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MobileLiveReplayActivity.this.finish();
            }
        });
        this.queryLiveSetRecord(this.mReplayId);
    }

    protected void queryLiveSetRecord(String replayId) {
        if (!NetworkUtils.isNetworkAvailable((Context)this)) {
            Toast.makeText((Context)this, (CharSequence)"\u7f51\u7edc\u4e0d\u7ed9\u529b", (int)0).show();
            return;
        }
        MobileLiveProtocol.QueryLiveSetRecordReq req = new MobileLiveProtocol.QueryLiveSetRecordReq();
        req.programId = replayId;
        if (this.disposable != null) {
            this.disposable.dispose();
        }
        this.disposable = ICoreManagerBase.getEntCore().sendAsFlowable(MobileLiveProtocol.QueryLiveSetRecordRsp.class, (IEntProtocol)req, (EntRetryPolicy)new DefaultEntRetryPolicy(5000, 0, 0.5f, false)).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<MobileLiveProtocol.QueryLiveSetRecordRsp>(){

            public void accept(MobileLiveProtocol.QueryLiveSetRecordRsp rsp) throws Exception {
                MobileLiveReplayActivity.this.onGetLiveSetRecord(new IMobileLiveClient_onGetLiveSetRecord_EventArgs(rsp.result.intValue(), rsp.recordlist));
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                MobileLiveReplayActivity.this.onGetLiveSetRecord(new IMobileLiveClient_onGetLiveSetRecord_EventArgs(-1, null));
            }
        });
    }

    public View onCreateView(String name, Context context, AttributeSet attrs) {
        return super.onCreateView(name, context, attrs);
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (this.sdkInitStatus.get()) {
            this.setIntent(intent);
            this.initData();
        }
    }

    private int getScreenWidth() {
        int screenWidth = 0;
        if (this.checkActivityValid()) {
            screenWidth = ResolutionUtils.getScreenHeight((Context)this);
        }
        return screenWidth;
    }

    public void configSwipeDetectorView() {
        if (this.mSwipeDetectorView != null) {
            this.mSwipeDetectorView.setOnSwipeListener(this);
            TouchInterceptRelativeLayout dimissLayout = (TouchInterceptRelativeLayout)this.findViewById(R.id.channel_template);
            if (dimissLayout != null) {
                if (((ITouchCore)ICoreManagerBase.getCore(ITouchCore.class)).getClearScreenSate()) {
                    this.mHideSwipe = true;
                    ((ITouchCore)ICoreManagerBase.getCore(ITouchCore.class)).setClearScreenSate(false);
                }
                this.mSwipeDetectorView.setmTranslateView((View)dimissLayout);
            }
        }
    }

    public void initSwipeDetectorView() {
        this.mSwipeDetectorView.setWorkingMode(2);
        this.mSwipeDetectorView.setMinimumLandScapeThreshold(this.getScreenWidth() / 10);
        this.mSwipeDetectorView.setMaximumLandScapeThreshold(this.getScreenWidth() + 100);
        int mTopLimitSwipeHeight = this.getResources().getDimensionPixelSize(R.dimen.basic_func_program_info_height);
        this.mOrientation = this.getResources().getConfiguration().orientation;
        if (this.mOrientation == 2) {
            this.mSwipeDetectorView.setBottomLimitSwipeHeight(ResolutionUtils.getScreenHeight((Context)this));
            this.mSwipeDetectorView.setTopLimitSwipeHeight(mTopLimitSwipeHeight / 4);
        } else {
            int mBottomLimitSwipeHeight = ResolutionUtils.getScreenHeight((Context)this) - this.getResources().getDimensionPixelSize(R.dimen.basic_interactive_expand_height);
            this.mSwipeDetectorView.setBottomLimitSwipeHeight(mBottomLimitSwipeHeight);
            this.mSwipeDetectorView.setTopLimitSwipeHeight(mTopLimitSwipeHeight / 3);
        }
        this.configSwipeDetectorView();
    }

    @Override
    public void onSwipeStart(int direction) {
        TouchInterceptRelativeLayout dimissLayout;
        if ((direction == 1 || direction == 3) && (dimissLayout = (TouchInterceptRelativeLayout)this.findViewById(R.id.channel_template)) != null) {
            dimissLayout.setInterceptTouch(false);
        }
    }

    @Override
    public void onSwiping(float swipeRatio, int direction) {
    }

    @Override
    public void onPostSwipe(int direction) {
    }

    @Override
    public void onSwipeFinished(int direction) {
    }

    @Override
    public void onSwipeCanceled(int direction) {
    }

    @Override
    public void onSwipeLandScape(int direction) {
        TouchInterceptRelativeLayout dimissLayout = (TouchInterceptRelativeLayout)this.findViewById(R.id.channel_template);
        if (dimissLayout != null) {
            dimissLayout.setInterceptTouch(false);
            if (direction == 0) {
                this.hideImgShowScreenElements();
                this.ismHideSwipe = false;
                ((ITouchCore)ICoreManagerBase.getCore(ITouchCore.class)).setClearScreenSate(true);
            }
            if (direction == 2) {
                this.ismHideSwipe = true;
                this.showImgShowScreenElements();
                ((ITouchCore)ICoreManagerBase.getCore(ITouchCore.class)).setClearScreenSate(false);
            }
        }
    }

    @Override
    public void setSwipeIntercetpTouch(boolean isIntercept) {
        TouchInterceptRelativeLayout dimissLayout = (TouchInterceptRelativeLayout)this.findViewById(R.id.channel_template);
        if (dimissLayout != null) {
            dimissLayout.setInterceptTouch(isIntercept);
        }
    }

    @Override
    public void onSwipeDistance(float distance) {
    }

    private void showImgShowScreenElements() {
        if (this.imgShowScreenElements != null) {
            this.imgShowScreenElements.setVisibility(0);
        }
    }

    private void hideImgShowScreenElements() {
        if (this.imgShowScreenElements != null) {
            this.imgShowScreenElements.setVisibility(8);
        }
    }

    @BusEvent(sync=true)
    public void onShowScreenElementsView(IBasicFunctionClient_onShowScreenElementsView_EventArgs busEventArgs) {
        TouchInterceptRelativeLayout dimissLayout = (TouchInterceptRelativeLayout)this.findViewById(R.id.channel_template);
        if (dimissLayout != null) {
            if (this.mSwipeDetectorView != null) {
                this.mSwipeDetectorView.setCurrentPosition(0);
            }
            ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)dimissLayout, (String)"translationX", (float[])new float[]{ResolutionUtils.getScreenWidth((Context)this), 0.0f});
            objectAnimator.setDuration(400L);
            objectAnimator.start();
            dimissLayout.setInterceptTouch(false);
        }
        if (this.mSwipeDetectorView != null) {
            this.mSwipeDetectorView.setCurrentPosition(-1);
        }
        this.ismHideSwipe = false;
    }

    public void onClick(View v) {
        if (v == this.imgShowScreenElements) {
            ((IBasicFunctionCore)ICoreManagerBase.getCore(IBasicFunctionCore.class)).showScreenElementsView();
            this.hideImgShowScreenElements();
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive")
    public void receiveVideoAreaClickEventArgs(ReplayVideoFragment_VideoAreaClick_EventArgs event) {
        this.onTouchPublicChat();
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive")
    public void receiveUpdateEventArgs(ReplayVideoFragment_UpdateEventArgs event) {
        if (this.mSwipeDetectorView != null) {
            this.mSwipeDetectorView.setEnableSwipe(true);
            this.mSwipeDetectorView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MobileLiveReplayActivity.this.onTouchPublicChat();
                }
            });
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive")
    public void receiveHideLoadingViewEventArgs(HideLoadingViewEvent event) {
        MLog.info((Object)TAG, (String)"[receiveHideLoadingViewEventArgs]", (Object[])new Object[0]);
        this.hideLodingView();
        if (this.mCurrentTemplate.getComponentBehavior(ReplayControlComponentBehavior.class) != null) {
            ((ReplayControlComponentBehavior)this.mCurrentTemplate.getComponentBehavior(ReplayControlComponentBehavior.class)).updateProgressShowStatus(true);
        }
    }

    private void hideLodingView() {
        if (this.mRlLoadLiveStreamLayout.getVisibility() != 8) {
            this.animator = ObjectAnimator.ofFloat((Object)this.mRlLoadLiveStreamLayout, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
            this.animator.setDuration(500L);
            this.animator.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    MobileLiveReplayActivity.this.mRlLoadLiveStreamLayout.setVisibility(8);
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            this.animator.start();
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive")
    public void receiveVideoAreaClickEventArgs(ReplayControlFragment_onClickClose_EventArgs event) {
        this.clearCurrentTemplate();
    }

    @BusEvent(sync=true)
    public void onTouchPublicChat(IPublicChatBroadcastClient_onTouchPublicChat_EventArgs busEventArgs) {
        this.onTouchPublicChat();
    }

    public void onTouchPublicChat() {
        if (this.mCurrentTemplate != null && !this.ismHideSwipe) {
            if (this.mCurrentTemplate.getComponentBehavior(ReplayControlComponentBehavior.class) != null) {
                ((ReplayControlComponentBehavior)this.mCurrentTemplate.getComponentBehavior(ReplayControlComponentBehavior.class)).changProgressLayoutVisibility();
            }
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"IPublicChatBroadcastClient:onTouchPublicChat ", (Object[])new Object[0]);
            }
        }
    }

    public Boolean onGetLiveSetRecord(IMobileLiveClient_onGetLiveSetRecord_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        List data = busEventArgs.getData();
        MLog.info((Object)TAG, (String)("onGetLiveSetRecord result=" + result + " data=" + data), (Object[])new Object[0]);
        if (!MobileLiveReplayActivity.isForeground()) {
            MLog.info((Object)TAG, (String)"onGetLiveSetRecord isForeground = false", (Object[])new Object[0]);
            return false;
        }
        if (result != 0) {
            SingleToastUtil.showToast((String)"\u7f51\u7edc\u4e0d\u7ed9\u529b");
            this.finish();
            return false;
        }
        if (data == null || data.size() <= 0) {
            SingleToastUtil.showToast((String)"\u8be5\u89c6\u9891\u5df2\u5220\u9664");
            this.finish();
            return false;
        }
        String imgUrl = null;
        imgUrl = this.mImgUrl != null && this.mImgUrl.length() > 0 ? this.mImgUrl : (String)((Map)data.get(0)).get("imageUrl");
        if (imgUrl != null && imgUrl.length() > 0 && this.ivBackground != null) {
            ImageLoader.Builder.obtain((RecycleImageView)this.ivBackground, (String)imgUrl).setTransform(new YYBitmapTransformation[]{new YYBlurBitmapTransformation(20.0f)}).load();
        }
        FragmentTransaction ftmedia = this.getSupportFragmentManager().beginTransaction();
        this.mVideoFragment = ReplayVideoFragment.newInstance(data, imgUrl, this.mReplayId);
        ftmedia.replace(R.id.basic_replay_video_component, (Fragment)this.mVideoFragment, "mobile_replay_video_component");
        ftmedia.commitAllowingStateLoss();
        this.getSupportFragmentManager().executePendingTransactions();
        if (this.mCurrentTemplate.getComponentBehavior(ReplayControlComponentBehavior.class) != null) {
            ((ReplayControlComponentBehavior)this.mCurrentTemplate.getComponentBehavior(ReplayControlComponentBehavior.class)).setVideoPlayComponentProxy(this.mVideoFragment);
        }
        if (data.size() != 0 && ((Map)data.get(0)).containsKey("cid") && ((Map)data.get(0)).containsKey("sid") && ((Map)data.get(0)).containsKey("t_begin")) {
            long tid = Long.valueOf((String)((Map)data.get(0)).get("cid"));
            long sid = Long.valueOf((String)((Map)data.get(0)).get("sid"));
            long startTime = Long.valueOf((String)((Map)data.get(0)).get("t_begin"));
            int protocolType = 0;
            if (((Map)data.get(0)).containsKey("flowflag")) {
                protocolType = Integer.valueOf((String)((Map)data.get(0)).get("flowflag"));
            }
            long viewCount = -1L;
            if (((Map)data.get(0)).containsKey("ex_viewer") && ((Map)data.get(0)).containsKey("ex_record_viewer")) {
                viewCount = Long.valueOf((String)((Map)data.get(0)).get("ex_viewer")) + Long.valueOf((String)((Map)data.get(0)).get("ex_record_viewer"));
            }
            ((IMobileLiveReplayCore)ICoreManagerBase.getCore(IMobileLiveReplayCore.class)).initReplayData(this.mReplayId, tid, sid, startTime, protocolType, viewCount);
            ((IMobileLiveReplayCore)ICoreManagerBase.getCore(IMobileLiveReplayCore.class)).setReplayType(this.mReplayType);
        } else {
            ((IMobileLiveReplayCore)ICoreManagerBase.getCore(IMobileLiveReplayCore.class)).initReplayData(this.mReplayId, 0L, 0L, 0L, 0, -1L);
            ((IMobileLiveReplayCore)ICoreManagerBase.getCore(IMobileLiveReplayCore.class)).setReplayType(this.mReplayType);
        }
        return true;
    }

    @Override
    public void onClickClose() {
        this.clearCurrentTemplate();
    }

    private void clearCurrentTemplate() {
        MLog.info((Object)TAG, (String)"clearCurrentTemplate, mCurrentTemplate is null:%b, mHasClearCurrentTemplate:%b", (Object[])new Object[]{this.mCurrentTemplate == null, this.mHasClearCurrentTemplate});
        if (this.mCurrentTemplate != null && !this.mHasClearCurrentTemplate) {
            this.mCurrentTemplate.clear();
            this.mHasClearCurrentTemplate = true;
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.mHideSwipe) {
            this.mHideSwipe = false;
            ((ITouchCore)ICoreManagerBase.getCore(ITouchCore.class)).setClearScreenSate(false);
        }
        this.clearCurrentTemplate();
        if (this.mIhiidoWatchReplayStartTime > 0L && System.currentTimeMillis() > this.mIhiidoWatchReplayStartTime && ICoreManagerBase.getCore(IHiidoStatisticCore.class) != null) {
            Property property = new Property();
            property.putString("key1", this.mReplayId);
            property.putString("key2", this.mIhiidoWatchReplayStartTime / 1000L + "");
            property.putString("key3", System.currentTimeMillis() / 1000L + "");
            if (this.getIntent().hasExtra("to_mobile_live_replay_path")) {
                property.putString("key4", this.getIntent().getIntExtra("to_mobile_live_replay_path", 0) + "");
            }
            property.putString("key5", String.valueOf(this.mUid));
            ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "50403", "0001", (Serializable)property);
        }
        this.mCurrentTemplate = null;
        if (this.mSwipeDetectorView != null) {
            this.mSwipeDetectorView.onDestroyView();
            this.mSwipeDetectorView = null;
        }
    }

    protected boolean handleStatusBar() {
        return true;
    }

    @Override
    public void onEventBind() {
        super.onEventBind();
        if (this.mMobileLiveReplayActivitySniperEventBinder == null) {
            this.mMobileLiveReplayActivitySniperEventBinder = new MobileLiveReplayActivity$$EventBinder();
        }
        this.mMobileLiveReplayActivitySniperEventBinder.bindEvent((Object)this);
    }

    @Override
    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mMobileLiveReplayActivitySniperEventBinder != null) {
            this.mMobileLiveReplayActivitySniperEventBinder.unBindEvent();
        }
    }
}

