/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gift.widget;

import android.content.Context;
import android.support.v4.view.GestureDetectorCompat;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import com.yy.mobile.util.log.MLog;
import java.lang.reflect.Field;

public class FastScrollViewPager
extends ViewPager {
    private static final String TAG = "FastScrollViewPager";
    FixedSpeedScroller mFixedSpeedScroller = new FixedSpeedScroller(this.getContext());
    private int mScrollDuration = 500;
    private boolean isPagingEnabled = true;
    private GestureDetectorCompat mGestureDetectorCompat = new GestureDetectorCompat(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            float distanceX = e1.getX() - e2.getX();
            if (distanceX > 5.0f) {
                FastScrollViewPager.this.arrowScroll(66);
            } else if (distanceX < -5.0f) {
                FastScrollViewPager.this.arrowScroll(17);
            }
            return false;
        }
    });

    public FastScrollViewPager(Context context) {
        super(context);
        this.fixScrollSpeed();
    }

    public FastScrollViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.fixScrollSpeed();
    }

    public void setPagingEnabled(boolean b) {
        this.isPagingEnabled = b;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        try {
            if (this.isPagingEnabled) {
                return super.onTouchEvent(ev);
            }
        }
        catch (Throwable ex) {
            MLog.error((Object)TAG, (String)("xuwakao, onTouchEvent fix touch viewpager error happens, ev = " + ev), (Object[])new Object[0]);
        }
        return false;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("onInterceptTouchEvent ev = " + ev), (Object[])new Object[0]);
        }
        if (this.isPagingEnabled) {
            try {
                this.mGestureDetectorCompat.onTouchEvent(ev);
            }
            catch (Exception ex) {
                MLog.error((Object)TAG, (String)"onInterceptTouchEvent error", (Throwable)ex, (Object[])new Object[0]);
            }
            return false;
        }
        if (!this.isPagingEnabled && ev.getAction() == 1) {
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((Object)TAG, (String)"isPagingEnabled to true", (Object[])new Object[0]);
            }
            this.isPagingEnabled = true;
        }
        return false;
    }

    public void setScrollDuration(int millis) {
        if (millis >= 0) {
            this.mScrollDuration = millis;
        }
    }

    private void fixScrollSpeed() {
        try {
            Field mScroller = ViewPager.class.getDeclaredField("mScroller");
            mScroller.setAccessible(true);
            mScroller.set((Object)this, (Object)this.mFixedSpeedScroller);
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (String)("fixScrollSpeed error! " + throwable), (Object[])new Object[0]);
        }
    }

    public class FixedSpeedScroller
    extends Scroller {
        public FixedSpeedScroller(Context context) {
            super(context);
        }

        public FixedSpeedScroller(Context context, Interpolator interpolator) {
            super(context, interpolator);
        }

        public void startScroll(int startX, int startY, int dx, int dy, int duration) {
            super.startScroll(startX, startY, dx, dy, FastScrollViewPager.this.mScrollDuration);
        }

        public void startScroll(int startX, int startY, int dx, int dy) {
            super.startScroll(startX, startY, dx, dy, FastScrollViewPager.this.mScrollDuration);
        }
    }
}

