/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gift.hotball;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.graphics.PointF;
import android.os.Build;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.ScaleAnimation;
import android.view.animation.TranslateAnimation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.duowan.mobile.entlive.events.IQueueClient_onExecute_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.main.events.IChannelTurntableClient_onQueryTurnTableGrabChest_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.Temp;
import com.yy.mobile.ui.gift.hotball.Bezier2XEvaluator;
import com.yy.mobile.ui.gift.hotball.HeatBallEffectController$$EventBinder;
import com.yy.mobile.ui.streamlight.EntIdentityIconSet;
import com.yy.mobile.ui.turntable.core.IChannelTurntableCore;
import com.yy.mobile.ui.turntable.info.TurnTableLottoryInfo;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.BaseFragmentApi;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.Proxy.LiveModuleManagerProxy;
import com.yymobile.core.channel.userinterfaceQueue.QueueMessage;
import java.util.List;
import java.util.Map;

public class HeatBallEffectController
implements EventCompat {
    private static final String TAG = "HeatBallEffectController";
    private LinearLayout llSendInfo;
    private ImageView ivTower;
    private ImageView ivLeftCloud;
    private ImageView ivRightCloud;
    private Context mContext;
    private int wBall;
    private int hBall;
    private RelativeLayout rlBall;
    private View layout;
    private TextView ballUserName;
    private TextView tvTip;
    private LinearLayout llBallTextContainer;
    private String nobleLevel;
    private ImageView nobleIcon;
    private RelativeLayout mParent;
    private boolean isLandscape;
    private String baoXiangId;
    private String giftId;
    private View.OnClickListener heatBallOnclickListener = new View.OnClickListener(){

        public void onClick(View view) {
            if (LoginUtil.isLogined()) {
                ((IChannelTurntableCore)ICoreManagerBase.getCore(IChannelTurntableCore.class)).queryTurnTableGrabChest(HeatBallEffectController.this.baoXiangId, HeatBallEffectController.this.giftId);
                HeatBallEffectController.this.layout.setClickable(false);
            } else if (CoreApiManager.getInstance() != null && CoreApiManager.getInstance().getApi(BaseFragmentApi.class) != null) {
                ((BaseFragmentApi)CoreApiManager.getInstance().getApi(BaseFragmentApi.class)).showLoginDialog((Activity)HeatBallEffectController.this.mContext);
            }
        }
    };
    private EventBinder mHeatBallEffectControllerSniperEventBinder;

    public void onEventBind() {
        if (this.mHeatBallEffectControllerSniperEventBinder == null) {
            this.mHeatBallEffectControllerSniperEventBinder = new HeatBallEffectController$$EventBinder();
        }
        this.mHeatBallEffectControllerSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mHeatBallEffectControllerSniperEventBinder != null) {
            this.mHeatBallEffectControllerSniperEventBinder.unBindEvent();
        }
    }

    public HeatBallEffectController(Context ctx, ViewGroup parentView) {
        ICoreManagerBase.addClient((Object)this);
        this.mContext = ctx;
        this.mParent = new RelativeLayout(this.mContext);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, -1);
        this.mParent.setVisibility(8);
        parentView.addView((View)this.mParent, (ViewGroup.LayoutParams)lp);
    }

    private void initViews() {
        this.layout = LayoutInflater.from((Context)this.mContext).inflate(R.layout.heat_ball_layout, null);
        this.layout.setOnClickListener(this.heatBallOnclickListener);
        this.llSendInfo = (LinearLayout)this.layout.findViewById(R.id.ll_send_info);
        this.llBallTextContainer = (LinearLayout)this.layout.findViewById(R.id.ll_ball_text_container);
        this.ivTower = (ImageView)this.layout.findViewById(R.id.iv_tower);
        this.ivLeftCloud = (ImageView)this.layout.findViewById(R.id.iv_left_cloud);
        this.ivRightCloud = (ImageView)this.layout.findViewById(R.id.iv_right_cloud);
        this.rlBall = (RelativeLayout)this.layout.findViewById(R.id.rl_ball);
        this.ballUserName = (TextView)this.layout.findViewById(R.id.ball_user_name);
        this.nobleIcon = (ImageView)this.layout.findViewById(R.id.noble_icon);
        this.tvTip = (TextView)this.layout.findViewById(R.id.tv_tip);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, (int)ResolutionUtils.convertDpToPixel((float)300.0f, (Context)this.mContext));
        lp.addRule(12);
        this.setRootLp();
        this.mParent.addView(this.layout, (ViewGroup.LayoutParams)lp);
    }

    private void show(String fromName, String baoXiangId, String giftId, String noble) {
        if (this.layout == null) {
            return;
        }
        this.baoXiangId = baoXiangId;
        this.giftId = giftId;
        this.nobleLevel = noble;
        this.ballUserName.setText((CharSequence)fromName);
        if (Build.VERSION.SDK_INT >= 17) {
            this.ballUserName.setTextDirection(3);
        }
        this.layout.setVisibility(0);
        this.layout.setAlpha(1.0f);
        if (this.nobleLevel != null && !"".equals(this.nobleLevel) && EntIdentityIconSet.getIconResId((int)Integer.valueOf(this.nobleLevel)) > 0) {
            this.nobleIcon.setImageResource(EntIdentityIconSet.getIconResId((int)Integer.valueOf(this.nobleLevel)));
            this.nobleIcon.setVisibility(0);
        }
        this.tvTip.setText((CharSequence)"\u00d71\uff0c\u6233\u70ed\u6c14\u7403\u62a2\u7ea2\u94bb\uff01");
        this.layout.setClickable(true);
        this.animSendInfoTv();
        this.alphaTowerIv();
        this.animCloud();
        this.animBall();
    }

    private void animSendInfoTv() {
        TranslateAnimation translate = new TranslateAnimation(1, -1.0f, 1, 0.0f, 1, 0.0f, 1, 0.0f);
        translate.setDuration(1000L);
        translate.setFillAfter(true);
        ScaleAnimation scale = new ScaleAnimation(0.98f, 1.0f, 0.98f, 1.0f, 1, 0.5f, 1, 0.5f);
        scale.setRepeatMode(2);
        scale.setRepeatCount(-1);
        scale.setDuration(100L);
        AnimationSet set = new AnimationSet(false);
        set.addAnimation((Animation)translate);
        set.addAnimation((Animation)scale);
        this.llSendInfo.startAnimation((Animation)set);
    }

    private void alphaTowerIv() {
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)this.ivTower, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        alpha.setDuration(4000L);
        alpha.start();
    }

    private void animCloud() {
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)this.ivLeftCloud, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        alpha.setDuration(600L);
        ObjectAnimator translateLeft = ObjectAnimator.ofFloat((Object)this.ivLeftCloud, (String)"translationX", (float[])new float[]{-ResolutionUtils.convertDpToPixel((float)132.0f, (Context)this.mContext), -ResolutionUtils.convertDpToPixel((float)37.0f, (Context)this.mContext)});
        translateLeft.setDuration(8000L);
        ObjectAnimator translateRight = ObjectAnimator.ofFloat((Object)this.ivRightCloud, (String)"translationX", (float[])new float[]{ResolutionUtils.convertDpToPixel((float)264.0f, (Context)this.mContext), 0.0f});
        translateRight.setDuration(8000L);
        translateRight.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{alpha, translateLeft, translateRight});
        set.start();
    }

    private void animBall() {
        AnimatorSet set = new AnimatorSet();
        Bezier2XEvaluator evaluator = new Bezier2XEvaluator(new PointF(ResolutionUtils.convertDpToPixel((float)187.0f, (Context)this.mContext), ResolutionUtils.convertDpToPixel((float)230.0f, (Context)this.mContext)));
        ValueAnimator bezier = ValueAnimator.ofObject((TypeEvaluator)evaluator, (Object[])new Object[]{new PointF(ResolutionUtils.convertDpToPixel((float)70.0f, (Context)this.mContext), ResolutionUtils.convertDpToPixel((float)230.0f, (Context)this.mContext)), new PointF(ResolutionUtils.convertDpToPixel((float)139.0f, (Context)this.mContext), ResolutionUtils.convertDpToPixel((float)96.0f, (Context)this.mContext))});
        bezier.setDuration(2000L);
        this.rlBall.measure(0, 0);
        this.wBall = this.rlBall.getMeasuredWidth();
        this.hBall = this.rlBall.getMeasuredHeight();
        bezier.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                PointF p = (PointF)animation.getAnimatedValue();
                HeatBallEffectController.this.rlBall.setX(p.x - (float)(HeatBallEffectController.this.wBall / 2));
                HeatBallEffectController.this.rlBall.setY(p.y - (float)(HeatBallEffectController.this.hBall / 2));
            }
        });
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)this.rlBall, (String)"scaleX", (float[])new float[]{0.5f, 0.9f});
        scaleX.setDuration(1760L);
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)this.rlBall, (String)"scaleY", (float[])new float[]{0.5f, 0.9f});
        scaleY.setDuration(1760L);
        ObjectAnimator rotate = ObjectAnimator.ofFloat((Object)this.rlBall, (String)"rotation", (float[])new float[]{0.0f, 2.0f, 0.0f});
        rotate.setDuration(2000L);
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)this.rlBall, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        alpha.setDuration(240L);
        ObjectAnimator alphaRootView = ObjectAnimator.ofFloat((Object)this.layout, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        alphaRootView.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                HeatBallEffectController.this.layout.setVisibility(4);
                HeatBallEffectController.this.nobleIcon.setVisibility(8);
                HeatBallEffectController.this.mParent.setVisibility(8);
            }
        });
        alphaRootView.setDuration(1000L);
        set.play((Animator)bezier).with((Animator)alpha);
        set.play((Animator)scaleX).with((Animator)scaleY).after((Animator)alpha);
        set.play((Animator)rotate).after((Animator)scaleX);
        set.play((Animator)alphaRootView).after((Animator)scaleX).after(5000L);
        this.rlBall.setScaleX(0.5f);
        this.rlBall.setScaleY(0.5f);
        set.start();
    }

    @BusEvent(sync=true)
    public void onQueryTurnTableGrabChest(IChannelTurntableClient_onQueryTurnTableGrabChest_EventArgs busEventArgs) {
        long result = busEventArgs.getResult();
        Map extendInfo = busEventArgs.getExtendInfo();
        List otherList = busEventArgs.getOtherList();
        if (this.layout == null) {
            return;
        }
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("------[onQueryTurnTableGrabChest],result==" + result + ",redDiamond==" + (String)extendInfo.get("RED_DIAMOND")), (Object[])new Object[0]);
        }
        if (result == 0L) {
            String redDiamond = (String)extendInfo.get("RED_DIAMOND");
            SpannableString ss = new SpannableString((CharSequence)("\u00d71\uff0c\u60a8\u62a2\u5f97" + redDiamond + "\u6d3b\u52a8\u7ea2\u94bb"));
            int start = "\u00d71\uff0c\u60a8\u62a2\u5f97".length();
            int end = start + redDiamond.length();
            ss.setSpan((Object)new ForegroundColorSpan(this.mContext.getResources().getColor(R.color.hot_ball_user_name)), start, end, 33);
            ss.setSpan((Object)new StyleSpan(1), start, end, 33);
            this.tvTip.setText((CharSequence)ss);
        } else {
            SpannableString sp = new SpannableString((CharSequence)"\u00d71\uff0c\u60a8\u4e0b\u624b\u6162\u4e86");
            int start = "\u00d71\uff0c\u60a8".length();
            int end = start + "\u4e0b\u624b\u6162\u4e86".length();
            sp.setSpan((Object)new ForegroundColorSpan(this.mContext.getResources().getColor(R.color.hot_ball_fail_info)), start, end, 33);
            sp.setSpan((Object)new StyleSpan(1), start, end, 33);
            this.tvTip.setText((CharSequence)sp);
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void onExecute(IQueueClient_onExecute_EventArgs busEventArgs) {
        QueueMessage message = busEventArgs.mMessage;
        if (message != null) {
            this.onExecute(message.object);
        }
    }

    public void onExecute(Object queueMsg) {
        this.onReceiveQueueBroadCast(queueMsg);
    }

    protected void onReceiveQueueBroadCast(Object queueMsg) {
        if (queueMsg != null && queueMsg instanceof TurnTableLottoryInfo) {
            TurnTableLottoryInfo info = (TurnTableLottoryInfo)queueMsg;
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)("----- run hot ball info= " + info), (Object[])new Object[0]);
            }
            if (info.giftId.equals("401") || info.giftId.equals("5170")) {
                boolean isSkipModuleFlight;
                this.mParent.setVisibility(0);
                if (this.layout == null) {
                    this.initViews();
                }
                if (isSkipModuleFlight = LiveModuleManagerProxy.getInstance().isSkipModule(Temp.getCurrentBussinessId(), "HotBallDiamondBroadCastModule")) {
                    MLog.info((Object)TAG, (String)"isSkipModule is true", (Object[])new Object[0]);
                }
                if (!isSkipModuleFlight) {
                    this.show(info.fromName, info.treasureId, info.giftId, info.noble);
                }
            }
        }
    }

    private void setRootLp() {
        RelativeLayout.LayoutParams towerLp = (RelativeLayout.LayoutParams)this.ivTower.getLayoutParams();
        LinearLayout.LayoutParams llSendInfoLp = (LinearLayout.LayoutParams)this.llSendInfo.getLayoutParams();
        RelativeLayout.LayoutParams llBallTextContainerLp = (RelativeLayout.LayoutParams)this.llBallTextContainer.getLayoutParams();
        if (this.isLandscape) {
            towerLp.bottomMargin = -((int)ResolutionUtils.convertDpToPixel((float)10.0f, (Context)this.mContext));
            llSendInfoLp.bottomMargin = (int)ResolutionUtils.convertDpToPixel((float)38.0f, (Context)this.mContext);
            llBallTextContainerLp.leftMargin = (int)ResolutionUtils.convertDpToPixel((float)143.04f, (Context)this.mContext);
        } else {
            towerLp.bottomMargin = 0;
            llSendInfoLp.bottomMargin = (int)ResolutionUtils.convertDpToPixel((float)48.0f, (Context)this.mContext);
            llBallTextContainerLp.leftMargin = 0;
        }
    }

    public void onOrientationChange(boolean isLandscape) {
        this.isLandscape = isLandscape;
        if (this.layout != null) {
            this.setRootLp();
        }
    }

    public void setOrientation(boolean isLandscape) {
        this.isLandscape = isLandscape;
    }

    public void onDestroy() {
        ICoreManagerBase.removeClient((Object)this);
    }
}

