/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.chatemotion;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.duowan.mobile.basemedia.watchlive.activity.ViewingRoomProcessor;
import com.duowan.mobile.basemedia.watchlive.template.Scene;
import com.duowan.mobile.entlive.events.IChatEmotionClient_onGetSpeechList_EventArgs;
import com.duowan.mobile.entlive.events.IChatEmotionClient_onSetNormalEmoIconCheckedChangeListener_EventArgs;
import com.duowan.mobile.entlive.events.INNobleClient_onNobleShoutingTimesChange_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.live.module.nobleemotion.NobleEmotionFragment;
import com.yy.mobile.RxBus;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.liveapi.chatemotion.data.ChatFastSpeech;
import com.yy.mobile.liveapi.chatemotion.uicore.IChatEmotionCore;
import com.yy.mobile.memoryrecycle.views.YYTextView;
import com.yy.mobile.plugin.main.events.IChatEmotionClient_onAppendTextToInput_EventArgs;
import com.yy.mobile.plugin.main.events.IChatEmotionClient_onChatEmotionComponentDismiss_EventArgs;
import com.yy.mobile.plugin.main.events.IChatEmotionClient_onChatInputSwitch_EventArgs;
import com.yy.mobile.plugin.main.events.IChatEmotionClient_onDeleteInputMsg_EventArgs;
import com.yy.mobile.plugin.main.events.IChatEmotionClient_onSetNobleIconEntranceCallBack_EventArgs;
import com.yy.mobile.plugin.main.events.IChatEmotionClient_onSetNobleIconPanelCallBack_EventArgs;
import com.yy.mobile.plugin.main.events.IChatEmotionClient_onSetNormalEmotionIconChecked_EventArgs;
import com.yy.mobile.plugin.main.events.IChatEmotionClient_onSetTextToInput_EventArgs;
import com.yy.mobile.plugin.main.events.IChatEmotionClient_onTypeCViolationNotice_EventArgs;
import com.yy.mobile.plugin.main.events.IChatEmotionClient_setEmotionShownLayoutFragment_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.BasePopupComponent;
import com.yy.mobile.ui.basicchanneltemplate.component.IPopupComponent;
import com.yy.mobile.ui.chatemotion.CharacterValuesTipController;
import com.yy.mobile.ui.chatemotion.ChatEmotionPopupComponent$$EventBinder;
import com.yy.mobile.ui.chatemotion.ChatHotWordsView;
import com.yy.mobile.ui.chatemotion.EmotionChatEditText;
import com.yy.mobile.ui.chatemotion.SendChatPresenter;
import com.yy.mobile.ui.utils.SoftKeyboardStateHelper;
import com.yy.mobile.ui.widget.emoticons.EmoticonsView;
import com.yy.mobile.ui.widget.labelView.Label;
import com.yy.mobile.ui.widget.labelView.LabelView;
import com.yy.mobile.util.ActivityUtilKt;
import com.yy.mobile.util.DimenConverter;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.ImeUtil;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.basechannel.IChannelLinkCore;
import com.yymobile.core.noble.INNobleCore;
import com.yymobile.core.noble.bean.NobleInfoBean;
import com.yymobile.core.noble.event.NobleEvent;
import com.yymobile.core.sensitivewords.ISensitiveWordsCore;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ChatEmotionPopupComponent
extends BasePopupComponent
implements EventCompat,
IPopupComponent,
View.OnClickListener {
    private static final String TAG = "ChatEmotionPopupComponent";
    private static final String NOBLE_ICON_POPUP_COMPONENT_TAG = "noble_icon_popup_component_tag";
    private static final String CHAT_EMOTION_CONTENT_CACHE = "chat_emotion_content_cache";
    private static final String CHAT_EMOTION_DEFAULT_INPUT_TEXT = "CHAT_EMOTION_DEFAULT_INPUT_TEXT";
    private IChannelLinkCore linkChannelCore;
    private IChatEmotionCore chatEmotionCore;
    private View rootView;
    private RelativeLayout rootContainer;
    private LinearLayout imEmotionContainer;
    private LinearLayout hotWordsSummaryContainer;
    private LabelView hotWordsSummary;
    private Button btnEmotion;
    private Button btnKeyBorad;
    private YYTextView btnHotWords;
    private CheckBox chkHanHua;
    private EmotionChatEditText editInputContent;
    private Button btnSend;
    private FrameLayout frameEmotionLayout;
    private FrameLayout frameHotWordsLayout;
    private View emotionIconLayout;
    private RelativeLayout emotionSelectLayout;
    private RelativeLayout customEmotionSelectLayout;
    private RelativeLayout rlInputContainer;
    private CheckBox chkNormalIcon;
    private EmoticonsView emoticonsView;
    private ChatHotWordsView hotWordsView;
    private Context mContext;
    private SoftKeyboardStateHelper mSoftKeyboardStateHelper;
    private boolean isEmotionForceKeyBoardClose = false;
    private boolean isHotWordsForceKeyBoardClose = false;
    private boolean isCustomChangeState = false;
    private boolean isNormalEmotionIconChecked = true;
    private RelativeLayout characterValuesLayout;
    private CharSequence mDefaultText;
    private SendChatPresenter mSendPresenter;
    private CharacterValuesTipController mCharacterValuesTipController;
    private boolean isNobleShouting = false;
    private TextView nobleShoutingCal;
    private View.OnClickListener onClickDismissListener = new View.OnClickListener(){

        public void onClick(View view) {
            ChatEmotionPopupComponent.this.chatEmotionCore.setTextToInput(ChatEmotionPopupComponent.this.editInputContent.getText().toString());
            ChatEmotionPopupComponent.this.chatEmotionCore.setMsgSendState(-1);
            ChatEmotionPopupComponent.this.btnHotWords.setSelected(false);
            ChatEmotionPopupComponent.this.dismissComponent();
        }
    };
    private Runnable mResumeShowIMETask = new Runnable(){

        @Override
        public void run() {
            ChatEmotionPopupComponent.this.isEmotionForceKeyBoardClose = false;
            ChatEmotionPopupComponent.this.isHotWordsForceKeyBoardClose = false;
            if (ChatEmotionPopupComponent.this.editInputContent != null) {
                ChatEmotionPopupComponent.this.editInputContent.setFocusableInTouchMode(true);
                ChatEmotionPopupComponent.this.editInputContent.requestFocus();
                ChatEmotionPopupComponent.this.editInputContent.setFocusable(true);
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)ChatEmotionPopupComponent.TAG, (String)"mResumeShowIMETask showInput", (Object[])new Object[0]);
                }
                ImeUtil.showIME((Activity)ChatEmotionPopupComponent.this.getActivity(), (View)ChatEmotionPopupComponent.this.editInputContent);
            }
        }
    };
    private EventBinder mChatEmotionPopupComponentSniperEventBinder;

    public static ChatEmotionPopupComponent newInstance() {
        ChatEmotionPopupComponent fragment = new ChatEmotionPopupComponent();
        return fragment;
    }

    public static ChatEmotionPopupComponent newInstance(CharSequence defaultInputText) {
        ChatEmotionPopupComponent fragment = new ChatEmotionPopupComponent();
        Bundle argments = new Bundle();
        argments.putCharSequence(CHAT_EMOTION_DEFAULT_INPUT_TEXT, defaultInputText);
        fragment.setArguments(argments);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        MLog.info((Object)TAG, (String)"ChatEmotionComponent onCreate", (Object[])new Object[0]);
        this.setStyle(1, 16973837);
        this.mContext = this.getActivity();
        this.mDefaultText = this.getArguments() != null ? this.getArguments().getCharSequence(CHAT_EMOTION_DEFAULT_INPUT_TEXT) : "";
        this.linkChannelCore = ICoreManagerBase.getChannelLinkCore();
        this.chatEmotionCore = (IChatEmotionCore)ICoreManagerBase.getCore(IChatEmotionCore.class);
        this.mSendPresenter = new SendChatPresenter(this.getContext());
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        MLog.info((Object)TAG, (String)"ChatEmotionComponent onCreateView", (Object[])new Object[0]);
        this.rootView = inflater.inflate(R.layout.fragment_chat_emotion_popup_component, container, false);
        if (this.getDialog() != null) {
            this.getDialog().setCanceledOnTouchOutside(true);
        }
        this.rootContainer = (RelativeLayout)this.rootView.findViewById(R.id.ime_root_container);
        this.rootContainer.setOnClickListener(this.onClickDismissListener);
        this.imEmotionContainer = (LinearLayout)this.rootContainer.findViewById(R.id.ll_im_emotion_container);
        this.hotWordsSummaryContainer = (LinearLayout)this.imEmotionContainer.findViewById(R.id.hot_words_summary_container);
        this.hotWordsSummary = (LabelView)this.rootView.findViewById(R.id.hot_words_summary);
        this.hotWordsSummary.setLimitRows(1);
        this.hotWordsSummary.setOnLabelClickListener(new LabelView.OnLabelClickListener(){

            public void onLabelClick(Label label, int i) {
                if (ChatEmotionPopupComponent.this.chatEmotionCore.chooseChatFastSpeech(label)) {
                    return;
                }
                ChatEmotionPopupComponent.this.onPreSendMessege(label.text, "1");
                Property property = new Property();
                property.putString("key1", String.valueOf(label.classId));
                property.putString("key2", String.valueOf(i + 1));
                property.putString("key3", URLEncoder.encode(label.text));
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51037", "0001", (Serializable)property);
            }
        });
        this.btnEmotion = (Button)this.imEmotionContainer.findViewById(R.id.btn_emoticon);
        this.btnKeyBorad = (Button)this.imEmotionContainer.findViewById(R.id.btn_keyboard);
        this.chkHanHua = (CheckBox)this.imEmotionContainer.findViewById(R.id.chk_hanhua);
        if (ViewingRoomProcessor.getInstance().getCurrentScene() != Scene.ENTERTAINMENT) {
            this.chkHanHua.setVisibility(8);
        }
        this.btnSend = (Button)this.imEmotionContainer.findViewById(R.id.btn_send);
        this.editInputContent = (EmotionChatEditText)this.imEmotionContainer.findViewById(R.id.input_box);
        this.editInputContent.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                return false;
            }
        });
        this.editInputContent.setOnSendEnableListener(new EmotionChatEditText.OnSendEnableListener(){

            @Override
            public void onSendEnable(boolean enable) {
                int resId = enable ? R.drawable.btn_yellow_selector_corner_90 : R.drawable.bg_chat_input;
                int color2 = enable ? ChatEmotionPopupComponent.this.mContext.getResources().getColor(R.color.txt_color_unfollow) : ChatEmotionPopupComponent.this.mContext.getResources().getColor(R.color.common_color_9);
                ChatEmotionPopupComponent.this.btnSend.setEnabled(enable);
                ChatEmotionPopupComponent.this.btnSend.setBackgroundResource(resId);
                ChatEmotionPopupComponent.this.btnSend.setTextColor(color2);
                if (ChatEmotionPopupComponent.this.isNobleShouting) {
                    int length = 0;
                    if (ChatEmotionPopupComponent.this.editInputContent.getText() != null) {
                        length = ChatEmotionPopupComponent.this.editInputContent.getText().toString().length();
                    }
                    ChatEmotionPopupComponent.this.nobleShoutingCal.setText((CharSequence)(length + "/16"));
                }
            }
        });
        this.editInputContent.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                ChatEmotionPopupComponent.this.isEmotionForceKeyBoardClose = false;
                ChatEmotionPopupComponent.this.isHotWordsForceKeyBoardClose = false;
                ChatEmotionPopupComponent.this.btnHotWords.setSelected(ChatEmotionPopupComponent.this.isHotWordsForceKeyBoardClose);
                if (ChatEmotionPopupComponent.this.emoticonsView != null && ChatEmotionPopupComponent.this.emoticonsView.getVisibility() != 8) {
                    ChatEmotionPopupComponent.this.emoticonsView.setVisibility(8);
                }
                if (ChatEmotionPopupComponent.this.hotWordsView != null && ChatEmotionPopupComponent.this.hotWordsView.getVisibility() != 8) {
                    ChatEmotionPopupComponent.this.hotWordsView.setVisibility(8);
                }
                if (ChatEmotionPopupComponent.this.btnEmotion != null && ChatEmotionPopupComponent.this.btnEmotion.getVisibility() != 0) {
                    ChatEmotionPopupComponent.this.btnEmotion.setVisibility(0);
                }
                if (ChatEmotionPopupComponent.this.btnKeyBorad != null && ChatEmotionPopupComponent.this.btnKeyBorad.getVisibility() != 8) {
                    ChatEmotionPopupComponent.this.btnKeyBorad.setVisibility(8);
                }
                if (ChatEmotionPopupComponent.this.emotionSelectLayout != null && ChatEmotionPopupComponent.this.emotionSelectLayout.getVisibility() != 8) {
                    ChatEmotionPopupComponent.this.emotionSelectLayout.setVisibility(8);
                }
                if (ChatEmotionPopupComponent.this.frameHotWordsLayout != null && ChatEmotionPopupComponent.this.frameHotWordsLayout.getVisibility() != 8) {
                    ChatEmotionPopupComponent.this.frameHotWordsLayout.setVisibility(8);
                }
                ImeUtil.showIME((Activity)ChatEmotionPopupComponent.this.getActivity(), (View)ChatEmotionPopupComponent.this.editInputContent);
                return false;
            }
        });
        this.frameEmotionLayout = (FrameLayout)this.imEmotionContainer.findViewById(R.id.emotion_frame);
        this.frameHotWordsLayout = (FrameLayout)this.rootView.findViewById(R.id.hot_words_frame);
        this.emotionIconLayout = this.imEmotionContainer.findViewById(R.id.emoticon_layout);
        this.rlInputContainer = (RelativeLayout)this.imEmotionContainer.findViewById(R.id.rl_input_container);
        this.emotionSelectLayout = (RelativeLayout)this.imEmotionContainer.findViewById(R.id.emotion_layout);
        this.emotionSelectLayout.setVisibility(8);
        this.customEmotionSelectLayout = (RelativeLayout)this.imEmotionContainer.findViewById(R.id.rl_emotion_select_layout);
        this.chkNormalIcon = (CheckBox)this.imEmotionContainer.findViewById(R.id.normal_emoticon);
        this.btnEmotion.setOnClickListener((View.OnClickListener)this);
        this.btnKeyBorad.setOnClickListener((View.OnClickListener)this);
        this.nobleShoutingCal = (TextView)this.rootView.findViewById(R.id.noble_shouting_cal);
        this.chkHanHua.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton compoundButton, boolean isCheck) {
                NobleInfoBean bean = ((INNobleCore)ICoreManagerBase.getCore(INNobleCore.class)).getNobleInfoBean();
                boolean isOldNobleExpired = false;
                if (bean != null && bean.isOldNoble == 1 && bean.isOldNobleExpired == 1) {
                    isOldNobleExpired = true;
                }
                if (bean != null && bean.type < 6 && bean.type > 0 && !isOldNobleExpired) {
                    ChatEmotionPopupComponent.this.editInputContent.setText("");
                    if (isCheck) {
                        ChatEmotionPopupComponent.this.onKeyBoardBtnClick();
                        ChatEmotionPopupComponent.this.nobleShoutingCal.setVisibility(0);
                        ChatEmotionPopupComponent.this.isNobleShouting = true;
                        int times = ((INNobleCore)ICoreManagerBase.getCore(INNobleCore.class)).getNobleShoutingTimes();
                        String timesStr = String.format("\u4eca\u65e5\u5269\u4f59\u558a\u8bdd\u6b21\u6570:%d\u6b21", times);
                        ChatEmotionPopupComponent.this.editInputContent.setHint(timesStr);
                    } else {
                        ChatEmotionPopupComponent.this.nobleShoutingCal.setText((CharSequence)"0/16");
                        ChatEmotionPopupComponent.this.nobleShoutingCal.setVisibility(8);
                        ChatEmotionPopupComponent.this.isNobleShouting = false;
                        ChatEmotionPopupComponent.this.editInputContent.setHint("\u8bf7\u8f93\u5165\u5185\u5bb9");
                    }
                } else {
                    ChatEmotionPopupComponent.this.chkHanHua.setChecked(false);
                    MLog.debug((Object)ChatEmotionPopupComponent.TAG, (String)"wwd hanhua---->not open!", (Object[])new Object[0]);
                    Integer code = new Integer(3905);
                    NobleEvent nobleEvent = new NobleEvent((Object)code, 244);
                    RxBus.getDefault().post((Object)nobleEvent);
                    ChatEmotionPopupComponent.this.dismissComponent();
                }
            }
        });
        this.btnSend.setOnClickListener((View.OnClickListener)this);
        this.chkNormalIcon.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                ChatEmotionPopupComponent.this.updateChkNormalEmoIconChecked(b);
                if (ChatEmotionPopupComponent.this.chatEmotionCore.getNormalEmoIconCheckedCallBack() != null) {
                    MLog.info((Object)ChatEmotionPopupComponent.TAG, (String)"ChatEmotionComponent: onEntertaimentTemplateInit set custom listener for normal icon check box", (Object[])new Object[0]);
                    ChatEmotionPopupComponent.this.chatEmotionCore.getNormalEmoIconCheckedCallBack().getNormalEmoIconCheckedChangedListener().onCheckedChanged(compoundButton, b);
                }
            }
        });
        this.mSoftKeyboardStateHelper = new SoftKeyboardStateHelper(this.imEmotionContainer.getRootView());
        this.mSoftKeyboardStateHelper.addSoftKeyboardStateListener(new SoftKeyboardStateHelper.SoftKeyboardStateListener(){

            public void onSoftKeyboardOpened(int keyboardHeightInPx) {
                ChatEmotionPopupComponent.this.chatEmotionCore.setIMEHeight(keyboardHeightInPx);
                if (ChatEmotionPopupComponent.this.checkActivityValid()) {
                    MLog.info((Object)ChatEmotionPopupComponent.TAG, (String)"ChatEmotionComponent: SoftKeyBoard Opened", (Object[])new Object[0]);
                    if (ChatEmotionPopupComponent.this.editInputContent != null) {
                        ChatEmotionPopupComponent.this.editInputContent.setFocusableInTouchMode(true);
                        ChatEmotionPopupComponent.this.editInputContent.requestFocus();
                    }
                    if (MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)ChatEmotionPopupComponent.TAG, (String)"ChatEmotionComponent: SoftKeyBoard Opened, input container reLayout finished", (Object[])new Object[0]);
                    }
                }
            }

            public void onSoftKeyboardClosed() {
                ChatEmotionPopupComponent.this.chatEmotionCore.setIMEHeight(0);
                if (ChatEmotionPopupComponent.this.checkActivityValid()) {
                    MLog.info((Object)ChatEmotionPopupComponent.TAG, (String)"ChatEmotionComponent: SoftKeyBoard Closed", (Object[])new Object[0]);
                    if (!ChatEmotionPopupComponent.this.isEmotionForceKeyBoardClose && !ChatEmotionPopupComponent.this.isHotWordsForceKeyBoardClose) {
                        ChatEmotionPopupComponent.this.dismissComponent();
                    }
                    if (MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)ChatEmotionPopupComponent.TAG, (String)"ChatEmotionComponent: SoftKeyBoard Closed, input container reLayout finished", (Object[])new Object[0]);
                    }
                }
            }
        });
        this.btnHotWords = (YYTextView)this.rootView.findViewById(R.id.btn_hot_words);
        this.btnHotWords.setSelected(false);
        this.btnHotWords.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ChatEmotionPopupComponent.this.onHotWordsBtnClick();
                Property property = new Property();
                property.putString("key1", String.valueOf(ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().topSid));
                property.putString("key3", String.valueOf(ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId()));
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51012", "0001", (Serializable)property);
            }
        });
        this.initCustomEmotionEntrace();
        this.initNobleIconTipInfo();
        this.characterValuesLayout = (RelativeLayout)this.rootView.findViewById(R.id.rl_character_values_layout);
        this.mCharacterValuesTipController = new CharacterValuesTipController(this.getActivity(), (ViewGroup)this.characterValuesLayout);
        this.mCharacterValuesTipController.attach((Activity)this.getActivity());
        this.mCharacterValuesTipController.create(null, (ViewGroup)this.characterValuesLayout);
        this.mCharacterValuesTipController.setOnMakeChatComponentDismissListener(new CharacterValuesTipController.OnMakeChatComponentDismissListener(){

            @Override
            public void onMakeChatComponentDismiss() {
                ChatEmotionPopupComponent.this.dismissComponent();
            }
        });
        return this.rootView;
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"ChatEmotionComponent onCreateDialog", (Object[])new Object[0]);
        }
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.setCanceledOnTouchOutside(true);
        dialog.requestWindowFeature(1);
        dialog.getWindow().setWindowAnimations(R.style.slide_dialog_animation);
        dialog.getWindow().setBackgroundDrawableResource(R.color.transparent);
        if (ActivityUtilKt.isLandScape((Activity)this.getActivity())) {
            dialog.getWindow().setFlags(1024, 1024);
        }
        dialog.getWindow().clearFlags(2);
        dialog.getWindow().setGravity(80);
        dialog.getWindow().setSoftInputMode(20);
        dialog.getWindow().setLayout(-1, -1);
        return dialog;
    }

    public void onResume() {
        super.onResume();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"ChatEmotionComponent onResume", (Object[])new Object[0]);
        }
        this.showInput();
        if (ICoreManagerBase.getCore(IChatEmotionCore.class) != null) {
            ((IChatEmotionCore)ICoreManagerBase.getCore(IChatEmotionCore.class)).getQuickSpeech();
        }
    }

    private void showInput() {
        if (this.editInputContent != null) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"onResume showInput", (Object[])new Object[0]);
            }
            if (this.mCharacterValuesTipController != null) {
                this.mCharacterValuesTipController.onToastMoralQualityStateNotice();
            }
            if (this.mResumeShowIMETask != null) {
                this.getHandler().removeCallbacks(this.mResumeShowIMETask);
                this.getHandler().postDelayed(this.mResumeShowIMETask, 30L);
            }
            this.initDefaultInputContent();
            this.notifyChatInputSwitch(true);
        }
    }

    private void initDefaultInputContent() {
        if (TextUtils.isEmpty((CharSequence)this.mDefaultText)) {
            if (!(this.chatEmotionCore == null || StringUtils.isEmpty((String)this.chatEmotionCore.getTextFromInput()).booleanValue() || this.chatEmotionCore.getMsgSendState() != 0 && this.chatEmotionCore.getMsgSendState() != -1)) {
                this.editInputContent.setText(this.chatEmotionCore.getTextFromInput());
            }
        } else {
            this.editInputContent.setText(this.mDefaultText);
        }
    }

    private void notifyChatInputSwitch(boolean chatInputSwitch) {
        MLog.debug((Object)TAG, (String)"notifyChatInputSwitch = %b", (Object[])new Object[]{chatInputSwitch});
        RxBus.getDefault().post((Object)new IChatEmotionClient_onChatInputSwitch_EventArgs(chatInputSwitch));
    }

    public void initCustomEmotionEntrace() {
        IChatEmotionCore.NobleIconEntraceCallBack callBack;
        if (this.chatEmotionCore != null && (callBack = this.chatEmotionCore.getNobleIconEntraceCallBack()) != null) {
            MLog.info((Object)TAG, (String)("[initCustomEmotionEntrace] callBack = " + callBack), (Object[])new Object[0]);
            View view = callBack.getNobleIconEntraceCallBack();
            if (view != null && this.customEmotionSelectLayout != null) {
                if (view.getParent() != null) {
                    ((ViewGroup)view.getParent()).removeView(view);
                }
                this.customEmotionSelectLayout.removeAllViews();
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
                this.customEmotionSelectLayout.addView(view, (ViewGroup.LayoutParams)layoutParams);
            }
        }
        this.updateNobleIconFragment();
    }

    @BusEvent(sync=true)
    public void onSetNobleIconPanelCallBack(IChatEmotionClient_onSetNobleIconPanelCallBack_EventArgs busEventArgs) {
        this.updateNobleIconFragment();
    }

    private void updateNobleIconFragment() {
        this.showNobleEmotionFragment();
    }

    public void initNobleIconTipInfo() {
        Fragment tipFragment;
        if (this.chatEmotionCore.getNobleIconTipCallBack() != null && (tipFragment = this.chatEmotionCore.getNobleIconTipCallBack().getNobleIconTipFragment()) != null) {
            this.getChildFragmentManager().beginTransaction().replace(R.id.fl_noble_tip, tipFragment, "emotion_frame_noble_icon_tip_fragment").commitAllowingStateLoss();
        }
    }

    public void onClick(View view) {
        if (view == this.btnEmotion) {
            if (this.chkHanHua.isChecked()) {
                this.isNobleShouting = false;
                this.nobleShoutingCal.setText((CharSequence)"0/16");
                this.nobleShoutingCal.setVisibility(8);
                this.editInputContent.setText("");
                this.editInputContent.setHint("\u8bf7\u8f93\u5165\u5185\u5bb9");
                this.chkHanHua.setChecked(false);
            }
            this.onEmotionBtnClick();
        } else if (view == this.btnKeyBorad) {
            this.onKeyBoardBtnClick();
        } else if (view == this.btnSend) {
            if (this.isNobleShouting && ((INNobleCore)ICoreManagerBase.getCore(INNobleCore.class)).getNobleShoutingTimes() <= 0) {
                this.toast("\u558a\u8bdd\u6b21\u6570\u5df2\u4f7f\u7528\u5b8c");
                return;
            }
            String inputMsg = this.editInputContent.getText().toString();
            if (this.isNobleShouting && inputMsg.length() > 16) {
                this.toast("\u5df2\u8d85\u51fa\u89c4\u5b9a\u5b57\u6570");
                return;
            }
            if (this.isNobleShouting && ((ISensitiveWordsCore)ICoreManagerBase.getCore(ISensitiveWordsCore.class)).containFinanceSensitiveWord(inputMsg)) {
                this.toast("\u60a8\u53d1\u8a00\u5305\u542b\u654f\u611f\u5b57\u7b26");
                return;
            }
            boolean normal = true;
            if (this.isNobleShouting && ((INNobleCore)ICoreManagerBase.getCore(INNobleCore.class)).getNobleShoutingTimes() > 0) {
                ((INNobleCore)ICoreManagerBase.getCore(INNobleCore.class)).sendNobleChatMsg(inputMsg);
                boolean bl = normal = !((INNobleCore)ICoreManagerBase.getCore(INNobleCore.class)).nobleShoutingBreak();
                if (!normal) {
                    this.dismissComponent();
                }
            }
            if (normal) {
                this.onPreSendMessege(inputMsg, "0");
            }
            ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic_Channel_5_2(LoginUtil.getUid(), "51001", "0015");
        }
    }

    public void onEmotionBtnClick() {
        MLog.info((Object)TAG, (String)"onEmotionBtnClick", (Object[])new Object[0]);
        if (this.rlInputContainer != null && this.checkActivityValid()) {
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.rlInputContainer.getLayoutParams();
            layoutParams.bottomMargin = DimenConverter.dip2px((Context)this.mContext, (float)0.0f);
            this.rlInputContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        ImeUtil.hideIME((Context)this.getActivity(), (View)this.editInputContent);
        this.isEmotionForceKeyBoardClose = true;
        this.isHotWordsForceKeyBoardClose = false;
        this.hideImeInfo();
    }

    private void hideImeInfo() {
        if (this.isEmotionForceKeyBoardClose) {
            if (this.btnKeyBorad != null && this.btnKeyBorad.getVisibility() != 0) {
                this.btnKeyBorad.setVisibility(0);
            }
            if (this.btnEmotion != null && this.btnEmotion.getVisibility() != 8) {
                this.btnEmotion.setVisibility(8);
            }
            if (this.emoticonsView == null) {
                this.initEmoticonsView();
            }
            if (this.chkNormalIcon != null) {
                this.chkNormalIcon.setChecked(this.isNormalEmotionIconChecked);
                if (this.isNormalEmotionIconChecked) {
                    this.onChooseNormalEmoIcon();
                } else {
                    if (MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)TAG, (String)"hideImeInfo", (Object[])new Object[0]);
                    }
                    this.onChooseCustomEmoIcon();
                }
            }
        }
        if (this.isHotWordsForceKeyBoardClose && this.hotWordsView == null) {
            this.initHotWordsView();
        }
        if (this.emoticonsView != null) {
            this.emoticonsView.setVisibility(this.isEmotionForceKeyBoardClose && this.isNormalEmotionIconChecked ? 0 : 8);
        }
        if (this.frameEmotionLayout != null) {
            this.frameEmotionLayout.setVisibility(this.isEmotionForceKeyBoardClose && !this.isNormalEmotionIconChecked ? 0 : 8);
        }
        if (this.emotionSelectLayout != null) {
            this.emotionSelectLayout.setVisibility(this.isEmotionForceKeyBoardClose ? 0 : 8);
        }
        if (this.frameHotWordsLayout != null) {
            this.frameHotWordsLayout.setVisibility(this.isEmotionForceKeyBoardClose ? 0 : 8);
        }
        if (this.hotWordsView != null) {
            this.hotWordsView.setVisibility(this.isHotWordsForceKeyBoardClose ? 0 : 8);
        }
        if (this.frameHotWordsLayout != null) {
            this.frameHotWordsLayout.setVisibility(this.isHotWordsForceKeyBoardClose ? 0 : 8);
        }
        this.btnHotWords.setSelected(this.isHotWordsForceKeyBoardClose);
        if (this.editInputContent != null) {
            this.editInputContent.setFocusableInTouchMode(true);
            this.editInputContent.requestFocus();
        }
    }

    private void initEmoticonsView() {
        if (!this.checkActivityValid()) {
            return;
        }
        this.emoticonsView = new EmoticonsView((Context)this.getActivity(), this.rootView.findViewById(R.id.emoticon_layout), new EmoticonsView.IEmoticonsMessageListener(){

            public void sendMessageFromEmoticon(String msg) {
                if (ChatEmotionPopupComponent.this.editInputContent != null) {
                    String inputMsg = ChatEmotionPopupComponent.this.editInputContent.getText().toString();
                    ChatEmotionPopupComponent.this.onPreSendMessege(inputMsg, "0");
                    MLog.info((Object)ChatEmotionPopupComponent.TAG, (String)("[sendMessageFromEmoticon]" + msg), (Object[])new Object[0]);
                }
            }
        }, (EditText)this.editInputContent);
        this.emoticonsView.setIMomoEmotionListener(new EmoticonsView.IMomoEmotionListener(){

            public void onIMomoEmotionClick(String msg) {
            }
        });
    }

    private void initHotWordsView() {
        if (this.checkActivityValid()) {
            if (this.hotWordsView != null) {
                this.hotWordsView.destroyView();
            }
            this.hotWordsView = new ChatHotWordsView((Context)this.getActivity(), (ViewGroup)this.frameHotWordsLayout, new ChatHotWordsView.IHotWordsMessageListener(){

                @Override
                public void sendMessageFromHotWords(String msg) {
                    if (!TextUtils.isEmpty((CharSequence)msg)) {
                        ChatEmotionPopupComponent.this.onPreSendMessege(msg, "1");
                    }
                }
            }, this.editInputContent);
            this.hotWordsView.setLineMargin(12.0f);
            this.hotWordsView.setLabelMargin(15.0f);
            this.hotWordsView.setSkipCount(this.hotWordsSummary.getChildCount());
            if (ICoreManagerBase.getCore(IChatEmotionCore.class) != null) {
                ((IChatEmotionCore)ICoreManagerBase.getCore(IChatEmotionCore.class)).getQuickSpeech();
            }
        }
    }

    public void onKeyBoardBtnClick() {
        MLog.info((Object)TAG, (String)"onKeyBoardBtnClick", (Object[])new Object[0]);
        ImeUtil.showIME((Activity)this.getActivity(), (View)this.editInputContent);
        this.isEmotionForceKeyBoardClose = false;
        this.isHotWordsForceKeyBoardClose = false;
        this.hideEmotionInputInfo();
        this.hideHotWordsInfo();
    }

    private void hideEmotionInputInfo() {
        if (this.btnKeyBorad != null && this.btnKeyBorad.getVisibility() != 8) {
            this.btnKeyBorad.setVisibility(8);
        }
        if (this.btnEmotion != null && this.btnEmotion.getVisibility() != 0) {
            this.btnEmotion.setVisibility(0);
        }
        if (this.emoticonsView != null && this.emoticonsView.getVisibility() != 8) {
            this.emoticonsView.setVisibility(8);
        }
        if (this.emotionSelectLayout != null && this.emotionSelectLayout.getVisibility() != 8) {
            this.emotionSelectLayout.setVisibility(8);
        }
        if (this.editInputContent != null) {
            this.editInputContent.setFocusableInTouchMode(true);
            this.editInputContent.requestFocus();
        }
    }

    public void onHotWordsBtnClick() {
        if (this.checkActivityValid()) {
            try {
                LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.rlInputContainer.getLayoutParams();
                layoutParams.bottomMargin = DimenConverter.dip2px((Context)this.mContext, (float)0.0f);
                this.rlInputContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
            catch (Exception e) {
                Log.e((String)"ChatEmotionPopupCmpnt", (String)"Empty Catch on onHotWordsBtnClick", (Throwable)e);
            }
        }
        boolean bl = this.isHotWordsForceKeyBoardClose = !this.btnHotWords.isSelected();
        if (this.isHotWordsForceKeyBoardClose) {
            this.isEmotionForceKeyBoardClose = false;
            ImeUtil.hideIME((Context)this.getActivity(), (View)this.editInputContent);
        } else {
            if (this.btnKeyBorad != null && this.btnKeyBorad.getVisibility() == 0) {
                this.onEmotionBtnClick();
                return;
            }
            if (this.btnEmotion != null && this.btnEmotion.getVisibility() == 0) {
                this.onKeyBoardBtnClick();
                return;
            }
        }
        this.hideImeInfo();
    }

    private void hideHotWordsInfo() {
        this.btnHotWords.setSelected(this.isHotWordsForceKeyBoardClose);
        if (this.frameEmotionLayout != null && this.frameEmotionLayout.getVisibility() != 8) {
            this.frameEmotionLayout.setVisibility(8);
        }
        if (this.hotWordsView != null && this.hotWordsView.getVisibility() != 8) {
            this.hotWordsView.setVisibility(8);
        }
        if (this.editInputContent != null) {
            this.editInputContent.setFocusableInTouchMode(true);
            this.editInputContent.requestFocus();
        }
    }

    public void onPreSendMessege(String msg, String isDefault) {
        if (this.isNobleShouting) {
            this.mSendPresenter.sendMessage(msg, (TextView)this.editInputContent, new boolean[]{true}, isDefault);
        } else {
            boolean success = this.mSendPresenter.onPreSendMessage(msg, (TextView)this.editInputContent, new boolean[]{true}, isDefault);
            if (success) {
                this.dismissComponent();
            }
        }
    }

    @TargetApi(value=17)
    protected boolean checkActivityValid() {
        if (this.getActivity() == null) {
            return false;
        }
        if (this.getActivity().isFinishing()) {
            return false;
        }
        return Build.VERSION.SDK_INT < 17 || !this.getActivity().isDestroyed();
    }

    public void onPause() {
        if (this.editInputContent != null && this.chatEmotionCore != null && this.editInputContent.getText() != null) {
            String s = this.chatEmotionCore.getTextFromInput();
            String s2 = this.editInputContent.getText().toString();
            this.chatEmotionCore.setInputMsgCache(s2);
            if (!StringUtils.isEmpty((String)s2).booleanValue() && !StringUtils.equal((String)s, (String)s2)) {
                this.chatEmotionCore.setMsgSendState(-1);
            }
        }
        if (this.editInputContent != null) {
            this.editInputContent.setText("");
            this.dismissComponent();
        }
        MLog.info((Object)TAG, (String)("[ouyangyj] onPause send msg state = " + this.chatEmotionCore.getMsgSendState()), (Object[])new Object[0]);
        super.onPause();
    }

    public void onDestroy() {
        MLog.info((Object)TAG, (String)"onDestroy \u53d1\u9001\u53d1\u8a00\u7ec4\u4ef6\u6d88\u5931\u7684\u5e7f\u64ad", (Object[])new Object[0]);
        RxBus.getDefault().post((Object)new IChatEmotionClient_onChatEmotionComponentDismiss_EventArgs());
        if (this.getHandler() != null) {
            this.getHandler().removeCallbacksAndMessages(null);
        }
        this.mResumeShowIMETask = null;
        if (this.chatEmotionCore != null) {
            this.chatEmotionCore.setIMEHeight(0);
        }
        if (this.mCharacterValuesTipController != null) {
            this.mCharacterValuesTipController.dismiss();
            this.mCharacterValuesTipController = null;
        }
        if (this.hotWordsView != null) {
            this.hotWordsView.destroyView();
        }
        super.onDestroy();
    }

    public void dismissComponent() {
        MLog.info((Object)TAG, (String)("dismissComponent send broadcast onChatEmotionComponentDismiss, msg send state = " + this.chatEmotionCore.getMsgSendState() + " | cache input msg = " + this.chatEmotionCore.getTextFromInput()), (Object[])new Object[0]);
        ImeUtil.hideIME((Context)this.getActivity(), (View)this.editInputContent);
        this.notifyChatInputSwitch(false);
        RxBus.getDefault().post((Object)new IChatEmotionClient_onChatEmotionComponentDismiss_EventArgs());
        this.dismissAllowingStateLoss();
    }

    @BusEvent(sync=true)
    public void onSetNormalEmoIconCheckedChangeListener(IChatEmotionClient_onSetNormalEmoIconCheckedChangeListener_EventArgs busEventArgs) {
        final IChatEmotionCore.NormalEmoIconCheckedCallBack normalEmoIconCheckedCallBack = busEventArgs.getNormalEmoIconCheckedCallBack();
        MLog.info((Object)TAG, (String)"ChatEmotionComponent: onSetNormalEmoIconCheckedChangeListener", (Object[])new Object[0]);
        if (normalEmoIconCheckedCallBack != null && this.chkNormalIcon != null) {
            this.chkNormalIcon.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                    ChatEmotionPopupComponent.this.updateChkNormalEmoIconChecked(b);
                    normalEmoIconCheckedCallBack.getNormalEmoIconCheckedChangedListener().onCheckedChanged(compoundButton, b);
                }
            });
        }
    }

    private void updateChkNormalEmoIconChecked(boolean b) {
        MLog.info((Object)TAG, (String)("ChatEmotionComponent: updateChkNormalEmoIconChecked " + b + "   /isCustomChangeState = " + this.isCustomChangeState), (Object[])new Object[0]);
        if (this.isCustomChangeState) {
            if (b) {
                this.onChooseNormalEmoIcon();
            } else {
                this.onChooseCustomEmoIcon();
            }
            this.isNormalEmotionIconChecked = b;
        } else {
            if (b) {
                this.onChooseNormalEmoIcon();
            } else {
                this.chkNormalIcon.setChecked(true);
            }
            this.isNormalEmotionIconChecked = true;
        }
        this.isCustomChangeState = false;
    }

    public void onChooseNormalEmoIcon() {
        if (this.emoticonsView != null && this.emoticonsView.getVisibility() != 0) {
            this.emoticonsView.setVisibility(0);
        }
        if (this.frameEmotionLayout != null && this.frameEmotionLayout.getVisibility() != 8) {
            this.frameEmotionLayout.setVisibility(8);
        }
        if (this.editInputContent != null) {
            this.editInputContent.setFocusableInTouchMode(true);
            this.editInputContent.requestFocus();
        }
    }

    public void onChooseCustomEmoIcon() {
        MLog.info((Object)TAG, (String)"[ouyangyj] custom emoicon fragment test", (Object[])new Object[0]);
        if (this.emoticonsView != null && this.emoticonsView.getVisibility() != 8) {
            this.emoticonsView.setVisibility(8);
        }
        if (this.frameEmotionLayout != null) {
            this.frameEmotionLayout.setVisibility(0);
            this.updateNobleIconFragment();
        }
        if (this.editInputContent != null) {
            this.editInputContent.setFocusableInTouchMode(true);
            this.editInputContent.requestFocus();
        }
    }

    @BusEvent(sync=true)
    public void onSetNormalEmotionIconChecked(IChatEmotionClient_onSetNormalEmotionIconChecked_EventArgs busEventArgs) {
        boolean isChecked = busEventArgs.getIsChecked();
        MLog.info((Object)TAG, (String)("onSetNormalEmotionIconChecked " + isChecked), (Object[])new Object[0]);
        this.isCustomChangeState = true;
        if (this.chkNormalIcon != null) {
            this.chkNormalIcon.setChecked(isChecked);
        }
    }

    @BusEvent(sync=true)
    public void onSetNobleIconEntranceCallBack(IChatEmotionClient_onSetNobleIconEntranceCallBack_EventArgs busEventArgs) {
        MLog.info((Object)TAG, (String)"[onSetNobleIconEntranceCallBack]", (Object[])new Object[0]);
        this.initCustomEmotionEntrace();
    }

    @BusEvent(sync=true)
    public void setEmotionShownLayoutFragment(IChatEmotionClient_setEmotionShownLayoutFragment_EventArgs busEventArgs) {
        Fragment emotionIconShowFragment = busEventArgs.getEmotionIconShowFragment();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("setEmotionShownLayoutFragment emotionIconShowFragment is null  = " + (emotionIconShowFragment == null)), (Object[])new Object[0]);
        }
        this.updateNobleIconFragment();
    }

    @BusEvent(sync=true)
    public void onAppendTextToInput(IChatEmotionClient_onAppendTextToInput_EventArgs busEventArgs) {
        String msg = busEventArgs.getMsg();
        MLog.info((Object)TAG, (String)"ChatEmotionComponent: \u4e1a\u52a1\u65b9\u6dfb\u52a0\u5185\u5bb9", (Object[])new Object[0]);
        if (this.editInputContent != null) {
            this.editInputContent.append(msg);
        }
    }

    @BusEvent(sync=true)
    public void onSetTextToInput(IChatEmotionClient_onSetTextToInput_EventArgs busEventArgs) {
        String msg = busEventArgs.getMsg();
        if (this.checkActivityValid() && ActivityUtilKt.isLandScape((Activity)this.getActivity()) && this.editInputContent != null) {
            this.editInputContent.setText(msg);
        }
    }

    @BusEvent(sync=true)
    public void onDeleteInputMsg(IChatEmotionClient_onDeleteInputMsg_EventArgs busEventArgs) {
        if (this.editInputContent != null) {
            KeyEvent deleteEvent = new KeyEvent(0, 67);
            this.editInputContent.onKeyDown(67, deleteEvent);
        }
    }

    @BusEvent(sync=true)
    public void onTypeCViolationNotice(IChatEmotionClient_onTypeCViolationNotice_EventArgs busEventArgs) {
        String noticeInfo = busEventArgs.getNoticeInfo();
        this.onTypeCViolationNotice(noticeInfo);
    }

    public void onTypeCViolationNotice(String noticeInfo) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("[onMoralQualityNotice] noticeInfo=" + noticeInfo), (Object[])new Object[0]);
        }
        if (this.checkActivityValid() && ActivityUtilKt.isLandScape((Activity)this.getActivity()) && this.mCharacterValuesTipController != null && ((IChatEmotionCore)ICoreManagerBase.getCore(IChatEmotionCore.class)).shouldShowMoralQualityToastTime()) {
            this.mCharacterValuesTipController.onTypeCViolationNotice(noticeInfo);
        }
    }

    @BusEvent
    public void onGetSpeechList(IChatEmotionClient_onGetSpeechList_EventArgs busEventArgs) {
        List speechList = busEventArgs.getSpeechList();
        if (this.hotWordsSummary != null && !FP.empty((Collection)speechList)) {
            this.hotWordsSummary.clearAllLabels();
            ArrayList<Label> labels = new ArrayList<Label>();
            List extLabels = this.chatEmotionCore.getExternalChatFastSpeech();
            if (extLabels != null && extLabels.size() > 0) {
                labels.addAll(extLabels);
            }
            for (ChatFastSpeech speech : speechList) {
                for (int i = 0; i < speech.words.size(); ++i) {
                    Label label = new Label((String)speech.words.get(i));
                    label.classId = speech.classId;
                    label.tagTextColor = this.getResources().getColor(R.color.live_common_color_1);
                    labels.add(label);
                }
            }
            if (!labels.isEmpty()) {
                this.hotWordsSummary.setLayoutWidth(ResolutionUtils.getScreenWidth((Context)this.getContext()) - (int)ResolutionUtils.convertDpToPixel((float)71.0f, (Context)this.getContext()));
                this.hotWordsSummary.addAll(labels);
                this.hotWordsSummary.invalidate();
            }
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void onNobleShoutingTimesChange(INNobleClient_onNobleShoutingTimesChange_EventArgs busEventArgs) {
        int times = busEventArgs.mTimes;
        int result = busEventArgs.mResult;
        String errorTip = busEventArgs.mErrorTip;
        if (result == 0) {
            if (this.editInputContent != null) {
                String timesStr = String.format("\u4eca\u65e5\u5269\u4f59\u558a\u8bdd\u6b21\u6570:%d\u6b21", times);
                this.editInputContent.setHint(timesStr);
            }
        } else {
            this.toast(errorTip);
        }
    }

    private void showNobleEmotionFragment() {
        if (this.mContext != null && this.checkActivityValid()) {
            FragmentManager fm = this.getChildFragmentManager();
            FragmentTransaction ft = fm.beginTransaction();
            NobleEmotionFragment fragment = (NobleEmotionFragment)fm.findFragmentByTag(NOBLE_ICON_POPUP_COMPONENT_TAG);
            if (fragment == null) {
                block10: {
                    fragment = (NobleEmotionFragment)Fragment.instantiate((Context)this.mContext, (String)NobleEmotionFragment.class.getCanonicalName());
                    try {
                        MLog.info((Object)TAG, (String)"[ouyangyj] custom emoicon fragment is not null", (Object[])new Object[0]);
                        if (fragment.isDetached()) {
                            ft.attach((Fragment)fragment);
                        } else if (!fragment.isAdded()) {
                            ft.add(R.id.emotion_frame, (Fragment)fragment, NOBLE_ICON_POPUP_COMPONENT_TAG);
                        } else if (fragment.isHidden()) {
                            ft.show((Fragment)fragment);
                        }
                    }
                    catch (Throwable throwable) {
                        if (!MLog.isLogLevelAboveDebug()) break block10;
                        MLog.debug((Object)TAG, (String)("updateNobleIconFragment error! " + throwable), (Object[])new Object[0]);
                    }
                }
                ft.commitAllowingStateLoss();
            } else {
                fragment.refreshNotNobleView();
            }
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.hotWordsView != null) {
            this.hotWordsView.destroyView();
            this.hotWordsView = null;
        }
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mChatEmotionPopupComponentSniperEventBinder == null) {
            this.mChatEmotionPopupComponentSniperEventBinder = new ChatEmotionPopupComponent$$EventBinder();
        }
        this.mChatEmotionPopupComponentSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mChatEmotionPopupComponentSniperEventBinder != null) {
            this.mChatEmotionPopupComponentSniperEventBinder.unBindEvent();
        }
    }
}

